# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/monitoring/v3/group_service_pb"

module Google
  module Cloud
    module Monitoring
      module V3
        module GroupService
          ##
          # Client for the GroupService service.
          #
          # The Group API lets you inspect and manage your
          # [groups](#google.monitoring.v3.Group).
          #
          # A group is a named filter that is used to identify
          # a collection of monitored resources. Groups are typically used to
          # mirror the physical and/or logical topology of the environment.
          # Because group membership is computed dynamically, monitored
          # resources that are started in the future are automatically placed
          # in matching groups. By using a group to name monitored resources in,
          # for example, an alert policy, the target of that alert policy is
          # updated automatically as monitored resources are added and removed
          # from the infrastructure.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "monitoring.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :group_service_stub

            ##
            # Configure the GroupService Client class.
            #
            # See {::Google::Cloud::Monitoring::V3::GroupService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all GroupService clients
            #   ::Google::Cloud::Monitoring::V3::GroupService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Monitoring", "V3"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_groups.timeout = 30.0
                default_config.rpcs.list_groups.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_group.timeout = 30.0
                default_config.rpcs.get_group.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_group.timeout = 30.0

                default_config.rpcs.update_group.timeout = 180.0
                default_config.rpcs.update_group.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_group.timeout = 30.0
                default_config.rpcs.delete_group.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_group_members.timeout = 30.0
                default_config.rpcs.list_group_members.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the GroupService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Monitoring::V3::GroupService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @group_service_stub.universe_domain
            end

            ##
            # Create a new GroupService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Monitoring::V3::GroupService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Monitoring::V3::GroupService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the GroupService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/monitoring/v3/group_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @group_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Monitoring::V3::GroupService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @group_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @group_service_stub.logger
            end

            # Service calls

            ##
            # Lists the existing groups.
            #
            # @overload list_groups(request, options = nil)
            #   Pass arguments to `list_groups` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListGroupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListGroupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_groups(name: nil, children_of_group: nil, ancestors_of_group: nil, descendants_of_group: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_groups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) whose
            #     groups are to be listed. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #   @param children_of_group [::String]
            #     A group name. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
            #
            #     Returns groups whose `parent_name` field contains the group
            #     name.  If no groups have this parent, the results are empty.
            #
            #     Note: The following parameters are mutually exclusive: `children_of_group`, `ancestors_of_group`, `descendants_of_group`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param ancestors_of_group [::String]
            #     A group name. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
            #
            #     Returns groups that are ancestors of the specified group.
            #     The groups are returned in order, starting with the immediate parent and
            #     ending with the most distant ancestor.  If the specified group has no
            #     immediate parent, the results are empty.
            #
            #     Note: The following parameters are mutually exclusive: `ancestors_of_group`, `children_of_group`, `descendants_of_group`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param descendants_of_group [::String]
            #     A group name. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
            #
            #     Returns the descendants of the specified group.  This is a superset of
            #     the results returned by the `children_of_group` filter, and includes
            #     children-of-children, and so forth.
            #
            #     Note: The following parameters are mutually exclusive: `descendants_of_group`, `children_of_group`, `ancestors_of_group`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param page_size [::Integer]
            #     A positive number that is the maximum number of results to return.
            #   @param page_token [::String]
            #     If this field is not empty then it must contain the `next_page_token` value
            #     returned by a previous call to this method.  Using this field causes the
            #     method to return additional results from the previous method call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::Group>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::Group>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::GroupService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListGroupsRequest.new
            #
            #   # Call the list_groups method.
            #   result = client.list_groups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Monitoring::V3::Group.
            #     p item
            #   end
            #
            def list_groups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListGroupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_groups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_groups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_groups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @group_service_stub.call_rpc :list_groups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @group_service_stub, :list_groups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a single group.
            #
            # @overload get_group(request, options = nil)
            #   Pass arguments to `get_group` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::GetGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::GetGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_group(name: nil)
            #   Pass arguments to `get_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The group to retrieve. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::Group]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::Group]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::GroupService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::GetGroupRequest.new
            #
            #   # Call the get_group method.
            #   result = client.get_group request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::Group.
            #   p result
            #
            def get_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::GetGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @group_service_stub.call_rpc :get_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new group.
            #
            # @overload create_group(request, options = nil)
            #   Pass arguments to `create_group` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::CreateGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::CreateGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_group(name: nil, group: nil, validate_only: nil)
            #   Pass arguments to `create_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) in which
            #     to create the group. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #   @param group [::Google::Cloud::Monitoring::V3::Group, ::Hash]
            #     Required. A group definition. It is an error to define the `name` field
            #     because the system assigns the name.
            #   @param validate_only [::Boolean]
            #     If true, validate this request but do not create the group.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::Group]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::Group]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::GroupService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::CreateGroupRequest.new
            #
            #   # Call the create_group method.
            #   result = client.create_group request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::Group.
            #   p result
            #
            def create_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::CreateGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @group_service_stub.call_rpc :create_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing group.
            # You can change any group attributes except `name`.
            #
            # @overload update_group(request, options = nil)
            #   Pass arguments to `update_group` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::UpdateGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::UpdateGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_group(group: nil, validate_only: nil)
            #   Pass arguments to `update_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param group [::Google::Cloud::Monitoring::V3::Group, ::Hash]
            #     Required. The new definition of the group.  All fields of the existing
            #     group, excepting `name`, are replaced with the corresponding fields of this
            #     group.
            #   @param validate_only [::Boolean]
            #     If true, validate this request but do not update the existing group.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::Group]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::Group]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::GroupService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::UpdateGroupRequest.new
            #
            #   # Call the update_group method.
            #   result = client.update_group request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::Group.
            #   p result
            #
            def update_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::UpdateGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.group&.name
                header_params["group.name"] = request.group.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @group_service_stub.call_rpc :update_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing group.
            #
            # @overload delete_group(request, options = nil)
            #   Pass arguments to `delete_group` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::DeleteGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::DeleteGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_group(name: nil, recursive: nil)
            #   Pass arguments to `delete_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The group to delete. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
            #   @param recursive [::Boolean]
            #     If this field is true, then the request means to delete a group with all
            #     its descendants. Otherwise, the request means to delete a group only when
            #     it has no descendants. The default value is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::GroupService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::DeleteGroupRequest.new
            #
            #   # Call the delete_group method.
            #   result = client.delete_group request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::DeleteGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @group_service_stub.call_rpc :delete_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the monitored resources that are members of a group.
            #
            # @overload list_group_members(request, options = nil)
            #   Pass arguments to `list_group_members` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListGroupMembersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListGroupMembersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_group_members(name: nil, page_size: nil, page_token: nil, filter: nil, interval: nil)
            #   Pass arguments to `list_group_members` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The group whose members are listed. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]
            #   @param page_size [::Integer]
            #     A positive number that is the maximum number of results to return.
            #   @param page_token [::String]
            #     If this field is not empty then it must contain the `next_page_token` value
            #     returned by a previous call to this method.  Using this field causes the
            #     method to return additional results from the previous method call.
            #   @param filter [::String]
            #     An optional [list
            #     filter](https://cloud.google.com/monitoring/api/learn_more#filtering)
            #     describing the members to be returned.  The filter may reference the type,
            #     labels, and metadata of monitored resources that comprise the group. For
            #     example, to return only resources representing Compute Engine VM instances,
            #     use this filter:
            #
            #         `resource.type = "gce_instance"`
            #   @param interval [::Google::Cloud::Monitoring::V3::TimeInterval, ::Hash]
            #     An optional time interval for which results should be returned. Only
            #     members that were part of the group during the specified interval are
            #     included in the response.  If no interval is provided then the group
            #     membership over the last minute is returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Api::MonitoredResource>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Api::MonitoredResource>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::GroupService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListGroupMembersRequest.new
            #
            #   # Call the list_group_members method.
            #   result = client.list_group_members request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Api::MonitoredResource.
            #     p item
            #   end
            #
            def list_group_members request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListGroupMembersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_group_members.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_group_members.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_group_members.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @group_service_stub.call_rpc :list_group_members, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @group_service_stub, :list_group_members, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the GroupService API.
            #
            # This class represents the configuration for GroupService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Monitoring::V3::GroupService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_groups to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Monitoring::V3::GroupService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_groups.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Monitoring::V3::GroupService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_groups.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Monitoring::V3::GroupService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "monitoring.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the GroupService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_groups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_groups
                ##
                # RPC-specific configuration for `get_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_group
                ##
                # RPC-specific configuration for `create_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_group
                ##
                # RPC-specific configuration for `update_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_group
                ##
                # RPC-specific configuration for `delete_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_group
                ##
                # RPC-specific configuration for `list_group_members`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_group_members

                # @private
                def initialize parent_rpcs = nil
                  list_groups_config = parent_rpcs.list_groups if parent_rpcs.respond_to? :list_groups
                  @list_groups = ::Gapic::Config::Method.new list_groups_config
                  get_group_config = parent_rpcs.get_group if parent_rpcs.respond_to? :get_group
                  @get_group = ::Gapic::Config::Method.new get_group_config
                  create_group_config = parent_rpcs.create_group if parent_rpcs.respond_to? :create_group
                  @create_group = ::Gapic::Config::Method.new create_group_config
                  update_group_config = parent_rpcs.update_group if parent_rpcs.respond_to? :update_group
                  @update_group = ::Gapic::Config::Method.new update_group_config
                  delete_group_config = parent_rpcs.delete_group if parent_rpcs.respond_to? :delete_group
                  @delete_group = ::Gapic::Config::Method.new delete_group_config
                  list_group_members_config = parent_rpcs.list_group_members if parent_rpcs.respond_to? :list_group_members
                  @list_group_members = ::Gapic::Config::Method.new list_group_members_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
