# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/monitoring/v3/alert_service_pb"

module Google
  module Cloud
    module Monitoring
      module V3
        module AlertPolicyService
          ##
          # Client for the AlertPolicyService service.
          #
          # The AlertPolicyService API is used to manage (list, create, delete,
          # edit) alert policies in Cloud Monitoring. An alerting policy is
          # a description of the conditions under which some aspect of your
          # system is considered to be "unhealthy" and the ways to notify
          # people or services about this state. In addition to using this API, alert
          # policies can also be managed through
          # [Cloud Monitoring](https://cloud.google.com/monitoring/docs/),
          # which can be reached by clicking the "Monitoring" tab in
          # [Cloud console](https://console.cloud.google.com/).
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "monitoring.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :alert_policy_service_stub

            ##
            # Configure the AlertPolicyService Client class.
            #
            # See {::Google::Cloud::Monitoring::V3::AlertPolicyService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all AlertPolicyService clients
            #   ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Monitoring", "V3"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_alert_policies.timeout = 30.0
                default_config.rpcs.list_alert_policies.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_alert_policy.timeout = 30.0
                default_config.rpcs.get_alert_policy.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_alert_policy.timeout = 30.0

                default_config.rpcs.delete_alert_policy.timeout = 30.0
                default_config.rpcs.delete_alert_policy.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_alert_policy.timeout = 30.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the AlertPolicyService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Monitoring::V3::AlertPolicyService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @alert_policy_service_stub.universe_domain
            end

            ##
            # Create a new AlertPolicyService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the AlertPolicyService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/monitoring/v3/alert_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @alert_policy_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Monitoring::V3::AlertPolicyService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @alert_policy_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @alert_policy_service_stub.logger
            end

            # Service calls

            ##
            # Lists the existing alerting policies for the workspace.
            #
            # @overload list_alert_policies(request, options = nil)
            #   Pass arguments to `list_alert_policies` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListAlertPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListAlertPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_alert_policies(name: nil, filter: nil, order_by: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_alert_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) whose
            #     alert policies are to be listed. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #
            #     Note that this field names the parent container in which the alerting
            #     policies to be listed are stored. To retrieve a single alerting policy
            #     by name, use the
            #     {::Google::Cloud::Monitoring::V3::AlertPolicyService::Client#get_alert_policy GetAlertPolicy}
            #     operation, instead.
            #   @param filter [::String]
            #     Optional. If provided, this field specifies the criteria that must be met
            #     by alert policies to be included in the response.
            #
            #     For more details, see [sorting and
            #     filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
            #   @param order_by [::String]
            #     Optional. A comma-separated list of fields by which to sort the result.
            #     Supports the same set of field references as the `filter` field. Entries
            #     can be prefixed with a minus sign to sort by the field in descending order.
            #
            #     For more details, see [sorting and
            #     filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return in a single response.
            #   @param page_token [::String]
            #     Optional. If this field is not empty then it must contain the
            #     `nextPageToken` value returned by a previous call to this method.  Using
            #     this field causes the method to return more results from the previous
            #     method call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::AlertPolicy>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::AlertPolicy>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListAlertPoliciesRequest.new
            #
            #   # Call the list_alert_policies method.
            #   result = client.list_alert_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Monitoring::V3::AlertPolicy.
            #     p item
            #   end
            #
            def list_alert_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListAlertPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_alert_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_alert_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_alert_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @alert_policy_service_stub.call_rpc :list_alert_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @alert_policy_service_stub, :list_alert_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a single alerting policy.
            #
            # @overload get_alert_policy(request, options = nil)
            #   Pass arguments to `get_alert_policy` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::GetAlertPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::GetAlertPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_alert_policy(name: nil)
            #   Pass arguments to `get_alert_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The alerting policy to retrieve. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::AlertPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::AlertPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::GetAlertPolicyRequest.new
            #
            #   # Call the get_alert_policy method.
            #   result = client.get_alert_policy request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::AlertPolicy.
            #   p result
            #
            def get_alert_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::GetAlertPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_alert_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_alert_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_alert_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @alert_policy_service_stub.call_rpc :get_alert_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new alerting policy.
            #
            # Design your application to single-thread API calls that modify the state of
            # alerting policies in a single project. This includes calls to
            # CreateAlertPolicy, DeleteAlertPolicy and UpdateAlertPolicy.
            #
            # @overload create_alert_policy(request, options = nil)
            #   Pass arguments to `create_alert_policy` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::CreateAlertPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::CreateAlertPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_alert_policy(name: nil, alert_policy: nil)
            #   Pass arguments to `create_alert_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) in which
            #     to create the alerting policy. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #
            #     Note that this field names the parent container in which the alerting
            #     policy will be written, not the name of the created policy. |name| must be
            #     a host project of a Metrics Scope, otherwise INVALID_ARGUMENT error will
            #     return. The alerting policy that is returned will have a name that contains
            #     a normalized representation of this name as a prefix but adds a suffix of
            #     the form `/alertPolicies/[ALERT_POLICY_ID]`, identifying the policy in the
            #     container.
            #   @param alert_policy [::Google::Cloud::Monitoring::V3::AlertPolicy, ::Hash]
            #     Required. The requested alerting policy. You should omit the `name` field
            #     in this policy. The name will be returned in the new policy, including a
            #     new `[ALERT_POLICY_ID]` value.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::AlertPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::AlertPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::CreateAlertPolicyRequest.new
            #
            #   # Call the create_alert_policy method.
            #   result = client.create_alert_policy request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::AlertPolicy.
            #   p result
            #
            def create_alert_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::CreateAlertPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_alert_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_alert_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_alert_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @alert_policy_service_stub.call_rpc :create_alert_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an alerting policy.
            #
            # Design your application to single-thread API calls that modify the state of
            # alerting policies in a single project. This includes calls to
            # CreateAlertPolicy, DeleteAlertPolicy and UpdateAlertPolicy.
            #
            # @overload delete_alert_policy(request, options = nil)
            #   Pass arguments to `delete_alert_policy` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::DeleteAlertPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::DeleteAlertPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_alert_policy(name: nil)
            #   Pass arguments to `delete_alert_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The alerting policy to delete. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
            #
            #     For more information, see {::Google::Cloud::Monitoring::V3::AlertPolicy AlertPolicy}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::DeleteAlertPolicyRequest.new
            #
            #   # Call the delete_alert_policy method.
            #   result = client.delete_alert_policy request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_alert_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::DeleteAlertPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_alert_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_alert_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_alert_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @alert_policy_service_stub.call_rpc :delete_alert_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an alerting policy. You can either replace the entire policy with
            # a new one or replace only certain fields in the current alerting policy by
            # specifying the fields to be updated via `updateMask`. Returns the
            # updated alerting policy.
            #
            # Design your application to single-thread API calls that modify the state of
            # alerting policies in a single project. This includes calls to
            # CreateAlertPolicy, DeleteAlertPolicy and UpdateAlertPolicy.
            #
            # @overload update_alert_policy(request, options = nil)
            #   Pass arguments to `update_alert_policy` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::UpdateAlertPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::UpdateAlertPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_alert_policy(update_mask: nil, alert_policy: nil)
            #   Pass arguments to `update_alert_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. A list of alerting policy field names. If this field is not
            #     empty, each listed field in the existing alerting policy is set to the
            #     value of the corresponding field in the supplied policy (`alert_policy`),
            #     or to the field's default value if the field is not in the supplied
            #     alerting policy.  Fields not listed retain their previous value.
            #
            #     Examples of valid field masks include `display_name`, `documentation`,
            #     `documentation.content`, `documentation.mime_type`, `user_labels`,
            #     `user_label.nameofkey`, `enabled`, `conditions`, `combiner`, etc.
            #
            #     If this field is empty, then the supplied alerting policy replaces the
            #     existing policy. It is the same as deleting the existing policy and
            #     adding the supplied policy, except for the following:
            #
            #     +   The new policy will have the same `[ALERT_POLICY_ID]` as the former
            #         policy. This gives you continuity with the former policy in your
            #         notifications and incidents.
            #     +   Conditions in the new policy will keep their former `[CONDITION_ID]` if
            #         the supplied condition includes the `name` field with that
            #         `[CONDITION_ID]`. If the supplied condition omits the `name` field,
            #         then a new `[CONDITION_ID]` is created.
            #   @param alert_policy [::Google::Cloud::Monitoring::V3::AlertPolicy, ::Hash]
            #     Required. The updated alerting policy or the updated values for the
            #     fields listed in `update_mask`.
            #     If `update_mask` is not empty, any fields in this policy that are
            #     not in `update_mask` are ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::AlertPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::AlertPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::UpdateAlertPolicyRequest.new
            #
            #   # Call the update_alert_policy method.
            #   result = client.update_alert_policy request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::AlertPolicy.
            #   p result
            #
            def update_alert_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::UpdateAlertPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_alert_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.alert_policy&.name
                header_params["alert_policy.name"] = request.alert_policy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_alert_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_alert_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @alert_policy_service_stub.call_rpc :update_alert_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the AlertPolicyService API.
            #
            # This class represents the configuration for AlertPolicyService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Monitoring::V3::AlertPolicyService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_alert_policies to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_alert_policies.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_alert_policies.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "monitoring.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the AlertPolicyService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_alert_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_alert_policies
                ##
                # RPC-specific configuration for `get_alert_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_alert_policy
                ##
                # RPC-specific configuration for `create_alert_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_alert_policy
                ##
                # RPC-specific configuration for `delete_alert_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_alert_policy
                ##
                # RPC-specific configuration for `update_alert_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_alert_policy

                # @private
                def initialize parent_rpcs = nil
                  list_alert_policies_config = parent_rpcs.list_alert_policies if parent_rpcs.respond_to? :list_alert_policies
                  @list_alert_policies = ::Gapic::Config::Method.new list_alert_policies_config
                  get_alert_policy_config = parent_rpcs.get_alert_policy if parent_rpcs.respond_to? :get_alert_policy
                  @get_alert_policy = ::Gapic::Config::Method.new get_alert_policy_config
                  create_alert_policy_config = parent_rpcs.create_alert_policy if parent_rpcs.respond_to? :create_alert_policy
                  @create_alert_policy = ::Gapic::Config::Method.new create_alert_policy_config
                  delete_alert_policy_config = parent_rpcs.delete_alert_policy if parent_rpcs.respond_to? :delete_alert_policy
                  @delete_alert_policy = ::Gapic::Config::Method.new delete_alert_policy_config
                  update_alert_policy_config = parent_rpcs.update_alert_policy if parent_rpcs.respond_to? :update_alert_policy
                  @update_alert_policy = ::Gapic::Config::Method.new update_alert_policy_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
