# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module MetricsScope
        module V1
          # Request for the `GetMetricsScope` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the `Metrics Scope`.
          #     Example:
          #     `locations/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}`
          class GetMetricsScopeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for the `ListMetricsScopesByMonitoredProject` method.
          # @!attribute [rw] monitored_resource_container
          #   @return [::String]
          #     Required. The resource name of the `Monitored Project` being requested.
          #     Example:
          #     `projects/{MONITORED_PROJECT_ID_OR_NUMBER}`
          class ListMetricsScopesByMonitoredProjectRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response for the `ListMetricsScopesByMonitoredProject` method.
          # @!attribute [rw] metrics_scopes
          #   @return [::Array<::Google::Cloud::Monitoring::MetricsScope::V1::MetricsScope>]
          #     A set of all metrics scopes that the specified monitored project has been
          #     added to.
          class ListMetricsScopesByMonitoredProjectResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for the `CreateMonitoredProject` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the existing `Metrics Scope` that will monitor this
          #     project.
          #     Example:
          #     `locations/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}`
          # @!attribute [rw] monitored_project
          #   @return [::Google::Cloud::Monitoring::MetricsScope::V1::MonitoredProject]
          #     Required. The initial `MonitoredProject` configuration.
          #     Specify only the `monitored_project.name` field. All other fields are
          #     ignored. The `monitored_project.name` must be in the format:
          #     `locations/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}/projects/{MONITORED_PROJECT_ID_OR_NUMBER}`
          class CreateMonitoredProjectRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for the `DeleteMonitoredProject` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the `MonitoredProject`.
          #     Example:
          #     `locations/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}/projects/{MONITORED_PROJECT_ID_OR_NUMBER}`
          #
          #     Authorization requires the following [Google
          #     IAM](https://cloud.google.com/iam) permissions on both the `Metrics Scope`
          #     and on the `MonitoredProject`: `monitoring.metricsScopes.link`
          class DeleteMonitoredProjectRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains metadata for longrunning operation for the edit Metrics Scope
          # endpoints.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::Monitoring::MetricsScope::V1::OperationMetadata::State]
          #     Current state of the batch operation.
          # @!attribute [rw] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time when the batch request was received.
          # @!attribute [rw] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time when the operation result was last updated.
          class OperationMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Batch operation states.
            module State
              # Invalid.
              STATE_UNSPECIFIED = 0

              # Request has been received.
              CREATED = 1

              # Request is actively being processed.
              RUNNING = 2

              # The batch processing is done.
              DONE = 3

              # The batch processing was cancelled.
              CANCELLED = 4
            end
          end
        end
      end
    end
  end
end
