# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module Dashboard
        module V1
          # A widget that displays textual content.
          # @!attribute [rw] content
          #   @return [::String]
          #     The text content to be displayed.
          # @!attribute [rw] format
          #   @return [::Google::Cloud::Monitoring::Dashboard::V1::Text::Format]
          #     How the text content is formatted.
          # @!attribute [rw] style
          #   @return [::Google::Cloud::Monitoring::Dashboard::V1::Text::TextStyle]
          #     How the text is styled
          class Text
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Properties that determine how the title and content are styled
            # @!attribute [rw] background_color
            #   @return [::String]
            #     The background color as a hex string. "#RRGGBB" or "#RGB"
            # @!attribute [rw] text_color
            #   @return [::String]
            #     The text color as a hex string. "#RRGGBB" or "#RGB"
            # @!attribute [rw] horizontal_alignment
            #   @return [::Google::Cloud::Monitoring::Dashboard::V1::Text::TextStyle::HorizontalAlignment]
            #     The horizontal alignment of both the title and content
            # @!attribute [rw] vertical_alignment
            #   @return [::Google::Cloud::Monitoring::Dashboard::V1::Text::TextStyle::VerticalAlignment]
            #     The vertical alignment of both the title and content
            # @!attribute [rw] padding
            #   @return [::Google::Cloud::Monitoring::Dashboard::V1::Text::TextStyle::PaddingSize]
            #     The amount of padding around the widget
            # @!attribute [rw] font_size
            #   @return [::Google::Cloud::Monitoring::Dashboard::V1::Text::TextStyle::FontSize]
            #     Font sizes for both the title and content. The title will still be larger
            #     relative to the content.
            # @!attribute [rw] pointer_location
            #   @return [::Google::Cloud::Monitoring::Dashboard::V1::Text::TextStyle::PointerLocation]
            #     The pointer location for this widget (also sometimes called a "tail")
            class TextStyle
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The horizontal alignment of both the title and content on a text widget
              module HorizontalAlignment
                # No horizontal alignment specified, will default to H_LEFT
                HORIZONTAL_ALIGNMENT_UNSPECIFIED = 0

                # Left-align
                H_LEFT = 1

                # Center-align
                H_CENTER = 2

                # Right-align
                H_RIGHT = 3
              end

              # The vertical alignment of both the title and content on a text widget
              module VerticalAlignment
                # No vertical alignment specified, will default to V_TOP
                VERTICAL_ALIGNMENT_UNSPECIFIED = 0

                # Top-align
                V_TOP = 1

                # Center-align
                V_CENTER = 2

                # Bottom-align
                V_BOTTOM = 3
              end

              # Specifies padding size around a text widget
              module PaddingSize
                # No padding size specified, will default to P_EXTRA_SMALL
                PADDING_SIZE_UNSPECIFIED = 0

                # Extra small padding
                P_EXTRA_SMALL = 1

                # Small padding
                P_SMALL = 2

                # Medium padding
                P_MEDIUM = 3

                # Large padding
                P_LARGE = 4

                # Extra large padding
                P_EXTRA_LARGE = 5
              end

              # Specifies a font size for the title and content of a text widget
              module FontSize
                # No font size specified, will default to FS_LARGE
                FONT_SIZE_UNSPECIFIED = 0

                # Extra small font size
                FS_EXTRA_SMALL = 1

                # Small font size
                FS_SMALL = 2

                # Medium font size
                FS_MEDIUM = 3

                # Large font size
                FS_LARGE = 4

                # Extra large font size
                FS_EXTRA_LARGE = 5
              end

              # Specifies where a visual pointer is placed on a text widget (also
              # sometimes called a "tail")
              module PointerLocation
                # No visual pointer
                POINTER_LOCATION_UNSPECIFIED = 0

                # Placed in the middle of the top of the widget
                PL_TOP = 1

                # Placed in the middle of the right side of the widget
                PL_RIGHT = 2

                # Placed in the middle of the bottom of the widget
                PL_BOTTOM = 3

                # Placed in the middle of the left side of the widget
                PL_LEFT = 4

                # Placed on the left side of the top of the widget
                PL_TOP_LEFT = 5

                # Placed on the right side of the top of the widget
                PL_TOP_RIGHT = 6

                # Placed on the top of the right side of the widget
                PL_RIGHT_TOP = 7

                # Placed on the bottom of the right side of the widget
                PL_RIGHT_BOTTOM = 8

                # Placed on the right side of the bottom of the widget
                PL_BOTTOM_RIGHT = 9

                # Placed on the left side of the bottom of the widget
                PL_BOTTOM_LEFT = 10

                # Placed on the bottom of the left side of the widget
                PL_LEFT_BOTTOM = 11

                # Placed on the top of the left side of the widget
                PL_LEFT_TOP = 12
              end
            end

            # The format type of the text content.
            module Format
              # Format is unspecified. Defaults to MARKDOWN.
              FORMAT_UNSPECIFIED = 0

              # The text contains Markdown formatting.
              MARKDOWN = 1

              # The text contains no special formatting.
              RAW = 2
            end
          end
        end
      end
    end
  end
end
