# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module Dashboard
        module V1
          # The `CreateDashboard` request.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The project on which to execute the request. The format is:
          #
          #         projects/[PROJECT_ID_OR_NUMBER]
          #
          #     The `[PROJECT_ID_OR_NUMBER]` must match the dashboard resource name.
          # @!attribute [rw] dashboard
          #   @return [::Google::Cloud::Monitoring::Dashboard::V1::Dashboard]
          #     Required. The initial dashboard specification.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If set, validate the request and preview the review, but do not actually
          #     save it.
          class CreateDashboardRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The `ListDashboards` request.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The scope of the dashboards to list. The format is:
          #
          #         projects/[PROJECT_ID_OR_NUMBER]
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     A positive number that is the maximum number of results to return.
          #     If unspecified, a default of 1000 is used.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. If this field is not empty then it must contain the
          #     `nextPageToken` value returned by a previous call to this method.  Using
          #     this field causes the method to return additional results from the previous
          #     method call.
          class ListDashboardsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The `ListDashboards` request.
          # @!attribute [rw] dashboards
          #   @return [::Array<::Google::Cloud::Monitoring::Dashboard::V1::Dashboard>]
          #     The list of requested dashboards.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If there are more results than have been returned, then this field is set
          #     to a non-empty value.  To see the additional results,
          #     use that value as `page_token` in the next call to this method.
          class ListDashboardsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The `GetDashboard` request.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the Dashboard. The format is one of:
          #
          #      -  `dashboards/[DASHBOARD_ID]` (for system dashboards)
          #      -  `projects/[PROJECT_ID_OR_NUMBER]/dashboards/[DASHBOARD_ID]`
          #           (for custom dashboards).
          class GetDashboardRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The `DeleteDashboard` request.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the Dashboard. The format is:
          #
          #         projects/[PROJECT_ID_OR_NUMBER]/dashboards/[DASHBOARD_ID]
          class DeleteDashboardRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The `UpdateDashboard` request.
          # @!attribute [rw] dashboard
          #   @return [::Google::Cloud::Monitoring::Dashboard::V1::Dashboard]
          #     Required. The dashboard that will replace the existing dashboard.
          # @!attribute [rw] validate_only
          #   @return [::Boolean]
          #     If set, validate the request and preview the review, but do not actually
          #     save it.
          class UpdateDashboardRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
