# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module Dashboard
        module V1
          # A filter to reduce the amount of data charted in relevant widgets.
          # @!attribute [rw] label_key
          #   @return [::String]
          #     Required. The key for the label
          # @!attribute [rw] template_variable
          #   @return [::String]
          #     The placeholder text that can be referenced in a filter string or MQL
          #     query. If omitted, the dashboard filter will be applied to all relevant
          #     widgets in the dashboard.
          # @!attribute [rw] string_value
          #   @return [::String]
          #     A variable-length string value.
          # @!attribute [rw] filter_type
          #   @return [::Google::Cloud::Monitoring::Dashboard::V1::DashboardFilter::FilterType]
          #     The specified filter type
          class DashboardFilter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type for the dashboard filter
            module FilterType
              # Filter type is unspecified. This is not valid in a well-formed request.
              FILTER_TYPE_UNSPECIFIED = 0

              # Filter on a resource label value
              RESOURCE_LABEL = 1

              # Filter on a metrics label value
              METRIC_LABEL = 2

              # Filter on a user metadata label value
              USER_METADATA_LABEL = 3

              # Filter on a system metadata label value
              SYSTEM_METADATA_LABEL = 4

              # Filter on a group id
              GROUP = 5
            end
          end
        end
      end
    end
  end
end
