# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/migrationcenter/v1/migrationcenter_pb"
require "google/cloud/migration_center/v1/migration_center"

class ::Google::Cloud::MigrationCenter::V1::MigrationCenter::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_assets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ListAssetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :ASSET_VIEW_UNSPECIFIED

    list_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_assets, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ListAssetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal :ASSET_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_assets_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_assets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_assets ::Google::Cloud::MigrationCenter::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_assets(::Google::Cloud::MigrationCenter::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_assets_client_stub.call_rpc_count
    end
  end

  def test_get_asset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::Asset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :ASSET_VIEW_UNSPECIFIED

    get_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_asset, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetAssetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :ASSET_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_asset_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_asset({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_asset name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_asset ::Google::Cloud::MigrationCenter::V1::GetAssetRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_asset({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_asset(::Google::Cloud::MigrationCenter::V1::GetAssetRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_asset_client_stub.call_rpc_count
    end
  end

  def test_update_asset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::Asset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    asset = {}
    request_id = "hello world"

    update_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_asset, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::Asset), request["asset"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_asset_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_asset({ update_mask: update_mask, asset: asset, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_asset update_mask: update_mask, asset: asset, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_asset ::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest.new(update_mask: update_mask, asset: asset, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_asset({ update_mask: update_mask, asset: asset, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_asset(::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest.new(update_mask: update_mask, asset: asset, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_asset_client_stub.call_rpc_count
    end
  end

  def test_batch_update_assets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_update_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_update_assets, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_update_assets_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_update_assets({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_update_assets parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_update_assets ::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_update_assets({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_update_assets(::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_update_assets_client_stub.call_rpc_count
    end
  end

  def test_delete_asset
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_asset, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::DeleteAssetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_asset_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_asset({ name: name, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_asset name: name, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_asset ::Google::Cloud::MigrationCenter::V1::DeleteAssetRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_asset({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_asset(::Google::Cloud::MigrationCenter::V1::DeleteAssetRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_asset_client_stub.call_rpc_count
    end
  end

  def test_batch_delete_assets
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]
    allow_missing = true

    batch_delete_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_delete_assets, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::BatchDeleteAssetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["names"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_delete_assets_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_delete_assets({ parent: parent, names: names, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_delete_assets parent: parent, names: names, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_delete_assets ::Google::Cloud::MigrationCenter::V1::BatchDeleteAssetsRequest.new(parent: parent, names: names, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_delete_assets({ parent: parent, names: names, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_delete_assets(::Google::Cloud::MigrationCenter::V1::BatchDeleteAssetsRequest.new(parent: parent, names: names, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_delete_assets_client_stub.call_rpc_count
    end
  end

  def test_report_asset_frames
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ReportAssetFramesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    frames = {}
    source = "hello world"

    report_asset_frames_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :report_asset_frames, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ReportAssetFramesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::Frames), request["frames"]
      assert_equal "hello world", request["source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, report_asset_frames_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.report_asset_frames({ parent: parent, frames: frames, source: source }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.report_asset_frames parent: parent, frames: frames, source: source do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.report_asset_frames ::Google::Cloud::MigrationCenter::V1::ReportAssetFramesRequest.new(parent: parent, frames: frames, source: source) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.report_asset_frames({ parent: parent, frames: frames, source: source }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.report_asset_frames(::Google::Cloud::MigrationCenter::V1::ReportAssetFramesRequest.new(parent: parent, frames: frames, source: source), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, report_asset_frames_client_stub.call_rpc_count
    end
  end

  def test_aggregate_assets_values
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    aggregations = [{}]
    filter = "hello world"

    aggregate_assets_values_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :aggregate_assets_values, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::Aggregation, request["aggregations"].first
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, aggregate_assets_values_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.aggregate_assets_values({ parent: parent, aggregations: aggregations, filter: filter }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.aggregate_assets_values parent: parent, aggregations: aggregations, filter: filter do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.aggregate_assets_values ::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesRequest.new(parent: parent, aggregations: aggregations, filter: filter) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.aggregate_assets_values({ parent: parent, aggregations: aggregations, filter: filter }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.aggregate_assets_values(::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesRequest.new(parent: parent, aggregations: aggregations, filter: filter), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, aggregate_assets_values_client_stub.call_rpc_count
    end
  end

  def test_create_import_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    import_job_id = "hello world"
    import_job = {}
    request_id = "hello world"

    create_import_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_import_job, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::CreateImportJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["import_job_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::ImportJob), request["import_job"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_import_job_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_import_job({ parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_import_job parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_import_job ::Google::Cloud::MigrationCenter::V1::CreateImportJobRequest.new(parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_import_job({ parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_import_job(::Google::Cloud::MigrationCenter::V1::CreateImportJobRequest.new(parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_import_job_client_stub.call_rpc_count
    end
  end

  def test_list_import_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ListImportJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :IMPORT_JOB_VIEW_UNSPECIFIED

    list_import_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_import_jobs, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ListImportJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal :IMPORT_JOB_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_import_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_import_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_import_jobs ::Google::Cloud::MigrationCenter::V1::ListImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_import_jobs(::Google::Cloud::MigrationCenter::V1::ListImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_import_jobs_client_stub.call_rpc_count
    end
  end

  def test_get_import_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ImportJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :IMPORT_JOB_VIEW_UNSPECIFIED

    get_import_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_import_job, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetImportJobRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :IMPORT_JOB_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_import_job_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_import_job({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_import_job name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_import_job ::Google::Cloud::MigrationCenter::V1::GetImportJobRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_import_job({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_import_job(::Google::Cloud::MigrationCenter::V1::GetImportJobRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_import_job_client_stub.call_rpc_count
    end
  end

  def test_delete_import_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_import_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_import_job, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::DeleteImportJobRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_import_job_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_import_job({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_import_job name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_import_job ::Google::Cloud::MigrationCenter::V1::DeleteImportJobRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_import_job({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_import_job(::Google::Cloud::MigrationCenter::V1::DeleteImportJobRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_import_job_client_stub.call_rpc_count
    end
  end

  def test_update_import_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    import_job = {}
    request_id = "hello world"

    update_import_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_import_job, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::UpdateImportJobRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::ImportJob), request["import_job"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_import_job_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_import_job({ update_mask: update_mask, import_job: import_job, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_import_job update_mask: update_mask, import_job: import_job, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_import_job ::Google::Cloud::MigrationCenter::V1::UpdateImportJobRequest.new(update_mask: update_mask, import_job: import_job, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_import_job({ update_mask: update_mask, import_job: import_job, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_import_job(::Google::Cloud::MigrationCenter::V1::UpdateImportJobRequest.new(update_mask: update_mask, import_job: import_job, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_import_job_client_stub.call_rpc_count
    end
  end

  def test_validate_import_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    validate_import_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :validate_import_job, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ValidateImportJobRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, validate_import_job_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.validate_import_job({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.validate_import_job name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.validate_import_job ::Google::Cloud::MigrationCenter::V1::ValidateImportJobRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.validate_import_job({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.validate_import_job(::Google::Cloud::MigrationCenter::V1::ValidateImportJobRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, validate_import_job_client_stub.call_rpc_count
    end
  end

  def test_run_import_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    run_import_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :run_import_job, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::RunImportJobRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_import_job_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_import_job({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_import_job name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_import_job ::Google::Cloud::MigrationCenter::V1::RunImportJobRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_import_job({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_import_job(::Google::Cloud::MigrationCenter::V1::RunImportJobRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_import_job_client_stub.call_rpc_count
    end
  end

  def test_get_import_data_file
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ImportDataFile.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_import_data_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_import_data_file, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetImportDataFileRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_import_data_file_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_import_data_file({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_import_data_file name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_import_data_file ::Google::Cloud::MigrationCenter::V1::GetImportDataFileRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_import_data_file({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_import_data_file(::Google::Cloud::MigrationCenter::V1::GetImportDataFileRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_import_data_file_client_stub.call_rpc_count
    end
  end

  def test_list_import_data_files
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ListImportDataFilesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_import_data_files_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_import_data_files, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ListImportDataFilesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_import_data_files_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_import_data_files({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_import_data_files parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_import_data_files ::Google::Cloud::MigrationCenter::V1::ListImportDataFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_import_data_files({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_import_data_files(::Google::Cloud::MigrationCenter::V1::ListImportDataFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_import_data_files_client_stub.call_rpc_count
    end
  end

  def test_create_import_data_file
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    import_data_file_id = "hello world"
    import_data_file = {}
    request_id = "hello world"

    create_import_data_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_import_data_file, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::CreateImportDataFileRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["import_data_file_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::ImportDataFile), request["import_data_file"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_import_data_file_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_import_data_file({ parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_import_data_file parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_import_data_file ::Google::Cloud::MigrationCenter::V1::CreateImportDataFileRequest.new(parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_import_data_file({ parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_import_data_file(::Google::Cloud::MigrationCenter::V1::CreateImportDataFileRequest.new(parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_import_data_file_client_stub.call_rpc_count
    end
  end

  def test_delete_import_data_file
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_import_data_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_import_data_file, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::DeleteImportDataFileRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_import_data_file_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_import_data_file({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_import_data_file name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_import_data_file ::Google::Cloud::MigrationCenter::V1::DeleteImportDataFileRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_import_data_file({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_import_data_file(::Google::Cloud::MigrationCenter::V1::DeleteImportDataFileRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_import_data_file_client_stub.call_rpc_count
    end
  end

  def test_list_groups
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ListGroupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_groups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_groups, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ListGroupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_groups_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_groups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_groups ::Google::Cloud::MigrationCenter::V1::ListGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_groups(::Google::Cloud::MigrationCenter::V1::ListGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_groups_client_stub.call_rpc_count
    end
  end

  def test_get_group
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::Group.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_group, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetGroupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_group_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_group({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_group name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_group ::Google::Cloud::MigrationCenter::V1::GetGroupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_group({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_group(::Google::Cloud::MigrationCenter::V1::GetGroupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_group_client_stub.call_rpc_count
    end
  end

  def test_create_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    group_id = "hello world"
    group = {}
    request_id = "hello world"

    create_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_group, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::CreateGroupRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["group_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::Group), request["group"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_group_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_group({ parent: parent, group_id: group_id, group: group, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_group parent: parent, group_id: group_id, group: group, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_group ::Google::Cloud::MigrationCenter::V1::CreateGroupRequest.new(parent: parent, group_id: group_id, group: group, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_group({ parent: parent, group_id: group_id, group: group, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_group(::Google::Cloud::MigrationCenter::V1::CreateGroupRequest.new(parent: parent, group_id: group_id, group: group, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_group_client_stub.call_rpc_count
    end
  end

  def test_update_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    group = {}
    request_id = "hello world"

    update_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_group, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::UpdateGroupRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::Group), request["group"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_group_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_group({ update_mask: update_mask, group: group, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_group update_mask: update_mask, group: group, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_group ::Google::Cloud::MigrationCenter::V1::UpdateGroupRequest.new(update_mask: update_mask, group: group, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_group({ update_mask: update_mask, group: group, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_group(::Google::Cloud::MigrationCenter::V1::UpdateGroupRequest.new(update_mask: update_mask, group: group, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_group_client_stub.call_rpc_count
    end
  end

  def test_delete_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_group, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::DeleteGroupRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_group_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_group({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_group name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_group ::Google::Cloud::MigrationCenter::V1::DeleteGroupRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_group({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_group(::Google::Cloud::MigrationCenter::V1::DeleteGroupRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_group_client_stub.call_rpc_count
    end
  end

  def test_add_assets_to_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    group = "hello world"
    request_id = "hello world"
    assets = {}
    allow_existing = true

    add_assets_to_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :add_assets_to_group, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::AddAssetsToGroupRequest, request
      assert_equal "hello world", request["group"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::AssetList), request["assets"]
      assert_equal true, request["allow_existing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, add_assets_to_group_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.add_assets_to_group({ group: group, request_id: request_id, assets: assets, allow_existing: allow_existing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.add_assets_to_group group: group, request_id: request_id, assets: assets, allow_existing: allow_existing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.add_assets_to_group ::Google::Cloud::MigrationCenter::V1::AddAssetsToGroupRequest.new(group: group, request_id: request_id, assets: assets, allow_existing: allow_existing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.add_assets_to_group({ group: group, request_id: request_id, assets: assets, allow_existing: allow_existing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.add_assets_to_group(::Google::Cloud::MigrationCenter::V1::AddAssetsToGroupRequest.new(group: group, request_id: request_id, assets: assets, allow_existing: allow_existing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, add_assets_to_group_client_stub.call_rpc_count
    end
  end

  def test_remove_assets_from_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    group = "hello world"
    request_id = "hello world"
    assets = {}
    allow_missing = true

    remove_assets_from_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_assets_from_group, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::RemoveAssetsFromGroupRequest, request
      assert_equal "hello world", request["group"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::AssetList), request["assets"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_assets_from_group_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_assets_from_group({ group: group, request_id: request_id, assets: assets, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_assets_from_group group: group, request_id: request_id, assets: assets, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_assets_from_group ::Google::Cloud::MigrationCenter::V1::RemoveAssetsFromGroupRequest.new(group: group, request_id: request_id, assets: assets, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_assets_from_group({ group: group, request_id: request_id, assets: assets, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_assets_from_group(::Google::Cloud::MigrationCenter::V1::RemoveAssetsFromGroupRequest.new(group: group, request_id: request_id, assets: assets, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_assets_from_group_client_stub.call_rpc_count
    end
  end

  def test_list_error_frames
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ListErrorFramesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :ERROR_FRAME_VIEW_UNSPECIFIED

    list_error_frames_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_error_frames, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ListErrorFramesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :ERROR_FRAME_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_error_frames_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_error_frames({ parent: parent, page_size: page_size, page_token: page_token, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_error_frames parent: parent, page_size: page_size, page_token: page_token, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_error_frames ::Google::Cloud::MigrationCenter::V1::ListErrorFramesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_error_frames({ parent: parent, page_size: page_size, page_token: page_token, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_error_frames(::Google::Cloud::MigrationCenter::V1::ListErrorFramesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_error_frames_client_stub.call_rpc_count
    end
  end

  def test_get_error_frame
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ErrorFrame.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :ERROR_FRAME_VIEW_UNSPECIFIED

    get_error_frame_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_error_frame, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetErrorFrameRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :ERROR_FRAME_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_error_frame_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_error_frame({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_error_frame name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_error_frame ::Google::Cloud::MigrationCenter::V1::GetErrorFrameRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_error_frame({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_error_frame(::Google::Cloud::MigrationCenter::V1::GetErrorFrameRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_error_frame_client_stub.call_rpc_count
    end
  end

  def test_list_sources
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ListSourcesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_sources_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_sources, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ListSourcesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_sources_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_sources parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_sources ::Google::Cloud::MigrationCenter::V1::ListSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_sources(::Google::Cloud::MigrationCenter::V1::ListSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_sources_client_stub.call_rpc_count
    end
  end

  def test_get_source
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::Source.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_source, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetSourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_source_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_source({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_source name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_source ::Google::Cloud::MigrationCenter::V1::GetSourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_source({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_source(::Google::Cloud::MigrationCenter::V1::GetSourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_source_client_stub.call_rpc_count
    end
  end

  def test_create_source
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source_id = "hello world"
    source = {}
    request_id = "hello world"

    create_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_source, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::CreateSourceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["source_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::Source), request["source"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_source_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_source({ parent: parent, source_id: source_id, source: source, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_source parent: parent, source_id: source_id, source: source, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_source ::Google::Cloud::MigrationCenter::V1::CreateSourceRequest.new(parent: parent, source_id: source_id, source: source, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_source({ parent: parent, source_id: source_id, source: source, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_source(::Google::Cloud::MigrationCenter::V1::CreateSourceRequest.new(parent: parent, source_id: source_id, source: source, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_source_client_stub.call_rpc_count
    end
  end

  def test_update_source
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    source = {}
    request_id = "hello world"

    update_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_source, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::UpdateSourceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::Source), request["source"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_source_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_source({ update_mask: update_mask, source: source, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_source update_mask: update_mask, source: source, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_source ::Google::Cloud::MigrationCenter::V1::UpdateSourceRequest.new(update_mask: update_mask, source: source, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_source({ update_mask: update_mask, source: source, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_source(::Google::Cloud::MigrationCenter::V1::UpdateSourceRequest.new(update_mask: update_mask, source: source, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_source_client_stub.call_rpc_count
    end
  end

  def test_delete_source
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_source, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::DeleteSourceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_source_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_source({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_source name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_source ::Google::Cloud::MigrationCenter::V1::DeleteSourceRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_source({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_source(::Google::Cloud::MigrationCenter::V1::DeleteSourceRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_source_client_stub.call_rpc_count
    end
  end

  def test_list_preference_sets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_preference_sets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_preference_sets, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_preference_sets_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_preference_sets({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_preference_sets parent: parent, page_size: page_size, page_token: page_token, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_preference_sets ::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_preference_sets({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_preference_sets(::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_preference_sets_client_stub.call_rpc_count
    end
  end

  def test_get_preference_set
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::PreferenceSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_preference_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_preference_set, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetPreferenceSetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_preference_set_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_preference_set({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_preference_set name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_preference_set ::Google::Cloud::MigrationCenter::V1::GetPreferenceSetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_preference_set({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_preference_set(::Google::Cloud::MigrationCenter::V1::GetPreferenceSetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_preference_set_client_stub.call_rpc_count
    end
  end

  def test_create_preference_set
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    preference_set_id = "hello world"
    preference_set = {}
    request_id = "hello world"

    create_preference_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_preference_set, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::CreatePreferenceSetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["preference_set_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::PreferenceSet), request["preference_set"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_preference_set_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_preference_set({ parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_preference_set parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_preference_set ::Google::Cloud::MigrationCenter::V1::CreatePreferenceSetRequest.new(parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_preference_set({ parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_preference_set(::Google::Cloud::MigrationCenter::V1::CreatePreferenceSetRequest.new(parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_preference_set_client_stub.call_rpc_count
    end
  end

  def test_update_preference_set
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    preference_set = {}
    request_id = "hello world"

    update_preference_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_preference_set, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::UpdatePreferenceSetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::PreferenceSet), request["preference_set"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_preference_set_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_preference_set({ update_mask: update_mask, preference_set: preference_set, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_preference_set update_mask: update_mask, preference_set: preference_set, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_preference_set ::Google::Cloud::MigrationCenter::V1::UpdatePreferenceSetRequest.new(update_mask: update_mask, preference_set: preference_set, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_preference_set({ update_mask: update_mask, preference_set: preference_set, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_preference_set(::Google::Cloud::MigrationCenter::V1::UpdatePreferenceSetRequest.new(update_mask: update_mask, preference_set: preference_set, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_preference_set_client_stub.call_rpc_count
    end
  end

  def test_delete_preference_set
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_preference_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_preference_set, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::DeletePreferenceSetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_preference_set_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_preference_set({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_preference_set name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_preference_set ::Google::Cloud::MigrationCenter::V1::DeletePreferenceSetRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_preference_set({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_preference_set(::Google::Cloud::MigrationCenter::V1::DeletePreferenceSetRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_preference_set_client_stub.call_rpc_count
    end
  end

  def test_get_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::Settings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_settings, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_settings_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_settings ::Google::Cloud::MigrationCenter::V1::GetSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_settings(::Google::Cloud::MigrationCenter::V1::GetSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_settings_client_stub.call_rpc_count
    end
  end

  def test_update_settings
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    settings = {}
    request_id = "hello world"

    update_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_settings, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::UpdateSettingsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::Settings), request["settings"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_settings_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_settings({ update_mask: update_mask, settings: settings, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_settings update_mask: update_mask, settings: settings, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_settings ::Google::Cloud::MigrationCenter::V1::UpdateSettingsRequest.new(update_mask: update_mask, settings: settings, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_settings({ update_mask: update_mask, settings: settings, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_settings(::Google::Cloud::MigrationCenter::V1::UpdateSettingsRequest.new(update_mask: update_mask, settings: settings, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_settings_client_stub.call_rpc_count
    end
  end

  def test_create_report_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    report_config_id = "hello world"
    report_config = {}
    request_id = "hello world"

    create_report_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_report_config, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::CreateReportConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["report_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::ReportConfig), request["report_config"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_report_config_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_report_config({ parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_report_config parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_report_config ::Google::Cloud::MigrationCenter::V1::CreateReportConfigRequest.new(parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_report_config({ parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_report_config(::Google::Cloud::MigrationCenter::V1::CreateReportConfigRequest.new(parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_report_config_client_stub.call_rpc_count
    end
  end

  def test_get_report_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ReportConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_report_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_report_config, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetReportConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_report_config_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_report_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_report_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_report_config ::Google::Cloud::MigrationCenter::V1::GetReportConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_report_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_report_config(::Google::Cloud::MigrationCenter::V1::GetReportConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_report_config_client_stub.call_rpc_count
    end
  end

  def test_list_report_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ListReportConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_report_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_report_configs, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ListReportConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_report_configs_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_report_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_report_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_report_configs ::Google::Cloud::MigrationCenter::V1::ListReportConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_report_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_report_configs(::Google::Cloud::MigrationCenter::V1::ListReportConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_report_configs_client_stub.call_rpc_count
    end
  end

  def test_delete_report_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_report_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_report_config, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::DeleteReportConfigRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_report_config_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_report_config({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_report_config name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_report_config ::Google::Cloud::MigrationCenter::V1::DeleteReportConfigRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_report_config({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_report_config(::Google::Cloud::MigrationCenter::V1::DeleteReportConfigRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_report_config_client_stub.call_rpc_count
    end
  end

  def test_create_report
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    report_id = "hello world"
    report = {}
    request_id = "hello world"

    create_report_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_report, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::CreateReportRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["report_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MigrationCenter::V1::Report), request["report"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_report_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_report({ parent: parent, report_id: report_id, report: report, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_report parent: parent, report_id: report_id, report: report, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_report ::Google::Cloud::MigrationCenter::V1::CreateReportRequest.new(parent: parent, report_id: report_id, report: report, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_report({ parent: parent, report_id: report_id, report: report, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_report(::Google::Cloud::MigrationCenter::V1::CreateReportRequest.new(parent: parent, report_id: report_id, report: report, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_report_client_stub.call_rpc_count
    end
  end

  def test_get_report
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::Report.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :REPORT_VIEW_UNSPECIFIED

    get_report_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_report, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::GetReportRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :REPORT_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_report_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_report({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_report name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_report ::Google::Cloud::MigrationCenter::V1::GetReportRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_report({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_report(::Google::Cloud::MigrationCenter::V1::GetReportRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_report_client_stub.call_rpc_count
    end
  end

  def test_list_reports
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MigrationCenter::V1::ListReportsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :REPORT_VIEW_UNSPECIFIED

    list_reports_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_reports, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::ListReportsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal :REPORT_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_reports_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_reports({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_reports parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_reports ::Google::Cloud::MigrationCenter::V1::ListReportsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_reports({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_reports(::Google::Cloud::MigrationCenter::V1::ListReportsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_reports_client_stub.call_rpc_count
    end
  end

  def test_delete_report
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_report_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_report, name
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::DeleteReportRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_report_client_stub do
      # Create client
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_report({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_report name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_report ::Google::Cloud::MigrationCenter::V1::DeleteReportRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_report({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_report(::Google::Cloud::MigrationCenter::V1::DeleteReportRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_report_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Operations, client.operations_client
  end
end
