# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/migrationcenter/v1/migrationcenter_pb"
require "google/cloud/migration_center/v1/migration_center/rest"


class ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_assets
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ListAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :ASSET_VIEW_UNSPECIFIED

    list_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_list_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_assets_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_assets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_assets ::Google::Cloud::MigrationCenter::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_assets(::Google::Cloud::MigrationCenter::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_assets_client_stub.call_count
      end
    end
  end

  def test_get_asset
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::Asset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :ASSET_VIEW_UNSPECIFIED

    get_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_asset_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_asset({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_asset name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_asset ::Google::Cloud::MigrationCenter::V1::GetAssetRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_asset({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_asset(::Google::Cloud::MigrationCenter::V1::GetAssetRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_asset_client_stub.call_count
      end
    end
  end

  def test_update_asset
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::Asset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    asset = {}
    request_id = "hello world"

    update_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_update_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_asset_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_asset({ update_mask: update_mask, asset: asset, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_asset update_mask: update_mask, asset: asset, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_asset ::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest.new(update_mask: update_mask, asset: asset, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_asset({ update_mask: update_mask, asset: asset, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_asset(::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest.new(update_mask: update_mask, asset: asset, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_asset_client_stub.call_count
      end
    end
  end

  def test_batch_update_assets
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_update_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_batch_update_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_update_assets_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_update_assets({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_update_assets parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_update_assets ::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_update_assets({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_update_assets(::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_update_assets_client_stub.call_count
      end
    end
  end

  def test_delete_asset
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_delete_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_asset_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_asset({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_asset name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_asset ::Google::Cloud::MigrationCenter::V1::DeleteAssetRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_asset({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_asset(::Google::Cloud::MigrationCenter::V1::DeleteAssetRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_asset_client_stub.call_count
      end
    end
  end

  def test_batch_delete_assets
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]
    allow_missing = true

    batch_delete_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_batch_delete_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_delete_assets_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_delete_assets({ parent: parent, names: names, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_delete_assets parent: parent, names: names, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_delete_assets ::Google::Cloud::MigrationCenter::V1::BatchDeleteAssetsRequest.new(parent: parent, names: names, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_delete_assets({ parent: parent, names: names, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_delete_assets(::Google::Cloud::MigrationCenter::V1::BatchDeleteAssetsRequest.new(parent: parent, names: names, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_delete_assets_client_stub.call_count
      end
    end
  end

  def test_report_asset_frames
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ReportAssetFramesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    frames = {}
    source = "hello world"

    report_asset_frames_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_report_asset_frames_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, report_asset_frames_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.report_asset_frames({ parent: parent, frames: frames, source: source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.report_asset_frames parent: parent, frames: frames, source: source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.report_asset_frames ::Google::Cloud::MigrationCenter::V1::ReportAssetFramesRequest.new(parent: parent, frames: frames, source: source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.report_asset_frames({ parent: parent, frames: frames, source: source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.report_asset_frames(::Google::Cloud::MigrationCenter::V1::ReportAssetFramesRequest.new(parent: parent, frames: frames, source: source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, report_asset_frames_client_stub.call_count
      end
    end
  end

  def test_aggregate_assets_values
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    aggregations = [{}]
    filter = "hello world"

    aggregate_assets_values_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_aggregate_assets_values_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, aggregate_assets_values_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.aggregate_assets_values({ parent: parent, aggregations: aggregations, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.aggregate_assets_values parent: parent, aggregations: aggregations, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.aggregate_assets_values ::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesRequest.new(parent: parent, aggregations: aggregations, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.aggregate_assets_values({ parent: parent, aggregations: aggregations, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.aggregate_assets_values(::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesRequest.new(parent: parent, aggregations: aggregations, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, aggregate_assets_values_client_stub.call_count
      end
    end
  end

  def test_create_import_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    import_job_id = "hello world"
    import_job = {}
    request_id = "hello world"

    create_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_create_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_import_job({ parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_import_job parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_import_job ::Google::Cloud::MigrationCenter::V1::CreateImportJobRequest.new(parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_import_job({ parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_import_job(::Google::Cloud::MigrationCenter::V1::CreateImportJobRequest.new(parent: parent, import_job_id: import_job_id, import_job: import_job, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_import_job_client_stub.call_count
      end
    end
  end

  def test_list_import_jobs
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ListImportJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :IMPORT_JOB_VIEW_UNSPECIFIED

    list_import_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_list_import_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_import_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_import_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_import_jobs ::Google::Cloud::MigrationCenter::V1::ListImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_import_jobs(::Google::Cloud::MigrationCenter::V1::ListImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_import_jobs_client_stub.call_count
      end
    end
  end

  def test_get_import_job
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ImportJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :IMPORT_JOB_VIEW_UNSPECIFIED

    get_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_import_job({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_import_job name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_import_job ::Google::Cloud::MigrationCenter::V1::GetImportJobRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_import_job({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_import_job(::Google::Cloud::MigrationCenter::V1::GetImportJobRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_import_job_client_stub.call_count
      end
    end
  end

  def test_delete_import_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_delete_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_import_job({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_import_job name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_import_job ::Google::Cloud::MigrationCenter::V1::DeleteImportJobRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_import_job({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_import_job(::Google::Cloud::MigrationCenter::V1::DeleteImportJobRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_import_job_client_stub.call_count
      end
    end
  end

  def test_update_import_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    import_job = {}
    request_id = "hello world"

    update_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_update_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_import_job({ update_mask: update_mask, import_job: import_job, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_import_job update_mask: update_mask, import_job: import_job, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_import_job ::Google::Cloud::MigrationCenter::V1::UpdateImportJobRequest.new(update_mask: update_mask, import_job: import_job, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_import_job({ update_mask: update_mask, import_job: import_job, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_import_job(::Google::Cloud::MigrationCenter::V1::UpdateImportJobRequest.new(update_mask: update_mask, import_job: import_job, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_import_job_client_stub.call_count
      end
    end
  end

  def test_validate_import_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    validate_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_validate_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, validate_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.validate_import_job({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.validate_import_job name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.validate_import_job ::Google::Cloud::MigrationCenter::V1::ValidateImportJobRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.validate_import_job({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.validate_import_job(::Google::Cloud::MigrationCenter::V1::ValidateImportJobRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, validate_import_job_client_stub.call_count
      end
    end
  end

  def test_run_import_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    run_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_run_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_import_job({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_import_job name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_import_job ::Google::Cloud::MigrationCenter::V1::RunImportJobRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_import_job({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_import_job(::Google::Cloud::MigrationCenter::V1::RunImportJobRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_import_job_client_stub.call_count
      end
    end
  end

  def test_get_import_data_file
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ImportDataFile.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_import_data_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_import_data_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_import_data_file_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_import_data_file({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_import_data_file name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_import_data_file ::Google::Cloud::MigrationCenter::V1::GetImportDataFileRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_import_data_file({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_import_data_file(::Google::Cloud::MigrationCenter::V1::GetImportDataFileRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_import_data_file_client_stub.call_count
      end
    end
  end

  def test_list_import_data_files
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ListImportDataFilesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_import_data_files_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_list_import_data_files_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_import_data_files_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_import_data_files({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_import_data_files parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_import_data_files ::Google::Cloud::MigrationCenter::V1::ListImportDataFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_import_data_files({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_import_data_files(::Google::Cloud::MigrationCenter::V1::ListImportDataFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_import_data_files_client_stub.call_count
      end
    end
  end

  def test_create_import_data_file
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    import_data_file_id = "hello world"
    import_data_file = {}
    request_id = "hello world"

    create_import_data_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_create_import_data_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_import_data_file_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_import_data_file({ parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_import_data_file parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_import_data_file ::Google::Cloud::MigrationCenter::V1::CreateImportDataFileRequest.new(parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_import_data_file({ parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_import_data_file(::Google::Cloud::MigrationCenter::V1::CreateImportDataFileRequest.new(parent: parent, import_data_file_id: import_data_file_id, import_data_file: import_data_file, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_import_data_file_client_stub.call_count
      end
    end
  end

  def test_delete_import_data_file
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_import_data_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_delete_import_data_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_import_data_file_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_import_data_file({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_import_data_file name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_import_data_file ::Google::Cloud::MigrationCenter::V1::DeleteImportDataFileRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_import_data_file({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_import_data_file(::Google::Cloud::MigrationCenter::V1::DeleteImportDataFileRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_import_data_file_client_stub.call_count
      end
    end
  end

  def test_list_groups
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ListGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_list_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_groups_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_groups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_groups ::Google::Cloud::MigrationCenter::V1::ListGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_groups(::Google::Cloud::MigrationCenter::V1::ListGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_groups_client_stub.call_count
      end
    end
  end

  def test_get_group
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::Group.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_group_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_group ::Google::Cloud::MigrationCenter::V1::GetGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_group(::Google::Cloud::MigrationCenter::V1::GetGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_group_client_stub.call_count
      end
    end
  end

  def test_create_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    group_id = "hello world"
    group = {}
    request_id = "hello world"

    create_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_create_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_group_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_group({ parent: parent, group_id: group_id, group: group, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_group parent: parent, group_id: group_id, group: group, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_group ::Google::Cloud::MigrationCenter::V1::CreateGroupRequest.new(parent: parent, group_id: group_id, group: group, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_group({ parent: parent, group_id: group_id, group: group, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_group(::Google::Cloud::MigrationCenter::V1::CreateGroupRequest.new(parent: parent, group_id: group_id, group: group, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_group_client_stub.call_count
      end
    end
  end

  def test_update_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    group = {}
    request_id = "hello world"

    update_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_update_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_group_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_group({ update_mask: update_mask, group: group, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_group update_mask: update_mask, group: group, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_group ::Google::Cloud::MigrationCenter::V1::UpdateGroupRequest.new(update_mask: update_mask, group: group, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_group({ update_mask: update_mask, group: group, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_group(::Google::Cloud::MigrationCenter::V1::UpdateGroupRequest.new(update_mask: update_mask, group: group, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_group_client_stub.call_count
      end
    end
  end

  def test_delete_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_delete_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_group_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_group({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_group name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_group ::Google::Cloud::MigrationCenter::V1::DeleteGroupRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_group({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_group(::Google::Cloud::MigrationCenter::V1::DeleteGroupRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_group_client_stub.call_count
      end
    end
  end

  def test_add_assets_to_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    group = "hello world"
    request_id = "hello world"
    assets = {}
    allow_existing = true

    add_assets_to_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_add_assets_to_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_assets_to_group_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_assets_to_group({ group: group, request_id: request_id, assets: assets, allow_existing: allow_existing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_assets_to_group group: group, request_id: request_id, assets: assets, allow_existing: allow_existing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_assets_to_group ::Google::Cloud::MigrationCenter::V1::AddAssetsToGroupRequest.new(group: group, request_id: request_id, assets: assets, allow_existing: allow_existing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_assets_to_group({ group: group, request_id: request_id, assets: assets, allow_existing: allow_existing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_assets_to_group(::Google::Cloud::MigrationCenter::V1::AddAssetsToGroupRequest.new(group: group, request_id: request_id, assets: assets, allow_existing: allow_existing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_assets_to_group_client_stub.call_count
      end
    end
  end

  def test_remove_assets_from_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    group = "hello world"
    request_id = "hello world"
    assets = {}
    allow_missing = true

    remove_assets_from_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_remove_assets_from_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_assets_from_group_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_assets_from_group({ group: group, request_id: request_id, assets: assets, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_assets_from_group group: group, request_id: request_id, assets: assets, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_assets_from_group ::Google::Cloud::MigrationCenter::V1::RemoveAssetsFromGroupRequest.new(group: group, request_id: request_id, assets: assets, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_assets_from_group({ group: group, request_id: request_id, assets: assets, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_assets_from_group(::Google::Cloud::MigrationCenter::V1::RemoveAssetsFromGroupRequest.new(group: group, request_id: request_id, assets: assets, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_assets_from_group_client_stub.call_count
      end
    end
  end

  def test_list_error_frames
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ListErrorFramesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :ERROR_FRAME_VIEW_UNSPECIFIED

    list_error_frames_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_list_error_frames_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_error_frames_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_error_frames({ parent: parent, page_size: page_size, page_token: page_token, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_error_frames parent: parent, page_size: page_size, page_token: page_token, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_error_frames ::Google::Cloud::MigrationCenter::V1::ListErrorFramesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_error_frames({ parent: parent, page_size: page_size, page_token: page_token, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_error_frames(::Google::Cloud::MigrationCenter::V1::ListErrorFramesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_error_frames_client_stub.call_count
      end
    end
  end

  def test_get_error_frame
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ErrorFrame.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :ERROR_FRAME_VIEW_UNSPECIFIED

    get_error_frame_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_error_frame_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_error_frame_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_error_frame({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_error_frame name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_error_frame ::Google::Cloud::MigrationCenter::V1::GetErrorFrameRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_error_frame({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_error_frame(::Google::Cloud::MigrationCenter::V1::GetErrorFrameRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_error_frame_client_stub.call_count
      end
    end
  end

  def test_list_sources
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ListSourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_list_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sources_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sources parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sources ::Google::Cloud::MigrationCenter::V1::ListSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sources(::Google::Cloud::MigrationCenter::V1::ListSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sources_client_stub.call_count
      end
    end
  end

  def test_get_source
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_source_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_source({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_source name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_source ::Google::Cloud::MigrationCenter::V1::GetSourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_source({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_source(::Google::Cloud::MigrationCenter::V1::GetSourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_source_client_stub.call_count
      end
    end
  end

  def test_create_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source_id = "hello world"
    source = {}
    request_id = "hello world"

    create_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_create_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_source_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_source({ parent: parent, source_id: source_id, source: source, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_source parent: parent, source_id: source_id, source: source, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_source ::Google::Cloud::MigrationCenter::V1::CreateSourceRequest.new(parent: parent, source_id: source_id, source: source, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_source({ parent: parent, source_id: source_id, source: source, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_source(::Google::Cloud::MigrationCenter::V1::CreateSourceRequest.new(parent: parent, source_id: source_id, source: source, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_source_client_stub.call_count
      end
    end
  end

  def test_update_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    source = {}
    request_id = "hello world"

    update_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_update_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_source_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_source({ update_mask: update_mask, source: source, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_source update_mask: update_mask, source: source, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_source ::Google::Cloud::MigrationCenter::V1::UpdateSourceRequest.new(update_mask: update_mask, source: source, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_source({ update_mask: update_mask, source: source, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_source(::Google::Cloud::MigrationCenter::V1::UpdateSourceRequest.new(update_mask: update_mask, source: source, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_source_client_stub.call_count
      end
    end
  end

  def test_delete_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_delete_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_source_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_source({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_source name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_source ::Google::Cloud::MigrationCenter::V1::DeleteSourceRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_source({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_source(::Google::Cloud::MigrationCenter::V1::DeleteSourceRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_source_client_stub.call_count
      end
    end
  end

  def test_list_preference_sets
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_preference_sets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_list_preference_sets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_preference_sets_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_preference_sets({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_preference_sets parent: parent, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_preference_sets ::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_preference_sets({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_preference_sets(::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_preference_sets_client_stub.call_count
      end
    end
  end

  def test_get_preference_set
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::PreferenceSet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_preference_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_preference_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_preference_set_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_preference_set({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_preference_set name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_preference_set ::Google::Cloud::MigrationCenter::V1::GetPreferenceSetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_preference_set({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_preference_set(::Google::Cloud::MigrationCenter::V1::GetPreferenceSetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_preference_set_client_stub.call_count
      end
    end
  end

  def test_create_preference_set
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    preference_set_id = "hello world"
    preference_set = {}
    request_id = "hello world"

    create_preference_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_create_preference_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_preference_set_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_preference_set({ parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_preference_set parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_preference_set ::Google::Cloud::MigrationCenter::V1::CreatePreferenceSetRequest.new(parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_preference_set({ parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_preference_set(::Google::Cloud::MigrationCenter::V1::CreatePreferenceSetRequest.new(parent: parent, preference_set_id: preference_set_id, preference_set: preference_set, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_preference_set_client_stub.call_count
      end
    end
  end

  def test_update_preference_set
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    preference_set = {}
    request_id = "hello world"

    update_preference_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_update_preference_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_preference_set_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_preference_set({ update_mask: update_mask, preference_set: preference_set, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_preference_set update_mask: update_mask, preference_set: preference_set, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_preference_set ::Google::Cloud::MigrationCenter::V1::UpdatePreferenceSetRequest.new(update_mask: update_mask, preference_set: preference_set, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_preference_set({ update_mask: update_mask, preference_set: preference_set, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_preference_set(::Google::Cloud::MigrationCenter::V1::UpdatePreferenceSetRequest.new(update_mask: update_mask, preference_set: preference_set, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_preference_set_client_stub.call_count
      end
    end
  end

  def test_delete_preference_set
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_preference_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_delete_preference_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_preference_set_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_preference_set({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_preference_set name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_preference_set ::Google::Cloud::MigrationCenter::V1::DeletePreferenceSetRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_preference_set({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_preference_set(::Google::Cloud::MigrationCenter::V1::DeletePreferenceSetRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_preference_set_client_stub.call_count
      end
    end
  end

  def test_get_settings
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::Settings.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_settings_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_settings({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_settings name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_settings ::Google::Cloud::MigrationCenter::V1::GetSettingsRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_settings({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_settings(::Google::Cloud::MigrationCenter::V1::GetSettingsRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_settings_client_stub.call_count
      end
    end
  end

  def test_update_settings
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    settings = {}
    request_id = "hello world"

    update_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_update_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_settings_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_settings({ update_mask: update_mask, settings: settings, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_settings update_mask: update_mask, settings: settings, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_settings ::Google::Cloud::MigrationCenter::V1::UpdateSettingsRequest.new(update_mask: update_mask, settings: settings, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_settings({ update_mask: update_mask, settings: settings, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_settings(::Google::Cloud::MigrationCenter::V1::UpdateSettingsRequest.new(update_mask: update_mask, settings: settings, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_settings_client_stub.call_count
      end
    end
  end

  def test_create_report_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    report_config_id = "hello world"
    report_config = {}
    request_id = "hello world"

    create_report_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_create_report_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_report_config_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_report_config({ parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_report_config parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_report_config ::Google::Cloud::MigrationCenter::V1::CreateReportConfigRequest.new(parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_report_config({ parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_report_config(::Google::Cloud::MigrationCenter::V1::CreateReportConfigRequest.new(parent: parent, report_config_id: report_config_id, report_config: report_config, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_report_config_client_stub.call_count
      end
    end
  end

  def test_get_report_config
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ReportConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_report_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_report_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_report_config_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_report_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_report_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_report_config ::Google::Cloud::MigrationCenter::V1::GetReportConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_report_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_report_config(::Google::Cloud::MigrationCenter::V1::GetReportConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_report_config_client_stub.call_count
      end
    end
  end

  def test_list_report_configs
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ListReportConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_report_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_list_report_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_report_configs_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_report_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_report_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_report_configs ::Google::Cloud::MigrationCenter::V1::ListReportConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_report_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_report_configs(::Google::Cloud::MigrationCenter::V1::ListReportConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_report_configs_client_stub.call_count
      end
    end
  end

  def test_delete_report_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_report_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_delete_report_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_report_config_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_report_config({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_report_config name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_report_config ::Google::Cloud::MigrationCenter::V1::DeleteReportConfigRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_report_config({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_report_config(::Google::Cloud::MigrationCenter::V1::DeleteReportConfigRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_report_config_client_stub.call_count
      end
    end
  end

  def test_create_report
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    report_id = "hello world"
    report = {}
    request_id = "hello world"

    create_report_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_create_report_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_report_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_report({ parent: parent, report_id: report_id, report: report, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_report parent: parent, report_id: report_id, report: report, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_report ::Google::Cloud::MigrationCenter::V1::CreateReportRequest.new(parent: parent, report_id: report_id, report: report, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_report({ parent: parent, report_id: report_id, report: report, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_report(::Google::Cloud::MigrationCenter::V1::CreateReportRequest.new(parent: parent, report_id: report_id, report: report, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_report_client_stub.call_count
      end
    end
  end

  def test_get_report
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::Report.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :REPORT_VIEW_UNSPECIFIED

    get_report_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_get_report_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_report_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_report({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_report name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_report ::Google::Cloud::MigrationCenter::V1::GetReportRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_report({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_report(::Google::Cloud::MigrationCenter::V1::GetReportRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_report_client_stub.call_count
      end
    end
  end

  def test_list_reports
    # Create test objects.
    client_result = ::Google::Cloud::MigrationCenter::V1::ListReportsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :REPORT_VIEW_UNSPECIFIED

    list_reports_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_list_reports_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_reports_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_reports({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_reports parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_reports ::Google::Cloud::MigrationCenter::V1::ListReportsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_reports({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_reports(::Google::Cloud::MigrationCenter::V1::ListReportsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_reports_client_stub.call_count
      end
    end
  end

  def test_delete_report
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_report_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.stub :transcode_delete_report_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_report_client_stub do
        # Create client
        client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_report({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_report name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_report ::Google::Cloud::MigrationCenter::V1::DeleteReportRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_report({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_report(::Google::Cloud::MigrationCenter::V1::DeleteReportRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_report_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client::Configuration, config
  end
end
