# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/migration_center/v1/migration_center"

class ::Google::Cloud::MigrationCenter::V1::MigrationCenter::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_asset_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.asset_path project: "value0", location: "value1", asset: "value2"
      assert_equal "projects/value0/locations/value1/assets/value2", path
    end
  end

  def test_error_frame_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.error_frame_path project: "value0", location: "value1", source: "value2", error_frame: "value3"
      assert_equal "projects/value0/locations/value1/sources/value2/errorFrames/value3", path
    end
  end

  def test_group_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.group_path project: "value0", location: "value1", group: "value2"
      assert_equal "projects/value0/locations/value1/groups/value2", path
    end
  end

  def test_import_data_file_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.import_data_file_path project: "value0", location: "value1", import_job: "value2", import_data_file: "value3"
      assert_equal "projects/value0/locations/value1/importJobs/value2/importDataFiles/value3", path
    end
  end

  def test_import_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.import_job_path project: "value0", location: "value1", import_job: "value2"
      assert_equal "projects/value0/locations/value1/importJobs/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_preference_set_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.preference_set_path project: "value0", location: "value1", preference_set: "value2"
      assert_equal "projects/value0/locations/value1/preferenceSets/value2", path
    end
  end

  def test_report_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.report_path project: "value0", location: "value1", report_config: "value2", report: "value3"
      assert_equal "projects/value0/locations/value1/reportConfigs/value2/reports/value3", path
    end
  end

  def test_report_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.report_config_path project: "value0", location: "value1", report_config: "value2"
      assert_equal "projects/value0/locations/value1/reportConfigs/value2", path
    end
  end

  def test_settings_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.settings_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/settings", path
    end
  end

  def test_source_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.source_path project: "value0", location: "value1", source: "value2"
      assert_equal "projects/value0/locations/value1/sources/value2", path
    end
  end
end
