# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module MigrationCenter
      module V1
        # An asset represents a resource in your environment. Asset types include
        # virtual machines and databases.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The full name of the asset.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the asset was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the asset was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Generic asset attributes.
        # @!attribute [r] machine_details
        #   @return [::Google::Cloud::MigrationCenter::V1::MachineDetails]
        #     Output only. Asset information specific for virtual and physical
        #     machines.
        # @!attribute [r] insight_list
        #   @return [::Google::Cloud::MigrationCenter::V1::InsightList]
        #     Output only. The list of insights associated with the asset.
        # @!attribute [r] performance_data
        #   @return [::Google::Cloud::MigrationCenter::V1::AssetPerformanceData]
        #     Output only. Performance data for the asset.
        # @!attribute [r] sources
        #   @return [::Array<::String>]
        #     Output only. The list of sources contributing to the asset.
        # @!attribute [r] assigned_groups
        #   @return [::Array<::String>]
        #     Output only. The list of groups that the asset is assigned to.
        class Asset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The preferences that apply to all assets in a given context.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the preference set.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the preference set was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the preference set was last updated.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-friendly display name. Maximum length is 63 characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of the preference set.
        # @!attribute [rw] virtual_machine_preferences
        #   @return [::Google::Cloud::MigrationCenter::V1::VirtualMachinePreferences]
        #     A set of preferences that applies to all virtual machines in the context.
        class PreferenceSet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource that represents the background job that imports asset frames.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The full name of the import job.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-friendly display name. Maximum length is 63 characters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the import job was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the import job was last updated.
        # @!attribute [r] complete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the import job was completed.
        # @!attribute [r] state
        #   @return [::Google::Cloud::MigrationCenter::V1::ImportJob::ImportJobState]
        #     Output only. The state of the import job.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] asset_source
        #   @return [::String]
        #     Required. Reference to a source.
        # @!attribute [r] validation_report
        #   @return [::Google::Cloud::MigrationCenter::V1::ValidationReport]
        #     Output only. The report with the validation results of the import job.
        #
        #     Note: The following fields are mutually exclusive: `validation_report`, `execution_report`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] execution_report
        #   @return [::Google::Cloud::MigrationCenter::V1::ExecutionReport]
        #     Output only. The report with the results of running the import job.
        #
        #     Note: The following fields are mutually exclusive: `execution_report`, `validation_report`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ImportJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enumerates possible states of an import job.
          module ImportJobState
            # Default value.
            IMPORT_JOB_STATE_UNSPECIFIED = 0

            # The import job is pending.
            IMPORT_JOB_STATE_PENDING = 1

            # The processing of the import job is ongoing.
            IMPORT_JOB_STATE_RUNNING = 2

            # The import job processing has completed.
            IMPORT_JOB_STATE_COMPLETED = 3

            # The import job failed to be processed.
            IMPORT_JOB_STATE_FAILED = 4

            # The import job is being validated.
            IMPORT_JOB_STATE_VALIDATING = 5

            # The import job contains blocking errors.
            IMPORT_JOB_STATE_FAILED_VALIDATION = 6

            # The validation of the job completed with no blocking errors.
            IMPORT_JOB_STATE_READY = 7
          end
        end

        # A resource that represents a payload file in an import job.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the file.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-friendly display name. Maximum length is 63 characters.
        # @!attribute [rw] format
        #   @return [::Google::Cloud::MigrationCenter::V1::ImportJobFormat]
        #     Required. The payload format.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the file was created.
        # @!attribute [r] state
        #   @return [::Google::Cloud::MigrationCenter::V1::ImportDataFile::State]
        #     Output only. The state of the import data file.
        # @!attribute [rw] upload_file_info
        #   @return [::Google::Cloud::MigrationCenter::V1::UploadFileInfo]
        #     Information about a file that is uploaded to a storage service.
        class ImportDataFile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumerates possible states of an import data file.
          module State
            # Default value.
            STATE_UNSPECIFIED = 0

            # The data file is being created.
            CREATING = 1

            # The data file completed initialization.
            ACTIVE = 2
          end
        end

        # A resource that represents an asset group.
        # The purpose of an asset group is to bundle a set of assets that have
        # something in common, while allowing users to add annotations to the group.
        # An asset can belong to multiple groups.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the group.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the group was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the group was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-friendly display name.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the resource.
        class Group
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message representing a frame which failed to be processed due to an error.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The identifier of the ErrorFrame.
        # @!attribute [r] violations
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::FrameViolationEntry>]
        #     Output only. All the violations that were detected for the frame.
        # @!attribute [r] original_frame
        #   @return [::Google::Cloud::MigrationCenter::V1::AssetFrame]
        #     Output only. The frame that was originally reported.
        # @!attribute [r] ingestion_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Frame ingestion time.
        class ErrorFrame
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Source represents an object from which asset information is
        # streamed to Migration Center.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The full name of the source.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the source was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the source was last updated.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-friendly display name.
        # @!attribute [rw] description
        #   @return [::String]
        #     Free-text description.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::MigrationCenter::V1::Source::SourceType]
        #     Data source type.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     The information confidence of the source.
        #     The higher the value, the higher the confidence.
        # @!attribute [rw] managed
        #   @return [::Boolean]
        #     If `true`, the source is managed by other service(s).
        # @!attribute [r] pending_frame_count
        #   @return [::Integer]
        #     Output only. Number of frames that are still being processed.
        # @!attribute [r] error_frame_count
        #   @return [::Integer]
        #     Output only. The number of frames that were reported by the source and
        #     contained errors.
        # @!attribute [r] state
        #   @return [::Google::Cloud::MigrationCenter::V1::Source::State]
        #     Output only. The state of the source.
        class Source
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          module SourceType
            # Unspecified
            SOURCE_TYPE_UNKNOWN = 0

            # Manually uploaded file (e.g. CSV)
            SOURCE_TYPE_UPLOAD = 1

            # Guest-level info
            SOURCE_TYPE_GUEST_OS_SCAN = 2

            # Inventory-level scan
            SOURCE_TYPE_INVENTORY_SCAN = 3

            # Third-party owned sources.
            SOURCE_TYPE_CUSTOM = 4
          end

          # Enumerates possible states of a source.
          module State
            # Unspecified.
            STATE_UNSPECIFIED = 0

            # The source is active and ready to be used.
            ACTIVE = 1

            # In the process of being deleted.
            DELETING = 2

            # Source is in an invalid state. Asset frames reported to it will be
            # ignored.
            INVALID = 3
          end
        end

        # The groups and associated preference sets on which
        # we can generate reports.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was last updated.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-friendly display name. Maximum length is 63 characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     Free-text description.
        # @!attribute [rw] group_preferenceset_assignments
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ReportConfig::GroupPreferenceSetAssignment>]
        #     Required. Collection of combinations of groups and preference sets.
        class ReportConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a combination of a group with a preference set.
          # @!attribute [rw] group
          #   @return [::String]
          #     Required. Name of the group.
          # @!attribute [rw] preference_set
          #   @return [::String]
          #     Required. Name of the Preference Set.
          class GroupPreferenceSetAssignment
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Report represents a point-in-time rendering of the ReportConfig results.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update timestamp.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-friendly display name. Maximum length is 63 characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     Free-text description.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::MigrationCenter::V1::Report::Type]
        #     Report type.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::MigrationCenter::V1::Report::State]
        #     Report creation state.
        # @!attribute [r] summary
        #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary]
        #     Output only. Summary view of the Report.
        class Report
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Report type.
          module Type
            # Default Report type.
            TYPE_UNSPECIFIED = 0

            # Total cost of ownership Report type.
            TOTAL_COST_OF_OWNERSHIP = 1
          end

          # Report creation state.
          module State
            # Default Report creation state.
            STATE_UNSPECIFIED = 0

            # Creating Report.
            PENDING = 1

            # Successfully created Report.
            SUCCEEDED = 2

            # Failed to create Report.
            FAILED = 3
          end
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting a list of assets.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for `ListAssetsRequest`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::MigrationCenter::V1::AssetView]
        #     View of the assets. Defaults to BASIC.
        class ListAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing assets.
        # @!attribute [rw] assets
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::Asset>]
        #     A list of assets.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Asset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::MigrationCenter::V1::AssetView]
        #     View of the assets. Defaults to BASIC.
        class GetAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update an asset.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `Asset` resource by the update.
        #     The values specified in the `update_mask` field are relative to the
        #     resource, not the full request.
        #     A field will be overwritten if it is in the mask.
        #     A single * value in the mask lets you to overwrite all fields.
        # @!attribute [rw] asset
        #   @return [::Google::Cloud::MigrationCenter::V1::Asset]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update a list of assets.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for batch asset update.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest>]
        #     Required. The request message specifying the resources to update.
        #     A maximum of 1000 assets can be modified in a batch.
        class BatchUpdateAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for updating a list of assets.
        # @!attribute [rw] assets
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::Asset>]
        #     Update asset content.
        #     The content only includes values after field mask being applied.
        class BatchUpdateAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete an asset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a list of  asset.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for batch asset delete.
        # @!attribute [rw] names
        #   @return [::Array<::String>]
        #     Required. The IDs of the assets to delete.
        #     A maximum of 1000 assets can be deleted in a batch.
        #     Format: projects/\\{project}/locations/\\{location}/assets/\\{name}.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. When this value is set to `true` the request is a no-op for
        #     non-existing assets. See https://google.aip.dev/135#delete-if-existing for
        #     additional details. Default value is `false`.
        class BatchDeleteAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to report a set of asset frames.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent of the resource.
        # @!attribute [rw] frames
        #   @return [::Google::Cloud::MigrationCenter::V1::Frames]
        #     Collection of frames data.
        # @!attribute [rw] source
        #   @return [::String]
        #     Required. Reference to a source.
        class ReportAssetFramesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response to a call to `ReportAssetFrame`.
        class ReportAssetFramesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to aggregate one or more values.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for `AggregateAssetsValuesRequest`.
        # @!attribute [rw] aggregations
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::Aggregation>]
        #     Array of aggregations to perform.
        #     Up to 25 aggregations can be defined.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The aggregation will be performed on assets that match the provided filter.
        class AggregateAssetsValuesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response to a request to aggregated assets values.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::AggregationResult>]
        #     The aggregation results.
        class AggregateAssetsValuesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create an import job.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] import_job_id
        #   @return [::String]
        #     Required. ID of the import job.
        # @!attribute [rw] import_job
        #   @return [::Google::Cloud::MigrationCenter::V1::ImportJob]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list import jobs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for `ListImportJobsRequest`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::MigrationCenter::V1::ImportJobView]
        #     Optional. The level of details of each import job.
        #     Default value is BASIC.
        class ListImportJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response for listing import jobs.
        # @!attribute [rw] import_jobs
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ImportJob>]
        #     The list of import jobs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListImportJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get an import job.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::MigrationCenter::V1::ImportJobView]
        #     Optional. The level of details of the import job.
        #     Default value is FULL.
        class GetImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete an import job.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to `true`, any `ImportDataFiles` of this job will also be
        #     deleted If set to `false`, the request only works if the job has no data
        #     files.
        class DeleteImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update an import job.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `Asset` resource by the update.
        #     The values specified in the `update_mask` field are relative to the
        #     resource, not the full request.
        #     A field will be overwritten if it is in the mask.
        #     A single * value in the mask lets you to overwrite all fields.
        # @!attribute [rw] import_job
        #   @return [::Google::Cloud::MigrationCenter::V1::ImportJob]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to validate an import job.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the import job to validate.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class ValidateImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to run an import job.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the import job to run.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class RunImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get an import data file.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ImportDataFile.
        class GetImportDataFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list import data files of an import job.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent of the `ImportDataFiles` resource.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of data files to return. The service may return
        #     fewer than this value. If unspecified, at most 500 data files will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListImportDataFiles` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListImportDataFiles`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        class ListImportDataFilesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for listing payload files of an import job.
        # @!attribute [rw] import_data_files
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ImportDataFile>]
        #     The list of import data files.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListImportDataFilesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create an `ImportDataFile` resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent of the ImportDataFile.
        # @!attribute [rw] import_data_file_id
        #   @return [::String]
        #     Required. The ID of the new data file.
        # @!attribute [rw] import_data_file
        #   @return [::Google::Cloud::MigrationCenter::V1::ImportDataFile]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateImportDataFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete an `ImportDataFile` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ImportDataFile to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteImportDataFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list groups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for `ListGroupsRequest`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        class ListGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response for listing groups.
        # @!attribute [rw] groups
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::Group>]
        #     The list of Group
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a group.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a group.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] group_id
        #   @return [::String]
        #     Required. User specified ID for the group. It will become the last
        #     component of the group name. The ID must be unique within the project, must
        #     conform with RFC-1034, is restricted to lower-cased letters, and has a
        #     maximum length of 63 characters. The ID must match the regular expression:
        #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
        # @!attribute [rw] group
        #   @return [::Google::Cloud::MigrationCenter::V1::Group]
        #     Required. The group resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update a group.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `Group` resource by the update.
        #     The values specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask.
        #     A single * value in the mask lets you to overwrite all fields.
        # @!attribute [rw] group
        #   @return [::Google::Cloud::MigrationCenter::V1::Group]
        #     Required. The group resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a group.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the group resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to add assets to a group.
        # @!attribute [rw] group
        #   @return [::String]
        #     Required. Group reference.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] assets
        #   @return [::Google::Cloud::MigrationCenter::V1::AssetList]
        #     Required. List of assets to be added.
        #     The maximum number of assets that can be added in a single request is
        #     1000.
        # @!attribute [rw] allow_existing
        #   @return [::Boolean]
        #     Optional. When this value is set to `false` and one of the given assets is
        #     already an existing member of the group, the operation fails with an
        #     `Already Exists` error. When set to `true` this situation is silently
        #     ignored by the server.
        #
        #     Default value is `false`.
        class AddAssetsToGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to remove assets from a group.
        # @!attribute [rw] group
        #   @return [::String]
        #     Required. Group reference.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] assets
        #   @return [::Google::Cloud::MigrationCenter::V1::AssetList]
        #     Required. List of assets to be removed.
        #     The maximum number of assets that can be removed in a single request is
        #     1000.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. When this value is set to `false` and one of the given assets is
        #     not an existing member of the group, the operation fails with a `Not Found`
        #     error. When set to `true` this situation is silently ignored by the server.
        #
        #     Default value is `false`.
        class RemoveAssetsFromGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list error frames for a source.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value (the source) for `ListErrorFramesRequest`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::MigrationCenter::V1::ErrorFrameView]
        #     Optional. An optional view mode to control the level of details of each
        #     error frame. The default is a BASIC frame view.
        class ListErrorFramesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response for listing error frames.
        # @!attribute [rw] error_frames
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ErrorFrame>]
        #     The list of error frames.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListErrorFramesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the frame to retrieve.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/sources/\\{source}/errorFrames/\\{error_frame}
        # @!attribute [rw] view
        #   @return [::Google::Cloud::MigrationCenter::V1::ErrorFrameView]
        #     Optional. An optional view mode to control the level of details for the
        #     frame. The default is a basic frame view.
        class GetErrorFrameRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request for a list of sources.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for `ListSourcesRequest`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. The server may return fewer items than requested.
        #     If unspecified, the server will pick an appropriate default value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results that the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        class ListSourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing sources.
        # @!attribute [rw] sources
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::Source>]
        #     The list of sources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListSourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a source.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a source.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] source_id
        #   @return [::String]
        #     Required. User specified ID for the source. It will become the last
        #     component of the source name. The ID must be unique within the project,
        #     must conform with RFC-1034, is restricted to lower-cased letters, and has a
        #     maximum length of 63 characters. The ID must match the regular expression:
        #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::MigrationCenter::V1::Source]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update a source.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `Source` resource by the update.
        #     The values specified in the `update_mask` field are relative to the
        #     resource, not the full request.
        #     A field will be overwritten if it is in the mask.
        #     A single * value in the mask lets you to overwrite all fields.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::MigrationCenter::V1::Source]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a source.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for listing preference sets.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for `ListPreferenceSetsRequest`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, at most 500 preference sets will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        class ListPreferenceSetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing preference sets.
        # @!attribute [rw] preference_sets
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::PreferenceSet>]
        #     The list of PreferenceSets
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListPreferenceSetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a preference set.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetPreferenceSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a preference set.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] preference_set_id
        #   @return [::String]
        #     Required. User specified ID for the preference set. It will become the last
        #     component of the preference set name. The ID must be unique within the
        #     project, must conform with RFC-1034, is restricted to lower-cased letters,
        #     and has a maximum length of 63 characters. The ID must match the regular
        #     expression
        #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
        # @!attribute [rw] preference_set
        #   @return [::Google::Cloud::MigrationCenter::V1::PreferenceSet]
        #     Required. The preference set resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreatePreferenceSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update a preference set.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `PreferenceSet` resource by the update.
        #     The values specified in the `update_mask` field are relative to the
        #     resource, not the full request.
        #     A field will be overwritten if it is in the mask.
        #     A single * value in the mask lets you to overwrite all fields.
        # @!attribute [rw] preference_set
        #   @return [::Google::Cloud::MigrationCenter::V1::PreferenceSet]
        #     Required. The preference set resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdatePreferenceSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a preference set.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the group resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeletePreferenceSetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get the settings.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update the settings.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `Settings` resource by the update.
        #     The values specified in the `update_mask` field are relative to the
        #     resource, not the full request.
        #     A field will be overwritten if it is in the mask.
        #     A single * value in the mask lets you to overwrite all fields.
        # @!attribute [rw] settings
        #   @return [::Google::Cloud::MigrationCenter::V1::Settings]
        #     Required. The project settings resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a `ReportConfig` resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] report_config_id
        #   @return [::String]
        #     Required. User specified ID for the report config. It will become the last
        #     component of the report config name. The ID must be unique within the
        #     project, must conform with RFC-1034, is restricted to lower-cased letters,
        #     and has a maximum length of 63 characters. The ID must match the regular
        #     expression: [a-z]([a-z0-9-]\\{0,61}[a-z0-9])?.
        # @!attribute [rw] report_config
        #   @return [::Google::Cloud::MigrationCenter::V1::ReportConfig]
        #     Required. The report config set resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateReportConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a ReportConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to `true`, any child `Reports` of this entity will also be
        #     deleted. If set to `false`, the request only works if the resource has no
        #     children.
        class DeleteReportConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a Report.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::MigrationCenter::V1::ReportView]
        #     Determines what information to retrieve for the Report.
        class GetReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request for a list of Reports.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for `ListReportsRequest`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. The server may return fewer items than requested.
        #     If unspecified, the server will pick an appropriate default value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results that the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::MigrationCenter::V1::ReportView]
        #     Determines what information to retrieve for each Report.
        class ListReportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing Reports.
        # @!attribute [rw] reports
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::Report>]
        #     The list of Reports.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListReportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a Report.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a `ReportConfig` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetReportConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a list of `ReportConfig` resources.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for `ListReportConfigsRequest`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        class ListReportConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing report configs.
        # @!attribute [rw] report_configs
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ReportConfig>]
        #     A list of report configs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListReportConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Report.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] report_id
        #   @return [::String]
        #     Required. User specified id for the report. It will become the last
        #     component of the report name. The id must be unique within the project,
        #     must conform with RFC-1034, is restricted to lower-cased letters, and has a
        #     maximum length of 63 characters. The id must match the regular expression:
        #     [a-z]([a-z0-9-]\\{0,61}[a-z0-9])?.
        # @!attribute [rw] report
        #   @return [::Google::Cloud::MigrationCenter::V1::Report]
        #     Required. The report resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Collection of frame data.
        # @!attribute [rw] frames_data
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::AssetFrame>]
        #     A repeated field of asset data.
        class Frames
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains data reported from an inventory source on an asset.
        # @!attribute [rw] machine_details
        #   @return [::Google::Cloud::MigrationCenter::V1::MachineDetails]
        #     Asset information specific for virtual machines.
        # @!attribute [rw] report_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the data was reported.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Generic asset attributes.
        # @!attribute [rw] performance_samples
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::PerformanceSample>]
        #     Asset performance data samples.
        #     Samples that are from more than 40 days ago or after tomorrow are ignored.
        # @!attribute [rw] trace_token
        #   @return [::String]
        #     Optional. Trace token is optionally provided to assist with debugging and
        #     traceability.
        class AssetFrame
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Details of a machine.
        # @!attribute [rw] uuid
        #   @return [::String]
        #     Machine unique identifier.
        # @!attribute [rw] machine_name
        #   @return [::String]
        #     Machine name.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Machine creation time.
        # @!attribute [rw] core_count
        #   @return [::Integer]
        #     Number of CPU cores in the machine. Must be non-negative.
        # @!attribute [rw] memory_mb
        #   @return [::Integer]
        #     The amount of memory in the machine. Must be non-negative.
        # @!attribute [rw] power_state
        #   @return [::Google::Cloud::MigrationCenter::V1::MachineDetails::PowerState]
        #     Power state of the machine.
        # @!attribute [rw] architecture
        #   @return [::Google::Cloud::MigrationCenter::V1::MachineArchitectureDetails]
        #     Architecture details (vendor, CPU architecture).
        # @!attribute [rw] guest_os
        #   @return [::Google::Cloud::MigrationCenter::V1::GuestOsDetails]
        #     Guest OS information.
        # @!attribute [rw] network
        #   @return [::Google::Cloud::MigrationCenter::V1::MachineNetworkDetails]
        #     Network details.
        # @!attribute [rw] disks
        #   @return [::Google::Cloud::MigrationCenter::V1::MachineDiskDetails]
        #     Disk details.
        # @!attribute [rw] platform
        #   @return [::Google::Cloud::MigrationCenter::V1::PlatformDetails]
        #     Platform specific information.
        class MachineDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Machine power state.
          module PowerState
            # Power state is unknown.
            POWER_STATE_UNSPECIFIED = 0

            # The machine is preparing to enter the ACTIVE state. An instance may enter
            # the PENDING state when it launches for the first time, or when it is
            # started after being in the SUSPENDED state.
            PENDING = 1

            # The machine is active.
            ACTIVE = 2

            # The machine is being turned off.
            SUSPENDING = 3

            # The machine is off.
            SUSPENDED = 4

            # The machine is being deleted from the hosting platform.
            DELETING = 5

            # The machine is deleted from the hosting platform.
            DELETED = 6
          end
        end

        # Details of the machine architecture.
        # @!attribute [rw] cpu_architecture
        #   @return [::String]
        #     CPU architecture, e.g., "x64-based PC", "x86_64", "i686" etc.
        # @!attribute [rw] cpu_name
        #   @return [::String]
        #     CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
        # @!attribute [rw] vendor
        #   @return [::String]
        #     Hardware vendor.
        # @!attribute [rw] cpu_thread_count
        #   @return [::Integer]
        #     Number of CPU threads allocated to the machine.
        # @!attribute [rw] cpu_socket_count
        #   @return [::Integer]
        #     Number of processor sockets allocated to the machine.
        # @!attribute [rw] bios
        #   @return [::Google::Cloud::MigrationCenter::V1::BiosDetails]
        #     BIOS Details.
        # @!attribute [rw] firmware_type
        #   @return [::Google::Cloud::MigrationCenter::V1::MachineArchitectureDetails::FirmwareType]
        #     Firmware type.
        # @!attribute [rw] hyperthreading
        #   @return [::Google::Cloud::MigrationCenter::V1::MachineArchitectureDetails::CpuHyperThreading]
        #     CPU hyper-threading support.
        class MachineArchitectureDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Firmware type.
          module FirmwareType
            # Unspecified or unknown.
            FIRMWARE_TYPE_UNSPECIFIED = 0

            # BIOS firmware.
            BIOS = 1

            # EFI firmware.
            EFI = 2
          end

          # CPU hyper-threading support.
          module CpuHyperThreading
            # Unspecified or unknown.
            CPU_HYPER_THREADING_UNSPECIFIED = 0

            # Hyper-threading is disabled.
            DISABLED = 1

            # Hyper-threading is enabled.
            ENABLED = 2
          end
        end

        # Details about the BIOS.
        # @!attribute [rw] bios_name
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     BIOS name.
        #     This fields is deprecated. Please use the `id` field instead.
        # @!attribute [rw] id
        #   @return [::String]
        #     BIOS ID.
        # @!attribute [rw] manufacturer
        #   @return [::String]
        #     BIOS manufacturer.
        # @!attribute [rw] version
        #   @return [::String]
        #     BIOS version.
        # @!attribute [rw] release_date
        #   @return [::Google::Type::Date]
        #     BIOS release date.
        # @!attribute [rw] smbios_uuid
        #   @return [::String]
        #     SMBIOS UUID.
        class BiosDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of network adapters and settings.
        # @!attribute [rw] primary_ip_address
        #   @return [::String]
        #     The primary IP address of the machine.
        # @!attribute [rw] public_ip_address
        #   @return [::String]
        #     The public IP address of the machine.
        # @!attribute [rw] primary_mac_address
        #   @return [::String]
        #     MAC address of the machine.
        #     This property is used to uniqly identify the machine.
        # @!attribute [rw] adapters
        #   @return [::Google::Cloud::MigrationCenter::V1::NetworkAdapterList]
        #     List of network adapters.
        class MachineNetworkDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of network adapters.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::NetworkAdapterDetails>]
        #     Network adapter entries.
        class NetworkAdapterList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of network adapter.
        # @!attribute [rw] adapter_type
        #   @return [::String]
        #     Network adapter type (e.g. VMXNET3).
        # @!attribute [rw] mac_address
        #   @return [::String]
        #     MAC address.
        # @!attribute [rw] addresses
        #   @return [::Google::Cloud::MigrationCenter::V1::NetworkAddressList]
        #     NetworkAddressList
        class NetworkAdapterDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of allocated/assigned network addresses.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::NetworkAddress>]
        #     Network address entries.
        class NetworkAddressList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of network address.
        # @!attribute [rw] ip_address
        #   @return [::String]
        #     Assigned or configured IP Address.
        # @!attribute [rw] subnet_mask
        #   @return [::String]
        #     Subnet mask.
        # @!attribute [rw] bcast
        #   @return [::String]
        #     Broadcast address.
        # @!attribute [rw] fqdn
        #   @return [::String]
        #     Fully qualified domain name.
        # @!attribute [rw] assignment
        #   @return [::Google::Cloud::MigrationCenter::V1::NetworkAddress::AddressAssignment]
        #     Whether DHCP is used to assign addresses.
        class NetworkAddress
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Network address assignment.
          module AddressAssignment
            # Unknown (default value).
            ADDRESS_ASSIGNMENT_UNSPECIFIED = 0

            # Staticly assigned IP.
            ADDRESS_ASSIGNMENT_STATIC = 1

            # Dynamically assigned IP (DHCP).
            ADDRESS_ASSIGNMENT_DHCP = 2
          end
        end

        # Details of machine disks.
        # @!attribute [rw] total_capacity_bytes
        #   @return [::Integer]
        #     Disk total Capacity.
        # @!attribute [rw] total_free_bytes
        #   @return [::Integer]
        #     Total disk free space.
        # @!attribute [rw] disks
        #   @return [::Google::Cloud::MigrationCenter::V1::DiskEntryList]
        #     List of disks.
        class MachineDiskDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VM disks.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::DiskEntry>]
        #     Disk entries.
        class DiskEntryList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Single disk entry.
        # @!attribute [rw] capacity_bytes
        #   @return [::Integer]
        #     Disk capacity.
        # @!attribute [rw] free_bytes
        #   @return [::Integer]
        #     Disk free space.
        # @!attribute [rw] disk_label
        #   @return [::String]
        #     Disk label.
        # @!attribute [rw] disk_label_type
        #   @return [::String]
        #     Disk label type (e.g. BIOS/GPT)
        # @!attribute [rw] interface_type
        #   @return [::Google::Cloud::MigrationCenter::V1::DiskEntry::InterfaceType]
        #     Disks interface type.
        # @!attribute [rw] partitions
        #   @return [::Google::Cloud::MigrationCenter::V1::DiskPartitionList]
        #     Partition layout.
        # @!attribute [rw] hw_address
        #   @return [::String]
        #     Disk hardware address (e.g. 0:1 for SCSI).
        # @!attribute [rw] vmware
        #   @return [::Google::Cloud::MigrationCenter::V1::VmwareDiskConfig]
        #     VMware disk details.
        class DiskEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Disks interface type.
          module InterfaceType
            # Interface type unknown or unspecified.
            INTERFACE_TYPE_UNSPECIFIED = 0

            # IDE interface type.
            IDE = 1

            # SATA interface type.
            SATA = 2

            # SAS interface type.
            SAS = 3

            # SCSI interface type.
            SCSI = 4

            # NVME interface type.
            NVME = 5

            # FC interface type.
            FC = 6

            # iSCSI interface type.
            ISCSI = 7
          end
        end

        # Disk partition list.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::DiskPartition>]
        #     Partition entries.
        class DiskPartitionList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Disk Partition details.
        # @!attribute [rw] type
        #   @return [::String]
        #     Partition type.
        # @!attribute [rw] file_system
        #   @return [::String]
        #     Partition file system.
        # @!attribute [rw] mount_point
        #   @return [::String]
        #     Mount pount (Linux/Windows) or drive letter (Windows).
        # @!attribute [rw] capacity_bytes
        #   @return [::Integer]
        #     Partition capacity.
        # @!attribute [rw] free_bytes
        #   @return [::Integer]
        #     Partition free space.
        # @!attribute [rw] uuid
        #   @return [::String]
        #     Partition UUID.
        # @!attribute [rw] sub_partitions
        #   @return [::Google::Cloud::MigrationCenter::V1::DiskPartitionList]
        #     Sub-partitions.
        class DiskPartition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VMware disk config details.
        # @!attribute [rw] backing_type
        #   @return [::Google::Cloud::MigrationCenter::V1::VmwareDiskConfig::BackingType]
        #     VMDK backing type.
        # @!attribute [rw] shared
        #   @return [::Boolean]
        #     Is VMDK shared with other VMs.
        # @!attribute [rw] vmdk_mode
        #   @return [::Google::Cloud::MigrationCenter::V1::VmwareDiskConfig::VmdkMode]
        #     VMDK disk mode.
        # @!attribute [rw] rdm_compatibility
        #   @return [::Google::Cloud::MigrationCenter::V1::VmwareDiskConfig::RdmCompatibility]
        #     RDM compatibility mode.
        class VmwareDiskConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # VMDK backing type possible values.
          module BackingType
            # Default value.
            BACKING_TYPE_UNSPECIFIED = 0

            # Flat v1.
            BACKING_TYPE_FLAT_V1 = 1

            # Flat v2.
            BACKING_TYPE_FLAT_V2 = 2

            # Persistent memory, also known as Non-Volatile Memory (NVM).
            BACKING_TYPE_PMEM = 3

            # Raw Disk Memory v1.
            BACKING_TYPE_RDM_V1 = 4

            # Raw Disk Memory v2.
            BACKING_TYPE_RDM_V2 = 5

            # SEsparse is a snapshot format introduced in vSphere 5.5 for large disks.
            BACKING_TYPE_SESPARSE = 6

            # SEsparse v1.
            BACKING_TYPE_SESPARSE_V1 = 7

            # SEsparse v1.
            BACKING_TYPE_SESPARSE_V2 = 8
          end

          # VMDK disk mode.
          module VmdkMode
            # VMDK disk mode unspecified or unknown.
            VMDK_MODE_UNSPECIFIED = 0

            # Dependent disk mode.
            DEPENDENT = 1

            # Independent - Persistent disk mode.
            INDEPENDENT_PERSISTENT = 2

            # Independent - Nonpersistent disk mode.
            INDEPENDENT_NONPERSISTENT = 3
          end

          # RDM compatibility mode.
          module RdmCompatibility
            # Compatibility mode unspecified or unknown.
            RDM_COMPATIBILITY_UNSPECIFIED = 0

            # Physical compatibility mode.
            PHYSICAL_COMPATIBILITY = 1

            # Virtual compatibility mode.
            VIRTUAL_COMPATIBILITY = 2
          end
        end

        # Information from Guest-level collections.
        # @!attribute [rw] os_name
        #   @return [::String]
        #     The name of the operating system.
        # @!attribute [rw] family
        #   @return [::Google::Cloud::MigrationCenter::V1::OperatingSystemFamily]
        #     What family the OS belong to, if known.
        # @!attribute [rw] version
        #   @return [::String]
        #     The version of the operating system.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::MigrationCenter::V1::GuestConfigDetails]
        #     OS and app configuration.
        # @!attribute [rw] runtime
        #   @return [::Google::Cloud::MigrationCenter::V1::GuestRuntimeDetails]
        #     Runtime information.
        class GuestOsDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Guest OS config information.
        # @!attribute [rw] issue
        #   @return [::String]
        #     OS issue (typically /etc/issue in Linux).
        # @!attribute [rw] fstab
        #   @return [::Google::Cloud::MigrationCenter::V1::FstabEntryList]
        #     Mount list (Linux fstab).
        # @!attribute [rw] hosts
        #   @return [::Google::Cloud::MigrationCenter::V1::HostsEntryList]
        #     Hosts file (/etc/hosts).
        # @!attribute [rw] nfs_exports
        #   @return [::Google::Cloud::MigrationCenter::V1::NfsExportList]
        #     NFS exports.
        # @!attribute [rw] selinux_mode
        #   @return [::Google::Cloud::MigrationCenter::V1::GuestConfigDetails::SeLinuxMode]
        #     Security-Enhanced Linux (SELinux) mode.
        class GuestConfigDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Security-Enhanced Linux (SELinux) mode.
          module SeLinuxMode
            # SELinux mode unknown or unspecified.
            SE_LINUX_MODE_UNSPECIFIED = 0

            # SELinux is disabled.
            SE_LINUX_MODE_DISABLED = 1

            # SELinux permissive mode.
            SE_LINUX_MODE_PERMISSIVE = 2

            # SELinux enforcing mode.
            SE_LINUX_MODE_ENFORCING = 3
          end
        end

        # Fstab content.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::FstabEntry>]
        #     Fstab entries.
        class FstabEntryList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Single fstab entry.
        # @!attribute [rw] spec
        #   @return [::String]
        #     The block special device or remote filesystem to be mounted.
        # @!attribute [rw] file
        #   @return [::String]
        #     The mount point for the filesystem.
        # @!attribute [rw] vfstype
        #   @return [::String]
        #     The type of the filesystem.
        # @!attribute [rw] mntops
        #   @return [::String]
        #     Mount options associated with the filesystem.
        # @!attribute [rw] freq
        #   @return [::Integer]
        #     Used by dump to determine which filesystems need to be dumped.
        # @!attribute [rw] passno
        #   @return [::Integer]
        #     Used by the fsck(8) program to determine the order in which filesystem
        #     checks are done at reboot time.
        class FstabEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Hosts content.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::HostsEntry>]
        #     Hosts entries.
        class HostsEntryList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Single /etc/hosts entry.
        # @!attribute [rw] ip
        #   @return [::String]
        #     IP (raw, IPv4/6 agnostic).
        # @!attribute [rw] host_names
        #   @return [::Array<::String>]
        #     List of host names / aliases.
        class HostsEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # NFS exports.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::NfsExport>]
        #     NFS export entries.
        class NfsExportList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # NFS export.
        # @!attribute [rw] export_directory
        #   @return [::String]
        #     The directory being exported.
        # @!attribute [rw] hosts
        #   @return [::Array<::String>]
        #     The hosts or networks to which the export is being shared.
        class NfsExport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Guest OS runtime information.
        # @!attribute [rw] services
        #   @return [::Google::Cloud::MigrationCenter::V1::RunningServiceList]
        #     Running background services.
        # @!attribute [rw] processes
        #   @return [::Google::Cloud::MigrationCenter::V1::RunningProcessList]
        #     Running processes.
        # @!attribute [rw] network
        #   @return [::Google::Cloud::MigrationCenter::V1::RuntimeNetworkInfo]
        #     Runtime network information (connections, ports).
        # @!attribute [rw] last_boot_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Last time the OS was booted.
        # @!attribute [rw] domain
        #   @return [::String]
        #     Domain, e.g. c.stratozone-development.internal.
        # @!attribute [rw] machine_name
        #   @return [::String]
        #     Machine name.
        # @!attribute [rw] installed_apps
        #   @return [::Google::Cloud::MigrationCenter::V1::GuestInstalledApplicationList]
        #     Installed applications information.
        # @!attribute [rw] open_file_list
        #   @return [::Google::Cloud::MigrationCenter::V1::OpenFileList]
        #     Open files information.
        class GuestRuntimeDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of running guest OS services.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::RunningService>]
        #     Running service entries.
        class RunningServiceList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Guest OS running service details.
        # @!attribute [rw] service_name
        #   @return [::String]
        #     Service name.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::MigrationCenter::V1::RunningService::State]
        #     Service state (OS-agnostic).
        # @!attribute [rw] start_mode
        #   @return [::Google::Cloud::MigrationCenter::V1::RunningService::StartMode]
        #     Service start mode (OS-agnostic).
        # @!attribute [rw] exe_path
        #   @return [::String]
        #     Service binary path.
        # @!attribute [rw] cmdline
        #   @return [::String]
        #     Service command line.
        # @!attribute [rw] pid
        #   @return [::Integer]
        #     Service pid.
        class RunningService
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Service state (OS-agnostic).
          module State
            # Service state unspecified.
            STATE_UNSPECIFIED = 0

            # Service is active.
            ACTIVE = 1

            # Service is paused.
            PAUSED = 2

            # Service is stopped.
            STOPPED = 3
          end

          # Service start mode (OS-agnostic).
          module StartMode
            # Start mode unspecified.
            START_MODE_UNSPECIFIED = 0

            # The service is a device driver started by the system loader.
            BOOT = 1

            # The service is a device driver started by the IOInitSystem function.
            SYSTEM = 2

            # The service is started by the operating system, at system start-up
            AUTO = 3

            # The service is started only manually, by a user.
            MANUAL = 4

            # The service is disabled.
            DISABLED = 5
          end
        end

        # List of running guest OS processes.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::RunningProcess>]
        #     Running process entries.
        class RunningProcessList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Guest OS running process details.
        # @!attribute [rw] pid
        #   @return [::Integer]
        #     Process ID.
        # @!attribute [rw] exe_path
        #   @return [::String]
        #     Process binary path.
        # @!attribute [rw] cmdline
        #   @return [::String]
        #     Process full command line.
        # @!attribute [rw] user
        #   @return [::String]
        #     User running the process.
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Process extended attributes.
        class RunningProcess
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Runtime networking information.
        # @!attribute [rw] scan_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time of the last network scan.
        # @!attribute [rw] connections
        #   @return [::Google::Cloud::MigrationCenter::V1::NetworkConnectionList]
        #     Network connections.
        class RuntimeNetworkInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Network connection list.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::NetworkConnection>]
        #     Network connection entries.
        class NetworkConnectionList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] protocol
        #   @return [::String]
        #     Connection protocol (e.g. TCP/UDP).
        # @!attribute [rw] local_ip_address
        #   @return [::String]
        #     Local IP address.
        # @!attribute [rw] local_port
        #   @return [::Integer]
        #     Local port.
        # @!attribute [rw] remote_ip_address
        #   @return [::String]
        #     Remote IP address.
        # @!attribute [rw] remote_port
        #   @return [::Integer]
        #     Remote port.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::MigrationCenter::V1::NetworkConnection::State]
        #     Network connection state.
        # @!attribute [rw] pid
        #   @return [::Integer]
        #     Process ID.
        # @!attribute [rw] process_name
        #   @return [::String]
        #     Process or service name.
        class NetworkConnection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Network connection state.
          module State
            # Connection state is unknown or unspecified.
            STATE_UNSPECIFIED = 0

            # The connection is being opened.
            OPENING = 1

            # The connection is open.
            OPEN = 2

            # Listening for incoming connections.
            LISTEN = 3

            # The connection is being closed.
            CLOSING = 4

            # The connection is closed.
            CLOSED = 5
          end
        end

        # Guest installed application list.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::GuestInstalledApplication>]
        #     Application entries.
        class GuestInstalledApplicationList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Guest installed application information.
        # @!attribute [rw] application_name
        #   @return [::String]
        #     Installed application name.
        # @!attribute [rw] vendor
        #   @return [::String]
        #     Installed application vendor.
        # @!attribute [rw] install_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the application was installed.
        # @!attribute [rw] path
        #   @return [::String]
        #     Source path.
        # @!attribute [rw] version
        #   @return [::String]
        #     Installed application version.
        class GuestInstalledApplication
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Open file list.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::OpenFileDetails>]
        #     Open file details entries.
        class OpenFileList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Open file Information.
        # @!attribute [rw] command
        #   @return [::String]
        #     Opened file command.
        # @!attribute [rw] user
        #   @return [::String]
        #     Opened file user.
        # @!attribute [rw] file_type
        #   @return [::String]
        #     Opened file file type.
        # @!attribute [rw] file_path
        #   @return [::String]
        #     Opened file file path.
        class OpenFileDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the platform.
        # @!attribute [rw] vmware_details
        #   @return [::Google::Cloud::MigrationCenter::V1::VmwarePlatformDetails]
        #     VMware specific details.
        #
        #     Note: The following fields are mutually exclusive: `vmware_details`, `aws_ec2_details`, `azure_vm_details`, `generic_details`, `physical_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] aws_ec2_details
        #   @return [::Google::Cloud::MigrationCenter::V1::AwsEc2PlatformDetails]
        #     AWS EC2 specific details.
        #
        #     Note: The following fields are mutually exclusive: `aws_ec2_details`, `vmware_details`, `azure_vm_details`, `generic_details`, `physical_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] azure_vm_details
        #   @return [::Google::Cloud::MigrationCenter::V1::AzureVmPlatformDetails]
        #     Azure VM specific details.
        #
        #     Note: The following fields are mutually exclusive: `azure_vm_details`, `vmware_details`, `aws_ec2_details`, `generic_details`, `physical_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] generic_details
        #   @return [::Google::Cloud::MigrationCenter::V1::GenericPlatformDetails]
        #     Generic platform details.
        #
        #     Note: The following fields are mutually exclusive: `generic_details`, `vmware_details`, `aws_ec2_details`, `azure_vm_details`, `physical_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] physical_details
        #   @return [::Google::Cloud::MigrationCenter::V1::PhysicalPlatformDetails]
        #     Physical machines platform details.
        #
        #     Note: The following fields are mutually exclusive: `physical_details`, `vmware_details`, `aws_ec2_details`, `azure_vm_details`, `generic_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class PlatformDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VMware specific details.
        # @!attribute [rw] vcenter_version
        #   @return [::String]
        #     vCenter version.
        # @!attribute [rw] esx_version
        #   @return [::String]
        #     ESX version.
        # @!attribute [rw] osid
        #   @return [::String]
        #     VMware os enum -
        #     https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html.
        # @!attribute [rw] vcenter_folder
        #   @return [::String]
        #     Folder name in vCenter where asset resides.
        # @!attribute [rw] vcenter_uri
        #   @return [::String]
        #     vCenter URI used in collection.
        # @!attribute [rw] vcenter_vm_id
        #   @return [::String]
        #     vCenter VM ID.
        class VmwarePlatformDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AWS EC2 specific details.
        # @!attribute [rw] machine_type_label
        #   @return [::String]
        #     AWS platform's machine type label.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location of the machine in the AWS format.
        class AwsEc2PlatformDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Azure VM specific details.
        # @!attribute [rw] machine_type_label
        #   @return [::String]
        #     Azure platform's machine type label.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location of the machine in the Azure format.
        # @!attribute [rw] provisioning_state
        #   @return [::String]
        #     Azure platform's provisioning state.
        class AzureVmPlatformDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Generic platform details.
        # @!attribute [rw] location
        #   @return [::String]
        #     Free text representation of the machine location.
        #     The format of this field should not be relied on. Different VMs in the same
        #     location may have different string values for this field.
        class GenericPlatformDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Platform specific details for Physical Machines.
        # @!attribute [rw] location
        #   @return [::String]
        #     Free text representation of the machine location.
        #     The format of this field should not be relied on. Different machines in the
        #     same location may have different string values for this field.
        class PhysicalPlatformDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Memory usage sample.
        # @!attribute [rw] utilized_percentage
        #   @return [::Float]
        #     Percentage of system memory utilized. Must be in the interval [0, 100].
        class MemoryUsageSample
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CPU usage sample.
        # @!attribute [rw] utilized_percentage
        #   @return [::Float]
        #     Percentage of total CPU capacity utilized. Must be in the interval [0,
        #     100]. On most systems can be calculated using 100 - idle percentage.
        class CpuUsageSample
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Network usage sample. Values are across all network interfaces.
        # @!attribute [rw] average_ingress_bps
        #   @return [::Float]
        #     Average network ingress in B/s sampled over a short window.
        #     Must be non-negative.
        # @!attribute [rw] average_egress_bps
        #   @return [::Float]
        #     Average network egress in B/s sampled over a short window.
        #     Must be non-negative.
        class NetworkUsageSample
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Disk usage sample. Values are across all disks.
        # @!attribute [rw] average_iops
        #   @return [::Float]
        #     Average IOPS sampled over a short window. Must be non-negative.
        class DiskUsageSample
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Performance data sample.
        # @!attribute [rw] sample_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the sample was collected.
        #     If omitted, the frame report time will be used.
        # @!attribute [rw] memory
        #   @return [::Google::Cloud::MigrationCenter::V1::MemoryUsageSample]
        #     Memory usage sample.
        # @!attribute [rw] cpu
        #   @return [::Google::Cloud::MigrationCenter::V1::CpuUsageSample]
        #     CPU usage sample.
        # @!attribute [rw] network
        #   @return [::Google::Cloud::MigrationCenter::V1::NetworkUsageSample]
        #     Network usage sample.
        # @!attribute [rw] disk
        #   @return [::Google::Cloud::MigrationCenter::V1::DiskUsageSample]
        #     Disk usage sample.
        class PerformanceSample
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Performance data for an asset.
        # @!attribute [rw] daily_resource_usage_aggregations
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation>]
        #     Daily resource usage aggregations.
        #     Contains all of the data available for an asset, up to the last 420 days.
        #     Aggregations are sorted from oldest to most recent.
        class AssetPerformanceData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Usage data aggregation for a single day.
        # @!attribute [rw] date
        #   @return [::Google::Type::Date]
        #     Aggregation date. Day boundaries are at midnight UTC.
        # @!attribute [rw] cpu
        #   @return [::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation::CPU]
        #     CPU usage.
        # @!attribute [rw] memory
        #   @return [::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation::Memory]
        #     Memory usage.
        # @!attribute [rw] network
        #   @return [::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation::Network]
        #     Network usage.
        # @!attribute [rw] disk
        #   @return [::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation::Disk]
        #     Disk usage.
        class DailyResourceUsageAggregation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Statistical aggregation of samples for a single resource usage.
          # @!attribute [rw] average
          #   @return [::Float]
          #     Average usage value.
          # @!attribute [rw] median
          #   @return [::Float]
          #     Median usage value.
          # @!attribute [rw] nintey_fifth_percentile
          #   @return [::Float]
          #     95th percentile usage value.
          # @!attribute [rw] peak
          #   @return [::Float]
          #     Peak usage value.
          class Stats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Statistical aggregation of CPU usage.
          # @!attribute [rw] utilization_percentage
          #   @return [::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation::Stats]
          #     CPU utilization percentage.
          class CPU
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Statistical aggregation of memory usage.
          # @!attribute [rw] utilization_percentage
          #   @return [::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation::Stats]
          #     Memory utilization percentage.
          class Memory
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Statistical aggregation of network usage.
          # @!attribute [rw] ingress_bps
          #   @return [::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation::Stats]
          #     Network ingress in B/s.
          # @!attribute [rw] egress_bps
          #   @return [::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation::Stats]
          #     Network egress in B/s.
          class Network
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Statistical aggregation of disk usage.
          # @!attribute [rw] iops
          #   @return [::Google::Cloud::MigrationCenter::V1::DailyResourceUsageAggregation::Stats]
          #     Disk I/O operations per second.
          class Disk
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message containing insights list.
        # @!attribute [r] insights
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::Insight>]
        #     Output only. Insights of the list.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update timestamp.
        class InsightList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An insight about an asset.
        # @!attribute [r] migration_insight
        #   @return [::Google::Cloud::MigrationCenter::V1::MigrationInsight]
        #     Output only. An insight about potential migrations for an asset.
        #
        #     Note: The following fields are mutually exclusive: `migration_insight`, `generic_insight`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] generic_insight
        #   @return [::Google::Cloud::MigrationCenter::V1::GenericInsight]
        #     Output only. A generic insight about an asset
        #
        #     Note: The following fields are mutually exclusive: `generic_insight`, `migration_insight`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Insight
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A generic insight about an asset.
        # @!attribute [r] message_id
        #   @return [::Integer]
        #     Output only. Represents a globally unique message id for
        #     this insight, can be used for localization purposes, in case message_code
        #     is not yet known by the client use default_message instead.
        # @!attribute [r] default_message
        #   @return [::String]
        #     Output only. In case message_code is not yet known by the client
        #     default_message will be the message to be used instead.
        # @!attribute [r] additional_information
        #   @return [::Array<::String>]
        #     Output only. Additional information about the insight, each entry can be a
        #     logical entry and must make sense if it is displayed with line breaks
        #     between each entry. Text can contain md style links.
        class GenericInsight
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An insight about potential migrations for an asset.
        # @!attribute [r] fit
        #   @return [::Google::Cloud::MigrationCenter::V1::FitDescriptor]
        #     Output only. Description of how well the asset this insight is associated
        #     with fits the proposed migration.
        # @!attribute [r] compute_engine_target
        #   @return [::Google::Cloud::MigrationCenter::V1::ComputeEngineMigrationTarget]
        #     Output only. A Google Compute Engine target.
        class MigrationInsight
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Compute engine migration target.
        # @!attribute [rw] shape
        #   @return [::Google::Cloud::MigrationCenter::V1::ComputeEngineShapeDescriptor]
        #     Description of the suggested shape for the migration target.
        class ComputeEngineMigrationTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Compute Engine target shape descriptor.
        # @!attribute [rw] memory_mb
        #   @return [::Integer]
        #     Memory in mebibytes.
        # @!attribute [rw] physical_core_count
        #   @return [::Integer]
        #     Number of physical cores.
        # @!attribute [rw] logical_core_count
        #   @return [::Integer]
        #     Number of logical cores.
        # @!attribute [rw] series
        #   @return [::String]
        #     Compute Engine machine series.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Compute Engine machine type.
        # @!attribute [rw] storage
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ComputeStorageDescriptor>]
        #     Compute Engine storage. Never empty.
        class ComputeEngineShapeDescriptor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Compute Engine storage option descriptor.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::MigrationCenter::V1::PersistentDiskType]
        #     Disk type backing the storage.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     Disk size in GiB.
        class ComputeStorageDescriptor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the fit level of an asset for migration to a specific target.
        # @!attribute [rw] fit_level
        #   @return [::Google::Cloud::MigrationCenter::V1::FitDescriptor::FitLevel]
        #     Fit level.
        class FitDescriptor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Fit level.
          module FitLevel
            # Not enough information.
            FIT_LEVEL_UNSPECIFIED = 0

            # Fit.
            FIT = 1

            # No Fit.
            NO_FIT = 2

            # Fit with effort.
            REQUIRES_EFFORT = 3
          end
        end

        # Message describing an aggregation. The message includes the aggregation type,
        # parameters, and the field on which to perform the aggregation.
        # @!attribute [rw] field
        #   @return [::String]
        #     The name of the field on which to aggregate.
        # @!attribute [rw] count
        #   @return [::Google::Cloud::MigrationCenter::V1::Aggregation::Count]
        #     Count the number of matching objects.
        #
        #     Note: The following fields are mutually exclusive: `count`, `sum`, `histogram`, `frequency`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sum
        #   @return [::Google::Cloud::MigrationCenter::V1::Aggregation::Sum]
        #     Sum over a numeric field.
        #
        #     Note: The following fields are mutually exclusive: `sum`, `count`, `histogram`, `frequency`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] histogram
        #   @return [::Google::Cloud::MigrationCenter::V1::Aggregation::Histogram]
        #     Creates a bucketed histogram of field values.
        #
        #     Note: The following fields are mutually exclusive: `histogram`, `count`, `sum`, `frequency`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] frequency
        #   @return [::Google::Cloud::MigrationCenter::V1::Aggregation::Frequency]
        #     Creates a frequency distribution of all field values.
        #
        #     Note: The following fields are mutually exclusive: `frequency`, `count`, `sum`, `histogram`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Aggregation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Object count.
          class Count
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Sum of field values.
          class Sum
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Histogram of bucketed assets counts by field value.
          # @!attribute [rw] lower_bounds
          #   @return [::Array<::Float>]
          #     Lower bounds of buckets.
          #     The response will contain `n+1` buckets for `n` bounds.
          #     The first bucket will count all assets for which the field value is
          #     smaller than the first bound.
          #     Subsequent buckets will count assets for which the field value is
          #     greater or equal to a lower bound and smaller than the next one.
          #     The last bucket will count assets for which the field value is greater or
          #     equal to the final lower bound.
          #     You can define up to 20 lower bounds.
          class Histogram
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Frequency distribution of all field values.
          class Frequency
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message describing a result of an aggregation.
        # @!attribute [rw] field
        #   @return [::String]
        # @!attribute [rw] count
        #   @return [::Google::Cloud::MigrationCenter::V1::AggregationResult::Count]
        #     Note: The following fields are mutually exclusive: `count`, `sum`, `histogram`, `frequency`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sum
        #   @return [::Google::Cloud::MigrationCenter::V1::AggregationResult::Sum]
        #     Note: The following fields are mutually exclusive: `sum`, `count`, `histogram`, `frequency`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] histogram
        #   @return [::Google::Cloud::MigrationCenter::V1::AggregationResult::Histogram]
        #     Note: The following fields are mutually exclusive: `histogram`, `count`, `sum`, `frequency`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] frequency
        #   @return [::Google::Cloud::MigrationCenter::V1::AggregationResult::Frequency]
        #     Note: The following fields are mutually exclusive: `frequency`, `count`, `sum`, `histogram`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AggregationResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The result of a count aggregation.
          # @!attribute [rw] value
          #   @return [::Integer]
          class Count
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The result of a sum aggregation.
          # @!attribute [rw] value
          #   @return [::Float]
          class Sum
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The result of a bucketed histogram aggregation.
          # @!attribute [rw] buckets
          #   @return [::Array<::Google::Cloud::MigrationCenter::V1::AggregationResult::Histogram::Bucket>]
          #     Buckets in the histogram.
          #     There will be `n+1` buckets matching `n` lower bounds in the request.
          #     The first bucket will be from -infinity to the first bound.
          #     Subsequent buckets will be between one bound and the next.
          #     The final bucket will be from the final bound to infinity.
          class Histogram
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A histogram bucket with a lower and upper bound, and a count of items
            # with a field value between those bounds.
            # The lower bound is inclusive and the upper bound is exclusive.
            # Lower bound may be -infinity and upper bound may be infinity.
            # @!attribute [rw] lower_bound
            #   @return [::Float]
            #     Lower bound - inclusive.
            # @!attribute [rw] upper_bound
            #   @return [::Float]
            #     Upper bound - exclusive.
            # @!attribute [rw] count
            #   @return [::Integer]
            #     Count of items in the bucket.
            class Bucket
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The result of a frequency distribution aggregation.
          # @!attribute [rw] values
          #   @return [::Google::Protobuf::Map{::String => ::Integer}]
          class Frequency
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Integer]
            class ValuesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # A resource that aggregates the validation errors found in an import job file.
        # @!attribute [rw] file_name
        #   @return [::String]
        #     The name of the file.
        # @!attribute [rw] row_errors
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ImportRowError>]
        #     Partial list of rows that encountered validation error.
        # @!attribute [rw] partial_report
        #   @return [::Boolean]
        #     Flag indicating that processing was aborted due to maximum number of
        #     errors.
        # @!attribute [rw] file_errors
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ImportError>]
        #     List of file level errors.
        class FileValidationReport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource that aggregates errors across import job files.
        # @!attribute [rw] file_validations
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::FileValidationReport>]
        #     List of errors found in files.
        # @!attribute [rw] job_errors
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ImportError>]
        #     List of job level errors.
        class ValidationReport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource that reports result of the import job execution.
        # @!attribute [rw] frames_reported
        #   @return [::Integer]
        #     Total number of asset frames reported for the import job.
        # @!attribute [rw] execution_errors
        #   @return [::Google::Cloud::MigrationCenter::V1::ValidationReport]
        #     Validation errors encountered during the execution of the import job.
        # @!attribute [r] total_rows_count
        #   @return [::Integer]
        #     Output only. Total number of rows in the import job.
        class ExecutionReport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource that reports the errors encountered while processing an
        # import job.
        # @!attribute [rw] error_details
        #   @return [::String]
        #     The error information.
        # @!attribute [rw] severity
        #   @return [::Google::Cloud::MigrationCenter::V1::ImportError::Severity]
        #     The severity of the error.
        class ImportError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumerate possible error severity.
          module Severity
            SEVERITY_UNSPECIFIED = 0

            ERROR = 1

            WARNING = 2

            INFO = 3
          end
        end

        # A resource that reports the import job errors at row level.
        # @!attribute [rw] row_number
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     The row number where the error was detected.
        # @!attribute [rw] vm_name
        #   @return [::String]
        #     The name of the VM in the row.
        # @!attribute [rw] vm_uuid
        #   @return [::String]
        #     The VM UUID.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ImportError>]
        #     The list of errors detected in the row.
        class ImportRowError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource that contains a URI to which a data file can be uploaded.
        # @!attribute [r] signed_uri
        #   @return [::String]
        #     Output only. Upload URI for the file.
        # @!attribute [r] headers
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. The headers that were used to sign the URI.
        # @!attribute [r] uri_expiration_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Expiration time of the upload URI.
        class UploadFileInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class HeadersEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Lists the asset IDs of all assets.
        # @!attribute [rw] asset_ids
        #   @return [::Array<::String>]
        #     Required. A list of asset IDs
        class AssetList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource that contains a single violation of a reported `AssetFrame`
        # resource.
        # @!attribute [rw] field
        #   @return [::String]
        #     The field of the original frame where the violation occurred.
        # @!attribute [rw] violation
        #   @return [::String]
        #     A message describing the violation.
        class FrameViolationEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VirtualMachinePreferences enables you to create sets of assumptions, for
        # example, a geographical location and pricing track, for your migrated virtual
        # machines. The set of preferences influence recommendations for migrating
        # virtual machine assets.
        # @!attribute [rw] target_product
        #   @return [::Google::Cloud::MigrationCenter::V1::ComputeMigrationTargetProduct]
        #     Target product for assets using this preference set.
        #     Specify either target product or business goal, but
        #     not both.
        # @!attribute [rw] region_preferences
        #   @return [::Google::Cloud::MigrationCenter::V1::RegionPreferences]
        #     Region preferences for assets using this preference set.
        #     If you are unsure which value to set, the migration service API region is
        #     often a good value to start with.
        # @!attribute [rw] commitment_plan
        #   @return [::Google::Cloud::MigrationCenter::V1::CommitmentPlan]
        #     Commitment plan to consider when calculating costs for virtual machine
        #     insights and recommendations.
        #     If you are unsure which value to set, a 3 year commitment plan is often a
        #     good value to start with.
        # @!attribute [rw] sizing_optimization_strategy
        #   @return [::Google::Cloud::MigrationCenter::V1::SizingOptimizationStrategy]
        #     Sizing optimization strategy specifies the preferred strategy used when
        #     extrapolating usage data to calculate insights and recommendations for a
        #     virtual machine.
        #     If you are unsure which value to set, a moderate sizing optimization
        #     strategy is often a good value to start with.
        # @!attribute [rw] compute_engine_preferences
        #   @return [::Google::Cloud::MigrationCenter::V1::ComputeEnginePreferences]
        #     Compute Engine preferences concern insights and recommendations for Compute
        #     Engine target.
        # @!attribute [rw] vmware_engine_preferences
        #   @return [::Google::Cloud::MigrationCenter::V1::VmwareEnginePreferences]
        #     Preferences concerning insights and recommendations for
        #     Google Cloud VMware Engine.
        # @!attribute [rw] sole_tenancy_preferences
        #   @return [::Google::Cloud::MigrationCenter::V1::SoleTenancyPreferences]
        #     Preferences concerning Sole Tenant nodes and virtual machines.
        class VirtualMachinePreferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The user preferences relating to Compute Engine target platform.
        # @!attribute [rw] machine_preferences
        #   @return [::Google::Cloud::MigrationCenter::V1::MachinePreferences]
        #     Preferences concerning the machine types to consider on Compute Engine.
        # @!attribute [rw] license_type
        #   @return [::Google::Cloud::MigrationCenter::V1::LicenseType]
        #     License type to consider when calculating costs for virtual machine
        #     insights and recommendations. If unspecified, costs are calculated
        #     based on the default licensing plan.
        class ComputeEnginePreferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The type of machines to consider when calculating virtual machine migration
        # insights and recommendations.
        # Not all machine types are available in all zones and regions.
        # @!attribute [rw] allowed_machine_series
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::MachineSeries>]
        #     Compute Engine machine series to consider for insights and recommendations.
        #     If empty, no restriction is applied on the machine series.
        class MachinePreferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Compute Engine machine series.
        # @!attribute [rw] code
        #   @return [::String]
        #     Code to identify a Compute Engine machine series. Consult
        #     https://cloud.google.com/compute/docs/machine-resource#machine_type_comparison
        #     for more details on the available series.
        class MachineSeries
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The user preferences relating to Google Cloud VMware Engine target platform.
        # @!attribute [rw] cpu_overcommit_ratio
        #   @return [::Float]
        #     CPU overcommit ratio.
        #     Acceptable values are between 1.0 and 8.0, with 0.1 increment.
        # @!attribute [rw] memory_overcommit_ratio
        #   @return [::Float]
        #     Memory overcommit ratio.
        #     Acceptable values are 1.0, 1.25, 1.5, 1.75 and 2.0.
        # @!attribute [rw] storage_deduplication_compression_ratio
        #   @return [::Float]
        #     The Deduplication and Compression ratio is based on the logical (Used
        #     Before) space required to store data before applying deduplication and
        #     compression, in relation to the physical (Used After) space required after
        #     applying deduplication and compression. Specifically, the ratio is the Used
        #     Before space divided by the Used After space. For example, if the Used
        #     Before space is 3 GB, but the physical Used After space is 1 GB, the
        #     deduplication and compression ratio is 3x. Acceptable values are
        #     between 1.0 and 4.0.
        # @!attribute [rw] commitment_plan
        #   @return [::Google::Cloud::MigrationCenter::V1::VmwareEnginePreferences::CommitmentPlan]
        #     Commitment plan to consider when calculating costs for virtual machine
        #     insights and recommendations.
        #     If you are unsure which value to set, a 3 year commitment plan is often a
        #     good value to start with.
        class VmwareEnginePreferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of committed use discount.
          module CommitmentPlan
            # Unspecified commitment plan.
            COMMITMENT_PLAN_UNSPECIFIED = 0

            # No commitment plan (on-demand usage).
            ON_DEMAND = 1

            # 1 year commitment (monthly payments).
            COMMITMENT_1_YEAR_MONTHLY_PAYMENTS = 2

            # 3 year commitment (monthly payments).
            COMMITMENT_3_YEAR_MONTHLY_PAYMENTS = 3

            # 1 year commitment (upfront payment).
            COMMITMENT_1_YEAR_UPFRONT_PAYMENT = 4

            # 3 years commitment (upfront payment).
            COMMITMENT_3_YEAR_UPFRONT_PAYMENT = 5
          end
        end

        # Preferences concerning Sole Tenancy nodes and VMs.
        # @!attribute [rw] cpu_overcommit_ratio
        #   @return [::Float]
        #     CPU overcommit ratio.
        #     Acceptable values are between 1.0 and 2.0 inclusive.
        # @!attribute [rw] host_maintenance_policy
        #   @return [::Google::Cloud::MigrationCenter::V1::SoleTenancyPreferences::HostMaintenancePolicy]
        #     Sole Tenancy nodes maintenance policy.
        # @!attribute [rw] commitment_plan
        #   @return [::Google::Cloud::MigrationCenter::V1::SoleTenancyPreferences::CommitmentPlan]
        #     Commitment plan to consider when calculating costs for virtual machine
        #     insights and recommendations.
        #     If you are unsure which value to set, a 3 year commitment plan is often a
        #     good value to start with.
        # @!attribute [rw] node_types
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::SoleTenantNodeType>]
        #     A list of sole tenant node types.
        #     An empty list means that all possible node types will be considered.
        class SoleTenancyPreferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Sole Tenancy nodes maintenance policy.
          module HostMaintenancePolicy
            # Unspecified host maintenance policy.
            HOST_MAINTENANCE_POLICY_UNSPECIFIED = 0

            # Default host maintenance policy.
            HOST_MAINTENANCE_POLICY_DEFAULT = 1

            # Restart in place host maintenance policy.
            HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE = 2

            # Migrate within node group host maintenance policy.
            HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP = 3
          end

          # Type of committed use discount.
          module CommitmentPlan
            # Unspecified commitment plan.
            COMMITMENT_PLAN_UNSPECIFIED = 0

            # No commitment plan (on-demand usage).
            ON_DEMAND = 1

            # 1 year commitment.
            COMMITMENT_1_YEAR = 2

            # 3 years commitment.
            COMMITMENT_3_YEAR = 3
          end
        end

        # A Sole Tenant node type.
        # @!attribute [rw] node_name
        #   @return [::String]
        #     Name of the Sole Tenant node. Consult
        #     https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes
        class SoleTenantNodeType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The user preferences relating to target regions.
        # @!attribute [rw] preferred_regions
        #   @return [::Array<::String>]
        #     A list of preferred regions,
        #     ordered by the most preferred region first.
        #     Set only valid Google Cloud region names.
        #     See https://cloud.google.com/compute/docs/regions-zones
        #     for available regions.
        class RegionPreferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the Migration Center settings related to the project.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the resource.
        # @!attribute [rw] preference_set
        #   @return [::String]
        #     The preference set used by default for a project.
        class Settings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the Summary view of a Report, which contains aggregated values
        # for all the groups and preference sets included in this Report.
        # @!attribute [rw] all_assets_stats
        #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::AssetAggregateStats]
        #     Aggregate statistics for all the assets across all the groups.
        # @!attribute [rw] group_findings
        #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ReportSummary::GroupFinding>]
        #     Findings for each Group included in this report.
        class ReportSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes a collection of data points rendered as a Chart.
          # @!attribute [rw] data_points
          #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ReportSummary::ChartData::DataPoint>]
          #     Each data point in the chart is represented as a name-value pair
          #     with the name being the x-axis label, and the value being the y-axis
          #     value.
          class ChartData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes a single data point in the Chart.
            # @!attribute [rw] label
            #   @return [::String]
            #     The X-axis label for this data point.
            # @!attribute [rw] value
            #   @return [::Float]
            #     The Y-axis value for this data point.
            class DataPoint
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Utilization Chart is a specific type of visualization which displays
          # a metric classified into "Used" and "Free" buckets.
          # @!attribute [rw] used
          #   @return [::Integer]
          #     Aggregate value which falls into the "Used" bucket.
          # @!attribute [rw] free
          #   @return [::Integer]
          #     Aggregate value which falls into the "Free" bucket.
          class UtilizationChartData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A Histogram Chart shows a distribution of values into buckets, showing
          # a count of values which fall into a bucket.
          # @!attribute [rw] buckets
          #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ReportSummary::HistogramChartData::Bucket>]
          #     Buckets in the histogram.
          #     There will be `n+1` buckets matching `n` lower bounds in the request.
          #     The first bucket will be from -infinity to the first bound.
          #     Subsequent buckets will be between one bound and the next.
          #     The final bucket will be from the final bound to infinity.
          class HistogramChartData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A histogram bucket with a lower and upper bound, and a count of items
            # with a field value between those bounds.
            # The lower bound is inclusive and the upper bound is exclusive.
            # Lower bound may be -infinity and upper bound may be infinity.
            # @!attribute [rw] lower_bound
            #   @return [::Integer]
            #     Lower bound - inclusive.
            # @!attribute [rw] upper_bound
            #   @return [::Integer]
            #     Upper bound - exclusive.
            # @!attribute [rw] count
            #   @return [::Integer]
            #     Count of items in the bucket.
            class Bucket
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Aggregate statistics for a collection of assets.
          # @!attribute [rw] total_memory_bytes
          #   @return [::Integer]
          #     Sum of the memory in bytes of all the assets in this collection.
          # @!attribute [rw] total_storage_bytes
          #   @return [::Integer]
          #     Sum of persistent storage in bytes of all the assets in this collection.
          # @!attribute [rw] total_cores
          #   @return [::Integer]
          #     Sum of the CPU core count of all the assets in this collection.
          # @!attribute [rw] total_assets
          #   @return [::Integer]
          #     Count of the number of unique assets in this collection.
          # @!attribute [rw] memory_utilization_chart
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::UtilizationChartData]
          #     Total memory split into Used/Free buckets.
          # @!attribute [rw] storage_utilization_chart
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::UtilizationChartData]
          #     Total memory split into Used/Free buckets.
          # @!attribute [rw] operating_system
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::ChartData]
          #     Count of assets grouped by Operating System families.
          # @!attribute [rw] core_count_histogram
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::HistogramChartData]
          #     Histogram showing a distribution of CPU core counts.
          # @!attribute [rw] memory_bytes_histogram
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::HistogramChartData]
          #     Histogram showing a distribution of memory sizes.
          # @!attribute [rw] storage_bytes_histogram
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::HistogramChartData]
          #     Histogram showing a distribution of memory sizes.
          class AssetAggregateStats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a data point tracking the count of assets allocated for a
          # specific Machine Series.
          # @!attribute [rw] machine_series
          #   @return [::Google::Cloud::MigrationCenter::V1::MachineSeries]
          #     The Machine Series (e.g. "E2", "N2")
          # @!attribute [rw] allocated_asset_count
          #   @return [::Integer]
          #     Count of assets allocated to this machine series.
          class MachineSeriesAllocation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A set of findings that applies to assets destined for Compute Engine.
          # @!attribute [rw] allocated_regions
          #   @return [::Array<::String>]
          #     Set of regions in which the assets were allocated.
          # @!attribute [rw] allocated_asset_count
          #   @return [::Integer]
          #     Count of assets which were allocated.
          # @!attribute [rw] machine_series_allocations
          #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ReportSummary::MachineSeriesAllocation>]
          #     Distribution of assets based on the Machine Series.
          # @!attribute [rw] allocated_disk_types
          #   @return [::Array<::Google::Cloud::MigrationCenter::V1::PersistentDiskType>]
          #     Set of disk types allocated to assets.
          class ComputeEngineFinding
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A set of findings that applies to assets destined for VMWare Engine.
          # @!attribute [rw] allocated_regions
          #   @return [::Array<::String>]
          #     Set of regions in which the assets were allocated
          # @!attribute [rw] allocated_asset_count
          #   @return [::Integer]
          #     Count of assets which are allocated
          # @!attribute [rw] node_allocations
          #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ReportSummary::VmwareNodeAllocation>]
          #     Set of per-nodetype allocation records
          class VmwareEngineFinding
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents assets allocated to a specific VMWare Node type.
          # @!attribute [rw] vmware_node
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::VmwareNode]
          #     VMWare node type, e.g. "ve1-standard-72"
          # @!attribute [rw] node_count
          #   @return [::Integer]
          #     Count of this node type to be provisioned
          # @!attribute [rw] allocated_asset_count
          #   @return [::Integer]
          #     Count of assets allocated to these nodes
          class VmwareNodeAllocation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A VMWare Engine Node
          # @!attribute [rw] code
          #   @return [::String]
          #     Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
          #     on the displayName of
          #     cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
          class VmwareNode
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A set of findings that applies to assets destined for Sole-Tenant nodes.
          # @!attribute [rw] allocated_regions
          #   @return [::Array<::String>]
          #     Set of regions in which the assets are allocated
          # @!attribute [rw] allocated_asset_count
          #   @return [::Integer]
          #     Count of assets which are allocated
          # @!attribute [rw] node_allocations
          #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ReportSummary::SoleTenantNodeAllocation>]
          #     Set of per-nodetype allocation records
          class SoleTenantFinding
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents the assets allocated to a specific Sole-Tenant node type.
          # @!attribute [rw] node
          #   @return [::Google::Cloud::MigrationCenter::V1::SoleTenantNodeType]
          #     Sole Tenant node type, e.g. "m3-node-128-3904"
          # @!attribute [rw] node_count
          #   @return [::Integer]
          #     Count of this node type to be provisioned
          # @!attribute [rw] allocated_asset_count
          #   @return [::Integer]
          #     Count of assets allocated to these nodes
          class SoleTenantNodeAllocation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Summary Findings for a specific Group/PreferenceSet combination.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Display Name of the Preference Set
          # @!attribute [rw] description
          #   @return [::String]
          #     Description for the Preference Set.
          # @!attribute [rw] machine_preferences
          #   @return [::Google::Cloud::MigrationCenter::V1::VirtualMachinePreferences]
          #     A set of preferences that applies to all machines in the context.
          # @!attribute [rw] monthly_cost_total
          #   @return [::Google::Type::Money]
          #     Total monthly cost for this preference set.
          # @!attribute [rw] monthly_cost_compute
          #   @return [::Google::Type::Money]
          #     Compute monthly cost for this preference set.
          # @!attribute [rw] monthly_cost_os_license
          #   @return [::Google::Type::Money]
          #     Licensing monthly cost for this preference set.
          # @!attribute [rw] monthly_cost_network_egress
          #   @return [::Google::Type::Money]
          #     Network Egress monthly cost for this preference set.
          # @!attribute [rw] monthly_cost_storage
          #   @return [::Google::Type::Money]
          #     Storage monthly cost for this preference set.
          # @!attribute [rw] monthly_cost_other
          #   @return [::Google::Type::Money]
          #     Miscellaneous monthly cost for this preference set.
          # @!attribute [rw] compute_engine_finding
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::ComputeEngineFinding]
          #     A set of findings that applies to Compute Engine machines in the input.
          # @!attribute [rw] vmware_engine_finding
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::VmwareEngineFinding]
          #     A set of findings that applies to VMWare machines in the input.
          # @!attribute [rw] sole_tenant_finding
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::SoleTenantFinding]
          #     A set of findings that applies to Sole-Tenant machines in the input.
          class GroupPreferenceSetFinding
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Summary Findings for a specific Group.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Display Name for the Group.
          # @!attribute [rw] description
          #   @return [::String]
          #     Description for the Group.
          # @!attribute [rw] asset_aggregate_stats
          #   @return [::Google::Cloud::MigrationCenter::V1::ReportSummary::AssetAggregateStats]
          #     Summary statistics for all the assets in this group.
          # @!attribute [rw] overlapping_asset_count
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Integer]
          #     This field is deprecated, do not rely on it having a value.
          # @!attribute [rw] preference_set_findings
          #   @return [::Array<::Google::Cloud::MigrationCenter::V1::ReportSummary::GroupPreferenceSetFinding>]
          #     Findings for each of the PreferenceSets for this group.
          class GroupFinding
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Specifies the types of asset views that provide complete or partial details
        # of an asset.
        module AssetView
          # The asset view is not specified. The API displays the basic view by
          # default.
          ASSET_VIEW_UNSPECIFIED = 0

          # The asset view includes only basic metadata of the asset.
          ASSET_VIEW_BASIC = 1

          # The asset view includes all the metadata of an asset and performance data.
          ASSET_VIEW_FULL = 2
        end

        # Known categories of operating systems.
        module OperatingSystemFamily
          OS_FAMILY_UNKNOWN = 0

          # Microsoft Windows Server and Desktop.
          OS_FAMILY_WINDOWS = 1

          # Various Linux flavors.
          OS_FAMILY_LINUX = 2

          # Non-Linux Unix flavors.
          OS_FAMILY_UNIX = 3
        end

        # Specifies the data formats supported by Migration Center.
        module ImportJobFormat
          # Default value.
          IMPORT_JOB_FORMAT_UNSPECIFIED = 0

          # RVTools format (XLSX).
          IMPORT_JOB_FORMAT_RVTOOLS_XLSX = 1

          # RVTools format (CSV).
          IMPORT_JOB_FORMAT_RVTOOLS_CSV = 2

          # CSV format exported from AWS using the
          # [AWS collection
          # script][https://github.com/GoogleCloudPlatform/aws-to-stratozone-export].
          IMPORT_JOB_FORMAT_EXPORTED_AWS_CSV = 4

          # CSV format exported from Azure using the
          # [Azure collection
          # script][https://github.com/GoogleCloudPlatform/azure-to-stratozone-export].
          IMPORT_JOB_FORMAT_EXPORTED_AZURE_CSV = 5

          # CSV format created manually and following the StratoZone format. For more
          # information, see [Manually create and upload data
          # tables][https://cloud.google.com/migrate/stratozone/docs/import-data-portal].
          IMPORT_JOB_FORMAT_STRATOZONE_CSV = 6
        end

        # Specifies the types of import job views that provide complete or partial
        # details of an import job.
        module ImportJobView
          # The import job view is not specified. The API displays the basic view by
          # default.
          IMPORT_JOB_VIEW_UNSPECIFIED = 0

          # The import job view includes basic metadata of an import job.
          # This view does not include payload information.
          IMPORT_JOB_VIEW_BASIC = 1

          # The import job view includes all metadata of an import job.
          IMPORT_JOB_VIEW_FULL = 2
        end

        # ErrorFrameView can be specified in ErrorFrames List and Get requests to
        # control the level of details that is returned for the original frame.
        module ErrorFrameView
          # Value is unset. The system will fallback to the default value.
          ERROR_FRAME_VIEW_UNSPECIFIED = 0

          # Include basic frame data, but not the full contents.
          ERROR_FRAME_VIEW_BASIC = 1

          # Include everything.
          ERROR_FRAME_VIEW_FULL = 2
        end

        # The persistent disk (PD) types of Compute Engine virtual machines.
        module PersistentDiskType
          # Unspecified (default value).
          # Selecting this value allows the system to use any disk type according
          # to reported usage. This a good value to start with.
          PERSISTENT_DISK_TYPE_UNSPECIFIED = 0

          # Standard HDD Persistent Disk.
          PERSISTENT_DISK_TYPE_STANDARD = 1

          # Balanced Persistent Disk.
          PERSISTENT_DISK_TYPE_BALANCED = 2

          # SSD Persistent Disk.
          PERSISTENT_DISK_TYPE_SSD = 3
        end

        # The License type for premium images (RHEL, RHEL for SAP, SLES, SLES for SAP,
        # Windows Server).
        module LicenseType
          # Unspecified (default value).
          LICENSE_TYPE_UNSPECIFIED = 0

          # Default Google Cloud licensing plan. Licensing is charged per usage.
          # This a good value to start with.
          LICENSE_TYPE_DEFAULT = 1

          # Bring-your-own-license (BYOL) plan. User provides the OS license.
          LICENSE_TYPE_BRING_YOUR_OWN_LICENSE = 2
        end

        # The sizing optimization strategy preferences of a virtual machine. This
        # strategy, in addition to actual usage data of the virtual machine, can help
        # determine the recommended shape on the target platform.
        module SizingOptimizationStrategy
          # Unspecified (default value).
          SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED = 0

          # No optimization applied. Virtual machine sizing matches as closely as
          # possible the machine shape on the source site, not considering any actual
          # performance data.
          SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE = 1

          # Virtual machine sizing will match the reported usage and shape, with some
          # slack. This a good value to start with.
          SIZING_OPTIMIZATION_STRATEGY_MODERATE = 2

          # Virtual machine sizing will match the reported usage, with little slack.
          # Using this option can help reduce costs.
          SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE = 3
        end

        # The plan of commitments for VM resource-based committed use discount (CUD).
        module CommitmentPlan
          # Unspecified commitment plan.
          COMMITMENT_PLAN_UNSPECIFIED = 0

          # No commitment plan.
          COMMITMENT_PLAN_NONE = 1

          # 1 year commitment.
          COMMITMENT_PLAN_ONE_YEAR = 2

          # 3 years commitment.
          COMMITMENT_PLAN_THREE_YEARS = 3
        end

        # The preference for a specific Google Cloud product platform.
        module ComputeMigrationTargetProduct
          # Unspecified (default value).
          COMPUTE_MIGRATION_TARGET_PRODUCT_UNSPECIFIED = 0

          # Prefer to migrate to Google Cloud Compute Engine.
          COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE = 1

          # Prefer to migrate to Google Cloud VMware Engine.
          COMPUTE_MIGRATION_TARGET_PRODUCT_VMWARE_ENGINE = 2

          # Prefer to migrate to Google Cloud Sole Tenant Nodes.
          COMPUTE_MIGRATION_TARGET_PRODUCT_SOLE_TENANCY = 3
        end

        # Specifies the types of views that provide complete or partial details
        # of a Report.
        module ReportView
          # The report view is not specified. The API displays the basic view by
          # default.
          REPORT_VIEW_UNSPECIFIED = 0

          # The report view includes only basic metadata of the Report. Useful for
          # list views.
          REPORT_VIEW_BASIC = 1

          # The report view includes all the metadata of the Report. Useful for
          # preview.
          REPORT_VIEW_FULL = 2

          # The report view includes the standard metadata of an report. Useful for
          # detail view.
          REPORT_VIEW_STANDARD = 3
        end
      end
    end
  end
end
