# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/migrationcenter/v1/migrationcenter_pb"
require "google/cloud/migration_center/v1/migration_center/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module MigrationCenter
      module V1
        module MigrationCenter
          module Rest
            ##
            # REST client for the MigrationCenter service.
            #
            # Service describing handlers for resources.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "migrationcenter.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :migration_center_stub

              ##
              # Configure the MigrationCenter Client class.
              #
              # See {::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all MigrationCenter clients
              #   ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "MigrationCenter", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config.rpcs.delete_source.timeout = 600.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the MigrationCenter Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @migration_center_stub.universe_domain
              end

              ##
              # Create a new MigrationCenter REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the MigrationCenter client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @migration_center_stub = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @migration_center_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @migration_center_stub.endpoint
                  config.universe_domain = @migration_center_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @migration_center_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @migration_center_stub.logger
              end

              # Service calls

              ##
              # Lists all the assets in a given project and location.
              #
              # @overload list_assets(request, options = nil)
              #   Pass arguments to `list_assets` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ListAssetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ListAssetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_assets(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, view: nil)
              #   Pass arguments to `list_assets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for `ListAssetsRequest`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              #   @param view [::Google::Cloud::MigrationCenter::V1::AssetView]
              #     View of the assets. Defaults to BASIC.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::Asset>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::Asset>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ListAssetsRequest.new
              #
              #   # Call the list_assets method.
              #   result = client.list_assets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::MigrationCenter::V1::Asset.
              #     p item
              #   end
              #
              def list_assets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ListAssetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_assets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_assets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_assets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.list_assets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @migration_center_stub, :list_assets, "assets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of an asset.
              #
              # @overload get_asset(request, options = nil)
              #   Pass arguments to `get_asset` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_asset(name: nil, view: nil)
              #   Pass arguments to `get_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param view [::Google::Cloud::MigrationCenter::V1::AssetView]
              #     View of the assets. Defaults to BASIC.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::Asset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::Asset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetAssetRequest.new
              #
              #   # Call the get_asset method.
              #   result = client.get_asset request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::Asset.
              #   p result
              #
              def get_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_asset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_asset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of an asset.
              #
              # @overload update_asset(request, options = nil)
              #   Pass arguments to `update_asset` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_asset(update_mask: nil, asset: nil, request_id: nil)
              #   Pass arguments to `update_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     `Asset` resource by the update.
              #     The values specified in the `update_mask` field are relative to the
              #     resource, not the full request.
              #     A field will be overwritten if it is in the mask.
              #     A single * value in the mask lets you to overwrite all fields.
              #   @param asset [::Google::Cloud::MigrationCenter::V1::Asset, ::Hash]
              #     Required. The resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::Asset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::Asset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::UpdateAssetRequest.new
              #
              #   # Call the update_asset method.
              #   result = client.update_asset request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::Asset.
              #   p result
              #
              def update_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_asset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.update_asset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a list of assets.
              #
              # @overload batch_update_assets(request, options = nil)
              #   Pass arguments to `batch_update_assets` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_update_assets(parent: nil, requests: nil)
              #   Pass arguments to `batch_update_assets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for batch asset update.
              #   @param requests [::Array<::Google::Cloud::MigrationCenter::V1::UpdateAssetRequest, ::Hash>]
              #     Required. The request message specifying the resources to update.
              #     A maximum of 1000 assets can be modified in a batch.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsRequest.new
              #
              #   # Call the batch_update_assets method.
              #   result = client.batch_update_assets request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsResponse.
              #   p result
              #
              def batch_update_assets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::BatchUpdateAssetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_update_assets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_update_assets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_update_assets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.batch_update_assets request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an asset.
              #
              # @overload delete_asset(request, options = nil)
              #   Pass arguments to `delete_asset` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::DeleteAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::DeleteAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_asset(name: nil, request_id: nil)
              #   Pass arguments to `delete_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::DeleteAssetRequest.new
              #
              #   # Call the delete_asset method.
              #   result = client.delete_asset request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::DeleteAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_asset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.delete_asset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes list of Assets.
              #
              # @overload batch_delete_assets(request, options = nil)
              #   Pass arguments to `batch_delete_assets` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::BatchDeleteAssetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::BatchDeleteAssetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_delete_assets(parent: nil, names: nil, allow_missing: nil)
              #   Pass arguments to `batch_delete_assets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for batch asset delete.
              #   @param names [::Array<::String>]
              #     Required. The IDs of the assets to delete.
              #     A maximum of 1000 assets can be deleted in a batch.
              #     Format: projects/\\{project}/locations/\\{location}/assets/\\{name}.
              #   @param allow_missing [::Boolean]
              #     Optional. When this value is set to `true` the request is a no-op for
              #     non-existing assets. See https://google.aip.dev/135#delete-if-existing for
              #     additional details. Default value is `false`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::BatchDeleteAssetsRequest.new
              #
              #   # Call the batch_delete_assets method.
              #   result = client.batch_delete_assets request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def batch_delete_assets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::BatchDeleteAssetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_delete_assets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_delete_assets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_delete_assets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.batch_delete_assets request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Reports a set of frames.
              #
              # @overload report_asset_frames(request, options = nil)
              #   Pass arguments to `report_asset_frames` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ReportAssetFramesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ReportAssetFramesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload report_asset_frames(parent: nil, frames: nil, source: nil)
              #   Pass arguments to `report_asset_frames` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent of the resource.
              #   @param frames [::Google::Cloud::MigrationCenter::V1::Frames, ::Hash]
              #     Collection of frames data.
              #   @param source [::String]
              #     Required. Reference to a source.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::ReportAssetFramesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::ReportAssetFramesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ReportAssetFramesRequest.new
              #
              #   # Call the report_asset_frames method.
              #   result = client.report_asset_frames request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::ReportAssetFramesResponse.
              #   p result
              #
              def report_asset_frames request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ReportAssetFramesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.report_asset_frames.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.report_asset_frames.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.report_asset_frames.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.report_asset_frames request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Aggregates the requested fields based on provided function.
              #
              # @overload aggregate_assets_values(request, options = nil)
              #   Pass arguments to `aggregate_assets_values` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload aggregate_assets_values(parent: nil, aggregations: nil, filter: nil)
              #   Pass arguments to `aggregate_assets_values` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for `AggregateAssetsValuesRequest`.
              #   @param aggregations [::Array<::Google::Cloud::MigrationCenter::V1::Aggregation, ::Hash>]
              #     Array of aggregations to perform.
              #     Up to 25 aggregations can be defined.
              #   @param filter [::String]
              #     The aggregation will be performed on assets that match the provided filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesRequest.new
              #
              #   # Call the aggregate_assets_values method.
              #   result = client.aggregate_assets_values request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesResponse.
              #   p result
              #
              def aggregate_assets_values request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::AggregateAssetsValuesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.aggregate_assets_values.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.aggregate_assets_values.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.aggregate_assets_values.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.aggregate_assets_values request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an import job.
              #
              # @overload create_import_job(request, options = nil)
              #   Pass arguments to `create_import_job` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::CreateImportJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::CreateImportJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_import_job(parent: nil, import_job_id: nil, import_job: nil, request_id: nil)
              #   Pass arguments to `create_import_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param import_job_id [::String]
              #     Required. ID of the import job.
              #   @param import_job [::Google::Cloud::MigrationCenter::V1::ImportJob, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::CreateImportJobRequest.new
              #
              #   # Call the create_import_job method.
              #   result = client.create_import_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_import_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::CreateImportJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_import_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_import_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_import_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.create_import_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all import jobs.
              #
              # @overload list_import_jobs(request, options = nil)
              #   Pass arguments to `list_import_jobs` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ListImportJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ListImportJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_import_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, view: nil)
              #   Pass arguments to `list_import_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for `ListImportJobsRequest`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              #   @param view [::Google::Cloud::MigrationCenter::V1::ImportJobView]
              #     Optional. The level of details of each import job.
              #     Default value is BASIC.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::ImportJob>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::ImportJob>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ListImportJobsRequest.new
              #
              #   # Call the list_import_jobs method.
              #   result = client.list_import_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::MigrationCenter::V1::ImportJob.
              #     p item
              #   end
              #
              def list_import_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ListImportJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_import_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_import_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_import_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.list_import_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @migration_center_stub, :list_import_jobs, "import_jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of an import job.
              #
              # @overload get_import_job(request, options = nil)
              #   Pass arguments to `get_import_job` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetImportJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetImportJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_import_job(name: nil, view: nil)
              #   Pass arguments to `get_import_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param view [::Google::Cloud::MigrationCenter::V1::ImportJobView]
              #     Optional. The level of details of the import job.
              #     Default value is FULL.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::ImportJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::ImportJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetImportJobRequest.new
              #
              #   # Call the get_import_job method.
              #   result = client.get_import_job request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::ImportJob.
              #   p result
              #
              def get_import_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetImportJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_import_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_import_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_import_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_import_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an import job.
              #
              # @overload delete_import_job(request, options = nil)
              #   Pass arguments to `delete_import_job` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::DeleteImportJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::DeleteImportJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_import_job(name: nil, request_id: nil, force: nil)
              #   Pass arguments to `delete_import_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param force [::Boolean]
              #     Optional. If set to `true`, any `ImportDataFiles` of this job will also be
              #     deleted If set to `false`, the request only works if the job has no data
              #     files.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::DeleteImportJobRequest.new
              #
              #   # Call the delete_import_job method.
              #   result = client.delete_import_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_import_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::DeleteImportJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_import_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_import_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_import_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.delete_import_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an import job.
              #
              # @overload update_import_job(request, options = nil)
              #   Pass arguments to `update_import_job` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::UpdateImportJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::UpdateImportJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_import_job(update_mask: nil, import_job: nil, request_id: nil)
              #   Pass arguments to `update_import_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     `Asset` resource by the update.
              #     The values specified in the `update_mask` field are relative to the
              #     resource, not the full request.
              #     A field will be overwritten if it is in the mask.
              #     A single * value in the mask lets you to overwrite all fields.
              #   @param import_job [::Google::Cloud::MigrationCenter::V1::ImportJob, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::UpdateImportJobRequest.new
              #
              #   # Call the update_import_job method.
              #   result = client.update_import_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_import_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::UpdateImportJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_import_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_import_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_import_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.update_import_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Validates an import job.
              #
              # @overload validate_import_job(request, options = nil)
              #   Pass arguments to `validate_import_job` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ValidateImportJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ValidateImportJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload validate_import_job(name: nil, request_id: nil)
              #   Pass arguments to `validate_import_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the import job to validate.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ValidateImportJobRequest.new
              #
              #   # Call the validate_import_job method.
              #   result = client.validate_import_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def validate_import_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ValidateImportJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.validate_import_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.validate_import_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.validate_import_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.validate_import_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Runs an import job.
              #
              # @overload run_import_job(request, options = nil)
              #   Pass arguments to `run_import_job` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::RunImportJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::RunImportJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_import_job(name: nil, request_id: nil)
              #   Pass arguments to `run_import_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the import job to run.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::RunImportJobRequest.new
              #
              #   # Call the run_import_job method.
              #   result = client.run_import_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def run_import_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::RunImportJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_import_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_import_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_import_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.run_import_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an import data file.
              #
              # @overload get_import_data_file(request, options = nil)
              #   Pass arguments to `get_import_data_file` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetImportDataFileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetImportDataFileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_import_data_file(name: nil)
              #   Pass arguments to `get_import_data_file` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the ImportDataFile.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::ImportDataFile]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::ImportDataFile]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetImportDataFileRequest.new
              #
              #   # Call the get_import_data_file method.
              #   result = client.get_import_data_file request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::ImportDataFile.
              #   p result
              #
              def get_import_data_file request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetImportDataFileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_import_data_file.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_import_data_file.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_import_data_file.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_import_data_file request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List import data files.
              #
              # @overload list_import_data_files(request, options = nil)
              #   Pass arguments to `list_import_data_files` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ListImportDataFilesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ListImportDataFilesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_import_data_files(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_import_data_files` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent of the `ImportDataFiles` resource.
              #   @param page_size [::Integer]
              #     The maximum number of data files to return. The service may return
              #     fewer than this value. If unspecified, at most 500 data files will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListImportDataFiles` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListImportDataFiles`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::ImportDataFile>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::ImportDataFile>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ListImportDataFilesRequest.new
              #
              #   # Call the list_import_data_files method.
              #   result = client.list_import_data_files request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::MigrationCenter::V1::ImportDataFile.
              #     p item
              #   end
              #
              def list_import_data_files request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ListImportDataFilesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_import_data_files.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_import_data_files.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_import_data_files.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.list_import_data_files request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @migration_center_stub, :list_import_data_files, "import_data_files", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an import data file.
              #
              # @overload create_import_data_file(request, options = nil)
              #   Pass arguments to `create_import_data_file` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::CreateImportDataFileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::CreateImportDataFileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_import_data_file(parent: nil, import_data_file_id: nil, import_data_file: nil, request_id: nil)
              #   Pass arguments to `create_import_data_file` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Name of the parent of the ImportDataFile.
              #   @param import_data_file_id [::String]
              #     Required. The ID of the new data file.
              #   @param import_data_file [::Google::Cloud::MigrationCenter::V1::ImportDataFile, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::CreateImportDataFileRequest.new
              #
              #   # Call the create_import_data_file method.
              #   result = client.create_import_data_file request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_import_data_file request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::CreateImportDataFileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_import_data_file.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_import_data_file.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_import_data_file.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.create_import_data_file request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete an import data file.
              #
              # @overload delete_import_data_file(request, options = nil)
              #   Pass arguments to `delete_import_data_file` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::DeleteImportDataFileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::DeleteImportDataFileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_import_data_file(name: nil, request_id: nil)
              #   Pass arguments to `delete_import_data_file` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the ImportDataFile to delete.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::DeleteImportDataFileRequest.new
              #
              #   # Call the delete_import_data_file method.
              #   result = client.delete_import_data_file request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_import_data_file request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::DeleteImportDataFileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_import_data_file.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_import_data_file.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_import_data_file.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.delete_import_data_file request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all groups in a given project and location.
              #
              # @overload list_groups(request, options = nil)
              #   Pass arguments to `list_groups` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ListGroupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ListGroupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_groups(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_groups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for `ListGroupsRequest`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::Group>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::Group>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ListGroupsRequest.new
              #
              #   # Call the list_groups method.
              #   result = client.list_groups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::MigrationCenter::V1::Group.
              #     p item
              #   end
              #
              def list_groups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ListGroupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_groups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_groups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_groups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.list_groups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @migration_center_stub, :list_groups, "groups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a group.
              #
              # @overload get_group(request, options = nil)
              #   Pass arguments to `get_group` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_group(name: nil)
              #   Pass arguments to `get_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::Group]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::Group]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetGroupRequest.new
              #
              #   # Call the get_group method.
              #   result = client.get_group request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::Group.
              #   p result
              #
              def get_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new group in a given project and location.
              #
              # @overload create_group(request, options = nil)
              #   Pass arguments to `create_group` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::CreateGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::CreateGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_group(parent: nil, group_id: nil, group: nil, request_id: nil)
              #   Pass arguments to `create_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param group_id [::String]
              #     Required. User specified ID for the group. It will become the last
              #     component of the group name. The ID must be unique within the project, must
              #     conform with RFC-1034, is restricted to lower-cased letters, and has a
              #     maximum length of 63 characters. The ID must match the regular expression:
              #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
              #   @param group [::Google::Cloud::MigrationCenter::V1::Group, ::Hash]
              #     Required. The group resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::CreateGroupRequest.new
              #
              #   # Call the create_group method.
              #   result = client.create_group request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::CreateGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.create_group request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a group.
              #
              # @overload update_group(request, options = nil)
              #   Pass arguments to `update_group` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::UpdateGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::UpdateGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_group(update_mask: nil, group: nil, request_id: nil)
              #   Pass arguments to `update_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     `Group` resource by the update.
              #     The values specified in the `update_mask` are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #     A single * value in the mask lets you to overwrite all fields.
              #   @param group [::Google::Cloud::MigrationCenter::V1::Group, ::Hash]
              #     Required. The group resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::UpdateGroupRequest.new
              #
              #   # Call the update_group method.
              #   result = client.update_group request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::UpdateGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.update_group request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a group.
              #
              # @overload delete_group(request, options = nil)
              #   Pass arguments to `delete_group` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::DeleteGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::DeleteGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_group(name: nil, request_id: nil)
              #   Pass arguments to `delete_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the group resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::DeleteGroupRequest.new
              #
              #   # Call the delete_group method.
              #   result = client.delete_group request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::DeleteGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.delete_group request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds assets to a group.
              #
              # @overload add_assets_to_group(request, options = nil)
              #   Pass arguments to `add_assets_to_group` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::AddAssetsToGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::AddAssetsToGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload add_assets_to_group(group: nil, request_id: nil, assets: nil, allow_existing: nil)
              #   Pass arguments to `add_assets_to_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param group [::String]
              #     Required. Group reference.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param assets [::Google::Cloud::MigrationCenter::V1::AssetList, ::Hash]
              #     Required. List of assets to be added.
              #     The maximum number of assets that can be added in a single request is
              #     1000.
              #   @param allow_existing [::Boolean]
              #     Optional. When this value is set to `false` and one of the given assets is
              #     already an existing member of the group, the operation fails with an
              #     `Already Exists` error. When set to `true` this situation is silently
              #     ignored by the server.
              #
              #     Default value is `false`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::AddAssetsToGroupRequest.new
              #
              #   # Call the add_assets_to_group method.
              #   result = client.add_assets_to_group request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def add_assets_to_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::AddAssetsToGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.add_assets_to_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.add_assets_to_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.add_assets_to_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.add_assets_to_group request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes assets from a group.
              #
              # @overload remove_assets_from_group(request, options = nil)
              #   Pass arguments to `remove_assets_from_group` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::RemoveAssetsFromGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::RemoveAssetsFromGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload remove_assets_from_group(group: nil, request_id: nil, assets: nil, allow_missing: nil)
              #   Pass arguments to `remove_assets_from_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param group [::String]
              #     Required. Group reference.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param assets [::Google::Cloud::MigrationCenter::V1::AssetList, ::Hash]
              #     Required. List of assets to be removed.
              #     The maximum number of assets that can be removed in a single request is
              #     1000.
              #   @param allow_missing [::Boolean]
              #     Optional. When this value is set to `false` and one of the given assets is
              #     not an existing member of the group, the operation fails with a `Not Found`
              #     error. When set to `true` this situation is silently ignored by the server.
              #
              #     Default value is `false`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::RemoveAssetsFromGroupRequest.new
              #
              #   # Call the remove_assets_from_group method.
              #   result = client.remove_assets_from_group request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def remove_assets_from_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::RemoveAssetsFromGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.remove_assets_from_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.remove_assets_from_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.remove_assets_from_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.remove_assets_from_group request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all error frames in a given source and location.
              #
              # @overload list_error_frames(request, options = nil)
              #   Pass arguments to `list_error_frames` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ListErrorFramesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ListErrorFramesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_error_frames(parent: nil, page_size: nil, page_token: nil, view: nil)
              #   Pass arguments to `list_error_frames` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value (the source) for `ListErrorFramesRequest`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param view [::Google::Cloud::MigrationCenter::V1::ErrorFrameView]
              #     Optional. An optional view mode to control the level of details of each
              #     error frame. The default is a BASIC frame view.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::ErrorFrame>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::ErrorFrame>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ListErrorFramesRequest.new
              #
              #   # Call the list_error_frames method.
              #   result = client.list_error_frames request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::MigrationCenter::V1::ErrorFrame.
              #     p item
              #   end
              #
              def list_error_frames request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ListErrorFramesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_error_frames.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_error_frames.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_error_frames.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.list_error_frames request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @migration_center_stub, :list_error_frames, "error_frames", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of an error frame.
              #
              # @overload get_error_frame(request, options = nil)
              #   Pass arguments to `get_error_frame` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetErrorFrameRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetErrorFrameRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_error_frame(name: nil, view: nil)
              #   Pass arguments to `get_error_frame` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the frame to retrieve.
              #     Format:
              #     projects/\\{project}/locations/\\{location}/sources/\\{source}/errorFrames/\\{error_frame}
              #   @param view [::Google::Cloud::MigrationCenter::V1::ErrorFrameView]
              #     Optional. An optional view mode to control the level of details for the
              #     frame. The default is a basic frame view.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::ErrorFrame]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::ErrorFrame]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetErrorFrameRequest.new
              #
              #   # Call the get_error_frame method.
              #   result = client.get_error_frame request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::ErrorFrame.
              #   p result
              #
              def get_error_frame request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetErrorFrameRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_error_frame.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_error_frame.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_error_frame.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_error_frame request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the sources in a given project and location.
              #
              # @overload list_sources(request, options = nil)
              #   Pass arguments to `list_sources` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ListSourcesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ListSourcesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_sources(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_sources` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for `ListSourcesRequest`.
              #   @param page_size [::Integer]
              #     Requested page size. The server may return fewer items than requested.
              #     If unspecified, the server will pick an appropriate default value.
              #   @param page_token [::String]
              #     A token identifying a page of results that the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::Source>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::Source>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ListSourcesRequest.new
              #
              #   # Call the list_sources method.
              #   result = client.list_sources request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::MigrationCenter::V1::Source.
              #     p item
              #   end
              #
              def list_sources request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ListSourcesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_sources.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_sources.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_sources.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.list_sources request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @migration_center_stub, :list_sources, "sources", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a source.
              #
              # @overload get_source(request, options = nil)
              #   Pass arguments to `get_source` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_source(name: nil)
              #   Pass arguments to `get_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::Source]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::Source]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetSourceRequest.new
              #
              #   # Call the get_source method.
              #   result = client.get_source request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::Source.
              #   p result
              #
              def get_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_source.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_source request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new source in a given project and location.
              #
              # @overload create_source(request, options = nil)
              #   Pass arguments to `create_source` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::CreateSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::CreateSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_source(parent: nil, source_id: nil, source: nil, request_id: nil)
              #   Pass arguments to `create_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param source_id [::String]
              #     Required. User specified ID for the source. It will become the last
              #     component of the source name. The ID must be unique within the project,
              #     must conform with RFC-1034, is restricted to lower-cased letters, and has a
              #     maximum length of 63 characters. The ID must match the regular expression:
              #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
              #   @param source [::Google::Cloud::MigrationCenter::V1::Source, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::CreateSourceRequest.new
              #
              #   # Call the create_source method.
              #   result = client.create_source request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::CreateSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_source.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.create_source request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a source.
              #
              # @overload update_source(request, options = nil)
              #   Pass arguments to `update_source` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::UpdateSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::UpdateSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_source(update_mask: nil, source: nil, request_id: nil)
              #   Pass arguments to `update_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     `Source` resource by the update.
              #     The values specified in the `update_mask` field are relative to the
              #     resource, not the full request.
              #     A field will be overwritten if it is in the mask.
              #     A single * value in the mask lets you to overwrite all fields.
              #   @param source [::Google::Cloud::MigrationCenter::V1::Source, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::UpdateSourceRequest.new
              #
              #   # Call the update_source method.
              #   result = client.update_source request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::UpdateSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_source.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.update_source request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a source.
              #
              # @overload delete_source(request, options = nil)
              #   Pass arguments to `delete_source` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::DeleteSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::DeleteSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_source(name: nil, request_id: nil)
              #   Pass arguments to `delete_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::DeleteSourceRequest.new
              #
              #   # Call the delete_source method.
              #   result = client.delete_source request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::DeleteSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_source.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.delete_source request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all the preference sets in a given project and location.
              #
              # @overload list_preference_sets(request, options = nil)
              #   Pass arguments to `list_preference_sets` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_preference_sets(parent: nil, page_size: nil, page_token: nil, order_by: nil)
              #   Pass arguments to `list_preference_sets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for `ListPreferenceSetsRequest`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, at most 500 preference sets will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::PreferenceSet>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::PreferenceSet>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ListPreferenceSetsRequest.new
              #
              #   # Call the list_preference_sets method.
              #   result = client.list_preference_sets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::MigrationCenter::V1::PreferenceSet.
              #     p item
              #   end
              #
              def list_preference_sets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ListPreferenceSetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_preference_sets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_preference_sets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_preference_sets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.list_preference_sets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @migration_center_stub, :list_preference_sets, "preference_sets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a preference set.
              #
              # @overload get_preference_set(request, options = nil)
              #   Pass arguments to `get_preference_set` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetPreferenceSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetPreferenceSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_preference_set(name: nil)
              #   Pass arguments to `get_preference_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::PreferenceSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::PreferenceSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetPreferenceSetRequest.new
              #
              #   # Call the get_preference_set method.
              #   result = client.get_preference_set request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::PreferenceSet.
              #   p result
              #
              def get_preference_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetPreferenceSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_preference_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_preference_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_preference_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_preference_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new preference set in a given project and location.
              #
              # @overload create_preference_set(request, options = nil)
              #   Pass arguments to `create_preference_set` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::CreatePreferenceSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::CreatePreferenceSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_preference_set(parent: nil, preference_set_id: nil, preference_set: nil, request_id: nil)
              #   Pass arguments to `create_preference_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param preference_set_id [::String]
              #     Required. User specified ID for the preference set. It will become the last
              #     component of the preference set name. The ID must be unique within the
              #     project, must conform with RFC-1034, is restricted to lower-cased letters,
              #     and has a maximum length of 63 characters. The ID must match the regular
              #     expression
              #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
              #   @param preference_set [::Google::Cloud::MigrationCenter::V1::PreferenceSet, ::Hash]
              #     Required. The preference set resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::CreatePreferenceSetRequest.new
              #
              #   # Call the create_preference_set method.
              #   result = client.create_preference_set request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_preference_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::CreatePreferenceSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_preference_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_preference_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_preference_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.create_preference_set request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a preference set.
              #
              # @overload update_preference_set(request, options = nil)
              #   Pass arguments to `update_preference_set` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::UpdatePreferenceSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::UpdatePreferenceSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_preference_set(update_mask: nil, preference_set: nil, request_id: nil)
              #   Pass arguments to `update_preference_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     `PreferenceSet` resource by the update.
              #     The values specified in the `update_mask` field are relative to the
              #     resource, not the full request.
              #     A field will be overwritten if it is in the mask.
              #     A single * value in the mask lets you to overwrite all fields.
              #   @param preference_set [::Google::Cloud::MigrationCenter::V1::PreferenceSet, ::Hash]
              #     Required. The preference set resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::UpdatePreferenceSetRequest.new
              #
              #   # Call the update_preference_set method.
              #   result = client.update_preference_set request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_preference_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::UpdatePreferenceSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_preference_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_preference_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_preference_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.update_preference_set request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a preference set.
              #
              # @overload delete_preference_set(request, options = nil)
              #   Pass arguments to `delete_preference_set` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::DeletePreferenceSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::DeletePreferenceSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_preference_set(name: nil, request_id: nil)
              #   Pass arguments to `delete_preference_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the group resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::DeletePreferenceSetRequest.new
              #
              #   # Call the delete_preference_set method.
              #   result = client.delete_preference_set request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_preference_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::DeletePreferenceSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_preference_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_preference_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_preference_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.delete_preference_set request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of regional settings.
              #
              # @overload get_settings(request, options = nil)
              #   Pass arguments to `get_settings` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_settings(name: nil)
              #   Pass arguments to `get_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::Settings]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::Settings]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetSettingsRequest.new
              #
              #   # Call the get_settings method.
              #   result = client.get_settings request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::Settings.
              #   p result
              #
              def get_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_settings request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the regional-level project settings.
              #
              # @overload update_settings(request, options = nil)
              #   Pass arguments to `update_settings` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::UpdateSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::UpdateSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_settings(update_mask: nil, settings: nil, request_id: nil)
              #   Pass arguments to `update_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     `Settings` resource by the update.
              #     The values specified in the `update_mask` field are relative to the
              #     resource, not the full request.
              #     A field will be overwritten if it is in the mask.
              #     A single * value in the mask lets you to overwrite all fields.
              #   @param settings [::Google::Cloud::MigrationCenter::V1::Settings, ::Hash]
              #     Required. The project settings resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::UpdateSettingsRequest.new
              #
              #   # Call the update_settings method.
              #   result = client.update_settings request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::UpdateSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.update_settings request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a report configuration.
              #
              # @overload create_report_config(request, options = nil)
              #   Pass arguments to `create_report_config` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::CreateReportConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::CreateReportConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_report_config(parent: nil, report_config_id: nil, report_config: nil, request_id: nil)
              #   Pass arguments to `create_report_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param report_config_id [::String]
              #     Required. User specified ID for the report config. It will become the last
              #     component of the report config name. The ID must be unique within the
              #     project, must conform with RFC-1034, is restricted to lower-cased letters,
              #     and has a maximum length of 63 characters. The ID must match the regular
              #     expression: [a-z]([a-z0-9-]\\{0,61}[a-z0-9])?.
              #   @param report_config [::Google::Cloud::MigrationCenter::V1::ReportConfig, ::Hash]
              #     Required. The report config set resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::CreateReportConfigRequest.new
              #
              #   # Call the create_report_config method.
              #   result = client.create_report_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_report_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::CreateReportConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_report_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_report_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_report_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.create_report_config request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single ReportConfig.
              #
              # @overload get_report_config(request, options = nil)
              #   Pass arguments to `get_report_config` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetReportConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetReportConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_report_config(name: nil)
              #   Pass arguments to `get_report_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::ReportConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::ReportConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetReportConfigRequest.new
              #
              #   # Call the get_report_config method.
              #   result = client.get_report_config request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::ReportConfig.
              #   p result
              #
              def get_report_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetReportConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_report_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_report_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_report_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_report_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists ReportConfigs in a given project and location.
              #
              # @overload list_report_configs(request, options = nil)
              #   Pass arguments to `list_report_configs` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ListReportConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ListReportConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_report_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_report_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for `ListReportConfigsRequest`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::ReportConfig>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::ReportConfig>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ListReportConfigsRequest.new
              #
              #   # Call the list_report_configs method.
              #   result = client.list_report_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::MigrationCenter::V1::ReportConfig.
              #     p item
              #   end
              #
              def list_report_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ListReportConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_report_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_report_configs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_report_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.list_report_configs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @migration_center_stub, :list_report_configs, "report_configs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a ReportConfig.
              #
              # @overload delete_report_config(request, options = nil)
              #   Pass arguments to `delete_report_config` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::DeleteReportConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::DeleteReportConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_report_config(name: nil, request_id: nil, force: nil)
              #   Pass arguments to `delete_report_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param force [::Boolean]
              #     Optional. If set to `true`, any child `Reports` of this entity will also be
              #     deleted. If set to `false`, the request only works if the resource has no
              #     children.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::DeleteReportConfigRequest.new
              #
              #   # Call the delete_report_config method.
              #   result = client.delete_report_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_report_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::DeleteReportConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_report_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_report_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_report_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.delete_report_config request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a report.
              #
              # @overload create_report(request, options = nil)
              #   Pass arguments to `create_report` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::CreateReportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::CreateReportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_report(parent: nil, report_id: nil, report: nil, request_id: nil)
              #   Pass arguments to `create_report` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param report_id [::String]
              #     Required. User specified id for the report. It will become the last
              #     component of the report name. The id must be unique within the project,
              #     must conform with RFC-1034, is restricted to lower-cased letters, and has a
              #     maximum length of 63 characters. The id must match the regular expression:
              #     [a-z]([a-z0-9-]\\{0,61}[a-z0-9])?.
              #   @param report [::Google::Cloud::MigrationCenter::V1::Report, ::Hash]
              #     Required. The report resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::CreateReportRequest.new
              #
              #   # Call the create_report method.
              #   result = client.create_report request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_report request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::CreateReportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_report.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_report.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_report.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.create_report request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Report.
              #
              # @overload get_report(request, options = nil)
              #   Pass arguments to `get_report` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::GetReportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::GetReportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_report(name: nil, view: nil)
              #   Pass arguments to `get_report` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param view [::Google::Cloud::MigrationCenter::V1::ReportView]
              #     Determines what information to retrieve for the Report.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::MigrationCenter::V1::Report]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::MigrationCenter::V1::Report]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::GetReportRequest.new
              #
              #   # Call the get_report method.
              #   result = client.get_report request
              #
              #   # The returned object is of type Google::Cloud::MigrationCenter::V1::Report.
              #   p result
              #
              def get_report request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::GetReportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_report.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_report.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_report.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.get_report request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Reports in a given ReportConfig.
              #
              # @overload list_reports(request, options = nil)
              #   Pass arguments to `list_reports` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::ListReportsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::ListReportsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_reports(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, view: nil)
              #   Pass arguments to `list_reports` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for `ListReportsRequest`.
              #   @param page_size [::Integer]
              #     Requested page size. The server may return fewer items than requested.
              #     If unspecified, the server will pick an appropriate default value.
              #   @param page_token [::String]
              #     A token identifying a page of results that the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              #   @param view [::Google::Cloud::MigrationCenter::V1::ReportView]
              #     Determines what information to retrieve for each Report.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::Report>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::MigrationCenter::V1::Report>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::ListReportsRequest.new
              #
              #   # Call the list_reports method.
              #   result = client.list_reports request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::MigrationCenter::V1::Report.
              #     p item
              #   end
              #
              def list_reports request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::ListReportsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_reports.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_reports.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_reports.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.list_reports request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @migration_center_stub, :list_reports, "reports", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Report.
              #
              # @overload delete_report(request, options = nil)
              #   Pass arguments to `delete_report` via a request object, either of type
              #   {::Google::Cloud::MigrationCenter::V1::DeleteReportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::MigrationCenter::V1::DeleteReportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_report(name: nil, request_id: nil)
              #   Pass arguments to `delete_report` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/migration_center/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::MigrationCenter::V1::DeleteReportRequest.new
              #
              #   # Call the delete_report method.
              #   result = client.delete_report request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_report request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::MigrationCenter::V1::DeleteReportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_report.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::MigrationCenter::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_report.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_report.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @migration_center_stub.delete_report request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the MigrationCenter REST API.
              #
              # This class represents the configuration for MigrationCenter REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_assets to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_assets.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::MigrationCenter::V1::MigrationCenter::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_assets.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "migrationcenter.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the MigrationCenter API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_assets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_assets
                  ##
                  # RPC-specific configuration for `get_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_asset
                  ##
                  # RPC-specific configuration for `update_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_asset
                  ##
                  # RPC-specific configuration for `batch_update_assets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_update_assets
                  ##
                  # RPC-specific configuration for `delete_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_asset
                  ##
                  # RPC-specific configuration for `batch_delete_assets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_delete_assets
                  ##
                  # RPC-specific configuration for `report_asset_frames`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :report_asset_frames
                  ##
                  # RPC-specific configuration for `aggregate_assets_values`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :aggregate_assets_values
                  ##
                  # RPC-specific configuration for `create_import_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_import_job
                  ##
                  # RPC-specific configuration for `list_import_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_import_jobs
                  ##
                  # RPC-specific configuration for `get_import_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_import_job
                  ##
                  # RPC-specific configuration for `delete_import_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_import_job
                  ##
                  # RPC-specific configuration for `update_import_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_import_job
                  ##
                  # RPC-specific configuration for `validate_import_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :validate_import_job
                  ##
                  # RPC-specific configuration for `run_import_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_import_job
                  ##
                  # RPC-specific configuration for `get_import_data_file`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_import_data_file
                  ##
                  # RPC-specific configuration for `list_import_data_files`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_import_data_files
                  ##
                  # RPC-specific configuration for `create_import_data_file`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_import_data_file
                  ##
                  # RPC-specific configuration for `delete_import_data_file`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_import_data_file
                  ##
                  # RPC-specific configuration for `list_groups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_groups
                  ##
                  # RPC-specific configuration for `get_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_group
                  ##
                  # RPC-specific configuration for `create_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_group
                  ##
                  # RPC-specific configuration for `update_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_group
                  ##
                  # RPC-specific configuration for `delete_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_group
                  ##
                  # RPC-specific configuration for `add_assets_to_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :add_assets_to_group
                  ##
                  # RPC-specific configuration for `remove_assets_from_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :remove_assets_from_group
                  ##
                  # RPC-specific configuration for `list_error_frames`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_error_frames
                  ##
                  # RPC-specific configuration for `get_error_frame`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_error_frame
                  ##
                  # RPC-specific configuration for `list_sources`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_sources
                  ##
                  # RPC-specific configuration for `get_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_source
                  ##
                  # RPC-specific configuration for `create_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_source
                  ##
                  # RPC-specific configuration for `update_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_source
                  ##
                  # RPC-specific configuration for `delete_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_source
                  ##
                  # RPC-specific configuration for `list_preference_sets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_preference_sets
                  ##
                  # RPC-specific configuration for `get_preference_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_preference_set
                  ##
                  # RPC-specific configuration for `create_preference_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_preference_set
                  ##
                  # RPC-specific configuration for `update_preference_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_preference_set
                  ##
                  # RPC-specific configuration for `delete_preference_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_preference_set
                  ##
                  # RPC-specific configuration for `get_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_settings
                  ##
                  # RPC-specific configuration for `update_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_settings
                  ##
                  # RPC-specific configuration for `create_report_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_report_config
                  ##
                  # RPC-specific configuration for `get_report_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_report_config
                  ##
                  # RPC-specific configuration for `list_report_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_report_configs
                  ##
                  # RPC-specific configuration for `delete_report_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_report_config
                  ##
                  # RPC-specific configuration for `create_report`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_report
                  ##
                  # RPC-specific configuration for `get_report`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_report
                  ##
                  # RPC-specific configuration for `list_reports`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_reports
                  ##
                  # RPC-specific configuration for `delete_report`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_report

                  # @private
                  def initialize parent_rpcs = nil
                    list_assets_config = parent_rpcs.list_assets if parent_rpcs.respond_to? :list_assets
                    @list_assets = ::Gapic::Config::Method.new list_assets_config
                    get_asset_config = parent_rpcs.get_asset if parent_rpcs.respond_to? :get_asset
                    @get_asset = ::Gapic::Config::Method.new get_asset_config
                    update_asset_config = parent_rpcs.update_asset if parent_rpcs.respond_to? :update_asset
                    @update_asset = ::Gapic::Config::Method.new update_asset_config
                    batch_update_assets_config = parent_rpcs.batch_update_assets if parent_rpcs.respond_to? :batch_update_assets
                    @batch_update_assets = ::Gapic::Config::Method.new batch_update_assets_config
                    delete_asset_config = parent_rpcs.delete_asset if parent_rpcs.respond_to? :delete_asset
                    @delete_asset = ::Gapic::Config::Method.new delete_asset_config
                    batch_delete_assets_config = parent_rpcs.batch_delete_assets if parent_rpcs.respond_to? :batch_delete_assets
                    @batch_delete_assets = ::Gapic::Config::Method.new batch_delete_assets_config
                    report_asset_frames_config = parent_rpcs.report_asset_frames if parent_rpcs.respond_to? :report_asset_frames
                    @report_asset_frames = ::Gapic::Config::Method.new report_asset_frames_config
                    aggregate_assets_values_config = parent_rpcs.aggregate_assets_values if parent_rpcs.respond_to? :aggregate_assets_values
                    @aggregate_assets_values = ::Gapic::Config::Method.new aggregate_assets_values_config
                    create_import_job_config = parent_rpcs.create_import_job if parent_rpcs.respond_to? :create_import_job
                    @create_import_job = ::Gapic::Config::Method.new create_import_job_config
                    list_import_jobs_config = parent_rpcs.list_import_jobs if parent_rpcs.respond_to? :list_import_jobs
                    @list_import_jobs = ::Gapic::Config::Method.new list_import_jobs_config
                    get_import_job_config = parent_rpcs.get_import_job if parent_rpcs.respond_to? :get_import_job
                    @get_import_job = ::Gapic::Config::Method.new get_import_job_config
                    delete_import_job_config = parent_rpcs.delete_import_job if parent_rpcs.respond_to? :delete_import_job
                    @delete_import_job = ::Gapic::Config::Method.new delete_import_job_config
                    update_import_job_config = parent_rpcs.update_import_job if parent_rpcs.respond_to? :update_import_job
                    @update_import_job = ::Gapic::Config::Method.new update_import_job_config
                    validate_import_job_config = parent_rpcs.validate_import_job if parent_rpcs.respond_to? :validate_import_job
                    @validate_import_job = ::Gapic::Config::Method.new validate_import_job_config
                    run_import_job_config = parent_rpcs.run_import_job if parent_rpcs.respond_to? :run_import_job
                    @run_import_job = ::Gapic::Config::Method.new run_import_job_config
                    get_import_data_file_config = parent_rpcs.get_import_data_file if parent_rpcs.respond_to? :get_import_data_file
                    @get_import_data_file = ::Gapic::Config::Method.new get_import_data_file_config
                    list_import_data_files_config = parent_rpcs.list_import_data_files if parent_rpcs.respond_to? :list_import_data_files
                    @list_import_data_files = ::Gapic::Config::Method.new list_import_data_files_config
                    create_import_data_file_config = parent_rpcs.create_import_data_file if parent_rpcs.respond_to? :create_import_data_file
                    @create_import_data_file = ::Gapic::Config::Method.new create_import_data_file_config
                    delete_import_data_file_config = parent_rpcs.delete_import_data_file if parent_rpcs.respond_to? :delete_import_data_file
                    @delete_import_data_file = ::Gapic::Config::Method.new delete_import_data_file_config
                    list_groups_config = parent_rpcs.list_groups if parent_rpcs.respond_to? :list_groups
                    @list_groups = ::Gapic::Config::Method.new list_groups_config
                    get_group_config = parent_rpcs.get_group if parent_rpcs.respond_to? :get_group
                    @get_group = ::Gapic::Config::Method.new get_group_config
                    create_group_config = parent_rpcs.create_group if parent_rpcs.respond_to? :create_group
                    @create_group = ::Gapic::Config::Method.new create_group_config
                    update_group_config = parent_rpcs.update_group if parent_rpcs.respond_to? :update_group
                    @update_group = ::Gapic::Config::Method.new update_group_config
                    delete_group_config = parent_rpcs.delete_group if parent_rpcs.respond_to? :delete_group
                    @delete_group = ::Gapic::Config::Method.new delete_group_config
                    add_assets_to_group_config = parent_rpcs.add_assets_to_group if parent_rpcs.respond_to? :add_assets_to_group
                    @add_assets_to_group = ::Gapic::Config::Method.new add_assets_to_group_config
                    remove_assets_from_group_config = parent_rpcs.remove_assets_from_group if parent_rpcs.respond_to? :remove_assets_from_group
                    @remove_assets_from_group = ::Gapic::Config::Method.new remove_assets_from_group_config
                    list_error_frames_config = parent_rpcs.list_error_frames if parent_rpcs.respond_to? :list_error_frames
                    @list_error_frames = ::Gapic::Config::Method.new list_error_frames_config
                    get_error_frame_config = parent_rpcs.get_error_frame if parent_rpcs.respond_to? :get_error_frame
                    @get_error_frame = ::Gapic::Config::Method.new get_error_frame_config
                    list_sources_config = parent_rpcs.list_sources if parent_rpcs.respond_to? :list_sources
                    @list_sources = ::Gapic::Config::Method.new list_sources_config
                    get_source_config = parent_rpcs.get_source if parent_rpcs.respond_to? :get_source
                    @get_source = ::Gapic::Config::Method.new get_source_config
                    create_source_config = parent_rpcs.create_source if parent_rpcs.respond_to? :create_source
                    @create_source = ::Gapic::Config::Method.new create_source_config
                    update_source_config = parent_rpcs.update_source if parent_rpcs.respond_to? :update_source
                    @update_source = ::Gapic::Config::Method.new update_source_config
                    delete_source_config = parent_rpcs.delete_source if parent_rpcs.respond_to? :delete_source
                    @delete_source = ::Gapic::Config::Method.new delete_source_config
                    list_preference_sets_config = parent_rpcs.list_preference_sets if parent_rpcs.respond_to? :list_preference_sets
                    @list_preference_sets = ::Gapic::Config::Method.new list_preference_sets_config
                    get_preference_set_config = parent_rpcs.get_preference_set if parent_rpcs.respond_to? :get_preference_set
                    @get_preference_set = ::Gapic::Config::Method.new get_preference_set_config
                    create_preference_set_config = parent_rpcs.create_preference_set if parent_rpcs.respond_to? :create_preference_set
                    @create_preference_set = ::Gapic::Config::Method.new create_preference_set_config
                    update_preference_set_config = parent_rpcs.update_preference_set if parent_rpcs.respond_to? :update_preference_set
                    @update_preference_set = ::Gapic::Config::Method.new update_preference_set_config
                    delete_preference_set_config = parent_rpcs.delete_preference_set if parent_rpcs.respond_to? :delete_preference_set
                    @delete_preference_set = ::Gapic::Config::Method.new delete_preference_set_config
                    get_settings_config = parent_rpcs.get_settings if parent_rpcs.respond_to? :get_settings
                    @get_settings = ::Gapic::Config::Method.new get_settings_config
                    update_settings_config = parent_rpcs.update_settings if parent_rpcs.respond_to? :update_settings
                    @update_settings = ::Gapic::Config::Method.new update_settings_config
                    create_report_config_config = parent_rpcs.create_report_config if parent_rpcs.respond_to? :create_report_config
                    @create_report_config = ::Gapic::Config::Method.new create_report_config_config
                    get_report_config_config = parent_rpcs.get_report_config if parent_rpcs.respond_to? :get_report_config
                    @get_report_config = ::Gapic::Config::Method.new get_report_config_config
                    list_report_configs_config = parent_rpcs.list_report_configs if parent_rpcs.respond_to? :list_report_configs
                    @list_report_configs = ::Gapic::Config::Method.new list_report_configs_config
                    delete_report_config_config = parent_rpcs.delete_report_config if parent_rpcs.respond_to? :delete_report_config
                    @delete_report_config = ::Gapic::Config::Method.new delete_report_config_config
                    create_report_config = parent_rpcs.create_report if parent_rpcs.respond_to? :create_report
                    @create_report = ::Gapic::Config::Method.new create_report_config
                    get_report_config = parent_rpcs.get_report if parent_rpcs.respond_to? :get_report
                    @get_report = ::Gapic::Config::Method.new get_report_config
                    list_reports_config = parent_rpcs.list_reports if parent_rpcs.respond_to? :list_reports
                    @list_reports = ::Gapic::Config::Method.new list_reports_config
                    delete_report_config = parent_rpcs.delete_report if parent_rpcs.respond_to? :delete_report
                    @delete_report = ::Gapic::Config::Method.new delete_report_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
