# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/metastore/v1beta/metastore_federation.proto for package 'google.cloud.metastore.v1beta'
# Original file comments:
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/metastore/v1beta/metastore_federation_pb'

module Google
  module Cloud
    module Metastore
      module V1beta
        module DataprocMetastoreFederation
          # Configures and manages metastore federation services.
          # Dataproc Metastore Federation Service allows federating a collection of
          # backend metastores like BigQuery, Dataplex Lakes, and other Dataproc
          # Metastores. The Federation Service exposes a gRPC URL through which metadata
          # from the backend metastores are served at query time.
          #
          # The Dataproc Metastore Federation API defines the following resource model:
          # * The service works with a collection of Google Cloud projects.
          # * Each project has a collection of available locations.
          # * Each location has a collection of federations.
          # * Dataproc Metastore Federations are resources with names of the
          # form:
          # `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.metastore.v1beta.DataprocMetastoreFederation'

            # Lists federations in a project and location.
            rpc :ListFederations, ::Google::Cloud::Metastore::V1beta::ListFederationsRequest, ::Google::Cloud::Metastore::V1beta::ListFederationsResponse
            # Gets the details of a single federation.
            rpc :GetFederation, ::Google::Cloud::Metastore::V1beta::GetFederationRequest, ::Google::Cloud::Metastore::V1beta::Federation
            # Creates a metastore federation in a project and location.
            rpc :CreateFederation, ::Google::Cloud::Metastore::V1beta::CreateFederationRequest, ::Google::Longrunning::Operation
            # Updates the fields of a federation.
            rpc :UpdateFederation, ::Google::Cloud::Metastore::V1beta::UpdateFederationRequest, ::Google::Longrunning::Operation
            # Deletes a single federation.
            rpc :DeleteFederation, ::Google::Cloud::Metastore::V1beta::DeleteFederationRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
