# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/metastore/v1beta/metastore_federation_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Metastore
      module V1beta
        module DataprocMetastoreFederation
          ##
          # Client for the DataprocMetastoreFederation service.
          #
          # Configures and manages metastore federation services.
          # Dataproc Metastore Federation Service allows federating a collection of
          # backend metastores like BigQuery, Dataplex Lakes, and other Dataproc
          # Metastores. The Federation Service exposes a gRPC URL through which metadata
          # from the backend metastores are served at query time.
          #
          # The Dataproc Metastore Federation API defines the following resource model:
          # * The service works with a collection of Google Cloud projects.
          # * Each project has a collection of available locations.
          # * Each location has a collection of federations.
          # * Dataproc Metastore Federations are resources with names of the
          # form:
          # `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "metastore.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :dataproc_metastore_federation_stub

            ##
            # Configure the DataprocMetastoreFederation Client class.
            #
            # See {::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DataprocMetastoreFederation clients
            #   ::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Metastore", "V1beta"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DataprocMetastoreFederation Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @dataproc_metastore_federation_stub.universe_domain
            end

            ##
            # Create a new DataprocMetastoreFederation client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DataprocMetastoreFederation client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/metastore/v1beta/metastore_federation_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @dataproc_metastore_federation_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @dataproc_metastore_federation_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @dataproc_metastore_federation_stub.endpoint
                config.universe_domain = @dataproc_metastore_federation_stub.universe_domain
                config.logger = @dataproc_metastore_federation_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @dataproc_metastore_federation_stub.endpoint
                config.universe_domain = @dataproc_metastore_federation_stub.universe_domain
                config.logger = @dataproc_metastore_federation_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @dataproc_metastore_federation_stub.logger
            end

            # Service calls

            ##
            # Lists federations in a project and location.
            #
            # @overload list_federations(request, options = nil)
            #   Pass arguments to `list_federations` via a request object, either of type
            #   {::Google::Cloud::Metastore::V1beta::ListFederationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Metastore::V1beta::ListFederationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_federations(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_federations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The relative resource name of the location of metastore
            #     federations to list, in the following form:
            #     `projects/{project_number}/locations/{location_id}`.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of federations to return. The response may
            #     contain less than the maximum number. If unspecified, no more than 500
            #     services are returned. The maximum value is 1000; values above 1000 are
            #     changed to 1000.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous ListFederationServices
            #     call. Provide this token to retrieve the subsequent page.
            #
            #     To retrieve the first page, supply an empty page token.
            #
            #     When paginating, other parameters provided to
            #     ListFederationServices must match the call that provided the
            #     page token.
            #   @param filter [::String]
            #     Optional. The filter to apply to list results.
            #   @param order_by [::String]
            #     Optional. Specify the ordering of results as described in [Sorting
            #     Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
            #     If not specified, the results will be sorted in the default order.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Metastore::V1beta::Federation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Metastore::V1beta::Federation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/metastore/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Metastore::V1beta::ListFederationsRequest.new
            #
            #   # Call the list_federations method.
            #   result = client.list_federations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Metastore::V1beta::Federation.
            #     p item
            #   end
            #
            def list_federations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1beta::ListFederationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_federations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Metastore::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_federations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_federations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataproc_metastore_federation_stub.call_rpc :list_federations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataproc_metastore_federation_stub, :list_federations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a single federation.
            #
            # @overload get_federation(request, options = nil)
            #   Pass arguments to `get_federation` via a request object, either of type
            #   {::Google::Cloud::Metastore::V1beta::GetFederationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Metastore::V1beta::GetFederationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_federation(name: nil)
            #   Pass arguments to `get_federation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The relative resource name of the metastore federation to
            #     retrieve, in the following form:
            #
            #     `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Metastore::V1beta::Federation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Metastore::V1beta::Federation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/metastore/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Metastore::V1beta::GetFederationRequest.new
            #
            #   # Call the get_federation method.
            #   result = client.get_federation request
            #
            #   # The returned object is of type Google::Cloud::Metastore::V1beta::Federation.
            #   p result
            #
            def get_federation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1beta::GetFederationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_federation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Metastore::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_federation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_federation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataproc_metastore_federation_stub.call_rpc :get_federation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a metastore federation in a project and location.
            #
            # @overload create_federation(request, options = nil)
            #   Pass arguments to `create_federation` via a request object, either of type
            #   {::Google::Cloud::Metastore::V1beta::CreateFederationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Metastore::V1beta::CreateFederationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_federation(parent: nil, federation_id: nil, federation: nil, request_id: nil)
            #   Pass arguments to `create_federation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The relative resource name of the location in which to create a
            #     federation service, in the following form:
            #
            #     `projects/{project_number}/locations/{location_id}`.
            #   @param federation_id [::String]
            #     Required. The ID of the metastore federation, which is used as the final
            #     component of the metastore federation's name.
            #
            #     This value must be between 2 and 63 characters long inclusive, begin with a
            #     letter, end with a letter or number, and consist of alpha-numeric
            #     ASCII characters or hyphens.
            #   @param federation [::Google::Cloud::Metastore::V1beta::Federation, ::Hash]
            #     Required. The Metastore Federation to create. The `name` field is
            #     ignored. The ID of the created metastore federation must be
            #     provided in the request's `federation_id` field.
            #   @param request_id [::String]
            #     Optional. A request ID. Specify a unique request ID to allow the server to
            #     ignore the request if it has completed. The server will ignore subsequent
            #     requests that provide a duplicate request ID for at least 60 minutes after
            #     the first request.
            #
            #     For example, if an initial request times out, followed by another request
            #     with the same request ID, the server ignores the second request to prevent
            #     the creation of duplicate commitments.
            #
            #     The request ID must be a valid
            #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
            #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/metastore/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Metastore::V1beta::CreateFederationRequest.new
            #
            #   # Call the create_federation method.
            #   result = client.create_federation request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_federation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1beta::CreateFederationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_federation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Metastore::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_federation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_federation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataproc_metastore_federation_stub.call_rpc :create_federation, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the fields of a federation.
            #
            # @overload update_federation(request, options = nil)
            #   Pass arguments to `update_federation` via a request object, either of type
            #   {::Google::Cloud::Metastore::V1beta::UpdateFederationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Metastore::V1beta::UpdateFederationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_federation(update_mask: nil, federation: nil, request_id: nil)
            #   Pass arguments to `update_federation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. A field mask used to specify the fields to be overwritten in the
            #     metastore federation resource by the update.
            #     Fields specified in the `update_mask` are relative to the resource (not
            #     to the full request). A field is overwritten if it is in the mask.
            #   @param federation [::Google::Cloud::Metastore::V1beta::Federation, ::Hash]
            #     Required. The metastore federation to update. The server only merges fields
            #     in the service if they are specified in `update_mask`.
            #
            #     The metastore federation's `name` field is used to identify the
            #     metastore service to be updated.
            #   @param request_id [::String]
            #     Optional. A request ID. Specify a unique request ID to allow the server to
            #     ignore the request if it has completed. The server will ignore subsequent
            #     requests that provide a duplicate request ID for at least 60 minutes after
            #     the first request.
            #
            #     For example, if an initial request times out, followed by another request
            #     with the same request ID, the server ignores the second request to prevent
            #     the creation of duplicate commitments.
            #
            #     The request ID must be a valid
            #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
            #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/metastore/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Metastore::V1beta::UpdateFederationRequest.new
            #
            #   # Call the update_federation method.
            #   result = client.update_federation request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_federation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1beta::UpdateFederationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_federation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Metastore::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.federation&.name
                header_params["federation.name"] = request.federation.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_federation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_federation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataproc_metastore_federation_stub.call_rpc :update_federation, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single federation.
            #
            # @overload delete_federation(request, options = nil)
            #   Pass arguments to `delete_federation` via a request object, either of type
            #   {::Google::Cloud::Metastore::V1beta::DeleteFederationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Metastore::V1beta::DeleteFederationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_federation(name: nil, request_id: nil)
            #   Pass arguments to `delete_federation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The relative resource name of the metastore federation to delete,
            #     in the following form:
            #
            #     `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
            #   @param request_id [::String]
            #     Optional. A request ID. Specify a unique request ID to allow the server to
            #     ignore the request if it has completed. The server will ignore subsequent
            #     requests that provide a duplicate request ID for at least 60 minutes after
            #     the first request.
            #
            #     For example, if an initial request times out, followed by another request
            #     with the same request ID, the server ignores the second request to prevent
            #     the creation of duplicate commitments.
            #
            #     The request ID must be a valid
            #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
            #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/metastore/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Metastore::V1beta::DeleteFederationRequest.new
            #
            #   # Call the delete_federation method.
            #   result = client.delete_federation request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_federation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1beta::DeleteFederationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_federation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Metastore::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_federation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_federation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataproc_metastore_federation_stub.call_rpc :delete_federation, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DataprocMetastoreFederation API.
            #
            # This class represents the configuration for DataprocMetastoreFederation,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_federations to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_federations.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_federations.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Metastore::V1beta::DataprocMetastoreFederation::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "metastore.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DataprocMetastoreFederation API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_federations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_federations
                ##
                # RPC-specific configuration for `get_federation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_federation
                ##
                # RPC-specific configuration for `create_federation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_federation
                ##
                # RPC-specific configuration for `update_federation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_federation
                ##
                # RPC-specific configuration for `delete_federation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_federation

                # @private
                def initialize parent_rpcs = nil
                  list_federations_config = parent_rpcs.list_federations if parent_rpcs.respond_to? :list_federations
                  @list_federations = ::Gapic::Config::Method.new list_federations_config
                  get_federation_config = parent_rpcs.get_federation if parent_rpcs.respond_to? :get_federation
                  @get_federation = ::Gapic::Config::Method.new get_federation_config
                  create_federation_config = parent_rpcs.create_federation if parent_rpcs.respond_to? :create_federation
                  @create_federation = ::Gapic::Config::Method.new create_federation_config
                  update_federation_config = parent_rpcs.update_federation if parent_rpcs.respond_to? :update_federation
                  @update_federation = ::Gapic::Config::Method.new update_federation_config
                  delete_federation_config = parent_rpcs.delete_federation if parent_rpcs.respond_to? :delete_federation
                  @delete_federation = ::Gapic::Config::Method.new delete_federation_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
