# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Metastore
      module V1
        # A managed metastore service that serves metadata queries.
        # @!attribute [rw] hive_metastore_config
        #   @return [::Google::Cloud::Metastore::V1::HiveMetastoreConfig]
        #     Configuration information specific to running Hive metastore
        #     software as the metastore service.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The relative resource name of the metastore service, in the
        #     following format:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the metastore service was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the metastore service was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels for the metastore service.
        # @!attribute [rw] network
        #   @return [::String]
        #     Immutable. The relative resource name of the VPC network on which the
        #     instance can be accessed. It is specified in the following form:
        #
        #     `projects/{project_number}/global/networks/{network_id}`.
        # @!attribute [r] endpoint_uri
        #   @return [::String]
        #     Output only. The URI of the endpoint used to access the metastore service.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     The TCP port at which the metastore service is reached. Default: 9083.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Metastore::V1::Service::State]
        #     Output only. The current state of the metastore service.
        # @!attribute [r] state_message
        #   @return [::String]
        #     Output only. Additional information about the current state of the
        #     metastore service, if available.
        # @!attribute [r] artifact_gcs_uri
        #   @return [::String]
        #     Output only. A Cloud Storage URI (starting with `gs://`) that specifies
        #     where artifacts related to the metastore service are stored.
        # @!attribute [rw] tier
        #   @return [::Google::Cloud::Metastore::V1::Service::Tier]
        #     The tier of the service.
        # @!attribute [rw] maintenance_window
        #   @return [::Google::Cloud::Metastore::V1::MaintenanceWindow]
        #     The one hour maintenance window of the metastore service. This specifies
        #     when the service can be restarted for maintenance purposes in UTC time.
        #     Maintenance window is not needed for services with the SPANNER
        #     database type.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The globally unique resource identifier of the metastore
        #     service.
        # @!attribute [r] metadata_management_activity
        #   @return [::Google::Cloud::Metastore::V1::MetadataManagementActivity]
        #     Output only. The metadata management activities of the metastore service.
        # @!attribute [rw] release_channel
        #   @return [::Google::Cloud::Metastore::V1::Service::ReleaseChannel]
        #     Immutable. The release channel of the service.
        #     If unspecified, defaults to `STABLE`.
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::Metastore::V1::EncryptionConfig]
        #     Immutable. Information used to configure the Dataproc Metastore service to
        #     encrypt customer data at rest. Cannot be updated.
        # @!attribute [rw] network_config
        #   @return [::Google::Cloud::Metastore::V1::NetworkConfig]
        #     The configuration specifying the network settings for the
        #     Dataproc Metastore service.
        # @!attribute [rw] database_type
        #   @return [::Google::Cloud::Metastore::V1::Service::DatabaseType]
        #     Immutable. The database type that the Metastore service stores its data.
        # @!attribute [rw] telemetry_config
        #   @return [::Google::Cloud::Metastore::V1::TelemetryConfig]
        #     The configuration specifying telemetry settings for the Dataproc Metastore
        #     service. If unspecified defaults to `JSON`.
        # @!attribute [rw] scaling_config
        #   @return [::Google::Cloud::Metastore::V1::ScalingConfig]
        #     Scaling configuration of the metastore service.
        class Service
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The current state of the metastore service.
          module State
            # The state of the metastore service is unknown.
            STATE_UNSPECIFIED = 0

            # The metastore service is in the process of being created.
            CREATING = 1

            # The metastore service is running and ready to serve queries.
            ACTIVE = 2

            # The metastore service is entering suspension. Its query-serving
            # availability may cease unexpectedly.
            SUSPENDING = 3

            # The metastore service is suspended and unable to serve queries.
            SUSPENDED = 4

            # The metastore service is being updated. It remains usable but cannot
            # accept additional update requests or be deleted at this time.
            UPDATING = 5

            # The metastore service is undergoing deletion. It cannot be used.
            DELETING = 6

            # The metastore service has encountered an error and cannot be used. The
            # metastore service should be deleted.
            ERROR = 7
          end

          # Available service tiers.
          module Tier
            # The tier is not set.
            TIER_UNSPECIFIED = 0

            # The developer tier provides limited scalability and no fault tolerance.
            # Good for low-cost proof-of-concept.
            DEVELOPER = 1

            # The enterprise tier provides multi-zone high availability, and sufficient
            # scalability for enterprise-level Dataproc Metastore workloads.
            ENTERPRISE = 3
          end

          # Release channels bundle features of varying levels of stability. Newer
          # features may be introduced initially into less stable release channels and
          # can be automatically promoted into more stable release channels.
          module ReleaseChannel
            # Release channel is not specified.
            RELEASE_CHANNEL_UNSPECIFIED = 0

            # The `CANARY` release channel contains the newest features, which may be
            # unstable and subject to unresolved issues with no known workarounds.
            # Services using the `CANARY` release channel are not subject to any SLAs.
            CANARY = 1

            # The `STABLE` release channel contains features that are considered stable
            # and have been validated for production use.
            STABLE = 2
          end

          # The backend database type for the metastore service.
          module DatabaseType
            # The DATABASE_TYPE is not set.
            DATABASE_TYPE_UNSPECIFIED = 0

            # MySQL is used to persist the metastore data.
            MYSQL = 1

            # Spanner is used to persist the metastore data.
            SPANNER = 2
          end
        end

        # Maintenance window. This specifies when Dataproc Metastore
        # may perform system maintenance operation to the service.
        # @!attribute [rw] hour_of_day
        #   @return [::Google::Protobuf::Int32Value]
        #     The hour of day (0-23) when the window starts.
        # @!attribute [rw] day_of_week
        #   @return [::Google::Type::DayOfWeek]
        #     The day of week, when the window starts.
        class MaintenanceWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies configuration information specific to running Hive metastore
        # software as the metastore service.
        # @!attribute [rw] version
        #   @return [::String]
        #     Immutable. The Hive metastore schema version.
        # @!attribute [rw] config_overrides
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A mapping of Hive metastore configuration key-value pairs to apply to the
        #     Hive metastore (configured in `hive-site.xml`). The mappings
        #     override system defaults (some keys cannot be overridden). These
        #     overrides are also applied to auxiliary versions and can be further
        #     customized in the auxiliary version's `AuxiliaryVersionConfig`.
        # @!attribute [rw] kerberos_config
        #   @return [::Google::Cloud::Metastore::V1::KerberosConfig]
        #     Information used to configure the Hive metastore service as a service
        #     principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
        #     method and specify this field's path
        #     (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
        #     while omitting this field from the request's `service`.
        # @!attribute [rw] endpoint_protocol
        #   @return [::Google::Cloud::Metastore::V1::HiveMetastoreConfig::EndpointProtocol]
        #     The protocol to use for the metastore service endpoint. If unspecified,
        #     defaults to `THRIFT`.
        # @!attribute [rw] auxiliary_versions
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Metastore::V1::AuxiliaryVersionConfig}]
        #     A mapping of Hive metastore version to the auxiliary version
        #     configuration. When specified, a secondary Hive metastore service is
        #     created along with the primary service. All auxiliary versions must be less
        #     than the service's primary version. The key is the auxiliary service name
        #     and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
        #     means that the first character must be a lowercase letter, and all the
        #     following characters must be hyphens, lowercase letters, or digits, except
        #     the last character, which cannot be a hyphen.
        class HiveMetastoreConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ConfigOverridesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Metastore::V1::AuxiliaryVersionConfig]
          class AuxiliaryVersionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Protocols available for serving the metastore service endpoint.
          module EndpointProtocol
            # The protocol is not set.
            ENDPOINT_PROTOCOL_UNSPECIFIED = 0

            # Use the legacy Apache Thrift protocol for the metastore service endpoint.
            THRIFT = 1

            # Use the modernized gRPC protocol for the metastore service endpoint.
            GRPC = 2
          end
        end

        # Configuration information for a Kerberos principal.
        # @!attribute [rw] keytab
        #   @return [::Google::Cloud::Metastore::V1::Secret]
        #     A Kerberos keytab file that can be used to authenticate a service principal
        #     with a Kerberos Key Distribution Center (KDC).
        # @!attribute [rw] principal
        #   @return [::String]
        #     A Kerberos principal that exists in the both the keytab the KDC
        #     to authenticate as. A typical principal is of the form
        #     `primary/instance@REALM`, but there is no exact format.
        # @!attribute [rw] krb5_config_gcs_uri
        #   @return [::String]
        #     A Cloud Storage URI that specifies the path to a
        #     krb5.conf file. It is of the form `gs://{bucket_name}/path/to/krb5.conf`,
        #     although the file does not need to be named krb5.conf explicitly.
        class KerberosConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A securely stored value.
        # @!attribute [rw] cloud_secret
        #   @return [::String]
        #     The relative resource name of a Secret Manager secret version, in the
        #     following form:
        #
        #     `projects/{project_number}/secrets/{secret_id}/versions/{version_id}`.
        class Secret
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Encryption settings for the service.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     The fully qualified customer provided Cloud KMS key name to use for
        #     customer data encryption, in the following form:
        #
        #     `projects/{project_number}/locations/{location_id}/keyRings/{key_ring_id}/cryptoKeys/{crypto_key_id}`.
        class EncryptionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration information for the auxiliary service versions.
        # @!attribute [rw] version
        #   @return [::String]
        #     The Hive metastore version of the auxiliary service. It must be less
        #     than the primary Hive metastore service's version.
        # @!attribute [rw] config_overrides
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A mapping of Hive metastore configuration key-value pairs to apply to the
        #     auxiliary Hive metastore (configured in `hive-site.xml`) in addition to
        #     the primary version's overrides. If keys are present in both the auxiliary
        #     version's overrides and the primary version's overrides, the value from
        #     the auxiliary version's overrides takes precedence.
        # @!attribute [r] network_config
        #   @return [::Google::Cloud::Metastore::V1::NetworkConfig]
        #     Output only. The network configuration contains the endpoint URI(s) of the
        #     auxiliary Hive metastore service.
        class AuxiliaryVersionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ConfigOverridesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Network configuration for the Dataproc Metastore service.
        #
        # Next available ID: 4
        # @!attribute [rw] consumers
        #   @return [::Array<::Google::Cloud::Metastore::V1::NetworkConfig::Consumer>]
        #     Immutable. The consumer-side network configuration for the Dataproc
        #     Metastore instance.
        class NetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains information of the customer's network configurations.
          #
          # Next available ID: 5
          # @!attribute [rw] subnetwork
          #   @return [::String]
          #     Immutable. The subnetwork of the customer project from which an IP
          #     address is reserved and used as the Dataproc Metastore service's
          #     endpoint. It is accessible to hosts in the subnet and to all
          #     hosts in a subnet in the same region and same network. There must
          #     be at least one IP address available in the subnet's primary range. The
          #     subnet is specified in the following form:
          #
          #     `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
          # @!attribute [r] endpoint_uri
          #   @return [::String]
          #     Output only. The URI of the endpoint used to access the metastore
          #     service.
          # @!attribute [r] endpoint_location
          #   @return [::String]
          #     Output only. The location of the endpoint URI. Format:
          #     `projects/{project}/locations/{location}`.
          class Consumer
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Telemetry Configuration for the Dataproc Metastore service.
        # @!attribute [rw] log_format
        #   @return [::Google::Cloud::Metastore::V1::TelemetryConfig::LogFormat]
        #     The output format of the Dataproc Metastore service's logs.
        class TelemetryConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          module LogFormat
            # The LOG_FORMAT is not set.
            LOG_FORMAT_UNSPECIFIED = 0

            # Logging output uses the legacy `textPayload` format.
            LEGACY = 1

            # Logging output uses the `jsonPayload` format.
            JSON = 2
          end
        end

        # The metadata management activities of the metastore service.
        # @!attribute [r] metadata_exports
        #   @return [::Array<::Google::Cloud::Metastore::V1::MetadataExport>]
        #     Output only. The latest metadata exports of the metastore service.
        # @!attribute [r] restores
        #   @return [::Array<::Google::Cloud::Metastore::V1::Restore>]
        #     Output only. The latest restores of the metastore service.
        class MetadataManagementActivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A metastore resource that imports metadata.
        # @!attribute [rw] database_dump
        #   @return [::Google::Cloud::Metastore::V1::MetadataImport::DatabaseDump]
        #     Immutable. A database dump from a pre-existing metastore's database.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The relative resource name of the metadata import, of the form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{metadata_import_id}`.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the metadata import.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the metadata import was started.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the metadata import was last updated.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the metadata import finished.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Metastore::V1::MetadataImport::State]
        #     Output only. The current state of the metadata import.
        class MetadataImport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A specification of the location of and metadata about a database dump from
          # a relational database management system.
          # @!attribute [rw] database_type
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::Metastore::V1::MetadataImport::DatabaseDump::DatabaseType]
          #     The type of the database.
          # @!attribute [rw] gcs_uri
          #   @return [::String]
          #     A Cloud Storage object or folder URI that specifies the source from which
          #     to import metadata. It must begin with `gs://`.
          # @!attribute [rw] source_database
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     The name of the source database.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Metastore::V1::DatabaseDumpSpec::Type]
          #     Optional. The type of the database dump. If unspecified, defaults to
          #     `MYSQL`.
          class DatabaseDump
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the database.
            module DatabaseType
              # The type of the source database is unknown.
              DATABASE_TYPE_UNSPECIFIED = 0

              # The type of the source database is MySQL.
              MYSQL = 1
            end
          end

          # The current state of the metadata import.
          module State
            # The state of the metadata import is unknown.
            STATE_UNSPECIFIED = 0

            # The metadata import is running.
            RUNNING = 1

            # The metadata import completed successfully.
            SUCCEEDED = 2

            # The metadata import is being updated.
            UPDATING = 3

            # The metadata import failed, and attempted metadata changes were rolled
            # back.
            FAILED = 4
          end
        end

        # The details of a metadata export operation.
        # @!attribute [r] destination_gcs_uri
        #   @return [::String]
        #     Output only. A Cloud Storage URI of a folder that metadata are exported
        #     to, in the form of
        #     `gs://<bucket_name>/<path_inside_bucket>/<export_folder>`, where
        #     `<export_folder>` is automatically generated.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the export started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the export ended.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Metastore::V1::MetadataExport::State]
        #     Output only. The current state of the export.
        # @!attribute [r] database_dump_type
        #   @return [::Google::Cloud::Metastore::V1::DatabaseDumpSpec::Type]
        #     Output only. The type of the database dump.
        class MetadataExport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The current state of the metadata export.
          module State
            # The state of the metadata export is unknown.
            STATE_UNSPECIFIED = 0

            # The metadata export is running.
            RUNNING = 1

            # The metadata export completed successfully.
            SUCCEEDED = 2

            # The metadata export failed.
            FAILED = 3

            # The metadata export is cancelled.
            CANCELLED = 4
          end
        end

        # The details of a backup resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The relative resource name of the backup, in the following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the backup was started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the backup finished creating.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Metastore::V1::Backup::State]
        #     Output only. The current state of the backup.
        # @!attribute [r] service_revision
        #   @return [::Google::Cloud::Metastore::V1::Service]
        #     Output only. The revision of the service at the time of backup.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the backup.
        # @!attribute [r] restoring_services
        #   @return [::Array<::String>]
        #     Output only. Services that are restoring from the backup.
        class Backup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The current state of the backup.
          module State
            # The state of the backup is unknown.
            STATE_UNSPECIFIED = 0

            # The backup is being created.
            CREATING = 1

            # The backup is being deleted.
            DELETING = 2

            # The backup is active and ready to use.
            ACTIVE = 3

            # The backup failed.
            FAILED = 4

            # The backup is being restored.
            RESTORING = 5
          end
        end

        # The details of a metadata restore operation.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the restore started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the restore ended.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Metastore::V1::Restore::State]
        #     Output only. The current state of the restore.
        # @!attribute [r] backup
        #   @return [::String]
        #     Output only. The relative resource name of the metastore service backup to
        #     restore from, in the following form:
        #
        #     `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
        # @!attribute [r] type
        #   @return [::Google::Cloud::Metastore::V1::Restore::RestoreType]
        #     Output only. The type of restore.
        # @!attribute [r] details
        #   @return [::String]
        #     Output only. The restore details containing the revision of the service to
        #     be restored to, in format of JSON.
        class Restore
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The current state of the restore.
          module State
            # The state of the metadata restore is unknown.
            STATE_UNSPECIFIED = 0

            # The metadata restore is running.
            RUNNING = 1

            # The metadata restore completed successfully.
            SUCCEEDED = 2

            # The metadata restore failed.
            FAILED = 3

            # The metadata restore is cancelled.
            CANCELLED = 4
          end

          # The type of restore. If unspecified, defaults to `METADATA_ONLY`.
          module RestoreType
            # The restore type is unknown.
            RESTORE_TYPE_UNSPECIFIED = 0

            # The service's metadata and configuration are restored.
            FULL = 1

            # Only the service's metadata is restored.
            METADATA_ONLY = 2
          end
        end

        # Represents the scaling configuration of a metastore service.
        # @!attribute [rw] instance_size
        #   @return [::Google::Cloud::Metastore::V1::ScalingConfig::InstanceSize]
        #     An enum of readable instance sizes, with each instance size mapping to a
        #     float value (e.g. InstanceSize.EXTRA_SMALL = scaling_factor(0.1))
        #
        #     Note: The following fields are mutually exclusive: `instance_size`, `scaling_factor`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] scaling_factor
        #   @return [::Float]
        #     Scaling factor, increments of 0.1 for values less than 1.0, and
        #     increments of 1.0 for values greater than 1.0.
        #
        #     Note: The following fields are mutually exclusive: `scaling_factor`, `instance_size`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ScalingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metastore instance sizes.
          module InstanceSize
            # Unspecified instance size
            INSTANCE_SIZE_UNSPECIFIED = 0

            # Extra small instance size, maps to a scaling factor of 0.1.
            EXTRA_SMALL = 1

            # Small instance size, maps to a scaling factor of 0.5.
            SMALL = 2

            # Medium instance size, maps to a scaling factor of 1.0.
            MEDIUM = 3

            # Large instance size, maps to a scaling factor of 3.0.
            LARGE = 4

            # Extra large instance size, maps to a scaling factor of 6.0.
            EXTRA_LARGE = 5
          end
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_services DataprocMetastore.ListServices}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative resource name of the location of metastore services
        #     to list, in the following form:
        #
        #     `projects/{project_number}/locations/{location_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of services to return. The response may
        #     contain less than the maximum number. If unspecified, no more than 500
        #     services are returned. The maximum value is 1000; values above 1000 are
        #     changed to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_services DataprocMetastore.ListServices}
        #     call. Provide this token to retrieve the subsequent page.
        #
        #     To retrieve the first page, supply an empty page token.
        #
        #     When paginating, other parameters provided to
        #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_services DataprocMetastore.ListServices}
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter to apply to list results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Specify the ordering of results as described in [Sorting
        #     Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
        #     If not specified, the results will be sorted in the default order.
        class ListServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_services DataprocMetastore.ListServices}.
        # @!attribute [rw] services
        #   @return [::Array<::Google::Cloud::Metastore::V1::Service>]
        #     The services in the specified location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page. If this
        #     field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#get_service DataprocMetastore.GetService}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The relative resource name of the metastore service to retrieve,
        #     in the following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}`.
        class GetServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#create_service DataprocMetastore.CreateService}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative resource name of the location in which to create a
        #     metastore service, in the following form:
        #
        #     `projects/{project_number}/locations/{location_id}`.
        # @!attribute [rw] service_id
        #   @return [::String]
        #     Required. The ID of the metastore service, which is used as the final
        #     component of the metastore service's name.
        #
        #     This value must be between 2 and 63 characters long inclusive, begin with a
        #     letter, end with a letter or number, and consist of alpha-numeric
        #     ASCII characters or hyphens.
        # @!attribute [rw] service
        #   @return [::Google::Cloud::Metastore::V1::Service]
        #     Required. The Metastore service to create. The `name` field is
        #     ignored. The ID of the created metastore service must be provided in
        #     the request's `service_id` field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID. Specify a unique request ID to allow the server to
        #     ignore the request if it has completed. The server will ignore subsequent
        #     requests that provide a duplicate request ID for at least 60 minutes after
        #     the first request.
        #
        #     For example, if an initial request times out, followed by another request
        #     with the same request ID, the server ignores the second request to prevent
        #     the creation of duplicate commitments.
        #
        #     The request ID must be a valid
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
        #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
        class CreateServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#update_service DataprocMetastore.UpdateService}.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. A field mask used to specify the fields to be overwritten in the
        #     metastore service resource by the update.
        #     Fields specified in the `update_mask` are relative to the resource (not
        #     to the full request). A field is overwritten if it is in the mask.
        # @!attribute [rw] service
        #   @return [::Google::Cloud::Metastore::V1::Service]
        #     Required. The metastore service to update. The server only merges fields
        #     in the service if they are specified in `update_mask`.
        #
        #     The metastore service's `name` field is used to identify the metastore
        #     service to be updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID. Specify a unique request ID to allow the server to
        #     ignore the request if it has completed. The server will ignore subsequent
        #     requests that provide a duplicate request ID for at least 60 minutes after
        #     the first request.
        #
        #     For example, if an initial request times out, followed by another request
        #     with the same request ID, the server ignores the second request to prevent
        #     the creation of duplicate commitments.
        #
        #     The request ID must be a valid
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
        #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
        class UpdateServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#delete_service DataprocMetastore.DeleteService}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The relative resource name of the metastore service to delete, in
        #     the following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID. Specify a unique request ID to allow the server to
        #     ignore the request if it has completed. The server will ignore subsequent
        #     requests that provide a duplicate request ID for at least 60 minutes after
        #     the first request.
        #
        #     For example, if an initial request times out, followed by another request
        #     with the same request ID, the server ignores the second request to prevent
        #     the creation of duplicate commitments.
        #
        #     The request ID must be a valid
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
        #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
        class DeleteServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_metadata_imports DataprocMetastore.ListMetadataImports}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative resource name of the service whose metadata imports
        #     to list, in the following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of imports to return. The response may contain
        #     less than the maximum number. If unspecified, no more than 500 imports are
        #     returned. The maximum value is 1000; values above 1000 are changed to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_services DataprocMetastore.ListServices}
        #     call. Provide this token to retrieve the subsequent page.
        #
        #     To retrieve the first page, supply an empty page token.
        #
        #     When paginating, other parameters provided to
        #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_services DataprocMetastore.ListServices}
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter to apply to list results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Specify the ordering of results as described in [Sorting
        #     Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
        #     If not specified, the results will be sorted in the default order.
        class ListMetadataImportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_metadata_imports DataprocMetastore.ListMetadataImports}.
        # @!attribute [rw] metadata_imports
        #   @return [::Array<::Google::Cloud::Metastore::V1::MetadataImport>]
        #     The imports in the specified service.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page. If this
        #     field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListMetadataImportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#get_metadata_import DataprocMetastore.GetMetadataImport}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The relative resource name of the metadata import to retrieve, in
        #     the following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{import_id}`.
        class GetMetadataImportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#create_metadata_import DataprocMetastore.CreateMetadataImport}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative resource name of the service in which to create a
        #     metastore import, in the following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}`.
        # @!attribute [rw] metadata_import_id
        #   @return [::String]
        #     Required. The ID of the metadata import, which is used as the final
        #     component of the metadata import's name.
        #
        #     This value must be between 1 and 64 characters long, begin with a letter,
        #     end with a letter or number, and consist of alpha-numeric ASCII characters
        #     or hyphens.
        # @!attribute [rw] metadata_import
        #   @return [::Google::Cloud::Metastore::V1::MetadataImport]
        #     Required. The metadata import to create. The `name` field is ignored. The
        #     ID of the created metadata import must be provided in the request's
        #     `metadata_import_id` field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID. Specify a unique request ID to allow the server to
        #     ignore the request if it has completed. The server will ignore subsequent
        #     requests that provide a duplicate request ID for at least 60 minutes after
        #     the first request.
        #
        #     For example, if an initial request times out, followed by another request
        #     with the same request ID, the server ignores the second request to prevent
        #     the creation of duplicate commitments.
        #
        #     The request ID must be a valid
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
        #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
        class CreateMetadataImportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#update_metadata_import DataprocMetastore.UpdateMetadataImport}.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. A field mask used to specify the fields to be overwritten in the
        #     metadata import resource by the update.
        #     Fields specified in the `update_mask` are relative to the resource (not
        #     to the full request). A field is overwritten if it is in the mask.
        # @!attribute [rw] metadata_import
        #   @return [::Google::Cloud::Metastore::V1::MetadataImport]
        #     Required. The metadata import to update. The server only merges fields
        #     in the import if they are specified in `update_mask`.
        #
        #     The metadata import's `name` field is used to identify the metastore
        #     import to be updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID. Specify a unique request ID to allow the server to
        #     ignore the request if it has completed. The server will ignore subsequent
        #     requests that provide a duplicate request ID for at least 60 minutes after
        #     the first request.
        #
        #     For example, if an initial request times out, followed by another request
        #     with the same request ID, the server ignores the second request to prevent
        #     the creation of duplicate commitments.
        #
        #     The request ID must be a valid
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
        #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
        class UpdateMetadataImportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_backups DataprocMetastore.ListBackups}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative resource name of the service whose backups to
        #     list, in the following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}/backups`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of backups to return. The response may contain
        #     less than the maximum number. If unspecified, no more than 500 backups are
        #     returned. The maximum value is 1000; values above 1000 are changed to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_backups DataprocMetastore.ListBackups}
        #     call. Provide this token to retrieve the subsequent page.
        #
        #     To retrieve the first page, supply an empty page token.
        #
        #     When paginating, other parameters provided to
        #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_backups DataprocMetastore.ListBackups}
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter to apply to list results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Specify the ordering of results as described in [Sorting
        #     Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
        #     If not specified, the results will be sorted in the default order.
        class ListBackupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#list_backups DataprocMetastore.ListBackups}.
        # @!attribute [rw] backups
        #   @return [::Array<::Google::Cloud::Metastore::V1::Backup>]
        #     The backups of the specified service.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page. If this
        #     field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#get_backup DataprocMetastore.GetBackup}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The relative resource name of the backup to retrieve, in the
        #     following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
        class GetBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#create_backup DataprocMetastore.CreateBackup}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The relative resource name of the service in which to create a
        #     backup of the following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}`.
        # @!attribute [rw] backup_id
        #   @return [::String]
        #     Required. The ID of the backup, which is used as the final component of the
        #     backup's name.
        #
        #     This value must be between 1 and 64 characters long, begin with a letter,
        #     end with a letter or number, and consist of alpha-numeric ASCII characters
        #     or hyphens.
        # @!attribute [rw] backup
        #   @return [::Google::Cloud::Metastore::V1::Backup]
        #     Required. The backup to create. The `name` field is ignored. The ID of the
        #     created backup must be provided in the request's `backup_id` field.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID. Specify a unique request ID to allow the server to
        #     ignore the request if it has completed. The server will ignore subsequent
        #     requests that provide a duplicate request ID for at least 60 minutes after
        #     the first request.
        #
        #     For example, if an initial request times out, followed by another request
        #     with the same request ID, the server ignores the second request to prevent
        #     the creation of duplicate commitments.
        #
        #     The request ID must be a valid
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
        #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
        class CreateBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#delete_backup DataprocMetastore.DeleteBackup}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The relative resource name of the backup to delete, in the
        #     following form:
        #
        #     `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID. Specify a unique request ID to allow the server to
        #     ignore the request if it has completed. The server will ignore subsequent
        #     requests that provide a duplicate request ID for at least 60 minutes after
        #     the first request.
        #
        #     For example, if an initial request times out, followed by another request
        #     with the same request ID, the server ignores the second request to prevent
        #     the creation of duplicate commitments.
        #
        #     The request ID must be a valid
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
        #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
        class DeleteBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#export_metadata DataprocMetastore.ExportMetadata}.
        # @!attribute [rw] destination_gcs_folder
        #   @return [::String]
        #     A Cloud Storage URI of a folder, in the format
        #     `gs://<bucket_name>/<path_inside_bucket>`. A sub-folder
        #     `<export_folder>` containing exported files will be created below it.
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. The relative resource name of the metastore service to run
        #     export, in the following form:
        #
        #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID. Specify a unique request ID to allow the server to
        #     ignore the request if it has completed. The server will ignore subsequent
        #     requests that provide a duplicate request ID for at least 60 minutes after
        #     the first request.
        #
        #     For example, if an initial request times out, followed by another request
        #     with the same request ID, the server ignores the second request to prevent
        #     the creation of duplicate commitments.
        #
        #     The request ID must be a valid
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
        #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
        # @!attribute [rw] database_dump_type
        #   @return [::Google::Cloud::Metastore::V1::DatabaseDumpSpec::Type]
        #     Optional. The type of the database dump. If unspecified, defaults to
        #     `MYSQL`.
        class ExportMetadataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [DataprocMetastore.Restore][].
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. The relative resource name of the metastore service to run
        #     restore, in the following form:
        #
        #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
        # @!attribute [rw] backup
        #   @return [::String]
        #     Required. The relative resource name of the metastore service backup to
        #     restore from, in the following form:
        #
        #     `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
        # @!attribute [rw] restore_type
        #   @return [::Google::Cloud::Metastore::V1::Restore::RestoreType]
        #     Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID. Specify a unique request ID to allow the server to
        #     ignore the request if it has completed. The server will ignore subsequent
        #     requests that provide a duplicate request ID for at least 60 minutes after
        #     the first request.
        #
        #     For example, if an initial request times out, followed by another request
        #     with the same request ID, the server ignores the second request to prevent
        #     the creation of duplicate commitments.
        #
        #     The request ID must be a valid
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
        #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
        class RestoreServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of a long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the caller has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about the service in a location.
        # @!attribute [rw] supported_hive_metastore_versions
        #   @return [::Array<::Google::Cloud::Metastore::V1::LocationMetadata::HiveMetastoreVersion>]
        #     The versions of Hive Metastore that can be used when creating a new
        #     metastore service in this location. The server guarantees that exactly one
        #     `HiveMetastoreVersion` in the list will set `is_default`.
        class LocationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A specification of a supported version of the Hive Metastore software.
          # @!attribute [rw] version
          #   @return [::String]
          #     The semantic version of the Hive Metastore software.
          # @!attribute [rw] is_default
          #   @return [::Boolean]
          #     Whether `version` will be chosen by the server if a metastore service is
          #     created with a `HiveMetastoreConfig` that omits the `version`.
          class HiveMetastoreVersion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The specification of database dump to import from or export to.
        class DatabaseDumpSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the database dump.
          module Type
            # The type of the database dump is unknown.
            TYPE_UNSPECIFIED = 0

            # Database dump is a MySQL dump file.
            MYSQL = 1

            # Database dump contains Avro files.
            AVRO = 2
          end
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#query_metadata DataprocMetastore.QueryMetadata}.
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. The relative resource name of the metastore service to query
        #     metadata, in the following format:
        #
        #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. A read-only SQL query to execute against the metadata database.
        #     The query cannot change or mutate the data.
        class QueryMetadataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#query_metadata DataprocMetastore.QueryMetadata}.
        # @!attribute [rw] result_manifest_uri
        #   @return [::String]
        #     The manifest URI  is link to a JSON instance in Cloud Storage.
        #     This instance manifests immediately along with QueryMetadataResponse. The
        #     content of the URI is not retriable until the long-running operation query
        #     against the metadata finishes.
        class QueryMetadataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Error details in public error message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#query_metadata DataprocMetastore.QueryMetadata}.
        # @!attribute [rw] details
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Additional structured details about this error.
        #
        #     Keys define the failure items.
        #     Value describes the exception or details of the item.
        class ErrorDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DetailsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#move_table_to_database DataprocMetastore.MoveTableToDatabase}.
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. The relative resource name of the metastore service to mutate
        #     metadata, in the following format:
        #
        #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
        # @!attribute [rw] table_name
        #   @return [::String]
        #     Required. The name of the table to be moved.
        # @!attribute [rw] db_name
        #   @return [::String]
        #     Required. The name of the database where the table resides.
        # @!attribute [rw] destination_db_name
        #   @return [::String]
        #     Required. The name of the database where the table should be moved.
        class MoveTableToDatabaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#move_table_to_database DataprocMetastore.MoveTableToDatabase}.
        class MoveTableToDatabaseResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#alter_metadata_resource_location DataprocMetastore.AlterMetadataResourceLocation}.
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. The relative resource name of the metastore service to mutate
        #     metadata, in the following format:
        #
        #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
        # @!attribute [rw] resource_name
        #   @return [::String]
        #     Required. The relative metadata resource name in the following format.
        #
        #     `databases/{database_id}`
        #     or
        #     `databases/{database_id}/tables/{table_id}`
        #     or
        #     `databases/{database_id}/tables/{table_id}/partitions/{partition_id}`
        # @!attribute [rw] location_uri
        #   @return [::String]
        #     Required. The new location URI for the metadata resource.
        class AlterMetadataResourceLocationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Metastore::V1::DataprocMetastore::Client#alter_metadata_resource_location DataprocMetastore.AlterMetadataResourceLocation}.
        class AlterMetadataResourceLocationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
