# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/metastore/v1/metastore_pb"
require "google/cloud/metastore/v1/dataproc_metastore/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Metastore
      module V1
        module DataprocMetastore
          module Rest
            ##
            # REST client for the DataprocMetastore service.
            #
            # Configures and manages metastore services.
            # Metastore services are fully managed, highly available, autoscaled,
            # autohealing, OSS-native deployments of technical metadata management
            # software. Each metastore service exposes a network endpoint through which
            # metadata queries are served. Metadata queries can originate from a variety
            # of sources, including Apache Hive, Apache Presto, and Apache Spark.
            #
            # The Dataproc Metastore API defines the following resource model:
            #
            # * The service works with a collection of Google Cloud projects, named:
            # `/projects/*`
            # * Each project has a collection of available locations, named: `/locations/*`
            #   (a location must refer to a Google Cloud `region`)
            # * Each location has a collection of services, named: `/services/*`
            # * Dataproc Metastore services are resources with names of the form:
            #
            #   `/projects/{project_number}/locations/{location_id}/services/{service_id}`.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "metastore.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :dataproc_metastore_stub

              ##
              # Configure the DataprocMetastore Client class.
              #
              # See {::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DataprocMetastore clients
              #   ::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Metastore", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_service.timeout = 60.0

                  default_config.rpcs.update_service.timeout = 60.0

                  default_config.rpcs.delete_service.timeout = 60.0

                  default_config.rpcs.create_metadata_import.timeout = 60.0

                  default_config.rpcs.update_metadata_import.timeout = 60.0

                  default_config.rpcs.export_metadata.timeout = 60.0

                  default_config.rpcs.restore_service.timeout = 60.0

                  default_config.rpcs.create_backup.timeout = 60.0

                  default_config.rpcs.delete_backup.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DataprocMetastore Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @dataproc_metastore_stub.universe_domain
              end

              ##
              # Create a new DataprocMetastore REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DataprocMetastore client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @dataproc_metastore_stub = ::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @dataproc_metastore_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @dataproc_metastore_stub.endpoint
                  config.universe_domain = @dataproc_metastore_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @dataproc_metastore_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @dataproc_metastore_stub.endpoint
                  config.universe_domain = @dataproc_metastore_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @dataproc_metastore_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @dataproc_metastore_stub.logger
              end

              # Service calls

              ##
              # Lists services in a project and location.
              #
              # @overload list_services(request, options = nil)
              #   Pass arguments to `list_services` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::ListServicesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::ListServicesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_services(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_services` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The relative resource name of the location of metastore services
              #     to list, in the following form:
              #
              #     `projects/{project_number}/locations/{location_id}`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of services to return. The response may
              #     contain less than the maximum number. If unspecified, no more than 500
              #     services are returned. The maximum value is 1000; values above 1000 are
              #     changed to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client#list_services DataprocMetastore.ListServices}
              #     call. Provide this token to retrieve the subsequent page.
              #
              #     To retrieve the first page, supply an empty page token.
              #
              #     When paginating, other parameters provided to
              #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client#list_services DataprocMetastore.ListServices}
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter to apply to list results.
              #   @param order_by [::String]
              #     Optional. Specify the ordering of results as described in [Sorting
              #     Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
              #     If not specified, the results will be sorted in the default order.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Metastore::V1::Service>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Metastore::V1::Service>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::ListServicesRequest.new
              #
              #   # Call the list_services method.
              #   result = client.list_services request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Metastore::V1::Service.
              #     p item
              #   end
              #
              def list_services request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::ListServicesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_services.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_services.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_services.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.list_services request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataproc_metastore_stub, :list_services, "services", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a single service.
              #
              # @overload get_service(request, options = nil)
              #   Pass arguments to `get_service` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::GetServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::GetServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_service(name: nil)
              #   Pass arguments to `get_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The relative resource name of the metastore service to retrieve,
              #     in the following form:
              #
              #     `projects/{project_number}/locations/{location_id}/services/{service_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Metastore::V1::Service]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Metastore::V1::Service]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::GetServiceRequest.new
              #
              #   # Call the get_service method.
              #   result = client.get_service request
              #
              #   # The returned object is of type Google::Cloud::Metastore::V1::Service.
              #   p result
              #
              def get_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::GetServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.get_service request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a metastore service in a project and location.
              #
              # @overload create_service(request, options = nil)
              #   Pass arguments to `create_service` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::CreateServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::CreateServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_service(parent: nil, service_id: nil, service: nil, request_id: nil)
              #   Pass arguments to `create_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The relative resource name of the location in which to create a
              #     metastore service, in the following form:
              #
              #     `projects/{project_number}/locations/{location_id}`.
              #   @param service_id [::String]
              #     Required. The ID of the metastore service, which is used as the final
              #     component of the metastore service's name.
              #
              #     This value must be between 2 and 63 characters long inclusive, begin with a
              #     letter, end with a letter or number, and consist of alpha-numeric
              #     ASCII characters or hyphens.
              #   @param service [::Google::Cloud::Metastore::V1::Service, ::Hash]
              #     Required. The Metastore service to create. The `name` field is
              #     ignored. The ID of the created metastore service must be provided in
              #     the request's `service_id` field.
              #   @param request_id [::String]
              #     Optional. A request ID. Specify a unique request ID to allow the server to
              #     ignore the request if it has completed. The server will ignore subsequent
              #     requests that provide a duplicate request ID for at least 60 minutes after
              #     the first request.
              #
              #     For example, if an initial request times out, followed by another request
              #     with the same request ID, the server ignores the second request to prevent
              #     the creation of duplicate commitments.
              #
              #     The request ID must be a valid
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
              #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::CreateServiceRequest.new
              #
              #   # Call the create_service method.
              #   result = client.create_service request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::CreateServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.create_service request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single service.
              #
              # @overload update_service(request, options = nil)
              #   Pass arguments to `update_service` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::UpdateServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::UpdateServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_service(update_mask: nil, service: nil, request_id: nil)
              #   Pass arguments to `update_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. A field mask used to specify the fields to be overwritten in the
              #     metastore service resource by the update.
              #     Fields specified in the `update_mask` are relative to the resource (not
              #     to the full request). A field is overwritten if it is in the mask.
              #   @param service [::Google::Cloud::Metastore::V1::Service, ::Hash]
              #     Required. The metastore service to update. The server only merges fields
              #     in the service if they are specified in `update_mask`.
              #
              #     The metastore service's `name` field is used to identify the metastore
              #     service to be updated.
              #   @param request_id [::String]
              #     Optional. A request ID. Specify a unique request ID to allow the server to
              #     ignore the request if it has completed. The server will ignore subsequent
              #     requests that provide a duplicate request ID for at least 60 minutes after
              #     the first request.
              #
              #     For example, if an initial request times out, followed by another request
              #     with the same request ID, the server ignores the second request to prevent
              #     the creation of duplicate commitments.
              #
              #     The request ID must be a valid
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
              #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::UpdateServiceRequest.new
              #
              #   # Call the update_service method.
              #   result = client.update_service request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::UpdateServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.update_service request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single service.
              #
              # @overload delete_service(request, options = nil)
              #   Pass arguments to `delete_service` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::DeleteServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::DeleteServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_service(name: nil, request_id: nil)
              #   Pass arguments to `delete_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The relative resource name of the metastore service to delete, in
              #     the following form:
              #
              #     `projects/{project_number}/locations/{location_id}/services/{service_id}`.
              #   @param request_id [::String]
              #     Optional. A request ID. Specify a unique request ID to allow the server to
              #     ignore the request if it has completed. The server will ignore subsequent
              #     requests that provide a duplicate request ID for at least 60 minutes after
              #     the first request.
              #
              #     For example, if an initial request times out, followed by another request
              #     with the same request ID, the server ignores the second request to prevent
              #     the creation of duplicate commitments.
              #
              #     The request ID must be a valid
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
              #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::DeleteServiceRequest.new
              #
              #   # Call the delete_service method.
              #   result = client.delete_service request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::DeleteServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.delete_service request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists imports in a service.
              #
              # @overload list_metadata_imports(request, options = nil)
              #   Pass arguments to `list_metadata_imports` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::ListMetadataImportsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::ListMetadataImportsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_metadata_imports(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_metadata_imports` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The relative resource name of the service whose metadata imports
              #     to list, in the following form:
              #
              #     `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of imports to return. The response may contain
              #     less than the maximum number. If unspecified, no more than 500 imports are
              #     returned. The maximum value is 1000; values above 1000 are changed to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client#list_services DataprocMetastore.ListServices}
              #     call. Provide this token to retrieve the subsequent page.
              #
              #     To retrieve the first page, supply an empty page token.
              #
              #     When paginating, other parameters provided to
              #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client#list_services DataprocMetastore.ListServices}
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter to apply to list results.
              #   @param order_by [::String]
              #     Optional. Specify the ordering of results as described in [Sorting
              #     Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
              #     If not specified, the results will be sorted in the default order.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Metastore::V1::MetadataImport>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Metastore::V1::MetadataImport>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::ListMetadataImportsRequest.new
              #
              #   # Call the list_metadata_imports method.
              #   result = client.list_metadata_imports request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Metastore::V1::MetadataImport.
              #     p item
              #   end
              #
              def list_metadata_imports request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::ListMetadataImportsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_metadata_imports.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_metadata_imports.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_metadata_imports.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.list_metadata_imports request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataproc_metastore_stub, :list_metadata_imports, "metadata_imports", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single import.
              #
              # @overload get_metadata_import(request, options = nil)
              #   Pass arguments to `get_metadata_import` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::GetMetadataImportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::GetMetadataImportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_metadata_import(name: nil)
              #   Pass arguments to `get_metadata_import` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The relative resource name of the metadata import to retrieve, in
              #     the following form:
              #
              #     `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{import_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Metastore::V1::MetadataImport]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Metastore::V1::MetadataImport]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::GetMetadataImportRequest.new
              #
              #   # Call the get_metadata_import method.
              #   result = client.get_metadata_import request
              #
              #   # The returned object is of type Google::Cloud::Metastore::V1::MetadataImport.
              #   p result
              #
              def get_metadata_import request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::GetMetadataImportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_metadata_import.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_metadata_import.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_metadata_import.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.get_metadata_import request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new MetadataImport in a given project and location.
              #
              # @overload create_metadata_import(request, options = nil)
              #   Pass arguments to `create_metadata_import` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::CreateMetadataImportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::CreateMetadataImportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_metadata_import(parent: nil, metadata_import_id: nil, metadata_import: nil, request_id: nil)
              #   Pass arguments to `create_metadata_import` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The relative resource name of the service in which to create a
              #     metastore import, in the following form:
              #
              #     `projects/{project_number}/locations/{location_id}/services/{service_id}`.
              #   @param metadata_import_id [::String]
              #     Required. The ID of the metadata import, which is used as the final
              #     component of the metadata import's name.
              #
              #     This value must be between 1 and 64 characters long, begin with a letter,
              #     end with a letter or number, and consist of alpha-numeric ASCII characters
              #     or hyphens.
              #   @param metadata_import [::Google::Cloud::Metastore::V1::MetadataImport, ::Hash]
              #     Required. The metadata import to create. The `name` field is ignored. The
              #     ID of the created metadata import must be provided in the request's
              #     `metadata_import_id` field.
              #   @param request_id [::String]
              #     Optional. A request ID. Specify a unique request ID to allow the server to
              #     ignore the request if it has completed. The server will ignore subsequent
              #     requests that provide a duplicate request ID for at least 60 minutes after
              #     the first request.
              #
              #     For example, if an initial request times out, followed by another request
              #     with the same request ID, the server ignores the second request to prevent
              #     the creation of duplicate commitments.
              #
              #     The request ID must be a valid
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
              #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::CreateMetadataImportRequest.new
              #
              #   # Call the create_metadata_import method.
              #   result = client.create_metadata_import request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_metadata_import request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::CreateMetadataImportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_metadata_import.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_metadata_import.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_metadata_import.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.create_metadata_import request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a single import.
              # Only the description field of MetadataImport is supported to be updated.
              #
              # @overload update_metadata_import(request, options = nil)
              #   Pass arguments to `update_metadata_import` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::UpdateMetadataImportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::UpdateMetadataImportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_metadata_import(update_mask: nil, metadata_import: nil, request_id: nil)
              #   Pass arguments to `update_metadata_import` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. A field mask used to specify the fields to be overwritten in the
              #     metadata import resource by the update.
              #     Fields specified in the `update_mask` are relative to the resource (not
              #     to the full request). A field is overwritten if it is in the mask.
              #   @param metadata_import [::Google::Cloud::Metastore::V1::MetadataImport, ::Hash]
              #     Required. The metadata import to update. The server only merges fields
              #     in the import if they are specified in `update_mask`.
              #
              #     The metadata import's `name` field is used to identify the metastore
              #     import to be updated.
              #   @param request_id [::String]
              #     Optional. A request ID. Specify a unique request ID to allow the server to
              #     ignore the request if it has completed. The server will ignore subsequent
              #     requests that provide a duplicate request ID for at least 60 minutes after
              #     the first request.
              #
              #     For example, if an initial request times out, followed by another request
              #     with the same request ID, the server ignores the second request to prevent
              #     the creation of duplicate commitments.
              #
              #     The request ID must be a valid
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
              #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::UpdateMetadataImportRequest.new
              #
              #   # Call the update_metadata_import method.
              #   result = client.update_metadata_import request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_metadata_import request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::UpdateMetadataImportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_metadata_import.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_metadata_import.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_metadata_import.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.update_metadata_import request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports metadata from a service.
              #
              # @overload export_metadata(request, options = nil)
              #   Pass arguments to `export_metadata` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::ExportMetadataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::ExportMetadataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_metadata(destination_gcs_folder: nil, service: nil, request_id: nil, database_dump_type: nil)
              #   Pass arguments to `export_metadata` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param destination_gcs_folder [::String]
              #     A Cloud Storage URI of a folder, in the format
              #     `gs://<bucket_name>/<path_inside_bucket>`. A sub-folder
              #     `<export_folder>` containing exported files will be created below it.
              #   @param service [::String]
              #     Required. The relative resource name of the metastore service to run
              #     export, in the following form:
              #
              #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
              #   @param request_id [::String]
              #     Optional. A request ID. Specify a unique request ID to allow the server to
              #     ignore the request if it has completed. The server will ignore subsequent
              #     requests that provide a duplicate request ID for at least 60 minutes after
              #     the first request.
              #
              #     For example, if an initial request times out, followed by another request
              #     with the same request ID, the server ignores the second request to prevent
              #     the creation of duplicate commitments.
              #
              #     The request ID must be a valid
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
              #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
              #   @param database_dump_type [::Google::Cloud::Metastore::V1::DatabaseDumpSpec::Type]
              #     Optional. The type of the database dump. If unspecified, defaults to
              #     `MYSQL`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::ExportMetadataRequest.new
              #
              #   # Call the export_metadata method.
              #   result = client.export_metadata request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_metadata request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::ExportMetadataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_metadata.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_metadata.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_metadata.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.export_metadata request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Restores a service from a backup.
              #
              # @overload restore_service(request, options = nil)
              #   Pass arguments to `restore_service` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::RestoreServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::RestoreServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload restore_service(service: nil, backup: nil, restore_type: nil, request_id: nil)
              #   Pass arguments to `restore_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service [::String]
              #     Required. The relative resource name of the metastore service to run
              #     restore, in the following form:
              #
              #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
              #   @param backup [::String]
              #     Required. The relative resource name of the metastore service backup to
              #     restore from, in the following form:
              #
              #     `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
              #   @param restore_type [::Google::Cloud::Metastore::V1::Restore::RestoreType]
              #     Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
              #   @param request_id [::String]
              #     Optional. A request ID. Specify a unique request ID to allow the server to
              #     ignore the request if it has completed. The server will ignore subsequent
              #     requests that provide a duplicate request ID for at least 60 minutes after
              #     the first request.
              #
              #     For example, if an initial request times out, followed by another request
              #     with the same request ID, the server ignores the second request to prevent
              #     the creation of duplicate commitments.
              #
              #     The request ID must be a valid
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
              #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::RestoreServiceRequest.new
              #
              #   # Call the restore_service method.
              #   result = client.restore_service request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restore_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::RestoreServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.restore_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.restore_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.restore_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.restore_service request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists backups in a service.
              #
              # @overload list_backups(request, options = nil)
              #   Pass arguments to `list_backups` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::ListBackupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::ListBackupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_backups(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_backups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The relative resource name of the service whose backups to
              #     list, in the following form:
              #
              #     `projects/{project_number}/locations/{location_id}/services/{service_id}/backups`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of backups to return. The response may contain
              #     less than the maximum number. If unspecified, no more than 500 backups are
              #     returned. The maximum value is 1000; values above 1000 are changed to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client#list_backups DataprocMetastore.ListBackups}
              #     call. Provide this token to retrieve the subsequent page.
              #
              #     To retrieve the first page, supply an empty page token.
              #
              #     When paginating, other parameters provided to
              #     {::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client#list_backups DataprocMetastore.ListBackups}
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter to apply to list results.
              #   @param order_by [::String]
              #     Optional. Specify the ordering of results as described in [Sorting
              #     Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
              #     If not specified, the results will be sorted in the default order.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Metastore::V1::Backup>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Metastore::V1::Backup>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::ListBackupsRequest.new
              #
              #   # Call the list_backups method.
              #   result = client.list_backups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Metastore::V1::Backup.
              #     p item
              #   end
              #
              def list_backups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::ListBackupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_backups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_backups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.list_backups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataproc_metastore_stub, :list_backups, "backups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single backup.
              #
              # @overload get_backup(request, options = nil)
              #   Pass arguments to `get_backup` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::GetBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::GetBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_backup(name: nil)
              #   Pass arguments to `get_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The relative resource name of the backup to retrieve, in the
              #     following form:
              #
              #     `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Metastore::V1::Backup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Metastore::V1::Backup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::GetBackupRequest.new
              #
              #   # Call the get_backup method.
              #   result = client.get_backup request
              #
              #   # The returned object is of type Google::Cloud::Metastore::V1::Backup.
              #   p result
              #
              def get_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::GetBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.get_backup request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new backup in a given project and location.
              #
              # @overload create_backup(request, options = nil)
              #   Pass arguments to `create_backup` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::CreateBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::CreateBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_backup(parent: nil, backup_id: nil, backup: nil, request_id: nil)
              #   Pass arguments to `create_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The relative resource name of the service in which to create a
              #     backup of the following form:
              #
              #     `projects/{project_number}/locations/{location_id}/services/{service_id}`.
              #   @param backup_id [::String]
              #     Required. The ID of the backup, which is used as the final component of the
              #     backup's name.
              #
              #     This value must be between 1 and 64 characters long, begin with a letter,
              #     end with a letter or number, and consist of alpha-numeric ASCII characters
              #     or hyphens.
              #   @param backup [::Google::Cloud::Metastore::V1::Backup, ::Hash]
              #     Required. The backup to create. The `name` field is ignored. The ID of the
              #     created backup must be provided in the request's `backup_id` field.
              #   @param request_id [::String]
              #     Optional. A request ID. Specify a unique request ID to allow the server to
              #     ignore the request if it has completed. The server will ignore subsequent
              #     requests that provide a duplicate request ID for at least 60 minutes after
              #     the first request.
              #
              #     For example, if an initial request times out, followed by another request
              #     with the same request ID, the server ignores the second request to prevent
              #     the creation of duplicate commitments.
              #
              #     The request ID must be a valid
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
              #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::CreateBackupRequest.new
              #
              #   # Call the create_backup method.
              #   result = client.create_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::CreateBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.create_backup request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single backup.
              #
              # @overload delete_backup(request, options = nil)
              #   Pass arguments to `delete_backup` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::DeleteBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::DeleteBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_backup(name: nil, request_id: nil)
              #   Pass arguments to `delete_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The relative resource name of the backup to delete, in the
              #     following form:
              #
              #     `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
              #   @param request_id [::String]
              #     Optional. A request ID. Specify a unique request ID to allow the server to
              #     ignore the request if it has completed. The server will ignore subsequent
              #     requests that provide a duplicate request ID for at least 60 minutes after
              #     the first request.
              #
              #     For example, if an initial request times out, followed by another request
              #     with the same request ID, the server ignores the second request to prevent
              #     the creation of duplicate commitments.
              #
              #     The request ID must be a valid
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
              #     A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::DeleteBackupRequest.new
              #
              #   # Call the delete_backup method.
              #   result = client.delete_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::DeleteBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.delete_backup request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Query DPMS metadata.
              #
              # @overload query_metadata(request, options = nil)
              #   Pass arguments to `query_metadata` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::QueryMetadataRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::QueryMetadataRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload query_metadata(service: nil, query: nil)
              #   Pass arguments to `query_metadata` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service [::String]
              #     Required. The relative resource name of the metastore service to query
              #     metadata, in the following format:
              #
              #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
              #   @param query [::String]
              #     Required. A read-only SQL query to execute against the metadata database.
              #     The query cannot change or mutate the data.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::QueryMetadataRequest.new
              #
              #   # Call the query_metadata method.
              #   result = client.query_metadata request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def query_metadata request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::QueryMetadataRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.query_metadata.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.query_metadata.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.query_metadata.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.query_metadata request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Move a table to another database.
              #
              # @overload move_table_to_database(request, options = nil)
              #   Pass arguments to `move_table_to_database` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::MoveTableToDatabaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::MoveTableToDatabaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload move_table_to_database(service: nil, table_name: nil, db_name: nil, destination_db_name: nil)
              #   Pass arguments to `move_table_to_database` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service [::String]
              #     Required. The relative resource name of the metastore service to mutate
              #     metadata, in the following format:
              #
              #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
              #   @param table_name [::String]
              #     Required. The name of the table to be moved.
              #   @param db_name [::String]
              #     Required. The name of the database where the table resides.
              #   @param destination_db_name [::String]
              #     Required. The name of the database where the table should be moved.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::MoveTableToDatabaseRequest.new
              #
              #   # Call the move_table_to_database method.
              #   result = client.move_table_to_database request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def move_table_to_database request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::MoveTableToDatabaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.move_table_to_database.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.move_table_to_database.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.move_table_to_database.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.move_table_to_database request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Alter metadata resource location. The metadata resource can be a database,
              # table, or partition. This functionality only updates the parent directory
              # for the respective metadata resource and does not transfer any existing
              # data to the new location.
              #
              # @overload alter_metadata_resource_location(request, options = nil)
              #   Pass arguments to `alter_metadata_resource_location` via a request object, either of type
              #   {::Google::Cloud::Metastore::V1::AlterMetadataResourceLocationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Metastore::V1::AlterMetadataResourceLocationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload alter_metadata_resource_location(service: nil, resource_name: nil, location_uri: nil)
              #   Pass arguments to `alter_metadata_resource_location` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service [::String]
              #     Required. The relative resource name of the metastore service to mutate
              #     metadata, in the following format:
              #
              #     `projects/{project_id}/locations/{location_id}/services/{service_id}`.
              #   @param resource_name [::String]
              #     Required. The relative metadata resource name in the following format.
              #
              #     `databases/{database_id}`
              #     or
              #     `databases/{database_id}/tables/{table_id}`
              #     or
              #     `databases/{database_id}/tables/{table_id}/partitions/{partition_id}`
              #   @param location_uri [::String]
              #     Required. The new location URI for the metadata resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/metastore/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Metastore::V1::AlterMetadataResourceLocationRequest.new
              #
              #   # Call the alter_metadata_resource_location method.
              #   result = client.alter_metadata_resource_location request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def alter_metadata_resource_location request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Metastore::V1::AlterMetadataResourceLocationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.alter_metadata_resource_location.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Metastore::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.alter_metadata_resource_location.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.alter_metadata_resource_location.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataproc_metastore_stub.alter_metadata_resource_location request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DataprocMetastore REST API.
              #
              # This class represents the configuration for DataprocMetastore REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_services to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_services.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Metastore::V1::DataprocMetastore::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_services.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "metastore.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DataprocMetastore API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_services`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_services
                  ##
                  # RPC-specific configuration for `get_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_service
                  ##
                  # RPC-specific configuration for `create_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_service
                  ##
                  # RPC-specific configuration for `update_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_service
                  ##
                  # RPC-specific configuration for `delete_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_service
                  ##
                  # RPC-specific configuration for `list_metadata_imports`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_metadata_imports
                  ##
                  # RPC-specific configuration for `get_metadata_import`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_metadata_import
                  ##
                  # RPC-specific configuration for `create_metadata_import`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_metadata_import
                  ##
                  # RPC-specific configuration for `update_metadata_import`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_metadata_import
                  ##
                  # RPC-specific configuration for `export_metadata`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_metadata
                  ##
                  # RPC-specific configuration for `restore_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restore_service
                  ##
                  # RPC-specific configuration for `list_backups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_backups
                  ##
                  # RPC-specific configuration for `get_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_backup
                  ##
                  # RPC-specific configuration for `create_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_backup
                  ##
                  # RPC-specific configuration for `delete_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_backup
                  ##
                  # RPC-specific configuration for `query_metadata`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :query_metadata
                  ##
                  # RPC-specific configuration for `move_table_to_database`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :move_table_to_database
                  ##
                  # RPC-specific configuration for `alter_metadata_resource_location`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :alter_metadata_resource_location

                  # @private
                  def initialize parent_rpcs = nil
                    list_services_config = parent_rpcs.list_services if parent_rpcs.respond_to? :list_services
                    @list_services = ::Gapic::Config::Method.new list_services_config
                    get_service_config = parent_rpcs.get_service if parent_rpcs.respond_to? :get_service
                    @get_service = ::Gapic::Config::Method.new get_service_config
                    create_service_config = parent_rpcs.create_service if parent_rpcs.respond_to? :create_service
                    @create_service = ::Gapic::Config::Method.new create_service_config
                    update_service_config = parent_rpcs.update_service if parent_rpcs.respond_to? :update_service
                    @update_service = ::Gapic::Config::Method.new update_service_config
                    delete_service_config = parent_rpcs.delete_service if parent_rpcs.respond_to? :delete_service
                    @delete_service = ::Gapic::Config::Method.new delete_service_config
                    list_metadata_imports_config = parent_rpcs.list_metadata_imports if parent_rpcs.respond_to? :list_metadata_imports
                    @list_metadata_imports = ::Gapic::Config::Method.new list_metadata_imports_config
                    get_metadata_import_config = parent_rpcs.get_metadata_import if parent_rpcs.respond_to? :get_metadata_import
                    @get_metadata_import = ::Gapic::Config::Method.new get_metadata_import_config
                    create_metadata_import_config = parent_rpcs.create_metadata_import if parent_rpcs.respond_to? :create_metadata_import
                    @create_metadata_import = ::Gapic::Config::Method.new create_metadata_import_config
                    update_metadata_import_config = parent_rpcs.update_metadata_import if parent_rpcs.respond_to? :update_metadata_import
                    @update_metadata_import = ::Gapic::Config::Method.new update_metadata_import_config
                    export_metadata_config = parent_rpcs.export_metadata if parent_rpcs.respond_to? :export_metadata
                    @export_metadata = ::Gapic::Config::Method.new export_metadata_config
                    restore_service_config = parent_rpcs.restore_service if parent_rpcs.respond_to? :restore_service
                    @restore_service = ::Gapic::Config::Method.new restore_service_config
                    list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                    @list_backups = ::Gapic::Config::Method.new list_backups_config
                    get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                    @get_backup = ::Gapic::Config::Method.new get_backup_config
                    create_backup_config = parent_rpcs.create_backup if parent_rpcs.respond_to? :create_backup
                    @create_backup = ::Gapic::Config::Method.new create_backup_config
                    delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                    @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                    query_metadata_config = parent_rpcs.query_metadata if parent_rpcs.respond_to? :query_metadata
                    @query_metadata = ::Gapic::Config::Method.new query_metadata_config
                    move_table_to_database_config = parent_rpcs.move_table_to_database if parent_rpcs.respond_to? :move_table_to_database
                    @move_table_to_database = ::Gapic::Config::Method.new move_table_to_database_config
                    alter_metadata_resource_location_config = parent_rpcs.alter_metadata_resource_location if parent_rpcs.respond_to? :alter_metadata_resource_location
                    @alter_metadata_resource_location = ::Gapic::Config::Method.new alter_metadata_resource_location_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
