# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Memorystore
      module V1
        # A Memorystore instance.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::Memorystore::V1::Instance::GcsBackupSource]
        #     Optional. Immutable. Backups that stored in Cloud Storage buckets.
        #     The Cloud Storage buckets need to be the same region as the instances.
        #     Read permission is required to import from the provided Cloud Storage
        #     Objects.
        #
        #     Note: The following fields are mutually exclusive: `gcs_source`, `managed_backup_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] managed_backup_source
        #   @return [::Google::Cloud::Memorystore::V1::Instance::ManagedBackupSource]
        #     Optional. Immutable. Backups that generated and managed by memorystore
        #     service.
        #
        #     Note: The following fields are mutually exclusive: `managed_backup_source`, `gcs_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Unique name of the instance.
        #     Format: projects/\\{project}/locations/\\{location}/instances/\\{instance}
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation timestamp of the instance.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Latest update timestamp of the instance.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels to represent user-provided metadata.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Memorystore::V1::Instance::State]
        #     Output only. Current state of the instance.
        # @!attribute [r] state_info
        #   @return [::Google::Cloud::Memorystore::V1::Instance::StateInfo]
        #     Output only. Additional information about the state of the instance.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System assigned, unique identifier for the instance.
        # @!attribute [rw] replica_count
        #   @return [::Integer]
        #     Optional. Number of replica nodes per shard. If omitted the default is 0
        #     replicas.
        # @!attribute [rw] authorization_mode
        #   @return [::Google::Cloud::Memorystore::V1::Instance::AuthorizationMode]
        #     Optional. Immutable. Authorization mode of the instance.
        # @!attribute [rw] transit_encryption_mode
        #   @return [::Google::Cloud::Memorystore::V1::Instance::TransitEncryptionMode]
        #     Optional. Immutable. In-transit encryption mode of the instance.
        # @!attribute [rw] shard_count
        #   @return [::Integer]
        #     Optional. Number of shards for the instance.
        # @!attribute [r] discovery_endpoints
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::Memorystore::V1::DiscoveryEndpoint>]
        #     Output only. Deprecated: The discovery_endpoints parameter is deprecated.
        #     As a result, it will not be populated if the connections are created using
        #     endpoints parameter. Instead of this parameter, for discovery, use
        #     endpoints.connections.pscConnection and
        #     endpoints.connections.pscAutoConnection
        #     with connectionType CONNECTION_TYPE_DISCOVERY.
        # @!attribute [rw] node_type
        #   @return [::Google::Cloud::Memorystore::V1::Instance::NodeType]
        #     Optional. Machine type for individual nodes of the instance.
        # @!attribute [rw] persistence_config
        #   @return [::Google::Cloud::Memorystore::V1::PersistenceConfig]
        #     Optional. Persistence configuration of the instance.
        # @!attribute [rw] engine_version
        #   @return [::String]
        #     Optional. Engine version of the instance.
        # @!attribute [rw] engine_configs
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-provided engine configurations for the instance.
        # @!attribute [r] node_config
        #   @return [::Google::Cloud::Memorystore::V1::NodeConfig]
        #     Output only. Configuration of individual nodes of the instance.
        # @!attribute [rw] zone_distribution_config
        #   @return [::Google::Cloud::Memorystore::V1::ZoneDistributionConfig]
        #     Optional. Immutable. Zone distribution configuration of the instance for
        #     node allocation.
        # @!attribute [rw] deletion_protection_enabled
        #   @return [::Boolean]
        #     Optional. If set to true deletion of the instance will fail.
        # @!attribute [rw] psc_auto_connections
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::Memorystore::V1::PscAutoConnection>]
        #     Optional. Immutable. Deprecated: Use the
        #     endpoints.connections.psc_auto_connection value instead.
        # @!attribute [r] psc_attachment_details
        #   @return [::Array<::Google::Cloud::Memorystore::V1::PscAttachmentDetail>]
        #     Output only. Service attachment details to configure PSC connections.
        # @!attribute [rw] endpoints
        #   @return [::Array<::Google::Cloud::Memorystore::V1::Instance::InstanceEndpoint>]
        #     Optional. Endpoints for the instance.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::Memorystore::V1::Instance::Mode]
        #     Optional. The mode config for the instance.
        # @!attribute [rw] simulate_maintenance_event
        #   @return [::Boolean]
        #     Optional. Input only. Simulate a maintenance event.
        # @!attribute [rw] ondemand_maintenance
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Optional. Input only. Ondemand maintenance for the instance.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Optional. Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Optional. Output only. Reserved for future use.
        # @!attribute [rw] maintenance_policy
        #   @return [::Google::Cloud::Memorystore::V1::MaintenancePolicy]
        #     Optional. The maintenance policy for the instance. If not provided,
        #     the maintenance event will be performed based on Memorystore
        #     internal rollout schedule.
        # @!attribute [r] maintenance_schedule
        #   @return [::Google::Cloud::Memorystore::V1::MaintenanceSchedule]
        #     Output only. Published maintenance schedule.
        # @!attribute [rw] cross_instance_replication_config
        #   @return [::Google::Cloud::Memorystore::V1::CrossInstanceReplicationConfig]
        #     Optional. The config for cross instance replication.
        # @!attribute [rw] async_instance_endpoints_deletion_enabled
        #   @return [::Boolean]
        #     Optional. If true, instance endpoints that are created and registered by
        #     customers can be deleted asynchronously. That is, such an instance endpoint
        #     can be de-registered before the forwarding rules in the instance endpoint
        #     are deleted.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Optional. The KMS key used to encrypt the at-rest data of the cluster.
        # @!attribute [r] encryption_info
        #   @return [::Google::Cloud::Memorystore::V1::EncryptionInfo]
        #     Output only. Encryption information of the data at rest of the cluster.
        # @!attribute [r] backup_collection
        #   @return [::String]
        #     Output only. The backup collection full resource name. Example:
        #     projects/\\{project}/locations/\\{location}/backupCollections/\\{collection}
        # @!attribute [rw] automated_backup_config
        #   @return [::Google::Cloud::Memorystore::V1::AutomatedBackupConfig]
        #     Optional. The automated backup config for the instance.
        # @!attribute [rw] maintenance_version
        #   @return [::String]
        #     Optional. This field can be used to trigger self service update to indicate
        #     the desired maintenance version. The input to this field can be determined
        #     by the available_maintenance_versions field.
        # @!attribute [r] effective_maintenance_version
        #   @return [::String]
        #     Output only. This field represents the actual maintenance version of the
        #     instance.
        # @!attribute [r] available_maintenance_versions
        #   @return [::Array<::String>]
        #     Output only. This field is used to determine the available maintenance
        #     versions for the self service update.
        # @!attribute [rw] allow_fewer_zones_deployment
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Optional. Immutable. Deprecated, do not use.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Additional information about the state of the instance.
          # @!attribute [r] update_info
          #   @return [::Google::Cloud::Memorystore::V1::Instance::StateInfo::UpdateInfo]
          #     Output only. Describes ongoing update when instance state is UPDATING.
          class StateInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents information about instance with state UPDATING.
            # @!attribute [r] target_shard_count
            #   @return [::Integer]
            #     Output only. Target number of shards for the instance.
            # @!attribute [r] target_replica_count
            #   @return [::Integer]
            #     Output only. Target number of replica nodes per shard for the instance.
            # @!attribute [r] target_engine_version
            #   @return [::String]
            #     Output only. Target engine version for the instance.
            # @!attribute [r] target_node_type
            #   @return [::Google::Cloud::Memorystore::V1::Instance::NodeType]
            #     Output only. Target node type for the instance.
            class UpdateInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Backups that stored in Cloud Storage buckets.
          # The Cloud Storage buckets need to be the same region as the instances.
          # @!attribute [rw] uris
          #   @return [::Array<::String>]
          #     Optional. Example: gs://bucket1/object1, gs://bucket2/folder2/object2
          class GcsBackupSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Backups that generated and managed by memorystore.
          # @!attribute [rw] backup
          #   @return [::String]
          #     Optional. Example:
          #     //memorystore.googleapis.com/projects/\\{project}/locations/\\{location}/backupCollections/\\{collection}/backups/\\{backup}
          #     A shorter version (without the prefix) of the backup name is also
          #     supported, like
          #     projects/\\{project}/locations/\\{location}/backupCollections/\\{collection}/backups/\\{backup_id}
          #     In this case, it assumes the backup is under memorystore.googleapis.com.
          class ManagedBackupSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # InstanceEndpoint consists of PSC connections that are created
          # as a group in each VPC network for accessing the instance. In each group,
          # there shall be one connection for each service attachment in the cluster.
          # @!attribute [rw] connections
          #   @return [::Array<::Google::Cloud::Memorystore::V1::Instance::ConnectionDetail>]
          #     Optional. A group of PSC connections. They are created in the same VPC
          #     network, one for each service attachment in the cluster.
          class InstanceEndpoint
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information of each PSC connection.
          # @!attribute [rw] psc_auto_connection
          #   @return [::Google::Cloud::Memorystore::V1::PscAutoConnection]
          #     Immutable. Detailed information of a PSC connection that is created
          #     through service connectivity automation.
          #
          #     Note: The following fields are mutually exclusive: `psc_auto_connection`, `psc_connection`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] psc_connection
          #   @return [::Google::Cloud::Memorystore::V1::PscConnection]
          #     Detailed information of a PSC connection that is created by the user.
          #
          #     Note: The following fields are mutually exclusive: `psc_connection`, `psc_auto_connection`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ConnectionDetail
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class EngineConfigsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states of the instance.
          module State
            # Not set.
            STATE_UNSPECIFIED = 0

            # Instance is being created.
            CREATING = 1

            # Instance has been created and is usable.
            ACTIVE = 2

            # Instance is being updated.
            UPDATING = 3

            # Instance is being deleted.
            DELETING = 4
          end

          # Possible authorization modes of the instance.
          module AuthorizationMode
            # Not set.
            AUTHORIZATION_MODE_UNSPECIFIED = 0

            # Authorization disabled.
            AUTH_DISABLED = 1

            # IAM basic authorization.
            IAM_AUTH = 2
          end

          # Possible in-transit encryption modes of the instance.
          module TransitEncryptionMode
            # Not set.
            TRANSIT_ENCRYPTION_MODE_UNSPECIFIED = 0

            # In-transit encryption is disabled.
            TRANSIT_ENCRYPTION_DISABLED = 1

            # Server-managed encryption is used for in-transit encryption.
            SERVER_AUTHENTICATION = 2
          end

          # Possible node types of the instance. See
          # https://cloud.google.com/memorystore/docs/valkey/instance-node-specification
          # for more information.
          module NodeType
            # Not set.
            NODE_TYPE_UNSPECIFIED = 0

            # Shared core nano.
            SHARED_CORE_NANO = 1

            # High memory medium.
            HIGHMEM_MEDIUM = 2

            # High memory extra large.
            HIGHMEM_XLARGE = 3

            # Standard small.
            STANDARD_SMALL = 4
          end

          # The mode config, which is used to enable/disable cluster mode.
          module Mode
            # Mode is not specified.
            MODE_UNSPECIFIED = 0

            # Deprecated: Use CLUSTER_DISABLED instead.
            STANDALONE = 1

            # Instance is in cluster mode.
            CLUSTER = 2

            # Cluster mode is disabled for the instance.
            CLUSTER_DISABLED = 4
          end
        end

        # The automated backup config for an instance.
        # @!attribute [rw] fixed_frequency_schedule
        #   @return [::Google::Cloud::Memorystore::V1::AutomatedBackupConfig::FixedFrequencySchedule]
        #     Optional. Trigger automated backups at a fixed frequency.
        # @!attribute [rw] automated_backup_mode
        #   @return [::Google::Cloud::Memorystore::V1::AutomatedBackupConfig::AutomatedBackupMode]
        #     Optional. The automated backup mode. If the mode is disabled, the other
        #     fields will be ignored.
        # @!attribute [rw] retention
        #   @return [::Google::Protobuf::Duration]
        #     Optional. How long to keep automated backups before the backups are
        #     deleted. The value should be between 1 day and 365 days. If not specified,
        #     the default value is 35 days.
        class AutomatedBackupConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This schedule allows the backup to be triggered at a fixed frequency
          # (currently only daily is supported).
          # @!attribute [rw] start_time
          #   @return [::Google::Type::TimeOfDay]
          #     Required. The start time of every automated backup in UTC. It must be set
          #     to the start of an hour. This field is required.
          class FixedFrequencySchedule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The automated backup mode.
          module AutomatedBackupMode
            # Default value. Automated backup config is not specified.
            AUTOMATED_BACKUP_MODE_UNSPECIFIED = 0

            # Automated backup config disabled.
            DISABLED = 1

            # Automated backup config enabled.
            ENABLED = 2
          end
        end

        # BackupCollection of an instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Full resource path of the backup collection.
        # @!attribute [r] instance_uid
        #   @return [::String]
        #     Output only. The instance uid of the backup collection.
        # @!attribute [r] instance
        #   @return [::String]
        #     Output only. The full resource path of the instance the backup collection
        #     belongs to. Example:
        #     projects/\\{project}/locations/\\{location}/instances/\\{instance}
        # @!attribute [r] kms_key
        #   @return [::String]
        #     Output only. The KMS key used to encrypt the backups under this backup
        #     collection.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System assigned unique identifier of the backup collection.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the backup collection was created.
        # @!attribute [r] total_backup_size_bytes
        #   @return [::Integer]
        #     Output only. Total size of all backups in the backup collection.
        # @!attribute [r] total_backup_count
        #   @return [::Integer]
        #     Output only. Total number of backups in the backup collection.
        # @!attribute [r] last_backup_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time a backup was created in the backup collection.
        class BackupCollection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Backup of an instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Full resource path of the backup. the last part of the name is
        #     the backup id with the following format: [YYYYMMDDHHMMSS]_[Shorted Instance
        #     UID] OR customer specified while backup instance. Example:
        #     20240515123000_1234
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the backup was created.
        # @!attribute [r] instance
        #   @return [::String]
        #     Output only. Instance resource path of this backup.
        # @!attribute [r] instance_uid
        #   @return [::String]
        #     Output only. Instance uid of this backup.
        # @!attribute [r] total_size_bytes
        #   @return [::Integer]
        #     Output only. Total size of the backup in bytes.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the backup will expire.
        # @!attribute [r] engine_version
        #   @return [::String]
        #     Output only. valkey-7.5/valkey-8.0, etc.
        # @!attribute [r] backup_files
        #   @return [::Array<::Google::Cloud::Memorystore::V1::BackupFile>]
        #     Output only. List of backup files of the backup.
        # @!attribute [r] node_type
        #   @return [::Google::Cloud::Memorystore::V1::Instance::NodeType]
        #     Output only. Node type of the instance.
        # @!attribute [r] replica_count
        #   @return [::Integer]
        #     Output only. Number of replicas for the instance.
        # @!attribute [r] shard_count
        #   @return [::Integer]
        #     Output only. Number of shards for the instance.
        # @!attribute [r] backup_type
        #   @return [::Google::Cloud::Memorystore::V1::Backup::BackupType]
        #     Output only. Type of the backup.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Memorystore::V1::Backup::State]
        #     Output only. State of the backup.
        # @!attribute [r] encryption_info
        #   @return [::Google::Cloud::Memorystore::V1::EncryptionInfo]
        #     Output only. Encryption information of the backup.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System assigned unique identifier of the backup.
        class Backup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of the backup.
          module BackupType
            # The default value, not set.
            BACKUP_TYPE_UNSPECIFIED = 0

            # On-demand backup.
            ON_DEMAND = 1

            # Automated backup.
            AUTOMATED = 2
          end

          # State of the backup.
          module State
            # The default value, not set.
            STATE_UNSPECIFIED = 0

            # The backup is being created.
            CREATING = 1

            # The backup is active to be used.
            ACTIVE = 2

            # The backup is being deleted.
            DELETING = 3

            # The backup is currently suspended due to reasons like project deletion,
            # billing account closure, etc.
            SUSPENDED = 4
          end
        end

        # Backup is consisted of multiple backup files.
        # @!attribute [r] file_name
        #   @return [::String]
        #     Output only. e.g: <shard-id>.rdb
        # @!attribute [r] size_bytes
        #   @return [::Integer]
        #     Output only. Size of the backup file in bytes.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the backup file was created.
        class BackupFile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Cross instance replication config.
        # @!attribute [rw] instance_role
        #   @return [::Google::Cloud::Memorystore::V1::CrossInstanceReplicationConfig::InstanceRole]
        #     Required. The role of the instance in cross instance replication.
        # @!attribute [rw] primary_instance
        #   @return [::Google::Cloud::Memorystore::V1::CrossInstanceReplicationConfig::RemoteInstance]
        #     Optional. Details of the primary instance that is used as the replication
        #     source for this secondary instance.
        #
        #     This field is only set for a secondary instance.
        # @!attribute [rw] secondary_instances
        #   @return [::Array<::Google::Cloud::Memorystore::V1::CrossInstanceReplicationConfig::RemoteInstance>]
        #     Optional. List of secondary instances that are replicating from this
        #     primary instance.
        #
        #     This field is only set for a primary instance.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time cross instance replication config was updated.
        # @!attribute [r] membership
        #   @return [::Google::Cloud::Memorystore::V1::CrossInstanceReplicationConfig::Membership]
        #     Output only. An output only view of all the member instances participating
        #     in the cross instance replication. This view will be provided by every
        #     member instance irrespective of its instance role(primary or secondary).
        #
        #     A primary instance can provide information about all the secondary
        #     instances replicating from it. However, a secondary instance only knows
        #     about the primary instance from which it is replicating. However, for
        #     scenarios, where the primary instance is unavailable(e.g. regional outage),
        #     a Getinstance request can be sent to any other member instance and this
        #     field will list all the member instances participating in cross instance
        #     replication.
        class CrossInstanceReplicationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Details of the remote instance associated with this instance in a cross
          # instance replication setup.
          # @!attribute [rw] instance
          #   @return [::String]
          #     Optional. The full resource path of the remote instance in
          #     the format: projects/<project>/locations/<region>/instances/<instance-id>
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the remote instance.
          class RemoteInstance
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An output only view of all the member instances participating in the cross
          # instance replication.
          # @!attribute [r] primary_instance
          #   @return [::Google::Cloud::Memorystore::V1::CrossInstanceReplicationConfig::RemoteInstance]
          #     Output only. The primary instance that acts as the source of replication
          #     for the secondary instances.
          # @!attribute [r] secondary_instances
          #   @return [::Array<::Google::Cloud::Memorystore::V1::CrossInstanceReplicationConfig::RemoteInstance>]
          #     Output only. The list of secondary instances replicating from the primary
          #     instance.
          class Membership
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The role of the instance in cross instance replication.
          module InstanceRole
            # instance role is not set.
            # The behavior is equivalent to NONE.
            INSTANCE_ROLE_UNSPECIFIED = 0

            # This instance does not participate in cross instance replication. It is
            # an independent instance and does not replicate to or from any other
            # instances.
            NONE = 1

            # A instance that allows both reads and writes. Any data written to this
            # instance is also replicated to the attached secondary instances.
            PRIMARY = 2

            # A instance that allows only reads and replicates data from a primary
            # instance.
            SECONDARY = 3
          end
        end

        # Maintenance policy per instance.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the policy was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the policy was updated.
        # @!attribute [rw] weekly_maintenance_window
        #   @return [::Array<::Google::Cloud::Memorystore::V1::WeeklyMaintenanceWindow>]
        #     Optional. Maintenance window that is applied to resources covered by this
        #     policy. Minimum 1. For the current version, the maximum number of
        #     weekly_window is expected to be one.
        class MaintenancePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Time window specified for weekly operations.
        # @!attribute [rw] day
        #   @return [::Google::Type::DayOfWeek]
        #     Optional. Allows to define schedule that runs specified day of the week.
        # @!attribute [rw] start_time
        #   @return [::Google::Type::TimeOfDay]
        #     Optional. Start time of the window in UTC.
        class WeeklyMaintenanceWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Upcoming maintenance schedule.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The start time of any upcoming scheduled maintenance for this
        #     instance.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The end time of any upcoming scheduled maintenance for this
        #     instance.
        class MaintenanceSchedule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of a service attachment of the cluster, for creating PSC
        # connections.
        # @!attribute [r] service_attachment
        #   @return [::String]
        #     Output only. Service attachment URI which your self-created PscConnection
        #     should use as target.
        # @!attribute [r] connection_type
        #   @return [::Google::Cloud::Memorystore::V1::ConnectionType]
        #     Output only. Type of Psc endpoint.
        class PscAttachmentDetail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of consumer resources in a PSC connection.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Optional. port will only be set for Primary/Reader or Discovery endpoint.
        # @!attribute [r] psc_connection_id
        #   @return [::String]
        #     Output only. The PSC connection id of the forwarding rule connected to the
        #     service attachment.
        # @!attribute [r] ip_address
        #   @return [::String]
        #     Output only. The IP allocated on the consumer network for the PSC
        #     forwarding rule.
        # @!attribute [r] forwarding_rule
        #   @return [::String]
        #     Output only. The URI of the consumer side forwarding rule.
        #     Format:
        #     projects/\\{project}/regions/\\{region}/forwardingRules/\\{forwarding_rule}
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. The consumer project_id where PSC connections are established.
        #     This should be the same project_id that the instance is being created in.
        # @!attribute [rw] network
        #   @return [::String]
        #     Required. The network where the PSC endpoints are created, in the form of
        #     projects/\\{project_id}/global/networks/\\{network_id}.
        # @!attribute [r] service_attachment
        #   @return [::String]
        #     Output only. The service attachment which is the target of the PSC
        #     connection, in the form of
        #     projects/\\{project-id}/regions/\\{region}/serviceAttachments/\\{service-attachment-id}.
        # @!attribute [r] psc_connection_status
        #   @return [::Google::Cloud::Memorystore::V1::PscConnectionStatus]
        #     Output only. The status of the PSC connection: whether a connection exists
        #     and ACTIVE or it no longer exists. Please note that this value is updated
        #     periodically. Please use Private Service Connect APIs for the latest
        #     status.
        # @!attribute [r] connection_type
        #   @return [::Google::Cloud::Memorystore::V1::ConnectionType]
        #     Output only. Type of the PSC connection.
        class PscAutoConnection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # User created Psc connection configuration.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Optional. port will only be set for Primary/Reader or Discovery endpoint.
        # @!attribute [rw] psc_connection_id
        #   @return [::String]
        #     Required. The PSC connection id of the forwarding rule connected to the
        #     service attachment.
        # @!attribute [rw] ip_address
        #   @return [::String]
        #     Required. The IP allocated on the consumer network for the PSC forwarding
        #     rule.
        # @!attribute [rw] forwarding_rule
        #   @return [::String]
        #     Required. The URI of the consumer side forwarding rule.
        #     Format:
        #     projects/\\{project}/regions/\\{region}/forwardingRules/\\{forwarding_rule}
        # @!attribute [r] project_id
        #   @return [::String]
        #     Output only. The consumer project_id where the forwarding rule is created
        #     from.
        # @!attribute [rw] network
        #   @return [::String]
        #     Required. The consumer network where the IP address resides, in the form of
        #     projects/\\{project_id}/global/networks/\\{network_id}.
        # @!attribute [rw] service_attachment
        #   @return [::String]
        #     Required. The service attachment which is the target of the PSC connection,
        #     in the form of
        #     projects/\\{project-id}/regions/\\{region}/serviceAttachments/\\{service-attachment-id}.
        # @!attribute [r] psc_connection_status
        #   @return [::Google::Cloud::Memorystore::V1::PscConnectionStatus]
        #     Output only. The status of the PSC connection: whether a connection exists
        #     and ACTIVE or it no longer exists. Please note that this value is updated
        #     periodically. Please use Private Service Connect APIs for the latest
        #     status.
        # @!attribute [r] connection_type
        #   @return [::Google::Cloud::Memorystore::V1::ConnectionType]
        #     Output only. Type of the PSC connection.
        class PscConnection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an endpoint for clients to connect to the instance.
        # @!attribute [r] address
        #   @return [::String]
        #     Output only. IP address of the exposed endpoint clients connect to.
        # @!attribute [r] port
        #   @return [::Integer]
        #     Output only. The port number of the exposed endpoint.
        # @!attribute [r] network
        #   @return [::String]
        #     Output only. The network where the IP address of the discovery endpoint
        #     will be reserved, in the form of
        #     projects/\\{network_project}/global/networks/\\{network_id}.
        class DiscoveryEndpoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents persistence configuration for a instance.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::Memorystore::V1::PersistenceConfig::PersistenceMode]
        #     Optional. Current persistence mode.
        # @!attribute [rw] rdb_config
        #   @return [::Google::Cloud::Memorystore::V1::PersistenceConfig::RDBConfig]
        #     Optional. RDB configuration. This field will be ignored if mode is not RDB.
        # @!attribute [rw] aof_config
        #   @return [::Google::Cloud::Memorystore::V1::PersistenceConfig::AOFConfig]
        #     Optional. AOF configuration. This field will be ignored if mode is not AOF.
        class PersistenceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for RDB based persistence.
          # @!attribute [rw] rdb_snapshot_period
          #   @return [::Google::Cloud::Memorystore::V1::PersistenceConfig::RDBConfig::SnapshotPeriod]
          #     Optional. Period between RDB snapshots.
          # @!attribute [rw] rdb_snapshot_start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. Time that the first snapshot was/will be attempted, and to
          #     which future snapshots will be aligned. If not provided, the current time
          #     will be used.
          class RDBConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible snapshot periods.
            module SnapshotPeriod
              # Not set.
              SNAPSHOT_PERIOD_UNSPECIFIED = 0

              # One hour.
              ONE_HOUR = 1

              # Six hours.
              SIX_HOURS = 2

              # Twelve hours.
              TWELVE_HOURS = 3

              # Twenty four hours.
              TWENTY_FOUR_HOURS = 4
            end
          end

          # Configuration for AOF based persistence.
          # @!attribute [rw] append_fsync
          #   @return [::Google::Cloud::Memorystore::V1::PersistenceConfig::AOFConfig::AppendFsync]
          #     Optional. The fsync mode.
          class AOFConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible fsync modes.
            module AppendFsync
              # Not set. Default: EVERY_SEC
              APPEND_FSYNC_UNSPECIFIED = 0

              # Never fsync. Normally Linux will flush data every 30 seconds with this
              # configuration, but it's up to the kernel's exact tuning.
              NEVER = 1

              # Fsync every second. You may lose 1 second of data if there is a
              # disaster.
              EVERY_SEC = 2

              # Fsync every time new write commands are appended to the AOF. The best
              # data loss protection at the cost of performance.
              ALWAYS = 3
            end
          end

          # Possible persistence modes.
          module PersistenceMode
            # Not set.
            PERSISTENCE_MODE_UNSPECIFIED = 0

            # Persistence is disabled, and any snapshot data is deleted.
            DISABLED = 1

            # RDB based persistence is enabled.
            RDB = 2

            # AOF based persistence is enabled.
            AOF = 3
          end
        end

        # Represents configuration for nodes of the instance.
        # @!attribute [r] size_gb
        #   @return [::Float]
        #     Output only. Memory size in GB of the node.
        class NodeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Zone distribution configuration for allocation of instance resources.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Optional. Defines zone where all resources will be allocated with
        #     SINGLE_ZONE mode. Ignored for MULTI_ZONE mode.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::Memorystore::V1::ZoneDistributionConfig::ZoneDistributionMode]
        #     Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
        class ZoneDistributionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible zone distribution modes.
          module ZoneDistributionMode
            # Not Set. Default: MULTI_ZONE
            ZONE_DISTRIBUTION_MODE_UNSPECIFIED = 0

            # Distribute resources across 3 zones picked at random within the
            # region.
            MULTI_ZONE = 1

            # Provision resources in a single zone. Zone field must be specified.
            SINGLE_ZONE = 2
          end
        end

        # Request for rescheduling instance maintenance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the instance to reschedule maintenance for:
        #     `projects/{project}/locations/{location_id}/instances/{instance}`
        # @!attribute [rw] reschedule_type
        #   @return [::Google::Cloud::Memorystore::V1::RescheduleMaintenanceRequest::RescheduleType]
        #     Required. If reschedule type is SPECIFIC_TIME, schedule_time must be set.
        # @!attribute [rw] schedule_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp when the maintenance shall be rescheduled to if
        #     reschedule_type=SPECIFIC_TIME, in RFC 3339 format.
        #     Example: `2012-11-15T16:19:00.094Z`.
        class RescheduleMaintenanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Reschedule options.
          module RescheduleType
            # Not set.
            RESCHEDULE_TYPE_UNSPECIFIED = 0

            # If the user wants to schedule the maintenance to happen now.
            IMMEDIATE = 1

            # If the user wants to reschedule the maintenance to a specific time.
            SPECIFIC_TIME = 3
          end
        end

        # Request message for [ListInstances][].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent to list instances from.
        #     Format: projects/\\{project}/locations/\\{location}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Expression for filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Sort results by a defined order. Supported values: "name",
        #     "create_time".
        class ListInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for [ListInstances][].
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::Memorystore::V1::Instance>]
        #     If the \\{location} requested was "-" the response contains a list of
        #     instances from all locations. Instances in unreachable locations will be
        #     omitted.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [GetInstance][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the instance to retrieve.
        #     Format: projects/\\{project}/locations/\\{location}/instances/\\{instance}
        class GetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [CreateInstance][].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this instance will be created.
        #     Format: projects/\\{project}/locations/\\{location}
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. The ID to use for the instance, which will become the final
        #     component of the instance's resource name.
        #
        #     This value is subject to the following restrictions:
        #
        #     * Must be 4-63 characters in length
        #     * Must begin with a letter or digit
        #     * Must contain only lowercase letters, digits, and hyphens
        #     * Must not end with a hyphen
        #     * Must be unique within a location
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::Memorystore::V1::Instance]
        #     Required. The instance to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [UpdateInstance][].
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to be updated on the instance. At least one
        #     field must be specified.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::Memorystore::V1::Instance]
        #     Required. The instance to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [DeleteInstance][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the instance to delete.
        #     Format: projects/\\{project}/locations/\\{location}/instances/\\{instance}
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for [ListBackupCollections]
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the backupCollection location using the
        #     form:
        #         `projects/{project_id}/locations/{location_id}`
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #
        #     If not specified, a default value of 1000 will be used by the service.
        #     Regardless of the page_size value, the response may include a partial list
        #     and a caller should only rely on response's
        #     {::Google::Cloud::Memorystore::V1::ListBackupCollectionsResponse#next_page_token `next_page_token`}
        #     to determine if there are more clusters left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The `next_page_token` value returned from a previous
        #     [ListBackupCollections] request, if any.
        class ListBackupCollectionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for [ListBackupCollections].
        # @!attribute [rw] backup_collections
        #   @return [::Array<::Google::Cloud::Memorystore::V1::BackupCollection>]
        #     A list of backupCollections in the project.
        #
        #     If the `location_id` in the parent field of the request is "-", all regions
        #     available to the project are queried, and the results aggregated.
        #     If in such an aggregated query a location is unavailable, a placeholder
        #     backupCollection entry is included in the response with the `name` field
        #     set to a value of the form
        #     `projects/{project_id}/locations/{location_id}/backupCollections/`- and the
        #     `status` field set to ERROR and `status_message` field set to "location not
        #     available for ListBackupCollections".
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupCollectionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for [GetBackupCollection].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Instance backupCollection resource name using the form:
        #         `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}`
        #     where `location_id` refers to a Google Cloud region.
        class GetBackupCollectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for [ListBackups].
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the backupCollection using the form:
        #     `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #
        #     If not specified, a default value of 1000 will be used by the service.
        #     Regardless of the page_size value, the response may include a partial list
        #     and a caller should only rely on response's
        #     {::Google::Cloud::Memorystore::V1::ListBackupsResponse#next_page_token `next_page_token`}
        #     to determine if there are more clusters left to be queried.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The `next_page_token` value returned from a previous
        #     [ListBackupCollections] request, if any.
        class ListBackupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for [ListBackups].
        # @!attribute [rw] backups
        #   @return [::Array<::Google::Cloud::Memorystore::V1::Backup>]
        #     A list of backups in the project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Backups that could not be reached.
        class ListBackupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for [GetBackup].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Instance backup resource name using the form:
        #     `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}/backups/{backup_id}`
        class GetBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for [DeleteBackup].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Instance backup resource name using the form:
        #     `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}/backups/{backup_id}`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. Idempotent request UUID.
        class DeleteBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for [ExportBackup].
        # @!attribute [rw] gcs_bucket
        #   @return [::String]
        #     Google Cloud Storage bucket, like "my-bucket".
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Instance backup resource name using the form:
        #     `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}/backups/{backup_id}`
        class ExportBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for [BackupInstance].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Instance resource name using the form:
        #      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     Optional. TTL for the backup to expire. Value range is 1 day to 100 years.
        #     If not specified, the default value is 100 years.
        # @!attribute [rw] backup_id
        #   @return [::String]
        #     Optional. The id of the backup to be created. If not specified, the
        #     default value ([YYYYMMDDHHMMSS]_[Shortened Instance UID] is used.
        class BackupInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [GetCertificateAuthority][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the certificate authority.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/instances/\\{instance}/certificateAuthority
        class GetCertificateAuthorityRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A certificate authority for an instance.
        # @!attribute [rw] managed_server_ca
        #   @return [::Google::Cloud::Memorystore::V1::CertificateAuthority::ManagedCertificateAuthority]
        #     A managed server certificate authority.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Unique name of the certificate authority.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/instances/\\{instance}
        class CertificateAuthority
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A managed certificate authority.
          # @!attribute [rw] ca_certs
          #   @return [::Array<::Google::Cloud::Memorystore::V1::CertificateAuthority::ManagedCertificateAuthority::CertChain>]
          #     PEM encoded CA certificate chains for managed server authentication.
          class ManagedCertificateAuthority
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A certificate chain.
            # @!attribute [rw] certificates
            #   @return [::Array<::String>]
            #     The certificates that form the CA chain in order of leaf to root.
            class CertChain
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Represents the metadata of a long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # EncryptionInfo describes the encryption information of a cluster.
        # @!attribute [r] encryption_type
        #   @return [::Google::Cloud::Memorystore::V1::EncryptionInfo::Type]
        #     Output only. Type of encryption.
        # @!attribute [r] kms_key_versions
        #   @return [::Array<::String>]
        #     Output only. KMS key versions that are being used to protect the data
        #     at-rest.
        # @!attribute [r] kms_key_primary_state
        #   @return [::Google::Cloud::Memorystore::V1::EncryptionInfo::KmsKeyState]
        #     Output only. The state of the primary version of the KMS key perceived by
        #     the system. This field is not populated in backups.
        # @!attribute [r] last_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The most recent time when the encryption info was updated.
        class EncryptionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible encryption types.
          module Type
            # Encryption type not specified. Defaults to GOOGLE_DEFAULT_ENCRYPTION.
            TYPE_UNSPECIFIED = 0

            # The data is encrypted at rest with a key that is fully managed by Google.
            # No key version will be populated. This is the default state.
            GOOGLE_DEFAULT_ENCRYPTION = 1

            # The data is encrypted at rest with a key that is managed by the customer.
            # KMS key versions will be populated.
            CUSTOMER_MANAGED_ENCRYPTION = 2
          end

          # The state of the KMS key perceived by the system. Refer to the public
          # documentation for the impact of each state.
          module KmsKeyState
            # The default value. This value is unused.
            KMS_KEY_STATE_UNSPECIFIED = 0

            # The KMS key is enabled and correctly configured.
            ENABLED = 1

            # Permission denied on the KMS key.
            PERMISSION_DENIED = 2

            # The KMS key is disabled.
            DISABLED = 3

            # The KMS key is destroyed.
            DESTROYED = 4

            # The KMS key is scheduled to be destroyed.
            DESTROY_SCHEDULED = 5

            # The EKM key is unreachable.
            EKM_KEY_UNREACHABLE_DETECTED = 6

            # Billing is disabled for the project.
            BILLING_DISABLED = 7

            # All other unknown failures.
            UNKNOWN_FAILURE = 8
          end
        end

        # Status of the PSC connection.
        module PscConnectionStatus
          # PSC connection status is not specified.
          PSC_CONNECTION_STATUS_UNSPECIFIED = 0

          # The connection is active
          ACTIVE = 1

          # Connection not found
          NOT_FOUND = 2
        end

        # Type of a PSC connection
        module ConnectionType
          # Connection Type is not set
          CONNECTION_TYPE_UNSPECIFIED = 0

          # Connection that will be used for topology discovery.
          CONNECTION_TYPE_DISCOVERY = 1

          # Connection that will be used as primary endpoint to access primary.
          CONNECTION_TYPE_PRIMARY = 2

          # Connection that will be used as reader endpoint to access replicas.
          CONNECTION_TYPE_READER = 3
        end
      end
    end
  end
end
