# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Memorystore
      module V1
        module Memorystore
          # Path helper methods for the Memorystore API.
          module Paths
            ##
            # Create a fully-qualified Backup resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupCollections/{backup_collection}/backups/{backup}`
            #
            # @param project [String]
            # @param location [String]
            # @param backup_collection [String]
            # @param backup [String]
            #
            # @return [::String]
            def backup_path project:, location:, backup_collection:, backup:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "backup_collection cannot contain /" if backup_collection.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupCollections/#{backup_collection}/backups/#{backup}"
            end

            ##
            # Create a fully-qualified BackupCollection resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupCollections/{backup_collection}`
            #
            # @param project [String]
            # @param location [String]
            # @param backup_collection [String]
            #
            # @return [::String]
            def backup_collection_path project:, location:, backup_collection:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupCollections/#{backup_collection}"
            end

            ##
            # Create a fully-qualified CryptoKey resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            #
            # @return [::String]
            def crypto_key_path project:, location:, key_ring:, crypto_key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}"
            end

            ##
            # Create a fully-qualified CryptoKeyVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            # @param crypto_key_version [String]
            #
            # @return [::String]
            def crypto_key_version_path project:, location:, key_ring:, crypto_key:, crypto_key_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"
              raise ::ArgumentError, "crypto_key cannot contain /" if crypto_key.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}/cryptoKeyVersions/#{crypto_key_version}"
            end

            ##
            # Create a fully-qualified ForwardingRule resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}`
            #
            # @param project [String]
            # @param region [String]
            # @param forwarding_rule [String]
            #
            # @return [::String]
            def forwarding_rule_path project:, region:, forwarding_rule:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/forwardingRules/#{forwarding_rule}"
            end

            ##
            # Create a fully-qualified Instance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            #
            # @return [::String]
            def instance_path project:, location:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/global/networks/{network}`
            #
            # @param project [String]
            # @param network [String]
            #
            # @return [::String]
            def network_path project:, network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/global/networks/#{network}"
            end

            ##
            # Create a fully-qualified ServiceAttachment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`
            #
            # @param project [String]
            # @param region [String]
            # @param service_attachment [String]
            #
            # @return [::String]
            def service_attachment_path project:, region:, service_attachment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/serviceAttachments/#{service_attachment}"
            end

            extend self
          end
        end
      end
    end
  end
end
