# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/mediatranslation/v1beta1/media_translation_pb"
require "google/cloud/media_translation/v1beta1/speech_translation_service"

class ::Google::Cloud::MediaTranslation::V1beta1::SpeechTranslationService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_streaming_translate_speech
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    streaming_config = {}

    streaming_translate_speech_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :streaming_translate_speech, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, streaming_translate_speech_client_stub do
      # Create client
      client = ::Google::Cloud::MediaTranslation::V1beta1::SpeechTranslationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { streaming_config: streaming_config }
      request_proto = ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechRequest.new streaming_config: streaming_config
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_translate_speech enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { streaming_config: streaming_config }
      request_proto = ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechRequest.new streaming_config: streaming_config
      stream_input = Gapic::StreamInput.new
      client.streaming_translate_speech stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { streaming_config: streaming_config }
      request_proto = ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechRequest.new streaming_config: streaming_config
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_translate_speech enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { streaming_config: streaming_config }
      request_proto = ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechRequest.new streaming_config: streaming_config
      stream_input = Gapic::StreamInput.new
      client.streaming_translate_speech stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, streaming_translate_speech_client_stub.call_rpc_count
      streaming_translate_speech_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechRequest, r
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::MediaTranslation::V1beta1::StreamingTranslateSpeechConfig), r["streaming_config"]
          assert_equal :streaming_config, r.streaming_request
        end
      end
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::MediaTranslation::V1beta1::SpeechTranslationService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::MediaTranslation::V1beta1::SpeechTranslationService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::MediaTranslation::V1beta1::SpeechTranslationService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::MediaTranslation::V1beta1::SpeechTranslationService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
