# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/managedkafka/v1/managed_kafka_pb"
require "google/cloud/managed_kafka/v1/managed_kafka/rest"


class ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_clusters
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ListClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_list_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_clusters ::Google::Cloud::ManagedKafka::V1::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_clusters(::Google::Cloud::ManagedKafka::V1::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_clusters_client_stub.call_count
      end
    end
  end

  def test_get_cluster
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Cluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_get_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_cluster ::Google::Cloud::ManagedKafka::V1::GetClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_cluster(::Google::Cloud::ManagedKafka::V1::GetClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_cluster_client_stub.call_count
      end
    end
  end

  def test_create_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cluster_id = "hello world"
    cluster = {}
    request_id = "hello world"

    create_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_create_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_cluster parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_cluster ::Google::Cloud::ManagedKafka::V1::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_cluster(::Google::Cloud::ManagedKafka::V1::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_cluster_client_stub.call_count
      end
    end
  end

  def test_update_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    cluster = {}
    request_id = "hello world"

    update_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_update_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_cluster update_mask: update_mask, cluster: cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_cluster ::Google::Cloud::ManagedKafka::V1::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_cluster(::Google::Cloud::ManagedKafka::V1::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_cluster_client_stub.call_count
      end
    end
  end

  def test_delete_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_delete_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_cluster({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_cluster name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_cluster ::Google::Cloud::ManagedKafka::V1::DeleteClusterRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_cluster({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_cluster(::Google::Cloud::ManagedKafka::V1::DeleteClusterRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_cluster_client_stub.call_count
      end
    end
  end

  def test_list_topics
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ListTopicsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_topics_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_list_topics_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_topics_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_topics({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_topics parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_topics ::Google::Cloud::ManagedKafka::V1::ListTopicsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_topics({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_topics(::Google::Cloud::ManagedKafka::V1::ListTopicsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_topics_client_stub.call_count
      end
    end
  end

  def test_get_topic
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Topic.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_topic_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_get_topic_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_topic_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_topic({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_topic name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_topic ::Google::Cloud::ManagedKafka::V1::GetTopicRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_topic({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_topic(::Google::Cloud::ManagedKafka::V1::GetTopicRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_topic_client_stub.call_count
      end
    end
  end

  def test_create_topic
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Topic.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    topic_id = "hello world"
    topic = {}

    create_topic_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_create_topic_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_topic_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_topic({ parent: parent, topic_id: topic_id, topic: topic }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_topic parent: parent, topic_id: topic_id, topic: topic do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_topic ::Google::Cloud::ManagedKafka::V1::CreateTopicRequest.new(parent: parent, topic_id: topic_id, topic: topic) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_topic({ parent: parent, topic_id: topic_id, topic: topic }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_topic(::Google::Cloud::ManagedKafka::V1::CreateTopicRequest.new(parent: parent, topic_id: topic_id, topic: topic), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_topic_client_stub.call_count
      end
    end
  end

  def test_update_topic
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Topic.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    topic = {}

    update_topic_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_update_topic_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_topic_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_topic({ update_mask: update_mask, topic: topic }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_topic update_mask: update_mask, topic: topic do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_topic ::Google::Cloud::ManagedKafka::V1::UpdateTopicRequest.new(update_mask: update_mask, topic: topic) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_topic({ update_mask: update_mask, topic: topic }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_topic(::Google::Cloud::ManagedKafka::V1::UpdateTopicRequest.new(update_mask: update_mask, topic: topic), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_topic_client_stub.call_count
      end
    end
  end

  def test_delete_topic
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_topic_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_delete_topic_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_topic_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_topic({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_topic name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_topic ::Google::Cloud::ManagedKafka::V1::DeleteTopicRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_topic({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_topic(::Google::Cloud::ManagedKafka::V1::DeleteTopicRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_topic_client_stub.call_count
      end
    end
  end

  def test_list_consumer_groups
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ListConsumerGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_consumer_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_list_consumer_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_consumer_groups_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_consumer_groups({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_consumer_groups parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_consumer_groups ::Google::Cloud::ManagedKafka::V1::ListConsumerGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_consumer_groups({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_consumer_groups(::Google::Cloud::ManagedKafka::V1::ListConsumerGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_consumer_groups_client_stub.call_count
      end
    end
  end

  def test_get_consumer_group
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ConsumerGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_consumer_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_get_consumer_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_consumer_group_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_consumer_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_consumer_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_consumer_group ::Google::Cloud::ManagedKafka::V1::GetConsumerGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_consumer_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_consumer_group(::Google::Cloud::ManagedKafka::V1::GetConsumerGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_consumer_group_client_stub.call_count
      end
    end
  end

  def test_update_consumer_group
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ConsumerGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    consumer_group = {}

    update_consumer_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_update_consumer_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_consumer_group_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_consumer_group({ update_mask: update_mask, consumer_group: consumer_group }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_consumer_group update_mask: update_mask, consumer_group: consumer_group do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_consumer_group ::Google::Cloud::ManagedKafka::V1::UpdateConsumerGroupRequest.new(update_mask: update_mask, consumer_group: consumer_group) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_consumer_group({ update_mask: update_mask, consumer_group: consumer_group }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_consumer_group(::Google::Cloud::ManagedKafka::V1::UpdateConsumerGroupRequest.new(update_mask: update_mask, consumer_group: consumer_group), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_consumer_group_client_stub.call_count
      end
    end
  end

  def test_delete_consumer_group
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_consumer_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_delete_consumer_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_consumer_group_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_consumer_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_consumer_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_consumer_group ::Google::Cloud::ManagedKafka::V1::DeleteConsumerGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_consumer_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_consumer_group(::Google::Cloud::ManagedKafka::V1::DeleteConsumerGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_consumer_group_client_stub.call_count
      end
    end
  end

  def test_list_acls
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ListAclsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_acls_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_list_acls_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_acls_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_acls({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_acls parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_acls ::Google::Cloud::ManagedKafka::V1::ListAclsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_acls({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_acls(::Google::Cloud::ManagedKafka::V1::ListAclsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_acls_client_stub.call_count
      end
    end
  end

  def test_get_acl
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Acl.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_acl_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_get_acl_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_acl_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_acl({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_acl name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_acl ::Google::Cloud::ManagedKafka::V1::GetAclRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_acl({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_acl(::Google::Cloud::ManagedKafka::V1::GetAclRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_acl_client_stub.call_count
      end
    end
  end

  def test_create_acl
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Acl.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    acl_id = "hello world"
    acl = {}

    create_acl_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_create_acl_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_acl_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_acl({ parent: parent, acl_id: acl_id, acl: acl }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_acl parent: parent, acl_id: acl_id, acl: acl do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_acl ::Google::Cloud::ManagedKafka::V1::CreateAclRequest.new(parent: parent, acl_id: acl_id, acl: acl) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_acl({ parent: parent, acl_id: acl_id, acl: acl }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_acl(::Google::Cloud::ManagedKafka::V1::CreateAclRequest.new(parent: parent, acl_id: acl_id, acl: acl), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_acl_client_stub.call_count
      end
    end
  end

  def test_update_acl
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Acl.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    acl = {}
    update_mask = {}

    update_acl_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_update_acl_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_acl_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_acl({ acl: acl, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_acl acl: acl, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_acl ::Google::Cloud::ManagedKafka::V1::UpdateAclRequest.new(acl: acl, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_acl({ acl: acl, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_acl(::Google::Cloud::ManagedKafka::V1::UpdateAclRequest.new(acl: acl, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_acl_client_stub.call_count
      end
    end
  end

  def test_delete_acl
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_acl_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_delete_acl_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_acl_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_acl({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_acl name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_acl ::Google::Cloud::ManagedKafka::V1::DeleteAclRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_acl({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_acl(::Google::Cloud::ManagedKafka::V1::DeleteAclRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_acl_client_stub.call_count
      end
    end
  end

  def test_add_acl_entry
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::AddAclEntryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    acl = "hello world"
    acl_entry = {}

    add_acl_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_add_acl_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_acl_entry_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_acl_entry({ acl: acl, acl_entry: acl_entry }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_acl_entry acl: acl, acl_entry: acl_entry do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_acl_entry ::Google::Cloud::ManagedKafka::V1::AddAclEntryRequest.new(acl: acl, acl_entry: acl_entry) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_acl_entry({ acl: acl, acl_entry: acl_entry }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_acl_entry(::Google::Cloud::ManagedKafka::V1::AddAclEntryRequest.new(acl: acl, acl_entry: acl_entry), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_acl_entry_client_stub.call_count
      end
    end
  end

  def test_remove_acl_entry
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::RemoveAclEntryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    acl = "hello world"
    acl_entry = {}

    remove_acl_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::ServiceStub.stub :transcode_remove_acl_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_acl_entry_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_acl_entry({ acl: acl, acl_entry: acl_entry }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_acl_entry acl: acl, acl_entry: acl_entry do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_acl_entry ::Google::Cloud::ManagedKafka::V1::RemoveAclEntryRequest.new(acl: acl, acl_entry: acl_entry) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_acl_entry({ acl: acl, acl_entry: acl_entry }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_acl_entry(::Google::Cloud::ManagedKafka::V1::RemoveAclEntryRequest.new(acl: acl, acl_entry: acl_entry), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_acl_entry_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client::Configuration, config
  end
end
