# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/managedkafka/v1/managed_kafka_connect_pb"
require "google/cloud/managed_kafka/v1/managed_kafka_connect"

class ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_connect_clusters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::ListConnectClustersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_connect_clusters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_connect_clusters, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::ListConnectClustersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_connect_clusters_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_connect_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_connect_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_connect_clusters ::Google::Cloud::ManagedKafka::V1::ListConnectClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_connect_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_connect_clusters(::Google::Cloud::ManagedKafka::V1::ListConnectClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_connect_clusters_client_stub.call_rpc_count
    end
  end

  def test_get_connect_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::ConnectCluster.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connect_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connect_cluster, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::GetConnectClusterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connect_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connect_cluster({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connect_cluster name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connect_cluster ::Google::Cloud::ManagedKafka::V1::GetConnectClusterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connect_cluster({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connect_cluster(::Google::Cloud::ManagedKafka::V1::GetConnectClusterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connect_cluster_client_stub.call_rpc_count
    end
  end

  def test_create_connect_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connect_cluster_id = "hello world"
    connect_cluster = {}
    request_id = "hello world"

    create_connect_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_connect_cluster, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::CreateConnectClusterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["connect_cluster_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedKafka::V1::ConnectCluster), request["connect_cluster"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_connect_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_connect_cluster({ parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_connect_cluster parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_connect_cluster ::Google::Cloud::ManagedKafka::V1::CreateConnectClusterRequest.new(parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_connect_cluster({ parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_connect_cluster(::Google::Cloud::ManagedKafka::V1::CreateConnectClusterRequest.new(parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_connect_cluster_client_stub.call_rpc_count
    end
  end

  def test_update_connect_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    connect_cluster = {}
    request_id = "hello world"

    update_connect_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_connect_cluster, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::UpdateConnectClusterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedKafka::V1::ConnectCluster), request["connect_cluster"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_connect_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_connect_cluster({ update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_connect_cluster update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_connect_cluster ::Google::Cloud::ManagedKafka::V1::UpdateConnectClusterRequest.new(update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_connect_cluster({ update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_connect_cluster(::Google::Cloud::ManagedKafka::V1::UpdateConnectClusterRequest.new(update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_connect_cluster_client_stub.call_rpc_count
    end
  end

  def test_delete_connect_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_connect_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_connect_cluster, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::DeleteConnectClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_connect_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_connect_cluster({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_connect_cluster name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_connect_cluster ::Google::Cloud::ManagedKafka::V1::DeleteConnectClusterRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_connect_cluster({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_connect_cluster(::Google::Cloud::ManagedKafka::V1::DeleteConnectClusterRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_connect_cluster_client_stub.call_rpc_count
    end
  end

  def test_list_connectors
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::ListConnectorsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_connectors_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_connectors, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::ListConnectorsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_connectors_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_connectors({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_connectors parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_connectors ::Google::Cloud::ManagedKafka::V1::ListConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_connectors({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_connectors(::Google::Cloud::ManagedKafka::V1::ListConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_connectors_client_stub.call_rpc_count
    end
  end

  def test_get_connector
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::Connector.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connector, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::GetConnectorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connector_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connector({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connector name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connector ::Google::Cloud::ManagedKafka::V1::GetConnectorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connector({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connector(::Google::Cloud::ManagedKafka::V1::GetConnectorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connector_client_stub.call_rpc_count
    end
  end

  def test_create_connector
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::Connector.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connector_id = "hello world"
    connector = {}

    create_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_connector, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::CreateConnectorRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["connector_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedKafka::V1::Connector), request["connector"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_connector_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_connector({ parent: parent, connector_id: connector_id, connector: connector }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_connector parent: parent, connector_id: connector_id, connector: connector do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_connector ::Google::Cloud::ManagedKafka::V1::CreateConnectorRequest.new(parent: parent, connector_id: connector_id, connector: connector) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_connector({ parent: parent, connector_id: connector_id, connector: connector }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_connector(::Google::Cloud::ManagedKafka::V1::CreateConnectorRequest.new(parent: parent, connector_id: connector_id, connector: connector), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_connector_client_stub.call_rpc_count
    end
  end

  def test_update_connector
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::Connector.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    connector = {}

    update_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_connector, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::UpdateConnectorRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedKafka::V1::Connector), request["connector"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_connector_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_connector({ update_mask: update_mask, connector: connector }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_connector update_mask: update_mask, connector: connector do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_connector ::Google::Cloud::ManagedKafka::V1::UpdateConnectorRequest.new(update_mask: update_mask, connector: connector) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_connector({ update_mask: update_mask, connector: connector }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_connector(::Google::Cloud::ManagedKafka::V1::UpdateConnectorRequest.new(update_mask: update_mask, connector: connector), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_connector_client_stub.call_rpc_count
    end
  end

  def test_delete_connector
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_connector, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::DeleteConnectorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_connector_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_connector({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_connector name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_connector ::Google::Cloud::ManagedKafka::V1::DeleteConnectorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_connector({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_connector(::Google::Cloud::ManagedKafka::V1::DeleteConnectorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_connector_client_stub.call_rpc_count
    end
  end

  def test_pause_connector
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::PauseConnectorResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    pause_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :pause_connector, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::PauseConnectorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, pause_connector_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.pause_connector({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.pause_connector name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.pause_connector ::Google::Cloud::ManagedKafka::V1::PauseConnectorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.pause_connector({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.pause_connector(::Google::Cloud::ManagedKafka::V1::PauseConnectorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, pause_connector_client_stub.call_rpc_count
    end
  end

  def test_resume_connector
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::ResumeConnectorResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    resume_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resume_connector, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::ResumeConnectorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resume_connector_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resume_connector({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resume_connector name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resume_connector ::Google::Cloud::ManagedKafka::V1::ResumeConnectorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resume_connector({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resume_connector(::Google::Cloud::ManagedKafka::V1::ResumeConnectorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resume_connector_client_stub.call_rpc_count
    end
  end

  def test_restart_connector
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::RestartConnectorResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    restart_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :restart_connector, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::RestartConnectorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, restart_connector_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.restart_connector({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.restart_connector name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.restart_connector ::Google::Cloud::ManagedKafka::V1::RestartConnectorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.restart_connector({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.restart_connector(::Google::Cloud::ManagedKafka::V1::RestartConnectorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, restart_connector_client_stub.call_rpc_count
    end
  end

  def test_stop_connector
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::V1::StopConnectorResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :stop_connector, name
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::StopConnectorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stop_connector_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stop_connector({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stop_connector name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stop_connector ::Google::Cloud::ManagedKafka::V1::StopConnectorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stop_connector({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stop_connector(::Google::Cloud::ManagedKafka::V1::StopConnectorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stop_connector_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Operations, client.operations_client
  end
end
