# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/managedkafka/v1/managed_kafka_connect_pb"
require "google/cloud/managed_kafka/v1/managed_kafka_connect/rest"


class ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_connect_clusters
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ListConnectClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_connect_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_list_connect_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_connect_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_connect_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_connect_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_connect_clusters ::Google::Cloud::ManagedKafka::V1::ListConnectClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_connect_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_connect_clusters(::Google::Cloud::ManagedKafka::V1::ListConnectClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_connect_clusters_client_stub.call_count
      end
    end
  end

  def test_get_connect_cluster
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ConnectCluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connect_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_get_connect_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_connect_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_connect_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_connect_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_connect_cluster ::Google::Cloud::ManagedKafka::V1::GetConnectClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_connect_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_connect_cluster(::Google::Cloud::ManagedKafka::V1::GetConnectClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_connect_cluster_client_stub.call_count
      end
    end
  end

  def test_create_connect_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connect_cluster_id = "hello world"
    connect_cluster = {}
    request_id = "hello world"

    create_connect_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_create_connect_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_connect_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_connect_cluster({ parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_connect_cluster parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_connect_cluster ::Google::Cloud::ManagedKafka::V1::CreateConnectClusterRequest.new(parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_connect_cluster({ parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_connect_cluster(::Google::Cloud::ManagedKafka::V1::CreateConnectClusterRequest.new(parent: parent, connect_cluster_id: connect_cluster_id, connect_cluster: connect_cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_connect_cluster_client_stub.call_count
      end
    end
  end

  def test_update_connect_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    connect_cluster = {}
    request_id = "hello world"

    update_connect_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_update_connect_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_connect_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_connect_cluster({ update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_connect_cluster update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_connect_cluster ::Google::Cloud::ManagedKafka::V1::UpdateConnectClusterRequest.new(update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_connect_cluster({ update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_connect_cluster(::Google::Cloud::ManagedKafka::V1::UpdateConnectClusterRequest.new(update_mask: update_mask, connect_cluster: connect_cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_connect_cluster_client_stub.call_count
      end
    end
  end

  def test_delete_connect_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_connect_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_delete_connect_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_connect_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_connect_cluster({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_connect_cluster name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_connect_cluster ::Google::Cloud::ManagedKafka::V1::DeleteConnectClusterRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_connect_cluster({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_connect_cluster(::Google::Cloud::ManagedKafka::V1::DeleteConnectClusterRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_connect_cluster_client_stub.call_count
      end
    end
  end

  def test_list_connectors
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ListConnectorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_connectors_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_list_connectors_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_connectors_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_connectors({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_connectors parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_connectors ::Google::Cloud::ManagedKafka::V1::ListConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_connectors({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_connectors(::Google::Cloud::ManagedKafka::V1::ListConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_connectors_client_stub.call_count
      end
    end
  end

  def test_get_connector
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Connector.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_get_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_connector_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_connector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_connector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_connector ::Google::Cloud::ManagedKafka::V1::GetConnectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_connector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_connector(::Google::Cloud::ManagedKafka::V1::GetConnectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_connector_client_stub.call_count
      end
    end
  end

  def test_create_connector
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Connector.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connector_id = "hello world"
    connector = {}

    create_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_create_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_connector_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_connector({ parent: parent, connector_id: connector_id, connector: connector }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_connector parent: parent, connector_id: connector_id, connector: connector do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_connector ::Google::Cloud::ManagedKafka::V1::CreateConnectorRequest.new(parent: parent, connector_id: connector_id, connector: connector) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_connector({ parent: parent, connector_id: connector_id, connector: connector }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_connector(::Google::Cloud::ManagedKafka::V1::CreateConnectorRequest.new(parent: parent, connector_id: connector_id, connector: connector), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_connector_client_stub.call_count
      end
    end
  end

  def test_update_connector
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::Connector.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    connector = {}

    update_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_update_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_connector_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_connector({ update_mask: update_mask, connector: connector }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_connector update_mask: update_mask, connector: connector do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_connector ::Google::Cloud::ManagedKafka::V1::UpdateConnectorRequest.new(update_mask: update_mask, connector: connector) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_connector({ update_mask: update_mask, connector: connector }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_connector(::Google::Cloud::ManagedKafka::V1::UpdateConnectorRequest.new(update_mask: update_mask, connector: connector), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_connector_client_stub.call_count
      end
    end
  end

  def test_delete_connector
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_delete_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_connector_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_connector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_connector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_connector ::Google::Cloud::ManagedKafka::V1::DeleteConnectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_connector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_connector(::Google::Cloud::ManagedKafka::V1::DeleteConnectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_connector_client_stub.call_count
      end
    end
  end

  def test_pause_connector
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::PauseConnectorResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    pause_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_pause_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, pause_connector_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.pause_connector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.pause_connector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.pause_connector ::Google::Cloud::ManagedKafka::V1::PauseConnectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.pause_connector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.pause_connector(::Google::Cloud::ManagedKafka::V1::PauseConnectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, pause_connector_client_stub.call_count
      end
    end
  end

  def test_resume_connector
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::ResumeConnectorResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    resume_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_resume_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resume_connector_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resume_connector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resume_connector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resume_connector ::Google::Cloud::ManagedKafka::V1::ResumeConnectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resume_connector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resume_connector(::Google::Cloud::ManagedKafka::V1::ResumeConnectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resume_connector_client_stub.call_count
      end
    end
  end

  def test_restart_connector
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::RestartConnectorResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    restart_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_restart_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restart_connector_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restart_connector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restart_connector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restart_connector ::Google::Cloud::ManagedKafka::V1::RestartConnectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restart_connector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restart_connector(::Google::Cloud::ManagedKafka::V1::RestartConnectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restart_connector_client_stub.call_count
      end
    end
  end

  def test_stop_connector
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::V1::StopConnectorResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.stub :transcode_stop_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_connector_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_connector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_connector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_connector ::Google::Cloud::ManagedKafka::V1::StopConnectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_connector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_connector(::Google::Cloud::ManagedKafka::V1::StopConnectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_connector_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client::Configuration, config
  end
end
