# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ManagedKafka
      module V1
        # An Apache Kafka cluster deployed in a location.
        # @!attribute [rw] gcp_config
        #   @return [::Google::Cloud::ManagedKafka::V1::GcpConfig]
        #     Required. Configuration properties for a Kafka cluster deployed to Google
        #     Cloud Platform.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the cluster. Structured like:
        #     projects/\\{project_number}/locations/\\{location}/clusters/\\{cluster_id}
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the cluster was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the cluster was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs.
        # @!attribute [rw] capacity_config
        #   @return [::Google::Cloud::ManagedKafka::V1::CapacityConfig]
        #     Required. Capacity configuration for the Kafka cluster.
        # @!attribute [rw] rebalance_config
        #   @return [::Google::Cloud::ManagedKafka::V1::RebalanceConfig]
        #     Optional. Rebalance configuration for the Kafka cluster.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ManagedKafka::V1::Cluster::State]
        #     Output only. The current state of the cluster.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] tls_config
        #   @return [::Google::Cloud::ManagedKafka::V1::TlsConfig]
        #     Optional. TLS configuration for the Kafka cluster.
        class Cluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of the cluster.
          module State
            # A state was not specified.
            STATE_UNSPECIFIED = 0

            # The cluster is being created.
            CREATING = 1

            # The cluster is active.
            ACTIVE = 2

            # The cluster is being deleted.
            DELETING = 3
          end
        end

        # A capacity configuration of a Kafka cluster.
        # @!attribute [rw] vcpu_count
        #   @return [::Integer]
        #     Required. The number of vCPUs to provision for the cluster. Minimum: 3.
        # @!attribute [rw] memory_bytes
        #   @return [::Integer]
        #     Required. The memory to provision for the cluster in bytes.
        #     The CPU:memory ratio (vCPU:GiB) must be between 1:1 and 1:8.
        #     Minimum: 3221225472 (3 GiB).
        class CapacityConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines rebalancing behavior of a Kafka cluster.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::ManagedKafka::V1::RebalanceConfig::Mode]
        #     Optional. The rebalance behavior for the cluster.
        #     When not specified, defaults to `NO_REBALANCE`.
        class RebalanceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The partition rebalance mode for the cluster.
          module Mode
            # A mode was not specified. Do not use.
            MODE_UNSPECIFIED = 0

            # Do not rebalance automatically.
            NO_REBALANCE = 1

            # Automatically rebalance topic partitions among brokers when the
            # cluster is scaled up.
            AUTO_REBALANCE_ON_SCALE_UP = 2
          end
        end

        # The configuration of a Virtual Private Cloud (VPC) network that can access
        # the Kafka cluster.
        # @!attribute [rw] subnet
        #   @return [::String]
        #     Required. Name of the VPC subnet in which to create Private Service Connect
        #     (PSC) endpoints for the Kafka brokers and bootstrap address. Structured
        #     like: projects/\\{project}/regions/\\{region}/subnetworks/\\{subnet_id}
        #
        #     The subnet must be located in the same region as the Kafka cluster. The
        #     project may differ. Multiple subnets from the same parent network must not
        #     be specified.
        class NetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration of access to the Kafka cluster.
        # @!attribute [rw] network_configs
        #   @return [::Array<::Google::Cloud::ManagedKafka::V1::NetworkConfig>]
        #     Required. Virtual Private Cloud (VPC) networks that must be granted direct
        #     access to the Kafka cluster. Minimum of 1 network is required. Maximum 10
        #     networks can be specified.
        class AccessConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration properties for a Kafka cluster deployed to Google Cloud
        # Platform.
        # @!attribute [rw] access_config
        #   @return [::Google::Cloud::ManagedKafka::V1::AccessConfig]
        #     Required. Access configuration for the Kafka cluster.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Optional. Immutable. The Cloud KMS Key name to use for encryption. The key
        #     must be located in the same region as the cluster and cannot be changed.
        #     Structured like:
        #     projects/\\{project}/locations/\\{location}/keyRings/\\{key_ring}/cryptoKeys/\\{crypto_key}.
        class GcpConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The TLS configuration for the Kafka cluster.
        # @!attribute [rw] trust_config
        #   @return [::Google::Cloud::ManagedKafka::V1::TrustConfig]
        #     Optional. The configuration of the broker truststore. If specified, clients
        #     can use mTLS for authentication.
        # @!attribute [rw] ssl_principal_mapping_rules
        #   @return [::String]
        #     Optional. A list of rules for mapping from SSL principal names to
        #     short names. These are applied in order by Kafka.
        #     Refer to the Apache Kafka documentation for `ssl.principal.mapping.rules`
        #     for the precise formatting details and syntax.
        #     Example: "RULE:^CN=(.*?),OU=ServiceUsers.*$/$1@example.com/,DEFAULT"
        #
        #     This is a static Kafka broker configuration. Setting or modifying this
        #     field will trigger a rolling restart of the Kafka brokers to apply
        #     the change. An empty string means no rules are applied (Kafka default).
        class TlsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Sources of CA certificates to install in the broker's truststore.
        # @!attribute [rw] cas_configs
        #   @return [::Array<::Google::Cloud::ManagedKafka::V1::TrustConfig::CertificateAuthorityServiceConfig>]
        #     Optional. Configuration for the Google Certificate Authority Service.
        #     Maximum 10.
        class TrustConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A configuration for the Google Certificate Authority Service.
          # @!attribute [rw] ca_pool
          #   @return [::String]
          #     Required. The name of the CA pool to pull CA certificates from.
          #     Structured like:
          #     projects/\\{project}/locations/\\{location}/caPools/\\{ca_pool}.
          #     The CA pool does not need to be in the same project or location as the
          #     Kafka cluster.
          class CertificateAuthorityServiceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A Kafka topic in a given cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the topic. The `topic` segment is used when
        #     connecting directly to the cluster. Structured like:
        #     projects/\\{project}/locations/\\{location}/clusters/\\{cluster}/topics/\\{topic}
        # @!attribute [rw] partition_count
        #   @return [::Integer]
        #     Required. The number of partitions this topic has. The partition count can
        #     only be increased, not decreased. Please note that if partitions are
        #     increased for a topic that has a key, the partitioning logic or the
        #     ordering of the messages will be affected.
        # @!attribute [rw] replication_factor
        #   @return [::Integer]
        #     Required. Immutable. The number of replicas of each partition. A
        #     replication factor of 3 is recommended for high availability.
        # @!attribute [rw] configs
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Configurations for the topic that are overridden from the cluster
        #     defaults. The key of the map is a Kafka topic property name, for example:
        #     `cleanup.policy`, `compression.type`.
        class Topic
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ConfigsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata for a consumer group corresponding to a specific topic.
        # @!attribute [rw] partitions
        #   @return [::Google::Protobuf::Map{::Integer => ::Google::Cloud::ManagedKafka::V1::ConsumerPartitionMetadata}]
        #     Optional. Metadata for this consumer group and topic for all partition
        #     indexes it has metadata for.
        class ConsumerTopicMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::Integer]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ManagedKafka::V1::ConsumerPartitionMetadata]
          class PartitionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata for a consumer group corresponding to a specific partition.
        # @!attribute [rw] offset
        #   @return [::Integer]
        #     Required. The current offset for this partition, or 0 if no offset has been
        #     committed.
        # @!attribute [rw] metadata
        #   @return [::String]
        #     Optional. The associated metadata for this partition, or empty if it does
        #     not exist.
        class ConsumerPartitionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Kafka consumer group in a given cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the consumer group. The `consumer_group` segment is
        #     used when connecting directly to the cluster. Structured like:
        #     projects/\\{project}/locations/\\{location}/clusters/\\{cluster}/consumerGroups/\\{consumer_group}
        # @!attribute [rw] topics
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::ManagedKafka::V1::ConsumerTopicMetadata}]
        #     Optional. Metadata for this consumer group for all topics it has metadata
        #     for. The key of the map is a topic name, structured like:
        #     projects/\\{project}/locations/\\{location}/clusters/\\{cluster}/topics/\\{topic}
        class ConsumerGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::ManagedKafka::V1::ConsumerTopicMetadata]
          class TopicsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An Apache Kafka Connect cluster deployed in a location.
        # @!attribute [rw] gcp_config
        #   @return [::Google::Cloud::ManagedKafka::V1::ConnectGcpConfig]
        #     Required. Configuration properties for a Kafka Connect cluster deployed
        #     to Google Cloud Platform.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the Kafka Connect cluster. Structured like:
        #     projects/\\{project_number}/locations/\\{location}/connectClusters/\\{connect_cluster_id}
        # @!attribute [rw] kafka_cluster
        #   @return [::String]
        #     Required. Immutable. The name of the Kafka cluster this Kafka Connect
        #     cluster is attached to. Structured like:
        #     projects/\\{project}/locations/\\{location}/clusters/\\{cluster}
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the cluster was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the cluster was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs.
        # @!attribute [rw] capacity_config
        #   @return [::Google::Cloud::ManagedKafka::V1::CapacityConfig]
        #     Required. Capacity configuration for the Kafka Connect cluster.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ManagedKafka::V1::ConnectCluster::State]
        #     Output only. The current state of the cluster.
        # @!attribute [rw] config
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Configurations for the worker that are overridden from the
        #     defaults. The key of the map is a Kafka Connect worker property name, for
        #     example: `exactly.once.source.support`.
        class ConnectCluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ConfigEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of the cluster.
          module State
            # A state was not specified.
            STATE_UNSPECIFIED = 0

            # The cluster is being created.
            CREATING = 1

            # The cluster is active.
            ACTIVE = 2

            # The cluster is being deleted.
            DELETING = 3
          end
        end

        # The configuration of a Virtual Private Cloud (VPC) network that can access
        # the Kafka Connect cluster.
        # @!attribute [rw] primary_subnet
        #   @return [::String]
        #     Required. VPC subnet to make available to the Kafka Connect cluster.
        #     Structured like:
        #     projects/\\{project}/regions/\\{region}/subnetworks/\\{subnet_id}
        #
        #     It is used to create a Private Service Connect (PSC) interface for the
        #     Kafka Connect workers. It must be located in the same region as the
        #     Kafka Connect cluster.
        #
        #     The CIDR range of the subnet must be within the IPv4 address ranges for
        #     private networks, as specified in RFC 1918. The primary subnet CIDR range
        #     must have a minimum size of /22 (1024 addresses).
        # @!attribute [rw] additional_subnets
        #   @return [::Array<::String>]
        #     Optional. Additional subnets may be specified. They may be in another
        #     region, but must be in the same VPC network. The Connect workers can
        #     communicate with network endpoints in either the primary or additional
        #     subnets.
        # @!attribute [rw] dns_domain_names
        #   @return [::Array<::String>]
        #     Optional. Additional DNS domain names from the subnet's network to be made
        #     visible to the Connect Cluster. When using MirrorMaker2, it's necessary to
        #     add the bootstrap address's dns domain name of the target cluster to make
        #     it visible to the connector. For example:
        #     my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog
        class ConnectNetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration of access to the Kafka Connect cluster.
        # @!attribute [rw] network_configs
        #   @return [::Array<::Google::Cloud::ManagedKafka::V1::ConnectNetworkConfig>]
        #     Required.
        #     Virtual Private Cloud (VPC) networks that must be granted direct access to
        #     the Kafka Connect cluster. Minimum of 1 network is required. Maximum 10
        #     networks can be specified.
        class ConnectAccessConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration properties for a Kafka Connect cluster deployed to Google Cloud
        # Platform.
        # @!attribute [rw] access_config
        #   @return [::Google::Cloud::ManagedKafka::V1::ConnectAccessConfig]
        #     Required. Access configuration for the Kafka Connect cluster.
        # @!attribute [rw] secret_paths
        #   @return [::Array<::String>]
        #     Optional. Secrets to load into workers. Exact SecretVersions from Secret
        #     Manager must be provided -- aliases are not supported. Up to 32 secrets may
        #     be loaded into one cluster. Format:
        #     projects/<project-id>/secrets/<secret-name>/versions/<version-id>
        class ConnectGcpConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Kafka Connect connector in a given ConnectCluster.
        # @!attribute [rw] task_restart_policy
        #   @return [::Google::Cloud::ManagedKafka::V1::TaskRetryPolicy]
        #     Optional. Restarts the individual tasks of a Connector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the connector.
        #     Structured like:
        #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connect_cluster}/connectors/\\{connector}
        # @!attribute [rw] configs
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Connector config as keys/values.
        #     The keys of the map are connector property names, for example:
        #     `connector.class`, `tasks.max`, `key.converter`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::ManagedKafka::V1::Connector::State]
        #     Output only. The current state of the connector.
        class Connector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ConfigsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of the connector.
          module State
            # A state was not specified.
            STATE_UNSPECIFIED = 0

            # The connector is not assigned to any tasks, usually transient.
            UNASSIGNED = 1

            # The connector is running.
            RUNNING = 2

            # The connector has been paused.
            PAUSED = 3

            # The connector has failed. See logs for why.
            FAILED = 4

            # The connector is restarting.
            RESTARTING = 5

            # The connector has been stopped.
            STOPPED = 6
          end
        end

        # Task Retry Policy is implemented on a best-effort
        # basis.
        # Retry delay will be exponential based on provided minimum and maximum
        # backoffs. https://en.wikipedia.org/wiki/Exponential_backoff.
        # Note that the delay between consecutive task restarts may not always
        # precisely match the configured settings. This can happen when the
        # ConnectCluster is in rebalancing state or if the ConnectCluster is
        # unresponsive etc. The default values for minimum and maximum backoffs are
        # 60 seconds and 30 minutes respectively.
        # @!attribute [rw] minimum_backoff
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The minimum amount of time to wait before retrying a failed task.
        #     This sets a lower bound for the backoff delay.
        # @!attribute [rw] maximum_backoff
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The maximum amount of time to wait before retrying a failed task.
        #     This sets an upper bound for the backoff delay.
        class TaskRetryPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the set of ACLs for a given Kafka Resource Pattern, which consists
        # of resource_type, resource_name and pattern_type.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name for the acl. Represents a single Resource Pattern.
        #     Structured like:
        #     projects/\\{project}/locations/\\{location}/clusters/\\{cluster}/acls/\\{acl_id}
        #
        #     The structure of `acl_id` defines the Resource Pattern (resource_type,
        #     resource_name, pattern_type) of the acl. `acl_id` is structured like one of
        #     the following:
        #
        #     For acls on the cluster:
        #       `cluster`
        #
        #     For acls on a single resource within the cluster:
        #       `topic/{resource_name}`
        #       `consumerGroup/{resource_name}`
        #       `transactionalId/{resource_name}`
        #
        #     For acls on all resources that match a prefix:
        #       `topicPrefixed/{resource_name}`
        #       `consumerGroupPrefixed/{resource_name}`
        #       `transactionalIdPrefixed/{resource_name}`
        #
        #     For acls on all resources of a given type (i.e. the wildcard literal "*"):
        #       `allTopics` (represents `topic/*`)
        #       `allConsumerGroups` (represents `consumerGroup/*`)
        #       `allTransactionalIds` (represents `transactionalId/*`)
        # @!attribute [rw] acl_entries
        #   @return [::Array<::Google::Cloud::ManagedKafka::V1::AclEntry>]
        #     Required. The ACL entries that apply to the resource pattern. The maximum
        #     number of allowed entries 100.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. `etag` is used for concurrency control. An `etag` is returned in
        #     the response to `GetAcl` and `CreateAcl`. Callers are required to put that
        #     etag in the request to `UpdateAcl` to ensure that their change will be
        #     applied to the same version of the acl that exists in the Kafka Cluster.
        #
        #     A terminal 'T' character in the etag indicates that the AclEntries were
        #     truncated; more entries for the Acl exist on the Kafka Cluster, but can't
        #     be returned in the Acl due to repeated field limits.
        # @!attribute [r] resource_type
        #   @return [::String]
        #     Output only. The ACL resource type derived from the name. One of: CLUSTER,
        #     TOPIC, GROUP, TRANSACTIONAL_ID.
        # @!attribute [r] resource_name
        #   @return [::String]
        #     Output only. The ACL resource name derived from the name. For cluster
        #     resource_type, this is always "kafka-cluster". Can be the wildcard literal
        #     "*".
        # @!attribute [r] pattern_type
        #   @return [::String]
        #     Output only. The ACL pattern type derived from the name. One of: LITERAL,
        #     PREFIXED.
        class Acl
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the access granted for a given Resource Pattern in an ACL.
        # @!attribute [rw] principal
        #   @return [::String]
        #     Required. The principal. Specified as Google Cloud account, with the Kafka
        #     StandardAuthorizer prefix "User:". For example:
        #     "User:test-kafka-client@test-project.iam.gserviceaccount.com".
        #     Can be the wildcard "User:*" to refer to all users.
        # @!attribute [rw] permission_type
        #   @return [::String]
        #     Required. The permission type. Accepted values are (case insensitive):
        #     ALLOW, DENY.
        # @!attribute [rw] operation
        #   @return [::String]
        #     Required. The operation type. Allowed values are (case insensitive): ALL,
        #     READ, WRITE, CREATE, DELETE, ALTER, DESCRIBE, CLUSTER_ACTION,
        #     DESCRIBE_CONFIGS, ALTER_CONFIGS, and IDEMPOTENT_WRITE. See
        #     https://kafka.apache.org/documentation/#operations_resources_and_protocols
        #     for valid combinations of resource_type and operation for different Kafka
        #     API requests.
        # @!attribute [rw] host
        #   @return [::String]
        #     Required. The host. Must be set to "*" for Managed Service for Apache
        #     Kafka.
        class AclEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
