# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ManagedKafka
      module V1
        # Request for GetConnectCluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Kafka Connect cluster whose configuration to
        #     return. Structured like
        #     `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
        class GetConnectClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateConnectCluster.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent project/location in which to create the Kafka Connect
        #     cluster. Structured like
        #     `projects/{project}/locations/{location}/`.
        # @!attribute [rw] connect_cluster_id
        #   @return [::String]
        #     Required. The ID to use for the Connect cluster, which will become the
        #     final component of the cluster's name. The ID must be 1-63 characters long,
        #     and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply
        #     with RFC 1035.
        #
        #     This value is structured like: `my-cluster-id`.
        # @!attribute [rw] connect_cluster
        #   @return [::Google::Cloud::ManagedKafka::V1::ConnectCluster]
        #     Required. Configuration of the Kafka Connect cluster to create. Its `name`
        #     field is ignored.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID to avoid duplication of requests. If a request times out or
        #     fails, retrying with the same ID allows the server to recognize the
        #     previous attempt. For at least 60 minutes, the server ignores duplicate
        #     requests bearing the same ID.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID
        #     within 60 minutes of the last request, the server checks if an original
        #     operation with the same request ID was received. If so, the server ignores
        #     the second request.
        #
        #     The request ID must be a valid UUID. A zero UUID is not supported
        #     (00000000-0000-0000-0000-000000000000).
        class CreateConnectClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateConnectCluster.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     cluster resource by the update. The fields specified in the update_mask are
        #     relative to the resource, not the full request. A field will be overwritten
        #     if it is in the mask. The mask is required and a value of * will update all
        #     fields.
        # @!attribute [rw] connect_cluster
        #   @return [::Google::Cloud::ManagedKafka::V1::ConnectCluster]
        #     Required. The Kafka Connect cluster to update. Its `name` field must be
        #     populated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID to avoid duplication of requests. If a request times out or
        #     fails, retrying with the same ID allows the server to recognize the
        #     previous attempt. For at least 60 minutes, the server ignores duplicate
        #     requests bearing the same ID.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID
        #     within 60 minutes of the last request, the server checks if an original
        #     operation with the same request ID was received. If so, the server ignores
        #     the second request.
        #
        #     The request ID must be a valid UUID. A zero UUID is not supported
        #     (00000000-0000-0000-0000-000000000000).
        class UpdateConnectClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteConnectCluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Kafka Connect cluster to delete.
        #     Structured like
        #     `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID to avoid duplication of requests. If a request times out or
        #     fails, retrying with the same ID allows the server to recognize the
        #     previous attempt. For at least 60 minutes, the server ignores duplicate
        #     requests bearing the same ID.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID
        #     within 60 minutes of the last request, the server checks if an original
        #     operation with the same request ID was received. If so, the server ignores
        #     the second request.
        #
        #     The request ID must be a valid UUID. A zero UUID is not supported
        #     (00000000-0000-0000-0000-000000000000).
        class DeleteConnectClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListConnectClusters.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent project/location whose Connect clusters are to be
        #     listed. Structured like `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of Connect clusters to return. The service may
        #     return fewer than this value. If unspecified, server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListConnectClusters`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListConnectClusters`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter expression for the result.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListConnectClustersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListConnectClusters.
        # @!attribute [rw] connect_clusters
        #   @return [::Array<::Google::Cloud::ManagedKafka::V1::ConnectCluster>]
        #     The list of Connect clusters in the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page of
        #     results. If this field is omitted, there are no more results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListConnectClustersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetConnector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the connector whose configuration to return.
        #     Structured like:
        #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
        class GetConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateConnector.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent Connect cluster in which to create the connector.
        #     Structured like
        #     `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
        # @!attribute [rw] connector_id
        #   @return [::String]
        #     Required. The ID to use for the connector, which will become the final
        #     component of the connector's name. The ID must be 1-63 characters long, and
        #     match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
        #     RFC 1035.
        #
        #     This value is structured like: `my-connector-id`.
        # @!attribute [rw] connector
        #   @return [::Google::Cloud::ManagedKafka::V1::Connector]
        #     Required. The connector to create.
        class CreateConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateConnector.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     cluster resource by the update. The fields specified in the update_mask are
        #     relative to the resource, not the full request. A field will be overwritten
        #     if it is in the mask. The mask is required and a value of * will update all
        #     fields.
        # @!attribute [rw] connector
        #   @return [::Google::Cloud::ManagedKafka::V1::Connector]
        #     Required. The connector to update. Its `name` field must be populated.
        class UpdateConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteConnector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the connector to delete.
        #     Structured like:
        #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
        class DeleteConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListConnectors.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent Connect cluster whose connectors are to be listed.
        #     Structured like
        #     `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of connectors to return. The service may
        #     return fewer than this value. If unspecified, server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListConnectors` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListConnectors`
        #     must match the call that provided the page token.
        class ListConnectorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListConnectors.
        # @!attribute [rw] connectors
        #   @return [::Array<::Google::Cloud::ManagedKafka::V1::Connector>]
        #     The list of connectors in the requested parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page of
        #     results. If this field is omitted, there are no more results.
        class ListConnectorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for PauseConnector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the connector to pause.
        #     Structured like:
        #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
        class PauseConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for PauseConnector.
        class PauseConnectorResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ResumeConnector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the connector to pause.
        #     Structured like:
        #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
        class ResumeConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ResumeConnector.
        class ResumeConnectorResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for RestartConnector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the connector to restart.
        #     Structured like:
        #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
        class RestartConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for RestartConnector.
        class RestartConnectorResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for StopConnector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the connector to stop.
        #     Structured like:
        #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
        class StopConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for StopConnector.
        class StopConnectorResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
