# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/managedkafka/v1/managed_kafka_connect_pb"
require "google/cloud/managed_kafka/v1/managed_kafka_connect/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module ManagedKafka
      module V1
        module ManagedKafkaConnect
          module Rest
            ##
            # REST client for the ManagedKafkaConnect service.
            #
            # The service that a client application uses to manage Apache Kafka Connect
            # clusters and connectors.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "managedkafka.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :managed_kafka_connect_stub

              ##
              # Configure the ManagedKafkaConnect Client class.
              #
              # See {::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ManagedKafkaConnect clients
              #   ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ManagedKafka", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_connect_clusters.timeout = 60.0
                  default_config.rpcs.list_connect_clusters.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_connect_cluster.timeout = 60.0
                  default_config.rpcs.get_connect_cluster.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_connect_cluster.timeout = 60.0

                  default_config.rpcs.update_connect_cluster.timeout = 60.0

                  default_config.rpcs.delete_connect_cluster.timeout = 60.0

                  default_config.rpcs.list_connectors.timeout = 60.0
                  default_config.rpcs.list_connectors.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_connector.timeout = 60.0
                  default_config.rpcs.get_connector.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_connector.timeout = 60.0

                  default_config.rpcs.update_connector.timeout = 60.0

                  default_config.rpcs.delete_connector.timeout = 60.0

                  default_config.rpcs.pause_connector.timeout = 60.0

                  default_config.rpcs.resume_connector.timeout = 60.0

                  default_config.rpcs.restart_connector.timeout = 60.0

                  default_config.rpcs.stop_connector.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ManagedKafkaConnect Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @managed_kafka_connect_stub.universe_domain
              end

              ##
              # Create a new ManagedKafkaConnect REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ManagedKafkaConnect client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @managed_kafka_connect_stub = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @managed_kafka_connect_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @managed_kafka_connect_stub.endpoint
                  config.universe_domain = @managed_kafka_connect_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @managed_kafka_connect_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @managed_kafka_connect_stub.logger
              end

              # Service calls

              ##
              # Lists the Kafka Connect clusters in a given project and location.
              #
              # @overload list_connect_clusters(request, options = nil)
              #   Pass arguments to `list_connect_clusters` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::ListConnectClustersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::ListConnectClustersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_connect_clusters(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_connect_clusters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent project/location whose Connect clusters are to be
              #     listed. Structured like `projects/{project}/locations/{location}`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of Connect clusters to return. The service may
              #     return fewer than this value. If unspecified, server will pick an
              #     appropriate default.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListConnectClusters`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListConnectClusters`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter expression for the result.
              #   @param order_by [::String]
              #     Optional. Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ManagedKafka::V1::ConnectCluster>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ManagedKafka::V1::ConnectCluster>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::ListConnectClustersRequest.new
              #
              #   # Call the list_connect_clusters method.
              #   result = client.list_connect_clusters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ManagedKafka::V1::ConnectCluster.
              #     p item
              #   end
              #
              def list_connect_clusters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::ListConnectClustersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_connect_clusters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_connect_clusters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_connect_clusters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.list_connect_clusters request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @managed_kafka_connect_stub, :list_connect_clusters, "connect_clusters", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the properties of a single Kafka Connect cluster.
              #
              # @overload get_connect_cluster(request, options = nil)
              #   Pass arguments to `get_connect_cluster` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::GetConnectClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::GetConnectClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_connect_cluster(name: nil)
              #   Pass arguments to `get_connect_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Kafka Connect cluster whose configuration to
              #     return. Structured like
              #     `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ManagedKafka::V1::ConnectCluster]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ManagedKafka::V1::ConnectCluster]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::GetConnectClusterRequest.new
              #
              #   # Call the get_connect_cluster method.
              #   result = client.get_connect_cluster request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::V1::ConnectCluster.
              #   p result
              #
              def get_connect_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::GetConnectClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_connect_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_connect_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_connect_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.get_connect_cluster request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Kafka Connect cluster in a given project and location.
              #
              # @overload create_connect_cluster(request, options = nil)
              #   Pass arguments to `create_connect_cluster` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::CreateConnectClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::CreateConnectClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_connect_cluster(parent: nil, connect_cluster_id: nil, connect_cluster: nil, request_id: nil)
              #   Pass arguments to `create_connect_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent project/location in which to create the Kafka Connect
              #     cluster. Structured like
              #     `projects/{project}/locations/{location}/`.
              #   @param connect_cluster_id [::String]
              #     Required. The ID to use for the Connect cluster, which will become the
              #     final component of the cluster's name. The ID must be 1-63 characters long,
              #     and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply
              #     with RFC 1035.
              #
              #     This value is structured like: `my-cluster-id`.
              #   @param connect_cluster [::Google::Cloud::ManagedKafka::V1::ConnectCluster, ::Hash]
              #     Required. Configuration of the Kafka Connect cluster to create. Its `name`
              #     field is ignored.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID to avoid duplication of requests. If a request times out or
              #     fails, retrying with the same ID allows the server to recognize the
              #     previous attempt. For at least 60 minutes, the server ignores duplicate
              #     requests bearing the same ID.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID
              #     within 60 minutes of the last request, the server checks if an original
              #     operation with the same request ID was received. If so, the server ignores
              #     the second request.
              #
              #     The request ID must be a valid UUID. A zero UUID is not supported
              #     (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::CreateConnectClusterRequest.new
              #
              #   # Call the create_connect_cluster method.
              #   result = client.create_connect_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_connect_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::CreateConnectClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_connect_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_connect_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_connect_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.create_connect_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the properties of a single Kafka Connect cluster.
              #
              # @overload update_connect_cluster(request, options = nil)
              #   Pass arguments to `update_connect_cluster` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::UpdateConnectClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::UpdateConnectClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_connect_cluster(update_mask: nil, connect_cluster: nil, request_id: nil)
              #   Pass arguments to `update_connect_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     cluster resource by the update. The fields specified in the update_mask are
              #     relative to the resource, not the full request. A field will be overwritten
              #     if it is in the mask. The mask is required and a value of * will update all
              #     fields.
              #   @param connect_cluster [::Google::Cloud::ManagedKafka::V1::ConnectCluster, ::Hash]
              #     Required. The Kafka Connect cluster to update. Its `name` field must be
              #     populated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID to avoid duplication of requests. If a request times out or
              #     fails, retrying with the same ID allows the server to recognize the
              #     previous attempt. For at least 60 minutes, the server ignores duplicate
              #     requests bearing the same ID.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID
              #     within 60 minutes of the last request, the server checks if an original
              #     operation with the same request ID was received. If so, the server ignores
              #     the second request.
              #
              #     The request ID must be a valid UUID. A zero UUID is not supported
              #     (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::UpdateConnectClusterRequest.new
              #
              #   # Call the update_connect_cluster method.
              #   result = client.update_connect_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_connect_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::UpdateConnectClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_connect_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_connect_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_connect_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.update_connect_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Connect cluster.
              #
              # @overload delete_connect_cluster(request, options = nil)
              #   Pass arguments to `delete_connect_cluster` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::DeleteConnectClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::DeleteConnectClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_connect_cluster(name: nil, request_id: nil)
              #   Pass arguments to `delete_connect_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Kafka Connect cluster to delete.
              #     Structured like
              #     `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID to avoid duplication of requests. If a request times out or
              #     fails, retrying with the same ID allows the server to recognize the
              #     previous attempt. For at least 60 minutes, the server ignores duplicate
              #     requests bearing the same ID.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID
              #     within 60 minutes of the last request, the server checks if an original
              #     operation with the same request ID was received. If so, the server ignores
              #     the second request.
              #
              #     The request ID must be a valid UUID. A zero UUID is not supported
              #     (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::DeleteConnectClusterRequest.new
              #
              #   # Call the delete_connect_cluster method.
              #   result = client.delete_connect_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_connect_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::DeleteConnectClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_connect_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_connect_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_connect_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.delete_connect_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the connectors in a given Connect cluster.
              #
              # @overload list_connectors(request, options = nil)
              #   Pass arguments to `list_connectors` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::ListConnectorsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::ListConnectorsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_connectors(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_connectors` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent Connect cluster whose connectors are to be listed.
              #     Structured like
              #     `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of connectors to return. The service may
              #     return fewer than this value. If unspecified, server will pick an
              #     appropriate default.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListConnectors` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListConnectors`
              #     must match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ManagedKafka::V1::Connector>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ManagedKafka::V1::Connector>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::ListConnectorsRequest.new
              #
              #   # Call the list_connectors method.
              #   result = client.list_connectors request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ManagedKafka::V1::Connector.
              #     p item
              #   end
              #
              def list_connectors request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::ListConnectorsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_connectors.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_connectors.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_connectors.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.list_connectors request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @managed_kafka_connect_stub, :list_connectors, "connectors", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the properties of a single connector.
              #
              # @overload get_connector(request, options = nil)
              #   Pass arguments to `get_connector` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::GetConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::GetConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_connector(name: nil)
              #   Pass arguments to `get_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the connector whose configuration to return.
              #     Structured like:
              #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ManagedKafka::V1::Connector]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ManagedKafka::V1::Connector]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::GetConnectorRequest.new
              #
              #   # Call the get_connector method.
              #   result = client.get_connector request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::V1::Connector.
              #   p result
              #
              def get_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::GetConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.get_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new connector in a given Connect cluster.
              #
              # @overload create_connector(request, options = nil)
              #   Pass arguments to `create_connector` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::CreateConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::CreateConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_connector(parent: nil, connector_id: nil, connector: nil)
              #   Pass arguments to `create_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent Connect cluster in which to create the connector.
              #     Structured like
              #     `projects/{project}/locations/{location}/connectClusters/{connect_cluster_id}`.
              #   @param connector_id [::String]
              #     Required. The ID to use for the connector, which will become the final
              #     component of the connector's name. The ID must be 1-63 characters long, and
              #     match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` to comply with
              #     RFC 1035.
              #
              #     This value is structured like: `my-connector-id`.
              #   @param connector [::Google::Cloud::ManagedKafka::V1::Connector, ::Hash]
              #     Required. The connector to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ManagedKafka::V1::Connector]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ManagedKafka::V1::Connector]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::CreateConnectorRequest.new
              #
              #   # Call the create_connector method.
              #   result = client.create_connector request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::V1::Connector.
              #   p result
              #
              def create_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::CreateConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.create_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the properties of a connector.
              #
              # @overload update_connector(request, options = nil)
              #   Pass arguments to `update_connector` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::UpdateConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::UpdateConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_connector(update_mask: nil, connector: nil)
              #   Pass arguments to `update_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     cluster resource by the update. The fields specified in the update_mask are
              #     relative to the resource, not the full request. A field will be overwritten
              #     if it is in the mask. The mask is required and a value of * will update all
              #     fields.
              #   @param connector [::Google::Cloud::ManagedKafka::V1::Connector, ::Hash]
              #     Required. The connector to update. Its `name` field must be populated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ManagedKafka::V1::Connector]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ManagedKafka::V1::Connector]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::UpdateConnectorRequest.new
              #
              #   # Call the update_connector method.
              #   result = client.update_connector request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::V1::Connector.
              #   p result
              #
              def update_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::UpdateConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.update_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a connector.
              #
              # @overload delete_connector(request, options = nil)
              #   Pass arguments to `delete_connector` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::DeleteConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::DeleteConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_connector(name: nil)
              #   Pass arguments to `delete_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the connector to delete.
              #     Structured like:
              #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::DeleteConnectorRequest.new
              #
              #   # Call the delete_connector method.
              #   result = client.delete_connector request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::DeleteConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.delete_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Pauses the connector and its tasks.
              #
              # @overload pause_connector(request, options = nil)
              #   Pass arguments to `pause_connector` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::PauseConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::PauseConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload pause_connector(name: nil)
              #   Pass arguments to `pause_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the connector to pause.
              #     Structured like:
              #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ManagedKafka::V1::PauseConnectorResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ManagedKafka::V1::PauseConnectorResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::PauseConnectorRequest.new
              #
              #   # Call the pause_connector method.
              #   result = client.pause_connector request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::V1::PauseConnectorResponse.
              #   p result
              #
              def pause_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::PauseConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.pause_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.pause_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.pause_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.pause_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resumes the connector and its tasks.
              #
              # @overload resume_connector(request, options = nil)
              #   Pass arguments to `resume_connector` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::ResumeConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::ResumeConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resume_connector(name: nil)
              #   Pass arguments to `resume_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the connector to pause.
              #     Structured like:
              #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ManagedKafka::V1::ResumeConnectorResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ManagedKafka::V1::ResumeConnectorResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::ResumeConnectorRequest.new
              #
              #   # Call the resume_connector method.
              #   result = client.resume_connector request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::V1::ResumeConnectorResponse.
              #   p result
              #
              def resume_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::ResumeConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resume_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resume_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resume_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.resume_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Restarts the connector.
              #
              # @overload restart_connector(request, options = nil)
              #   Pass arguments to `restart_connector` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::RestartConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::RestartConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload restart_connector(name: nil)
              #   Pass arguments to `restart_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the connector to restart.
              #     Structured like:
              #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ManagedKafka::V1::RestartConnectorResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ManagedKafka::V1::RestartConnectorResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::RestartConnectorRequest.new
              #
              #   # Call the restart_connector method.
              #   result = client.restart_connector request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::V1::RestartConnectorResponse.
              #   p result
              #
              def restart_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::RestartConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.restart_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.restart_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.restart_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.restart_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops the connector.
              #
              # @overload stop_connector(request, options = nil)
              #   Pass arguments to `stop_connector` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::V1::StopConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::V1::StopConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_connector(name: nil)
              #   Pass arguments to `stop_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the connector to stop.
              #     Structured like:
              #     projects/\\{project}/locations/\\{location}/connectClusters/\\{connectCluster}/connectors/\\{connector}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ManagedKafka::V1::StopConnectorResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ManagedKafka::V1::StopConnectorResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::V1::StopConnectorRequest.new
              #
              #   # Call the stop_connector method.
              #   result = client.stop_connector request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::V1::StopConnectorResponse.
              #   p result
              #
              def stop_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::V1::StopConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_kafka_connect_stub.stop_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ManagedKafkaConnect REST API.
              #
              # This class represents the configuration for ManagedKafkaConnect REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_connect_clusters to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_connect_clusters.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_connect_clusters.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "managedkafka.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ManagedKafkaConnect API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_connect_clusters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_connect_clusters
                  ##
                  # RPC-specific configuration for `get_connect_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_connect_cluster
                  ##
                  # RPC-specific configuration for `create_connect_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_connect_cluster
                  ##
                  # RPC-specific configuration for `update_connect_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_connect_cluster
                  ##
                  # RPC-specific configuration for `delete_connect_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_connect_cluster
                  ##
                  # RPC-specific configuration for `list_connectors`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_connectors
                  ##
                  # RPC-specific configuration for `get_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_connector
                  ##
                  # RPC-specific configuration for `create_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_connector
                  ##
                  # RPC-specific configuration for `update_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_connector
                  ##
                  # RPC-specific configuration for `delete_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_connector
                  ##
                  # RPC-specific configuration for `pause_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :pause_connector
                  ##
                  # RPC-specific configuration for `resume_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resume_connector
                  ##
                  # RPC-specific configuration for `restart_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restart_connector
                  ##
                  # RPC-specific configuration for `stop_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_connector

                  # @private
                  def initialize parent_rpcs = nil
                    list_connect_clusters_config = parent_rpcs.list_connect_clusters if parent_rpcs.respond_to? :list_connect_clusters
                    @list_connect_clusters = ::Gapic::Config::Method.new list_connect_clusters_config
                    get_connect_cluster_config = parent_rpcs.get_connect_cluster if parent_rpcs.respond_to? :get_connect_cluster
                    @get_connect_cluster = ::Gapic::Config::Method.new get_connect_cluster_config
                    create_connect_cluster_config = parent_rpcs.create_connect_cluster if parent_rpcs.respond_to? :create_connect_cluster
                    @create_connect_cluster = ::Gapic::Config::Method.new create_connect_cluster_config
                    update_connect_cluster_config = parent_rpcs.update_connect_cluster if parent_rpcs.respond_to? :update_connect_cluster
                    @update_connect_cluster = ::Gapic::Config::Method.new update_connect_cluster_config
                    delete_connect_cluster_config = parent_rpcs.delete_connect_cluster if parent_rpcs.respond_to? :delete_connect_cluster
                    @delete_connect_cluster = ::Gapic::Config::Method.new delete_connect_cluster_config
                    list_connectors_config = parent_rpcs.list_connectors if parent_rpcs.respond_to? :list_connectors
                    @list_connectors = ::Gapic::Config::Method.new list_connectors_config
                    get_connector_config = parent_rpcs.get_connector if parent_rpcs.respond_to? :get_connector
                    @get_connector = ::Gapic::Config::Method.new get_connector_config
                    create_connector_config = parent_rpcs.create_connector if parent_rpcs.respond_to? :create_connector
                    @create_connector = ::Gapic::Config::Method.new create_connector_config
                    update_connector_config = parent_rpcs.update_connector if parent_rpcs.respond_to? :update_connector
                    @update_connector = ::Gapic::Config::Method.new update_connector_config
                    delete_connector_config = parent_rpcs.delete_connector if parent_rpcs.respond_to? :delete_connector
                    @delete_connector = ::Gapic::Config::Method.new delete_connector_config
                    pause_connector_config = parent_rpcs.pause_connector if parent_rpcs.respond_to? :pause_connector
                    @pause_connector = ::Gapic::Config::Method.new pause_connector_config
                    resume_connector_config = parent_rpcs.resume_connector if parent_rpcs.respond_to? :resume_connector
                    @resume_connector = ::Gapic::Config::Method.new resume_connector_config
                    restart_connector_config = parent_rpcs.restart_connector if parent_rpcs.respond_to? :restart_connector
                    @restart_connector = ::Gapic::Config::Method.new restart_connector_config
                    stop_connector_config = parent_rpcs.stop_connector if parent_rpcs.respond_to? :stop_connector
                    @stop_connector = ::Gapic::Config::Method.new stop_connector_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
