# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ManagedKafka
      module V1
        module ManagedKafkaConnect
          # Path helper methods for the ManagedKafkaConnect API.
          module Paths
            ##
            # Create a fully-qualified ConnectCluster resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connectClusters/{connect_cluster}`
            #
            # @param project [String]
            # @param location [String]
            # @param connect_cluster [String]
            #
            # @return [::String]
            def connect_cluster_path project:, location:, connect_cluster:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connectClusters/#{connect_cluster}"
            end

            ##
            # Create a fully-qualified Connector resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connectClusters/{connect_cluster}/connectors/{connector}`
            #
            # @param project [String]
            # @param location [String]
            # @param connect_cluster [String]
            # @param connector [String]
            #
            # @return [::String]
            def connector_path project:, location:, connect_cluster:, connector:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "connect_cluster cannot contain /" if connect_cluster.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connectClusters/#{connect_cluster}/connectors/#{connector}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified SecretVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/secrets/{secret}/versions/{secret_version}`
            #
            # @param project [String]
            # @param secret [String]
            # @param secret_version [String]
            #
            # @return [::String]
            def secret_version_path project:, secret:, secret_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

              "projects/#{project}/secrets/#{secret}/versions/#{secret_version}"
            end

            extend self
          end
        end
      end
    end
  end
end
