# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/managed_kafka/v1/version"

require "google/cloud/managed_kafka/v1/managed_kafka_connect/credentials"
require "google/cloud/managed_kafka/v1/managed_kafka_connect/paths"
require "google/cloud/managed_kafka/v1/managed_kafka_connect/operations"
require "google/cloud/managed_kafka/v1/managed_kafka_connect/client"
require "google/cloud/managed_kafka/v1/managed_kafka_connect/rest"

module Google
  module Cloud
    module ManagedKafka
      module V1
        ##
        # The service that a client application uses to manage Apache Kafka Connect
        # clusters and connectors.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/managed_kafka/v1/managed_kafka_connect"
        #     client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/managed_kafka/v1/managed_kafka_connect/rest"
        #     client = ::Google::Cloud::ManagedKafka::V1::ManagedKafkaConnect::Rest::Client.new
        #
        module ManagedKafkaConnect
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "managed_kafka_connect", "helpers.rb"
require "google/cloud/managed_kafka/v1/managed_kafka_connect/helpers" if ::File.file? helper_path
