# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/managed_kafka/v1/version"

require "google/cloud/managed_kafka/v1/managed_kafka/credentials"
require "google/cloud/managed_kafka/v1/managed_kafka/paths"
require "google/cloud/managed_kafka/v1/managed_kafka/operations"
require "google/cloud/managed_kafka/v1/managed_kafka/client"
require "google/cloud/managed_kafka/v1/managed_kafka/rest"

module Google
  module Cloud
    module ManagedKafka
      module V1
        ##
        # The service that a client application uses to manage Apache Kafka clusters,
        # topics and consumer groups.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/managed_kafka/v1/managed_kafka"
        #     client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/managed_kafka/v1/managed_kafka/rest"
        #     client = ::Google::Cloud::ManagedKafka::V1::ManagedKafka::Rest::Client.new
        #
        module ManagedKafka
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "managed_kafka", "helpers.rb"
require "google/cloud/managed_kafka/v1/managed_kafka/helpers" if ::File.file? helper_path
