# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/managed_kafka/schema_registry/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :managed_kafka_schema_registry do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module ManagedKafka
      module SchemaRegistry
        ##
        # Create a new client object for ManagedSchemaRegistry.
        #
        # By default, this returns an instance of
        # [Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-managed_kafka-schema_registry-v1/latest/Google-Cloud-ManagedKafka-SchemaRegistry-V1-ManagedSchemaRegistry-Client)
        # for a gRPC client for version V1 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the ManagedSchemaRegistry service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the ManagedSchemaRegistry service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::ManagedKafka::SchemaRegistry.managed_schema_registry_available?}.
        #
        # ## About ManagedSchemaRegistry
        #
        # SchemaRegistry is a service that allows users to manage schemas for their
        # Kafka clusters. It provides APIs to register, list, and delete schemas, as
        # well as to get the schema for a given schema id or a given version id under a
        # subject, to update the global or subject-specific compatibility mode, and to
        # check the compatibility of a schema against a subject or a version. The main
        # resource hierarchy is as follows:
        #
        # * SchemaRegistry
        # * SchemaRegistry/Context
        # * SchemaRegistry/Context/Schema
        # * SchemaRegistry/Context/Subject
        # * SchemaRegistry/Context/Subject/Version
        # * SchemaRegistry/Config
        # * SchemaRegistry/Mode
        #
        # **SchemaRegistry** is the root resource to represent a schema registry
        # instance. A customer can have multiple schema registry instances in a
        # project.
        #
        # **Context** is a context resource that represents a group of
        # schemas, subjects and versions. A schema registry instance can have multiple
        # contexts and always has a 'default' context. Contexts are independent of each
        # other. Context is optional and if not specified, it falls back to the
        # 'default' context.
        #
        # **Schema** is a schema resource that represents a unique schema in a context
        # of a schema registry instance. Each schema has a unique schema id, and can be
        # referenced by a version of a subject.
        #
        # **Subject** refers to the name under which the schema is registered. A
        # typical subject is the Kafka topic name. A schema registry instance can have
        # multiple subjects.
        #
        # **Version** represents a version of a subject. A subject can have multiple
        # versions. Creation of new version of a subject is guarded by the
        # compatibility mode configured globally or for the subject specifically.
        #
        # **Config** represents a config at global level cross all registry
        # instances or at subject level. Currently, only compatibility is supported in
        # config.
        #
        # **Mode** represents the mode of a schema registry or a specific subject.
        # Three modes are supported:
        # * READONLY: The schema registry is in read-only mode, no write operations
        # allowed..
        # * READWRITE: The schema registry is in read-write mode, which allows limited
        # write operations on the schema.
        # * IMPORT: The schema registry is in import mode, which allows more editing
        # operations on the schema for data importing purposes.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.managed_schema_registry version: :v1, transport: :grpc, &block
          require "google/cloud/managed_kafka/schema_registry/#{version.to_s.downcase}"

          package_name = Google::Cloud::ManagedKafka::SchemaRegistry
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::ManagedKafka::SchemaRegistry.const_get(package_name).const_get(:ManagedSchemaRegistry)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the ManagedSchemaRegistry service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::ManagedKafka::SchemaRegistry.managed_schema_registry}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the ManagedSchemaRegistry service,
        # or if the versioned client gem needs an update to support the ManagedSchemaRegistry service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.managed_schema_registry_available? version: :v1, transport: :grpc
          require "google/cloud/managed_kafka/schema_registry/#{version.to_s.downcase}"
          package_name = Google::Cloud::ManagedKafka::SchemaRegistry
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::ManagedKafka::SchemaRegistry.const_get package_name
          return false unless service_module.const_defined? :ManagedSchemaRegistry
          service_module = service_module.const_get :ManagedSchemaRegistry
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Configure the google-cloud-managed_kafka-schema_registry library.
        #
        # The following configuration parameters are supported:
        #
        # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
        #   The path to the keyfile as a String, the contents of the keyfile as a
        #   Hash, or a Google::Auth::Credentials object.
        # * `lib_name` (*type:* `String`) -
        #   The library name as recorded in instrumentation and logging.
        # * `lib_version` (*type:* `String`) -
        #   The library version as recorded in instrumentation and logging.
        # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
        #   An array of interceptors that are run before calls are executed.
        # * `timeout` (*type:* `Numeric`) -
        #   Default timeout in seconds.
        # * `metadata` (*type:* `Hash{Symbol=>String}`) -
        #   Additional headers to be sent with the call.
        # * `retry_policy` (*type:* `Hash`) -
        #   The retry policy. The value is a hash with the following keys:
        #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
        #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
        #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
        #     * `:retry_codes` (*type:* `Array<String>`) -
        #       The error codes that should trigger a retry.
        #
        # @return [::Google::Cloud::Config] The default configuration used by this library
        #
        def self.configure
          yield ::Google::Cloud.configure.managed_kafka_schema_registry if block_given?

          ::Google::Cloud.configure.managed_kafka_schema_registry
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "schema_registry", "helpers.rb"
require "google/cloud/managed_kafka/schema_registry/helpers" if ::File.file? helper_path
