# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/managedkafka/schemaregistry/v1/schema_registry_pb"
require "google/cloud/managed_kafka/schema_registry/v1/managed_schema_registry"

class ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_schema_registry
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_schema_registry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_schema_registry, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_schema_registry_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_schema_registry({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_schema_registry name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_schema_registry ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_schema_registry({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_schema_registry(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_schema_registry_client_stub.call_rpc_count
    end
  end

  def test_list_schema_registries
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_schema_registries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_schema_registries, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_schema_registries_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_schema_registries({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_schema_registries parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_schema_registries ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_schema_registries({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_schema_registries(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_schema_registries_client_stub.call_rpc_count
    end
  end

  def test_create_schema_registry
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    schema_registry_id = "hello world"
    schema_registry = {}

    create_schema_registry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_schema_registry, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["schema_registry_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry), request["schema_registry"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_schema_registry_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_schema_registry({ parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_schema_registry parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_schema_registry ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest.new(parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_schema_registry({ parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_schema_registry(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest.new(parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_schema_registry_client_stub.call_rpc_count
    end
  end

  def test_delete_schema_registry
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_schema_registry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_schema_registry, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_schema_registry_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_schema_registry({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_schema_registry name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_schema_registry ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_schema_registry({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_schema_registry(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_schema_registry_client_stub.call_rpc_count
    end
  end

  def test_get_context
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Context.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_context_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_context, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_context_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_context({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_context name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_context ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_context({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_context(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_context_client_stub.call_rpc_count
    end
  end

  def test_list_contexts
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_contexts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_contexts, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_contexts_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_contexts({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_contexts parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_contexts ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_contexts({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_contexts(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_contexts_client_stub.call_rpc_count
    end
  end

  def test_get_schema
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    subject = "hello world"

    get_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_schema, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["subject"]
      assert request.has_subject?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_schema_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_schema({ name: name, subject: subject }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_schema name: name, subject: subject do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_schema ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new(name: name, subject: subject) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_schema({ name: name, subject: subject }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_schema(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new(name: name, subject: subject), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_schema_client_stub.call_rpc_count
    end
  end

  def test_get_raw_schema
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    subject = "hello world"

    get_raw_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_raw_schema, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["subject"]
      assert request.has_subject?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_raw_schema_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_raw_schema({ name: name, subject: subject }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_raw_schema name: name, subject: subject do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_raw_schema ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new(name: name, subject: subject) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_raw_schema({ name: name, subject: subject }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_raw_schema(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new(name: name, subject: subject), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_raw_schema_client_stub.call_rpc_count
    end
  end

  def test_list_schema_versions
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subject = "hello world"
    deleted = true

    list_schema_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_schema_versions, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["subject"]
      assert request.has_subject?
      assert_equal true, request["deleted"]
      assert request.has_deleted?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_schema_versions_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_schema_versions({ parent: parent, subject: subject, deleted: deleted }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_schema_versions parent: parent, subject: subject, deleted: deleted do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_schema_versions ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest.new(parent: parent, subject: subject, deleted: deleted) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_schema_versions({ parent: parent, subject: subject, deleted: deleted }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_schema_versions(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest.new(parent: parent, subject: subject, deleted: deleted), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_schema_versions_client_stub.call_rpc_count
    end
  end

  def test_list_schema_types
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_schema_types_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_schema_types, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_schema_types_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_schema_types({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_schema_types parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_schema_types ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_schema_types({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_schema_types(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_schema_types_client_stub.call_rpc_count
    end
  end

  def test_list_subjects
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subject_prefix = "hello world"
    deleted = true

    list_subjects_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subjects, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["subject_prefix"]
      assert request.has_subject_prefix?
      assert_equal true, request["deleted"]
      assert request.has_deleted?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subjects_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subjects({ parent: parent, subject_prefix: subject_prefix, deleted: deleted }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subjects parent: parent, subject_prefix: subject_prefix, deleted: deleted do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subjects ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest.new(parent: parent, subject_prefix: subject_prefix, deleted: deleted) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subjects({ parent: parent, subject_prefix: subject_prefix, deleted: deleted }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subjects(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest.new(parent: parent, subject_prefix: subject_prefix, deleted: deleted), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subjects_client_stub.call_rpc_count
    end
  end

  def test_list_subjects_by_schema_id
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subject = "hello world"
    deleted = true

    list_subjects_by_schema_id_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subjects_by_schema_id, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["subject"]
      assert request.has_subject?
      assert_equal true, request["deleted"]
      assert request.has_deleted?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subjects_by_schema_id_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subjects_by_schema_id({ parent: parent, subject: subject, deleted: deleted }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subjects_by_schema_id parent: parent, subject: subject, deleted: deleted do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subjects_by_schema_id ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest.new(parent: parent, subject: subject, deleted: deleted) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subjects_by_schema_id({ parent: parent, subject: subject, deleted: deleted }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subjects_by_schema_id(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest.new(parent: parent, subject: subject, deleted: deleted), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subjects_by_schema_id_client_stub.call_rpc_count
    end
  end

  def test_delete_subject
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    permanent = true

    delete_subject_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_subject, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["permanent"]
      assert request.has_permanent?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_subject_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_subject({ name: name, permanent: permanent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_subject name: name, permanent: permanent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_subject ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest.new(name: name, permanent: permanent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_subject({ name: name, permanent: permanent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_subject(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest.new(name: name, permanent: permanent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_subject_client_stub.call_rpc_count
    end
  end

  def test_lookup_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    schema_type = :SCHEMA_TYPE_UNSPECIFIED
    schema = "hello world"
    references = [{}]
    normalize = true
    deleted = true

    lookup_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :lookup_version, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal :SCHEMA_TYPE_UNSPECIFIED, request["schema_type"]
      assert request.has_schema_type?
      assert_equal "hello world", request["schema"]
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference, request["references"].first
      assert_equal true, request["normalize"]
      assert request.has_normalize?
      assert_equal true, request["deleted"]
      assert request.has_deleted?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, lookup_version_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.lookup_version({ parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.lookup_version parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.lookup_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest.new(parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.lookup_version({ parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.lookup_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest.new(parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, lookup_version_client_stub.call_rpc_count
    end
  end

  def test_get_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    deleted = true

    get_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_version, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["deleted"]
      assert request.has_deleted?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_version_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_version({ name: name, deleted: deleted }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_version name: name, deleted: deleted do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new(name: name, deleted: deleted) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_version({ name: name, deleted: deleted }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new(name: name, deleted: deleted), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_version_client_stub.call_rpc_count
    end
  end

  def test_get_raw_schema_version
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    deleted = true

    get_raw_schema_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_raw_schema_version, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["deleted"]
      assert request.has_deleted?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_raw_schema_version_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_raw_schema_version({ name: name, deleted: deleted }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_raw_schema_version name: name, deleted: deleted do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_raw_schema_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new(name: name, deleted: deleted) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_raw_schema_version({ name: name, deleted: deleted }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_raw_schema_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new(name: name, deleted: deleted), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_raw_schema_version_client_stub.call_rpc_count
    end
  end

  def test_list_versions
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deleted = true

    list_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_versions, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal true, request["deleted"]
      assert request.has_deleted?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_versions_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_versions({ parent: parent, deleted: deleted }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_versions parent: parent, deleted: deleted do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_versions ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest.new(parent: parent, deleted: deleted) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_versions({ parent: parent, deleted: deleted }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_versions(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest.new(parent: parent, deleted: deleted), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_versions_client_stub.call_rpc_count
    end
  end

  def test_create_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    version = 42
    id = 42
    schema_type = :SCHEMA_TYPE_UNSPECIFIED
    schema = "hello world"
    references = [{}]
    normalize = true

    create_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_version, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["version"]
      assert request.has_version?
      assert_equal 42, request["id"]
      assert request.has_id?
      assert_equal :SCHEMA_TYPE_UNSPECIFIED, request["schema_type"]
      assert request.has_schema_type?
      assert_equal "hello world", request["schema"]
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference, request["references"].first
      assert_equal true, request["normalize"]
      assert request.has_normalize?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_version_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_version({ parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_version parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest.new(parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_version({ parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest.new(parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_version_client_stub.call_rpc_count
    end
  end

  def test_delete_version
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    permanent = true

    delete_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_version, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["permanent"]
      assert request.has_permanent?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_version_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_version({ name: name, permanent: permanent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_version name: name, permanent: permanent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest.new(name: name, permanent: permanent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_version({ name: name, permanent: permanent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest.new(name: name, permanent: permanent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_version_client_stub.call_rpc_count
    end
  end

  def test_list_referenced_schemas
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_referenced_schemas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_referenced_schemas, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_referenced_schemas_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_referenced_schemas({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_referenced_schemas parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_referenced_schemas ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_referenced_schemas({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_referenced_schemas(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_referenced_schemas_client_stub.call_rpc_count
    end
  end

  def test_check_compatibility
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    schema_type = :SCHEMA_TYPE_UNSPECIFIED
    schema = "hello world"
    references = [{}]
    verbose = true

    check_compatibility_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :check_compatibility, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :SCHEMA_TYPE_UNSPECIFIED, request["schema_type"]
      assert request.has_schema_type?
      assert_equal "hello world", request["schema"]
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference, request["references"].first
      assert_equal true, request["verbose"]
      assert request.has_verbose?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, check_compatibility_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.check_compatibility({ name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.check_compatibility name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.check_compatibility ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest.new(name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.check_compatibility({ name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.check_compatibility(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest.new(name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, check_compatibility_client_stub.call_rpc_count
    end
  end

  def test_get_schema_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    default_to_global = true

    get_schema_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_schema_config, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["default_to_global"]
      assert request.has_default_to_global?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_schema_config_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_schema_config({ name: name, default_to_global: default_to_global }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_schema_config name: name, default_to_global: default_to_global do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_schema_config ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest.new(name: name, default_to_global: default_to_global) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_schema_config({ name: name, default_to_global: default_to_global }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_schema_config(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest.new(name: name, default_to_global: default_to_global), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_schema_config_client_stub.call_rpc_count
    end
  end

  def test_update_schema_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    compatibility = :NONE
    normalize = true

    update_schema_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_schema_config, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :NONE, request["compatibility"]
      assert request.has_compatibility?
      assert_equal true, request["normalize"]
      assert request.has_normalize?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_schema_config_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_schema_config({ name: name, compatibility: compatibility, normalize: normalize }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_schema_config name: name, compatibility: compatibility, normalize: normalize do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_schema_config ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest.new(name: name, compatibility: compatibility, normalize: normalize) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_schema_config({ name: name, compatibility: compatibility, normalize: normalize }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_schema_config(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest.new(name: name, compatibility: compatibility, normalize: normalize), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_schema_config_client_stub.call_rpc_count
    end
  end

  def test_delete_schema_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_schema_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_schema_config, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_schema_config_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_schema_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_schema_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_schema_config ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_schema_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_schema_config(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_schema_config_client_stub.call_rpc_count
    end
  end

  def test_get_schema_mode
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_schema_mode_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_schema_mode, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_schema_mode_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_schema_mode({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_schema_mode name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_schema_mode ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_schema_mode({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_schema_mode(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_schema_mode_client_stub.call_rpc_count
    end
  end

  def test_update_schema_mode
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    mode = :NONE

    update_schema_mode_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_schema_mode, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :NONE, request["mode"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_schema_mode_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_schema_mode({ name: name, mode: mode }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_schema_mode name: name, mode: mode do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_schema_mode ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest.new(name: name, mode: mode) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_schema_mode({ name: name, mode: mode }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_schema_mode(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest.new(name: name, mode: mode), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_schema_mode_client_stub.call_rpc_count
    end
  end

  def test_delete_schema_mode
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_schema_mode_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_schema_mode, name
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_schema_mode_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_schema_mode({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_schema_mode name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_schema_mode ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_schema_mode({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_schema_mode(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_schema_mode_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
