# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/managedkafka/schemaregistry/v1/schema_registry_pb"
require "google/cloud/managed_kafka/schema_registry/v1/managed_schema_registry/rest"


class ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_schema_registry
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_schema_registry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_get_schema_registry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_schema_registry_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_schema_registry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_schema_registry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_schema_registry ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_schema_registry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_schema_registry(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_schema_registry_client_stub.call_count
      end
    end
  end

  def test_list_schema_registries
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_schema_registries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_list_schema_registries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_schema_registries_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_schema_registries({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_schema_registries parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_schema_registries ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_schema_registries({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_schema_registries(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_schema_registries_client_stub.call_count
      end
    end
  end

  def test_create_schema_registry
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    schema_registry_id = "hello world"
    schema_registry = {}

    create_schema_registry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_create_schema_registry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_schema_registry_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_schema_registry({ parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_schema_registry parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_schema_registry ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest.new(parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_schema_registry({ parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_schema_registry(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest.new(parent: parent, schema_registry_id: schema_registry_id, schema_registry: schema_registry), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_schema_registry_client_stub.call_count
      end
    end
  end

  def test_delete_schema_registry
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_schema_registry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_delete_schema_registry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_schema_registry_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_schema_registry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_schema_registry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_schema_registry ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_schema_registry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_schema_registry(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_schema_registry_client_stub.call_count
      end
    end
  end

  def test_get_context
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Context.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_context_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_get_context_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_context_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_context({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_context name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_context ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_context({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_context(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_context_client_stub.call_count
      end
    end
  end

  def test_list_contexts
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_contexts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_list_contexts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_contexts_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_contexts({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_contexts parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_contexts ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_contexts({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_contexts(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_contexts_client_stub.call_count
      end
    end
  end

  def test_get_schema
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    subject = "hello world"

    get_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_get_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_schema_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_schema({ name: name, subject: subject }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_schema name: name, subject: subject do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_schema ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new(name: name, subject: subject) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_schema({ name: name, subject: subject }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_schema(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new(name: name, subject: subject), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_schema_client_stub.call_count
      end
    end
  end

  def test_get_raw_schema
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    subject = "hello world"

    get_raw_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_get_raw_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_raw_schema_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_raw_schema({ name: name, subject: subject }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_raw_schema name: name, subject: subject do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_raw_schema ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new(name: name, subject: subject) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_raw_schema({ name: name, subject: subject }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_raw_schema(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new(name: name, subject: subject), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_raw_schema_client_stub.call_count
      end
    end
  end

  def test_list_schema_versions
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subject = "hello world"
    deleted = true

    list_schema_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_list_schema_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_schema_versions_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_schema_versions({ parent: parent, subject: subject, deleted: deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_schema_versions parent: parent, subject: subject, deleted: deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_schema_versions ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest.new(parent: parent, subject: subject, deleted: deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_schema_versions({ parent: parent, subject: subject, deleted: deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_schema_versions(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest.new(parent: parent, subject: subject, deleted: deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_schema_versions_client_stub.call_count
      end
    end
  end

  def test_list_schema_types
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_schema_types_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_list_schema_types_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_schema_types_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_schema_types({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_schema_types parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_schema_types ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_schema_types({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_schema_types(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_schema_types_client_stub.call_count
      end
    end
  end

  def test_list_subjects
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subject_prefix = "hello world"
    deleted = true

    list_subjects_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_list_subjects_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_subjects_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_subjects({ parent: parent, subject_prefix: subject_prefix, deleted: deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_subjects parent: parent, subject_prefix: subject_prefix, deleted: deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_subjects ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest.new(parent: parent, subject_prefix: subject_prefix, deleted: deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_subjects({ parent: parent, subject_prefix: subject_prefix, deleted: deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_subjects(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest.new(parent: parent, subject_prefix: subject_prefix, deleted: deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_subjects_client_stub.call_count
      end
    end
  end

  def test_list_subjects_by_schema_id
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subject = "hello world"
    deleted = true

    list_subjects_by_schema_id_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_list_subjects_by_schema_id_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_subjects_by_schema_id_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_subjects_by_schema_id({ parent: parent, subject: subject, deleted: deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_subjects_by_schema_id parent: parent, subject: subject, deleted: deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_subjects_by_schema_id ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest.new(parent: parent, subject: subject, deleted: deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_subjects_by_schema_id({ parent: parent, subject: subject, deleted: deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_subjects_by_schema_id(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest.new(parent: parent, subject: subject, deleted: deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_subjects_by_schema_id_client_stub.call_count
      end
    end
  end

  def test_delete_subject
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    permanent = true

    delete_subject_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_delete_subject_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_subject_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_subject({ name: name, permanent: permanent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_subject name: name, permanent: permanent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_subject ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest.new(name: name, permanent: permanent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_subject({ name: name, permanent: permanent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_subject(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest.new(name: name, permanent: permanent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_subject_client_stub.call_count
      end
    end
  end

  def test_lookup_version
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    schema_type = :SCHEMA_TYPE_UNSPECIFIED
    schema = "hello world"
    references = [{}]
    normalize = true
    deleted = true

    lookup_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_lookup_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_version_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_version({ parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_version parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest.new(parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_version({ parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest.new(parent: parent, schema_type: schema_type, schema: schema, references: references, normalize: normalize, deleted: deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_version_client_stub.call_count
      end
    end
  end

  def test_get_version
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    deleted = true

    get_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_get_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_version_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_version({ name: name, deleted: deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_version name: name, deleted: deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new(name: name, deleted: deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_version({ name: name, deleted: deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new(name: name, deleted: deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_version_client_stub.call_count
      end
    end
  end

  def test_get_raw_schema_version
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    deleted = true

    get_raw_schema_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_get_raw_schema_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_raw_schema_version_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_raw_schema_version({ name: name, deleted: deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_raw_schema_version name: name, deleted: deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_raw_schema_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new(name: name, deleted: deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_raw_schema_version({ name: name, deleted: deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_raw_schema_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new(name: name, deleted: deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_raw_schema_version_client_stub.call_count
      end
    end
  end

  def test_list_versions
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deleted = true

    list_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_list_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_versions_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_versions({ parent: parent, deleted: deleted }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_versions parent: parent, deleted: deleted do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_versions ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest.new(parent: parent, deleted: deleted) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_versions({ parent: parent, deleted: deleted }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_versions(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest.new(parent: parent, deleted: deleted), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_versions_client_stub.call_count
      end
    end
  end

  def test_create_version
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    version = 42
    id = 42
    schema_type = :SCHEMA_TYPE_UNSPECIFIED
    schema = "hello world"
    references = [{}]
    normalize = true

    create_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_create_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_version_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_version({ parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_version parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest.new(parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_version({ parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest.new(parent: parent, version: version, id: id, schema_type: schema_type, schema: schema, references: references, normalize: normalize), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_version_client_stub.call_count
      end
    end
  end

  def test_delete_version
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    permanent = true

    delete_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_delete_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_version_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_version({ name: name, permanent: permanent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_version name: name, permanent: permanent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_version ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest.new(name: name, permanent: permanent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_version({ name: name, permanent: permanent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_version(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest.new(name: name, permanent: permanent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_version_client_stub.call_count
      end
    end
  end

  def test_list_referenced_schemas
    # Create test objects.
    client_result = ::Google::Api::HttpBody.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_referenced_schemas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_list_referenced_schemas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_referenced_schemas_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_referenced_schemas({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_referenced_schemas parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_referenced_schemas ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_referenced_schemas({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_referenced_schemas(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_referenced_schemas_client_stub.call_count
      end
    end
  end

  def test_check_compatibility
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    schema_type = :SCHEMA_TYPE_UNSPECIFIED
    schema = "hello world"
    references = [{}]
    verbose = true

    check_compatibility_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_check_compatibility_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, check_compatibility_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.check_compatibility({ name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.check_compatibility name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.check_compatibility ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest.new(name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.check_compatibility({ name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.check_compatibility(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest.new(name: name, schema_type: schema_type, schema: schema, references: references, verbose: verbose), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, check_compatibility_client_stub.call_count
      end
    end
  end

  def test_get_schema_config
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    default_to_global = true

    get_schema_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_get_schema_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_schema_config_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_schema_config({ name: name, default_to_global: default_to_global }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_schema_config name: name, default_to_global: default_to_global do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_schema_config ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest.new(name: name, default_to_global: default_to_global) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_schema_config({ name: name, default_to_global: default_to_global }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_schema_config(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest.new(name: name, default_to_global: default_to_global), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_schema_config_client_stub.call_count
      end
    end
  end

  def test_update_schema_config
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    compatibility = :NONE
    normalize = true

    update_schema_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_update_schema_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_schema_config_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_schema_config({ name: name, compatibility: compatibility, normalize: normalize }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_schema_config name: name, compatibility: compatibility, normalize: normalize do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_schema_config ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest.new(name: name, compatibility: compatibility, normalize: normalize) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_schema_config({ name: name, compatibility: compatibility, normalize: normalize }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_schema_config(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest.new(name: name, compatibility: compatibility, normalize: normalize), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_schema_config_client_stub.call_count
      end
    end
  end

  def test_delete_schema_config
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_schema_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_delete_schema_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_schema_config_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_schema_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_schema_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_schema_config ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_schema_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_schema_config(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_schema_config_client_stub.call_count
      end
    end
  end

  def test_get_schema_mode
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_schema_mode_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_get_schema_mode_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_schema_mode_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_schema_mode({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_schema_mode name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_schema_mode ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_schema_mode({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_schema_mode(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_schema_mode_client_stub.call_count
      end
    end
  end

  def test_update_schema_mode
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    mode = :NONE

    update_schema_mode_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_update_schema_mode_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_schema_mode_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_schema_mode({ name: name, mode: mode }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_schema_mode name: name, mode: mode do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_schema_mode ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest.new(name: name, mode: mode) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_schema_mode({ name: name, mode: mode }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_schema_mode(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest.new(name: name, mode: mode), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_schema_mode_client_stub.call_count
      end
    end
  end

  def test_delete_schema_mode
    # Create test objects.
    client_result = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_schema_mode_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::ServiceStub.stub :transcode_delete_schema_mode_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_schema_mode_client_stub do
        # Create client
        client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_schema_mode({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_schema_mode name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_schema_mode ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_schema_mode({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_schema_mode(::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_schema_mode_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client::Configuration, config
  end
end
