# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/managed_kafka/schema_registry/v1/managed_schema_registry"

class ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_schema_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.schema_path project: "value0", location: "value1", schema_registry: "value2", schema: "value3"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/schemas/ids/value3", path

      path = client.schema_path project: "value0", location: "value1", schema_registry: "value2", context: "value3", schema: "value4"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/contexts/value3/schemas/ids/value4", path
    end
  end

  def test_schema_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.schema_config_path project: "value0", location: "value1", schema_registry: "value2"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/config", path

      path = client.schema_config_path project: "value0", location: "value1", schema_registry: "value2", subject: "value3"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/config/value3", path

      path = client.schema_config_path project: "value0", location: "value1", schema_registry: "value2", context: "value3"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/contexts/value3/config", path

      path = client.schema_config_path project: "value0", location: "value1", schema_registry: "value2", context: "value3", subject: "value4"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/contexts/value3/config/value4", path
    end
  end

  def test_schema_context_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.schema_context_path project: "value0", location: "value1", schema_registry: "value2", context: "value3"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/contexts/value3", path
    end
  end

  def test_schema_mode_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.schema_mode_path project: "value0", location: "value1", schema_registry: "value2"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/mode", path

      path = client.schema_mode_path project: "value0", location: "value1", schema_registry: "value2", subject: "value3"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/mode/value3", path

      path = client.schema_mode_path project: "value0", location: "value1", schema_registry: "value2", context: "value3"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/contexts/value3/mode", path

      path = client.schema_mode_path project: "value0", location: "value1", schema_registry: "value2", context: "value3", subject: "value4"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/contexts/value3/mode/value4", path
    end
  end

  def test_schema_registry_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.schema_registry_path project: "value0", location: "value1", schema_registry: "value2"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2", path
    end
  end

  def test_schema_subject_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.schema_subject_path project: "value0", location: "value1", schema_registry: "value2", subject: "value3"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/subjects/value3", path

      path = client.schema_subject_path project: "value0", location: "value1", schema_registry: "value2", context: "value3", subject: "value4"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/contexts/value3/subjects/value4", path
    end
  end

  def test_schema_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.schema_version_path project: "value0", location: "value1", schema_registry: "value2", subject: "value3", version: "value4"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/subjects/value3/versions/value4", path

      path = client.schema_version_path project: "value0", location: "value1", schema_registry: "value2", context: "value3", subject: "value4", version: "value5"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/contexts/value3/subjects/value4/versions/value5", path

      path = client.schema_version_path project: "value0", location: "value1", schema_registry: "value2", subject: "value3"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/compatibility/subjects/value3/versions", path

      path = client.schema_version_path project: "value0", location: "value1", schema_registry: "value2", context: "value3", subject: "value4"
      assert_equal "projects/value0/locations/value1/schemaRegistries/value2/contexts/value3/compatibility/subjects/value4/versions", path
    end
  end
end
