# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ManagedKafka
      module SchemaRegistry
        module V1
          # SchemaRegistry is a schema registry instance.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the schema registry instance. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
          #     The instance name \\{schema_registry} can contain the following:
          #     * Up to 255 characters.
          #     * Letters (uppercase or lowercase), numbers, and underscores.
          # @!attribute [r] contexts
          #   @return [::Array<::String>]
          #     Output only. The contexts of the schema registry instance.
          class SchemaRegistry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Context represents an independent schema grouping in a schema registry
          # instance.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the context. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
          #     The context name \\{context} can contain the following:
          #     * Up to 255 characters.
          #     * Allowed characters: letters (uppercase or lowercase), numbers, and the
          #     following special characters: `.`, `-`, `_`, `+`, `%`, and `~`.
          # @!attribute [rw] subjects
          #   @return [::Array<::String>]
          #     Optional. The subjects of the context.
          class Context
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Schema for a Kafka message.
          # @!attribute [rw] schema_type
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaType]
          #     Optional. The schema type of the schema.
          # @!attribute [rw] schema_payload
          #   @return [::String]
          #     The schema payload.
          # @!attribute [rw] references
          #   @return [::Array<::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference>]
          #     Optional. The schema references used by the schema.
          class Schema
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # SchemaReference is a reference to a schema.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the reference.
            # @!attribute [rw] subject
            #   @return [::String]
            #     Required. The subject of the reference.
            # @!attribute [rw] version
            #   @return [::Integer]
            #     Required. The version of the reference.
            class SchemaReference
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Schema types.
            module SchemaType
              # No schema type. The default will be AVRO.
              SCHEMA_TYPE_UNSPECIFIED = 0

              # Avro schema type.
              AVRO = 1

              # JSON schema type.
              JSON = 2

              # Protobuf schema type.
              PROTOBUF = 3
            end
          end

          # Subject defines the evolution scope of schemas as a holder of schema
          # versions.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the subject. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
          #
          #     Subject name \\{subject} can contain the following:
          #     * Up to 255 UTF-8 bytes.
          #     * Allowed characters: letters (uppercase or lowercase), numbers, and the
          #     following special characters: `.`, `-`, `_`, `+`, `%`, and `~`.
          # @!attribute [rw] versions
          #   @return [::Array<::String>]
          #     The versions of the subject.
          class SchemaSubject
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Version of a schema.
          # @!attribute [rw] subject
          #   @return [::String]
          #     Required. The subject of the version.
          # @!attribute [rw] version_id
          #   @return [::Integer]
          #     Required. The version ID
          # @!attribute [rw] schema_id
          #   @return [::Integer]
          #     Required. The schema ID.
          # @!attribute [rw] schema_type
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaType]
          #     Optional. The schema type of the schema.
          # @!attribute [rw] schema_payload
          #   @return [::String]
          #     Required. The schema payload.
          # @!attribute [rw] references
          #   @return [::Array<::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference>]
          #     Optional. The schema references used by the schema.
          class SchemaVersion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # SchemaConfig represents configuration for a schema registry or a specific
          # subject.
          # @!attribute [rw] compatibility
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig::CompatibilityType]
          #     Required. The compatibility type of the schema.
          #     The default value is BACKWARD.
          #     If unset in a SchemaSubject-level SchemaConfig, defaults to the global
          #     value. If unset in a SchemaRegistry-level SchemaConfig, reverts to the
          #     default value.
          # @!attribute [rw] normalize
          #   @return [::Boolean]
          #     Optional. If true, the schema will be normalized before being stored or
          #     looked up. The default is false. If unset in a SchemaSubject-level
          #     SchemaConfig, the global value will be used. If unset in a
          #     SchemaRegistry-level SchemaConfig, reverts to the default value.
          # @!attribute [rw] alias
          #   @return [::String]
          #     Optional. The subject to which this subject is an alias of. Only applicable
          #     for subject config.
          class SchemaConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Compatibility type of the schemas.
            module CompatibilityType
              # No compatibility check.
              NONE = 0

              # Backwards compatible with the most recent version.
              BACKWARD = 1

              # Backwards compatible with all previous versions.
              BACKWARD_TRANSITIVE = 2

              # Forwards compatible with the most recent version.
              FORWARD = 3

              # Forwards compatible with all previous versions.
              FORWARD_TRANSITIVE = 4

              # Backwards and forwards compatible with the most recent version.
              FULL = 5

              # Backwards and forwards compatible with all previous versions.
              FULL_TRANSITIVE = 6
            end
          end

          # SchemaMode represents the mode of a schema registry or a specific subject.
          # Four modes are supported:
          # * NONE: deprecated. This was the default mode for a subject, but now the
          # default is unset (which means use the global schema registry setting)
          # * READONLY: The schema registry is in read-only mode.
          # * READWRITE: The schema registry is in read-write mode, which allows limited
          # write operations on the schema.
          # * IMPORT: The schema registry is in import mode, which allows more editing
          # operations on the schema for data importing purposes.
          # @!attribute [rw] mode
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode::ModeType]
          #     Required. The mode type of a schema registry (READWRITE by default) or of a
          #     subject (unset by default, which means use the global schema registry
          #     setting).
          class SchemaMode
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Mode type of the schemas or subjects.
            module ModeType
              # The default / unset value.
              # The subject mode is NONE/unset by default, which means use the global
              # schema registry mode. This should not be used for setting the mode.
              NONE = 0

              # READONLY mode.
              READONLY = 1

              # READWRITE mode.
              READWRITE = 2

              # IMPORT mode.
              IMPORT = 3
            end
          end
        end
      end
    end
  end
end
