# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ManagedKafka
      module SchemaRegistry
        module V1
          # Request for GetSchemaRegistry.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the schema registry instance to return. Structured
          #     like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
          class GetSchemaRegistryRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for ListSchemaRegistries.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent whose schema registry instances are to be listed.
          #     Structured like: `projects/{project}/locations/{location}`
          class ListSchemaRegistriesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for ListSchemaRegistries.
          # @!attribute [rw] schema_registries
          #   @return [::Array<::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry>]
          #     The schema registry instances.
          class ListSchemaRegistriesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to create a schema registry instance.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent whose schema registry instance is to be created.
          #     Structured like: `projects/{project}/locations/{location}`
          # @!attribute [rw] schema_registry_id
          #   @return [::String]
          #     Required. The schema registry instance ID to use for this schema registry.
          #     The ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores
          #     (-). The maximum length is 63 characters.
          #     The ID must not start with a number.
          # @!attribute [rw] schema_registry
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry]
          #     Required. The schema registry instance to create.
          #     The name field is ignored.
          class CreateSchemaRegistryRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for DeleteSchemaRegistry.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the schema registry instance to delete. Structured
          #     like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
          class DeleteSchemaRegistryRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for GetContext
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the context to return. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
          class GetContextRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for ListContexts.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the contexts. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
          class ListContextsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for GetSchema.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the schema to return. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}`
          # @!attribute [rw] subject
          #   @return [::String]
          #     Optional. Used to limit the search for the schema ID to a specific subject,
          #     otherwise the schema ID will be searched for in all subjects in the given
          #     specified context.
          class GetSchemaRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for ListSchemaTypes.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent schema registry whose schema types are to be listed.
          #     Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
          class ListSchemaTypesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for ListSchemaVersions.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The schema whose schema versions are to be listed. Structured
          #     like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/schemas/ids/{schema}`
          # @!attribute [rw] subject
          #   @return [::String]
          #     Optional. The subject to filter the subjects by.
          # @!attribute [rw] deleted
          #   @return [::Boolean]
          #     Optional. If true, the response will include soft-deleted versions of the
          #     schema, even if the subject is soft-deleted. The default is false.
          class ListSchemaVersionsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for listing subjects.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent schema registry/context whose subjects are to be
          #     listed. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
          # @!attribute [rw] subject_prefix
          #   @return [::String]
          #     Optional. The context to filter the subjects by, in the format of
          #     `:.{context}:`. If unset, all subjects in the registry are returned. Set to
          #     empty string or add as
          #     '?subjectPrefix=' at the end of this request to list subjects in the
          #     default context.
          # @!attribute [rw] deleted
          #   @return [::Boolean]
          #     Optional. If true, the response will include soft-deleted subjects. The
          #     default is false.
          class ListSubjectsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for listing subjects.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The schema resource whose associated subjects are to be listed.
          #     Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/schemas/ids/{schema}`
          # @!attribute [rw] subject
          #   @return [::String]
          #     Optional. The subject to filter the subjects by.
          # @!attribute [rw] deleted
          #   @return [::Boolean]
          #     Optional. If true, the response will include soft-deleted subjects. The
          #     default is false.
          class ListSubjectsBySchemaIdRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for GetVersions.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The subject whose versions are to be listed. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
          # @!attribute [rw] deleted
          #   @return [::Boolean]
          #     Optional. If true, the response will include soft-deleted versions of an
          #     active or soft-deleted subject. The default is false.
          class ListVersionsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for DeleteSubject.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the subject to delete. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
          # @!attribute [rw] permanent
          #   @return [::Boolean]
          #     Optional. If true, the subject and all associated metadata including the
          #     schema ID will be deleted permanently. Otherwise, only the subject is
          #     soft-deleted. The default is false. Soft-deleted subjects can still be
          #     searched in ListSubjects API call with deleted=true query parameter. A
          #     soft-delete of a subject must be performed before a hard-delete.
          class DeleteSubjectRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for GetVersion.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the subject to return versions. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}/versions/{version}`
          # @!attribute [rw] deleted
          #   @return [::Boolean]
          #     Optional. If true, no matter if the subject/version is soft-deleted or not,
          #     it returns the version details. If false, it returns NOT_FOUND error if the
          #     subject/version is soft-deleted. The default is false.
          class GetVersionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for CreateVersion.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The subject to create the version for. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
          # @!attribute [rw] version
          #   @return [::Integer]
          #     Optional. The version to create. It is optional. If not specified, the
          #     version will be created with the max version ID of the subject increased
          #     by 1. If the version ID is specified, it will be used as the new version ID
          #     and must not be used by an existing version of the subject.
          # @!attribute [rw] id
          #   @return [::Integer]
          #     Optional. The schema ID of the schema. If not specified, the schema ID will
          #     be generated by the server. If the schema ID is specified, it must not be
          #     used by an existing schema that is different from the schema to be created.
          # @!attribute [rw] schema_type
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaType]
          #     Optional. The type of the schema. It is optional. If not specified, the
          #     schema type will be AVRO.
          # @!attribute [rw] schema
          #   @return [::String]
          #     Required. The schema payload
          # @!attribute [rw] references
          #   @return [::Array<::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference>]
          #     Optional. The schema references used by the schema.
          # @!attribute [rw] normalize
          #   @return [::Boolean]
          #     Optional. If true, the schema will be normalized before being stored. The
          #     default is false.
          class CreateVersionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response for CreateVersion.
          # @!attribute [rw] id
          #   @return [::Integer]
          #     The unique identifier of the schema created.
          class CreateVersionResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for LookupVersion.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The subject to lookup the schema in. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
          # @!attribute [rw] schema_type
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaType]
          #     Optional. The schema type of the schema.
          # @!attribute [rw] schema
          #   @return [::String]
          #     Required. The schema payload
          # @!attribute [rw] references
          #   @return [::Array<::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference>]
          #     Optional. The schema references used by the schema.
          # @!attribute [rw] normalize
          #   @return [::Boolean]
          #     Optional. If true, the schema will be normalized before being looked up.
          #     The default is false.
          # @!attribute [rw] deleted
          #   @return [::Boolean]
          #     Optional. If true, soft-deleted versions will be included in lookup, no
          #     matter if the subject is active or soft-deleted. If false, soft-deleted
          #     versions will be excluded. The default is false.
          class LookupVersionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for DeleteVersion.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the subject version to delete. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}/versions/{version}`
          # @!attribute [rw] permanent
          #   @return [::Boolean]
          #     Optional. If true, both the version and the referenced schema ID will be
          #     permanently deleted. The default is false. If false, the version will be
          #     deleted but the schema ID will be retained. Soft-deleted versions can still
          #     be searched in ListVersions API call with deleted=true query parameter. A
          #     soft-delete of a version must be performed before a hard-delete.
          class DeleteVersionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for ListReferencedSchemas.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The version to list referenced by. Structured like:
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}`
          #     or
          #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}/versions/{version}`
          class ListReferencedSchemasRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for CheckCompatibility.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the resource to check compatibility for. The format
          #     is either of following:
          #     * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/compatibility/subjects/*/versions: Check compatibility with one or
          #       more versions of the specified subject.
          #     * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/compatibility/subjects/\\{subject}/versions/\\{version}: Check
          #       compatibility with a specific version of the subject.
          # @!attribute [rw] schema_type
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaType]
          #     Optional. The schema type of the schema.
          # @!attribute [rw] schema
          #   @return [::String]
          #     Required. The schema payload
          # @!attribute [rw] references
          #   @return [::Array<::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference>]
          #     Optional. The schema references used by the schema.
          # @!attribute [rw] verbose
          #   @return [::Boolean]
          #     Optional. If true, the response will contain the compatibility check result
          #     with reasons for failed checks. The default is false.
          class CheckCompatibilityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response for CheckCompatibility.
          # @!attribute [rw] is_compatible
          #   @return [::Boolean]
          #     The compatibility check result. If true, the schema is compatible with the
          #     resource.
          # @!attribute [rw] messages
          #   @return [::Array<::String>]
          #     Failure reasons if verbose = true.
          class CheckCompatibilityResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for getting config.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name to get the config for. It can be either of
          #     following:
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config: Get config at global level.
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config/\\{subject}: Get config for a specific subject.
          # @!attribute [rw] default_to_global
          #   @return [::Boolean]
          #     Optional. If true, the config will fall back to the config at the global
          #     level if no subject level config is found.
          class GetSchemaConfigRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for updating schema config.
          # On a SchemaSubject-level SchemaConfig, an unset field will be removed from
          # the SchemaConfig.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name to update the config for. It can be either of
          #     following:
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config: Update config at global level.
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config/\\{subject}: Update config for a specific subject.
          # @!attribute [rw] compatibility
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig::CompatibilityType]
          #     Required. The compatibility type of the schemas.
          #     Cannot be unset for a SchemaRegistry-level SchemaConfig.
          #     If unset on a SchemaSubject-level SchemaConfig, removes the compatibility
          #     field for the SchemaConfig.
          # @!attribute [rw] normalize
          #   @return [::Boolean]
          #     Optional. If true, the schema will be normalized before being stored or
          #     looked up. The default is false. Cannot be unset for a SchemaRegistry-level
          #     SchemaConfig. If unset on a SchemaSubject-level SchemaConfig, removes the
          #     normalize field for the SchemaConfig.
          class UpdateSchemaConfigRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for deleting schema config.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of subject to delete the config for. The format
          #     is
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config/\\{subject}
          class DeleteSchemaConfigRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for getting schema registry or subject mode.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the mode. The format is
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/mode/\\{subject}: mode for a schema registry, or
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/contexts/\\{context}/mode/\\{subject}: mode for a specific subject in a specific context
          class GetSchemaModeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for updating schema registry or subject mode.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the mode. The format is
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/mode/\\{subject}: mode for a schema registry, or
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/contexts/\\{context}/mode/\\{subject}: mode for a specific subject in a specific context
          # @!attribute [rw] mode
          #   @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode::ModeType]
          #     Required. The mode type.
          class UpdateSchemaModeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for deleting schema mode.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of subject to delete the mode for. The format
          #     is
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/mode/\\{subject}
          #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/contexts/\\{context}/mode/\\{subject}
          class DeleteSchemaModeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
