# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/managedkafka/schemaregistry/v1/schema_registry.proto for package 'Google.Cloud.ManagedKafka.SchemaRegistry.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/managedkafka/schemaregistry/v1/schema_registry_pb'

module Google
  module Cloud
    module ManagedKafka
      module SchemaRegistry
        module V1
          module ManagedSchemaRegistry
            # SchemaRegistry is a service that allows users to manage schemas for their
            # Kafka clusters. It provides APIs to register, list, and delete schemas, as
            # well as to get the schema for a given schema id or a given version id under a
            # subject, to update the global or subject-specific compatibility mode, and to
            # check the compatibility of a schema against a subject or a version. The main
            # resource hierarchy is as follows:
            #
            # * SchemaRegistry
            # * SchemaRegistry/Context
            # * SchemaRegistry/Context/Schema
            # * SchemaRegistry/Context/Subject
            # * SchemaRegistry/Context/Subject/Version
            # * SchemaRegistry/Config
            # * SchemaRegistry/Mode
            #
            # **SchemaRegistry** is the root resource to represent a schema registry
            # instance. A customer can have multiple schema registry instances in a
            # project.
            #
            # **Context** is a context resource that represents a group of
            # schemas, subjects and versions. A schema registry instance can have multiple
            # contexts and always has a 'default' context. Contexts are independent of each
            # other. Context is optional and if not specified, it falls back to the
            # 'default' context.
            #
            # **Schema** is a schema resource that represents a unique schema in a context
            # of a schema registry instance. Each schema has a unique schema id, and can be
            # referenced by a version of a subject.
            #
            # **Subject** refers to the name under which the schema is registered. A
            # typical subject is the Kafka topic name. A schema registry instance can have
            # multiple subjects.
            #
            # **Version** represents a version of a subject. A subject can have multiple
            # versions. Creation of new version of a subject is guarded by the
            # compatibility mode configured globally or for the subject specifically.
            #
            # **Config** represents a config at global level cross all registry
            # instances or at subject level. Currently, only compatibility is supported in
            # config.
            #
            # **Mode** represents the mode of a schema registry or a specific subject.
            # Three modes are supported:
            # * READONLY: The schema registry is in read-only mode, no write operations
            # allowed..
            # * READWRITE: The schema registry is in read-write mode, which allows limited
            # write operations on the schema.
            # * IMPORT: The schema registry is in import mode, which allows more editing
            # operations on the schema for data importing purposes.
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.cloud.managedkafka.schemaregistry.v1.ManagedSchemaRegistry'

              # Get the schema registry instance.
              rpc :GetSchemaRegistry, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry
              # List schema registries.
              rpc :ListSchemaRegistries, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesResponse
              # Create a schema registry instance.
              rpc :CreateSchemaRegistry, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry
              # Delete a schema registry instance.
              rpc :DeleteSchemaRegistry, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest, ::Google::Protobuf::Empty
              # Get the context.
              rpc :GetContext, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Context
              # List contexts for a schema registry.
              rpc :ListContexts, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest, ::Google::Api::HttpBody
              # Get the schema for the given schema id.
              rpc :GetSchema, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema
              # Get the schema string for the given schema id.
              # The response will be the schema string.
              rpc :GetRawSchema, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest, ::Google::Api::HttpBody
              # List the schema versions for the given schema id.
              # The response will be an array of subject-version pairs as:
              # [{"subject":"subject1", "version":1}, {"subject":"subject2", "version":2}].
              rpc :ListSchemaVersions, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest, ::Google::Api::HttpBody
              # List the supported schema types.
              # The response will be an array of schema types.
              rpc :ListSchemaTypes, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest, ::Google::Api::HttpBody
              # List subjects in the schema registry.
              # The response will be an array of subject names.
              rpc :ListSubjects, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest, ::Google::Api::HttpBody
              # List subjects which reference a particular schema id.
              # The response will be an array of subject names.
              rpc :ListSubjectsBySchemaId, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest, ::Google::Api::HttpBody
              # Delete a subject.
              # The response will be an array of versions of the deleted subject.
              rpc :DeleteSubject, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest, ::Google::Api::HttpBody
              # Lookup a schema under the specified subject.
              rpc :LookupVersion, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion
              # Get a versioned schema (schema with subject/version) of a subject.
              rpc :GetVersion, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion
              # Get the schema string only for a version of a subject.
              # The response will be the schema string.
              rpc :GetRawSchemaVersion, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest, ::Google::Api::HttpBody
              # Get all versions of a subject.
              # The response will be an array of versions of the subject.
              rpc :ListVersions, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest, ::Google::Api::HttpBody
              # Register a new version under a given subject with the given schema.
              rpc :CreateVersion, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionResponse
              # Delete a version of a subject.
              # The response will be the deleted version id.
              rpc :DeleteVersion, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest, ::Google::Api::HttpBody
              # Get a list of IDs of schemas that reference the schema with the given
              # subject and version.
              rpc :ListReferencedSchemas, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest, ::Google::Api::HttpBody
              # Check compatibility of a schema with all versions or a specific version of
              # a subject.
              rpc :CheckCompatibility, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityResponse
              # Get schema config at global level or for a subject.
              rpc :GetSchemaConfig, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig
              # Update config at global level or for a subject.
              # Creates a SchemaSubject-level SchemaConfig if it does not exist.
              rpc :UpdateSchemaConfig, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig
              # Delete schema config for a subject.
              rpc :DeleteSchemaConfig, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig
              # Get mode at global level or for a subject.
              rpc :GetSchemaMode, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode
              # Update mode at global level or for a subject.
              rpc :UpdateSchemaMode, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode
              # Delete schema mode for a subject.
              rpc :DeleteSchemaMode, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest, ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
