# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/managed_kafka/schema_registry/v1/version"
require "google/cloud/managed_kafka/schema_registry/v1/bindings_override"

require "google/cloud/managed_kafka/schema_registry/v1/managed_schema_registry/credentials"
require "google/cloud/managed_kafka/schema_registry/v1/managed_schema_registry/paths"
require "google/cloud/managed_kafka/schema_registry/v1/managed_schema_registry/rest/client"

module Google
  module Cloud
    module ManagedKafka
      module SchemaRegistry
        module V1
          ##
          # SchemaRegistry is a service that allows users to manage schemas for their
          # Kafka clusters. It provides APIs to register, list, and delete schemas, as
          # well as to get the schema for a given schema id or a given version id under a
          # subject, to update the global or subject-specific compatibility mode, and to
          # check the compatibility of a schema against a subject or a version. The main
          # resource hierarchy is as follows:
          #
          # * SchemaRegistry
          # * SchemaRegistry/Context
          # * SchemaRegistry/Context/Schema
          # * SchemaRegistry/Context/Subject
          # * SchemaRegistry/Context/Subject/Version
          # * SchemaRegistry/Config
          # * SchemaRegistry/Mode
          #
          # **SchemaRegistry** is the root resource to represent a schema registry
          # instance. A customer can have multiple schema registry instances in a
          # project.
          #
          # **Context** is a context resource that represents a group of
          # schemas, subjects and versions. A schema registry instance can have multiple
          # contexts and always has a 'default' context. Contexts are independent of each
          # other. Context is optional and if not specified, it falls back to the
          # 'default' context.
          #
          # **Schema** is a schema resource that represents a unique schema in a context
          # of a schema registry instance. Each schema has a unique schema id, and can be
          # referenced by a version of a subject.
          #
          # **Subject** refers to the name under which the schema is registered. A
          # typical subject is the Kafka topic name. A schema registry instance can have
          # multiple subjects.
          #
          # **Version** represents a version of a subject. A subject can have multiple
          # versions. Creation of new version of a subject is guarded by the
          # compatibility mode configured globally or for the subject specifically.
          #
          # **Config** represents a config at global level cross all registry
          # instances or at subject level. Currently, only compatibility is supported in
          # config.
          #
          # **Mode** represents the mode of a schema registry or a specific subject.
          # Three modes are supported:
          # * READONLY: The schema registry is in read-only mode, no write operations
          # allowed..
          # * READWRITE: The schema registry is in read-write mode, which allows limited
          # write operations on the schema.
          # * IMPORT: The schema registry is in import mode, which allows more editing
          # operations on the schema for data importing purposes.
          #
          # To load this service and instantiate a REST client:
          #
          #     require "google/cloud/managed_kafka/schema_registry/v1/managed_schema_registry/rest"
          #     client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Rest::Client.new
          #
          module ManagedSchemaRegistry
            # Client for the REST transport
            module Rest
            end
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/managed_kafka/schema_registry/v1/managed_schema_registry/rest/helpers" if ::File.file? helper_path
