# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ManagedKafka
      module SchemaRegistry
        module V1
          module ManagedSchemaRegistry
            # Path helper methods for the ManagedSchemaRegistry API.
            module Paths
              ##
              # Create a fully-qualified Schema resource string.
              #
              # @overload schema_path(project:, location:, schema_registry:, schema:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param schema [String]
              #
              # @overload schema_path(project:, location:, schema_registry:, context:, schema:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/schemas/ids/{schema}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param context [String]
              #   @param schema [String]
              #
              # @return [::String]
              def schema_path **args
                resources = {
                  "location:project:schema:schema_registry" => (proc do |project:, location:, schema_registry:, schema:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/schemas/ids/#{schema}"
                  end),
                  "context:location:project:schema:schema_registry" => (proc do |project:, location:, schema_registry:, context:, schema:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"
                    raise ::ArgumentError, "context cannot contain /" if context.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/contexts/#{context}/schemas/ids/#{schema}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified SchemaConfig resource string.
              #
              # @overload schema_config_path(project:, location:, schema_registry:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/config`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #
              # @overload schema_config_path(project:, location:, schema_registry:, subject:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/config/{subject}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param subject [String]
              #
              # @overload schema_config_path(project:, location:, schema_registry:, context:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/config`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param context [String]
              #
              # @overload schema_config_path(project:, location:, schema_registry:, context:, subject:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/config/{subject}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param context [String]
              #   @param subject [String]
              #
              # @return [::String]
              def schema_config_path **args
                resources = {
                  "location:project:schema_registry" => (proc do |project:, location:, schema_registry:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/config"
                  end),
                  "location:project:schema_registry:subject" => (proc do |project:, location:, schema_registry:, subject:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/config/#{subject}"
                  end),
                  "context:location:project:schema_registry" => (proc do |project:, location:, schema_registry:, context:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/contexts/#{context}/config"
                  end),
                  "context:location:project:schema_registry:subject" => (proc do |project:, location:, schema_registry:, context:, subject:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"
                    raise ::ArgumentError, "context cannot contain /" if context.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/contexts/#{context}/config/#{subject}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified SchemaContext resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
              #
              # @param project [String]
              # @param location [String]
              # @param schema_registry [String]
              # @param context [String]
              #
              # @return [::String]
              def schema_context_path project:, location:, schema_registry:, context:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"

                "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/contexts/#{context}"
              end

              ##
              # Create a fully-qualified SchemaMode resource string.
              #
              # @overload schema_mode_path(project:, location:, schema_registry:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/mode`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #
              # @overload schema_mode_path(project:, location:, schema_registry:, subject:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/mode/{subject}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param subject [String]
              #
              # @overload schema_mode_path(project:, location:, schema_registry:, context:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/mode`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param context [String]
              #
              # @overload schema_mode_path(project:, location:, schema_registry:, context:, subject:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/mode/{subject}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param context [String]
              #   @param subject [String]
              #
              # @return [::String]
              def schema_mode_path **args
                resources = {
                  "location:project:schema_registry" => (proc do |project:, location:, schema_registry:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/mode"
                  end),
                  "location:project:schema_registry:subject" => (proc do |project:, location:, schema_registry:, subject:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/mode/#{subject}"
                  end),
                  "context:location:project:schema_registry" => (proc do |project:, location:, schema_registry:, context:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/contexts/#{context}/mode"
                  end),
                  "context:location:project:schema_registry:subject" => (proc do |project:, location:, schema_registry:, context:, subject:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"
                    raise ::ArgumentError, "context cannot contain /" if context.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/contexts/#{context}/mode/#{subject}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified SchemaRegistry resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
              #
              # @param project [String]
              # @param location [String]
              # @param schema_registry [String]
              #
              # @return [::String]
              def schema_registry_path project:, location:, schema_registry:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}"
              end

              ##
              # Create a fully-qualified SchemaSubject resource string.
              #
              # @overload schema_subject_path(project:, location:, schema_registry:, subject:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param subject [String]
              #
              # @overload schema_subject_path(project:, location:, schema_registry:, context:, subject:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param context [String]
              #   @param subject [String]
              #
              # @return [::String]
              def schema_subject_path **args
                resources = {
                  "location:project:schema_registry:subject" => (proc do |project:, location:, schema_registry:, subject:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/subjects/#{subject}"
                  end),
                  "context:location:project:schema_registry:subject" => (proc do |project:, location:, schema_registry:, context:, subject:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"
                    raise ::ArgumentError, "context cannot contain /" if context.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/contexts/#{context}/subjects/#{subject}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified SchemaVersion resource string.
              #
              # @overload schema_version_path(project:, location:, schema_registry:, subject:, version:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param subject [String]
              #   @param version [String]
              #
              # @overload schema_version_path(project:, location:, schema_registry:, context:, subject:, version:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}/versions/{version}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param context [String]
              #   @param subject [String]
              #   @param version [String]
              #
              # @overload schema_version_path(project:, location:, schema_registry:, subject:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/compatibility/subjects/{subject}/versions`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param subject [String]
              #
              # @overload schema_version_path(project:, location:, schema_registry:, context:, subject:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/compatibility/subjects/{subject}/versions`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param schema_registry [String]
              #   @param context [String]
              #   @param subject [String]
              #
              # @return [::String]
              def schema_version_path **args
                resources = {
                  "location:project:schema_registry:subject:version" => (proc do |project:, location:, schema_registry:, subject:, version:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"
                    raise ::ArgumentError, "subject cannot contain /" if subject.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/subjects/#{subject}/versions/#{version}"
                  end),
                  "context:location:project:schema_registry:subject:version" => (proc do |project:, location:, schema_registry:, context:, subject:, version:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"
                    raise ::ArgumentError, "context cannot contain /" if context.to_s.include? "/"
                    raise ::ArgumentError, "subject cannot contain /" if subject.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/contexts/#{context}/subjects/#{subject}/versions/#{version}"
                  end),
                  "location:project:schema_registry:subject" => (proc do |project:, location:, schema_registry:, subject:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/compatibility/subjects/#{subject}/versions"
                  end),
                  "context:location:project:schema_registry:subject" => (proc do |project:, location:, schema_registry:, context:, subject:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "schema_registry cannot contain /" if schema_registry.to_s.include? "/"
                    raise ::ArgumentError, "context cannot contain /" if context.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/schemaRegistries/#{schema_registry}/contexts/#{context}/compatibility/subjects/#{subject}/versions"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              extend self
            end
          end
        end
      end
    end
  end
end
