# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/managedkafka/schemaregistry/v1/schema_registry_pb"
require "google/cloud/location"

module Google
  module Cloud
    module ManagedKafka
      module SchemaRegistry
        module V1
          module ManagedSchemaRegistry
            ##
            # Client for the ManagedSchemaRegistry service.
            #
            # SchemaRegistry is a service that allows users to manage schemas for their
            # Kafka clusters. It provides APIs to register, list, and delete schemas, as
            # well as to get the schema for a given schema id or a given version id under a
            # subject, to update the global or subject-specific compatibility mode, and to
            # check the compatibility of a schema against a subject or a version. The main
            # resource hierarchy is as follows:
            #
            # * SchemaRegistry
            # * SchemaRegistry/Context
            # * SchemaRegistry/Context/Schema
            # * SchemaRegistry/Context/Subject
            # * SchemaRegistry/Context/Subject/Version
            # * SchemaRegistry/Config
            # * SchemaRegistry/Mode
            #
            # **SchemaRegistry** is the root resource to represent a schema registry
            # instance. A customer can have multiple schema registry instances in a
            # project.
            #
            # **Context** is a context resource that represents a group of
            # schemas, subjects and versions. A schema registry instance can have multiple
            # contexts and always has a 'default' context. Contexts are independent of each
            # other. Context is optional and if not specified, it falls back to the
            # 'default' context.
            #
            # **Schema** is a schema resource that represents a unique schema in a context
            # of a schema registry instance. Each schema has a unique schema id, and can be
            # referenced by a version of a subject.
            #
            # **Subject** refers to the name under which the schema is registered. A
            # typical subject is the Kafka topic name. A schema registry instance can have
            # multiple subjects.
            #
            # **Version** represents a version of a subject. A subject can have multiple
            # versions. Creation of new version of a subject is guarded by the
            # compatibility mode configured globally or for the subject specifically.
            #
            # **Config** represents a config at global level cross all registry
            # instances or at subject level. Currently, only compatibility is supported in
            # config.
            #
            # **Mode** represents the mode of a schema registry or a specific subject.
            # Three modes are supported:
            # * READONLY: The schema registry is in read-only mode, no write operations
            # allowed..
            # * READWRITE: The schema registry is in read-write mode, which allows limited
            # write operations on the schema.
            # * IMPORT: The schema registry is in import mode, which allows more editing
            # operations on the schema for data importing purposes.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "managedkafka.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :managed_schema_registry_stub

              ##
              # Configure the ManagedSchemaRegistry Client class.
              #
              # See {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ManagedSchemaRegistry clients
              #   ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ManagedKafka", "SchemaRegistry", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ManagedSchemaRegistry Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @managed_schema_registry_stub.universe_domain
              end

              ##
              # Create a new ManagedSchemaRegistry client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ManagedSchemaRegistry client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/cloud/managedkafka/schemaregistry/v1/schema_registry_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @managed_schema_registry_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @managed_schema_registry_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @managed_schema_registry_stub.endpoint
                  config.universe_domain = @managed_schema_registry_stub.universe_domain
                  config.logger = @managed_schema_registry_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @managed_schema_registry_stub.logger
              end

              # Service calls

              ##
              # Get the schema registry instance.
              #
              # @overload get_schema_registry(request, options = nil)
              #   Pass arguments to `get_schema_registry` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_schema_registry(name: nil)
              #   Pass arguments to `get_schema_registry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the schema registry instance to return. Structured
              #     like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest.new
              #
              #   # Call the get_schema_registry method.
              #   result = client.get_schema_registry request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry.
              #   p result
              #
              def get_schema_registry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRegistryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_schema_registry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_schema_registry.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_schema_registry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :get_schema_registry, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List schema registries.
              #
              # @overload list_schema_registries(request, options = nil)
              #   Pass arguments to `list_schema_registries` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_schema_registries(parent: nil)
              #   Pass arguments to `list_schema_registries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent whose schema registry instances are to be listed.
              #     Structured like: `projects/{project}/locations/{location}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest.new
              #
              #   # Call the list_schema_registries method.
              #   result = client.list_schema_registries request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesResponse.
              #   p result
              #
              def list_schema_registries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaRegistriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_schema_registries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_schema_registries.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_schema_registries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :list_schema_registries, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a schema registry instance.
              #
              # @overload create_schema_registry(request, options = nil)
              #   Pass arguments to `create_schema_registry` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_schema_registry(parent: nil, schema_registry_id: nil, schema_registry: nil)
              #   Pass arguments to `create_schema_registry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent whose schema registry instance is to be created.
              #     Structured like: `projects/{project}/locations/{location}`
              #   @param schema_registry_id [::String]
              #     Required. The schema registry instance ID to use for this schema registry.
              #     The ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores
              #     (-). The maximum length is 63 characters.
              #     The ID must not start with a number.
              #   @param schema_registry [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry, ::Hash]
              #     Required. The schema registry instance to create.
              #     The name field is ignored.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest.new
              #
              #   # Call the create_schema_registry method.
              #   result = client.create_schema_registry request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaRegistry.
              #   p result
              #
              def create_schema_registry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateSchemaRegistryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_schema_registry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_schema_registry.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_schema_registry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :create_schema_registry, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a schema registry instance.
              #
              # @overload delete_schema_registry(request, options = nil)
              #   Pass arguments to `delete_schema_registry` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_schema_registry(name: nil)
              #   Pass arguments to `delete_schema_registry` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the schema registry instance to delete. Structured
              #     like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest.new
              #
              #   # Call the delete_schema_registry method.
              #   result = client.delete_schema_registry request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_schema_registry request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaRegistryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_schema_registry.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_schema_registry.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_schema_registry.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :delete_schema_registry, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get the context.
              #
              # @overload get_context(request, options = nil)
              #   Pass arguments to `get_context` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_context(name: nil)
              #   Pass arguments to `get_context` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the context to return. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Context]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Context]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest.new
              #
              #   # Call the get_context method.
              #   result = client.get_context request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::Context.
              #   p result
              #
              def get_context request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetContextRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_context.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_context.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_context.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :get_context, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List contexts for a schema registry.
              #
              # @overload list_contexts(request, options = nil)
              #   Pass arguments to `list_contexts` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_contexts(parent: nil)
              #   Pass arguments to `list_contexts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent of the contexts. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest.new
              #
              #   # Call the list_contexts method.
              #   result = client.list_contexts request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def list_contexts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListContextsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_contexts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_contexts.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_contexts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :list_contexts, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get the schema for the given schema id.
              #
              # @overload get_schema(request, options = nil)
              #   Pass arguments to `get_schema` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_schema(name: nil, subject: nil)
              #   Pass arguments to `get_schema` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the schema to return. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}`
              #   @param subject [::String]
              #     Optional. Used to limit the search for the schema ID to a specific subject,
              #     otherwise the schema ID will be searched for in all subjects in the given
              #     specified context.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new
              #
              #   # Call the get_schema method.
              #   result = client.get_schema request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema.
              #   p result
              #
              def get_schema request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_schema.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_schema.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_schema.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :get_schema, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get the schema string for the given schema id.
              # The response will be the schema string.
              #
              # @overload get_raw_schema(request, options = nil)
              #   Pass arguments to `get_raw_schema` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_raw_schema(name: nil, subject: nil)
              #   Pass arguments to `get_raw_schema` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the schema to return. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}`
              #   @param subject [::String]
              #     Optional. Used to limit the search for the schema ID to a specific subject,
              #     otherwise the schema ID will be searched for in all subjects in the given
              #     specified context.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest.new
              #
              #   # Call the get_raw_schema method.
              #   result = client.get_raw_schema request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def get_raw_schema request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_raw_schema.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_raw_schema.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_raw_schema.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :get_raw_schema, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List the schema versions for the given schema id.
              # The response will be an array of subject-version pairs as:
              # [\\{"subject":"subject1", "version":1}, \\{"subject":"subject2", "version":2}].
              #
              # @overload list_schema_versions(request, options = nil)
              #   Pass arguments to `list_schema_versions` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_schema_versions(parent: nil, subject: nil, deleted: nil)
              #   Pass arguments to `list_schema_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The schema whose schema versions are to be listed. Structured
              #     like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/schemas/ids/{schema}`
              #   @param subject [::String]
              #     Optional. The subject to filter the subjects by.
              #   @param deleted [::Boolean]
              #     Optional. If true, the response will include soft-deleted versions of the
              #     schema, even if the subject is soft-deleted. The default is false.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest.new
              #
              #   # Call the list_schema_versions method.
              #   result = client.list_schema_versions request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def list_schema_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_schema_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_schema_versions.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_schema_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :list_schema_versions, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List the supported schema types.
              # The response will be an array of schema types.
              #
              # @overload list_schema_types(request, options = nil)
              #   Pass arguments to `list_schema_types` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_schema_types(parent: nil)
              #   Pass arguments to `list_schema_types` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent schema registry whose schema types are to be listed.
              #     Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest.new
              #
              #   # Call the list_schema_types method.
              #   result = client.list_schema_types request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def list_schema_types request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSchemaTypesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_schema_types.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_schema_types.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_schema_types.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :list_schema_types, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List subjects in the schema registry.
              # The response will be an array of subject names.
              #
              # @overload list_subjects(request, options = nil)
              #   Pass arguments to `list_subjects` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_subjects(parent: nil, subject_prefix: nil, deleted: nil)
              #   Pass arguments to `list_subjects` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent schema registry/context whose subjects are to be
              #     listed. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}`
              #   @param subject_prefix [::String]
              #     Optional. The context to filter the subjects by, in the format of
              #     `:.{context}:`. If unset, all subjects in the registry are returned. Set to
              #     empty string or add as
              #     '?subjectPrefix=' at the end of this request to list subjects in the
              #     default context.
              #   @param deleted [::Boolean]
              #     Optional. If true, the response will include soft-deleted subjects. The
              #     default is false.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest.new
              #
              #   # Call the list_subjects method.
              #   result = client.list_subjects request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def list_subjects request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_subjects.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_subjects.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_subjects.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :list_subjects, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List subjects which reference a particular schema id.
              # The response will be an array of subject names.
              #
              # @overload list_subjects_by_schema_id(request, options = nil)
              #   Pass arguments to `list_subjects_by_schema_id` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_subjects_by_schema_id(parent: nil, subject: nil, deleted: nil)
              #   Pass arguments to `list_subjects_by_schema_id` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The schema resource whose associated subjects are to be listed.
              #     Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/schemas/ids/{schema}`
              #   @param subject [::String]
              #     Optional. The subject to filter the subjects by.
              #   @param deleted [::Boolean]
              #     Optional. If true, the response will include soft-deleted subjects. The
              #     default is false.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest.new
              #
              #   # Call the list_subjects_by_schema_id method.
              #   result = client.list_subjects_by_schema_id request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def list_subjects_by_schema_id request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListSubjectsBySchemaIdRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_subjects_by_schema_id.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_subjects_by_schema_id.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_subjects_by_schema_id.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :list_subjects_by_schema_id, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a subject.
              # The response will be an array of versions of the deleted subject.
              #
              # @overload delete_subject(request, options = nil)
              #   Pass arguments to `delete_subject` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_subject(name: nil, permanent: nil)
              #   Pass arguments to `delete_subject` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the subject to delete. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
              #   @param permanent [::Boolean]
              #     Optional. If true, the subject and all associated metadata including the
              #     schema ID will be deleted permanently. Otherwise, only the subject is
              #     soft-deleted. The default is false. Soft-deleted subjects can still be
              #     searched in ListSubjects API call with deleted=true query parameter. A
              #     soft-delete of a subject must be performed before a hard-delete.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest.new
              #
              #   # Call the delete_subject method.
              #   result = client.delete_subject request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def delete_subject request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSubjectRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_subject.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_subject.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_subject.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :delete_subject, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lookup a schema under the specified subject.
              #
              # @overload lookup_version(request, options = nil)
              #   Pass arguments to `lookup_version` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload lookup_version(parent: nil, schema_type: nil, schema: nil, references: nil, normalize: nil, deleted: nil)
              #   Pass arguments to `lookup_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The subject to lookup the schema in. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
              #   @param schema_type [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaType]
              #     Optional. The schema type of the schema.
              #   @param schema [::String]
              #     Required. The schema payload
              #   @param references [::Array<::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference, ::Hash>]
              #     Optional. The schema references used by the schema.
              #   @param normalize [::Boolean]
              #     Optional. If true, the schema will be normalized before being looked up.
              #     The default is false.
              #   @param deleted [::Boolean]
              #     Optional. If true, soft-deleted versions will be included in lookup, no
              #     matter if the subject is active or soft-deleted. If false, soft-deleted
              #     versions will be excluded. The default is false.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest.new
              #
              #   # Call the lookup_version method.
              #   result = client.lookup_version request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion.
              #   p result
              #
              def lookup_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::LookupVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.lookup_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.lookup_version.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.lookup_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :lookup_version, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get a versioned schema (schema with subject/version) of a subject.
              #
              # @overload get_version(request, options = nil)
              #   Pass arguments to `get_version` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_version(name: nil, deleted: nil)
              #   Pass arguments to `get_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the subject to return versions. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}/versions/{version}`
              #   @param deleted [::Boolean]
              #     Optional. If true, no matter if the subject/version is soft-deleted or not,
              #     it returns the version details. If false, it returns NOT_FOUND error if the
              #     subject/version is soft-deleted. The default is false.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new
              #
              #   # Call the get_version method.
              #   result = client.get_version request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaVersion.
              #   p result
              #
              def get_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_version.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :get_version, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get the schema string only for a version of a subject.
              # The response will be the schema string.
              #
              # @overload get_raw_schema_version(request, options = nil)
              #   Pass arguments to `get_raw_schema_version` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_raw_schema_version(name: nil, deleted: nil)
              #   Pass arguments to `get_raw_schema_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the subject to return versions. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}/versions/{version}`
              #   @param deleted [::Boolean]
              #     Optional. If true, no matter if the subject/version is soft-deleted or not,
              #     it returns the version details. If false, it returns NOT_FOUND error if the
              #     subject/version is soft-deleted. The default is false.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest.new
              #
              #   # Call the get_raw_schema_version method.
              #   result = client.get_raw_schema_version request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def get_raw_schema_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_raw_schema_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_raw_schema_version.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_raw_schema_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :get_raw_schema_version, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get all versions of a subject.
              # The response will be an array of versions of the subject.
              #
              # @overload list_versions(request, options = nil)
              #   Pass arguments to `list_versions` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_versions(parent: nil, deleted: nil)
              #   Pass arguments to `list_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The subject whose versions are to be listed. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
              #   @param deleted [::Boolean]
              #     Optional. If true, the response will include soft-deleted versions of an
              #     active or soft-deleted subject. The default is false.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest.new
              #
              #   # Call the list_versions method.
              #   result = client.list_versions request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def list_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_versions.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :list_versions, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Register a new version under a given subject with the given schema.
              #
              # @overload create_version(request, options = nil)
              #   Pass arguments to `create_version` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_version(parent: nil, version: nil, id: nil, schema_type: nil, schema: nil, references: nil, normalize: nil)
              #   Pass arguments to `create_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The subject to create the version for. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}`
              #   @param version [::Integer]
              #     Optional. The version to create. It is optional. If not specified, the
              #     version will be created with the max version ID of the subject increased
              #     by 1. If the version ID is specified, it will be used as the new version ID
              #     and must not be used by an existing version of the subject.
              #   @param id [::Integer]
              #     Optional. The schema ID of the schema. If not specified, the schema ID will
              #     be generated by the server. If the schema ID is specified, it must not be
              #     used by an existing schema that is different from the schema to be created.
              #   @param schema_type [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaType]
              #     Optional. The type of the schema. It is optional. If not specified, the
              #     schema type will be AVRO.
              #   @param schema [::String]
              #     Required. The schema payload
              #   @param references [::Array<::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference, ::Hash>]
              #     Optional. The schema references used by the schema.
              #   @param normalize [::Boolean]
              #     Optional. If true, the schema will be normalized before being stored. The
              #     default is false.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest.new
              #
              #   # Call the create_version method.
              #   result = client.create_version request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionResponse.
              #   p result
              #
              def create_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CreateVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_version.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :create_version, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a version of a subject.
              # The response will be the deleted version id.
              #
              # @overload delete_version(request, options = nil)
              #   Pass arguments to `delete_version` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_version(name: nil, permanent: nil)
              #   Pass arguments to `delete_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the subject version to delete. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}/versions/{version}`
              #   @param permanent [::Boolean]
              #     Optional. If true, both the version and the referenced schema ID will be
              #     permanently deleted. The default is false. If false, the version will be
              #     deleted but the schema ID will be retained. Soft-deleted versions can still
              #     be searched in ListVersions API call with deleted=true query parameter. A
              #     soft-delete of a version must be performed before a hard-delete.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest.new
              #
              #   # Call the delete_version method.
              #   result = client.delete_version request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def delete_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_version.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :delete_version, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get a list of IDs of schemas that reference the schema with the given
              # subject and version.
              #
              # @overload list_referenced_schemas(request, options = nil)
              #   Pass arguments to `list_referenced_schemas` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_referenced_schemas(parent: nil)
              #   Pass arguments to `list_referenced_schemas` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The version to list referenced by. Structured like:
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}`
              #     or
              #     `projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}/versions/{version}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Api::HttpBody]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Api::HttpBody]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest.new
              #
              #   # Call the list_referenced_schemas method.
              #   result = client.list_referenced_schemas request
              #
              #   # The returned object is of type Google::Api::HttpBody.
              #   p result
              #
              def list_referenced_schemas request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ListReferencedSchemasRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_referenced_schemas.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_referenced_schemas.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_referenced_schemas.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :list_referenced_schemas, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Check compatibility of a schema with all versions or a specific version of
              # a subject.
              #
              # @overload check_compatibility(request, options = nil)
              #   Pass arguments to `check_compatibility` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload check_compatibility(name: nil, schema_type: nil, schema: nil, references: nil, verbose: nil)
              #   Pass arguments to `check_compatibility` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the resource to check compatibility for. The format
              #     is either of following:
              #     * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/compatibility/subjects/*/versions: Check compatibility with one or
              #       more versions of the specified subject.
              #     * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/compatibility/subjects/\\{subject}/versions/\\{version}: Check
              #       compatibility with a specific version of the subject.
              #   @param schema_type [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaType]
              #     Optional. The schema type of the schema.
              #   @param schema [::String]
              #     Required. The schema payload
              #   @param references [::Array<::Google::Cloud::ManagedKafka::SchemaRegistry::V1::Schema::SchemaReference, ::Hash>]
              #     Optional. The schema references used by the schema.
              #   @param verbose [::Boolean]
              #     Optional. If true, the response will contain the compatibility check result
              #     with reasons for failed checks. The default is false.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest.new
              #
              #   # Call the check_compatibility method.
              #   result = client.check_compatibility request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityResponse.
              #   p result
              #
              def check_compatibility request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::CheckCompatibilityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.check_compatibility.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.check_compatibility.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.check_compatibility.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :check_compatibility, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get schema config at global level or for a subject.
              #
              # @overload get_schema_config(request, options = nil)
              #   Pass arguments to `get_schema_config` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_schema_config(name: nil, default_to_global: nil)
              #   Pass arguments to `get_schema_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name to get the config for. It can be either of
              #     following:
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config: Get config at global level.
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config/\\{subject}: Get config for a specific subject.
              #   @param default_to_global [::Boolean]
              #     Optional. If true, the config will fall back to the config at the global
              #     level if no subject level config is found.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest.new
              #
              #   # Call the get_schema_config method.
              #   result = client.get_schema_config request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig.
              #   p result
              #
              def get_schema_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_schema_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_schema_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_schema_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :get_schema_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update config at global level or for a subject.
              # Creates a SchemaSubject-level SchemaConfig if it does not exist.
              #
              # @overload update_schema_config(request, options = nil)
              #   Pass arguments to `update_schema_config` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_schema_config(name: nil, compatibility: nil, normalize: nil)
              #   Pass arguments to `update_schema_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name to update the config for. It can be either of
              #     following:
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config: Update config at global level.
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config/\\{subject}: Update config for a specific subject.
              #   @param compatibility [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig::CompatibilityType]
              #     Required. The compatibility type of the schemas.
              #     Cannot be unset for a SchemaRegistry-level SchemaConfig.
              #     If unset on a SchemaSubject-level SchemaConfig, removes the compatibility
              #     field for the SchemaConfig.
              #   @param normalize [::Boolean]
              #     Optional. If true, the schema will be normalized before being stored or
              #     looked up. The default is false. Cannot be unset for a SchemaRegistry-level
              #     SchemaConfig. If unset on a SchemaSubject-level SchemaConfig, removes the
              #     normalize field for the SchemaConfig.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest.new
              #
              #   # Call the update_schema_config method.
              #   result = client.update_schema_config request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig.
              #   p result
              #
              def update_schema_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_schema_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_schema_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_schema_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :update_schema_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete schema config for a subject.
              #
              # @overload delete_schema_config(request, options = nil)
              #   Pass arguments to `delete_schema_config` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_schema_config(name: nil)
              #   Pass arguments to `delete_schema_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of subject to delete the config for. The format
              #     is
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/config/\\{subject}
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest.new
              #
              #   # Call the delete_schema_config method.
              #   result = client.delete_schema_config request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaConfig.
              #   p result
              #
              def delete_schema_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_schema_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_schema_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_schema_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :delete_schema_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get mode at global level or for a subject.
              #
              # @overload get_schema_mode(request, options = nil)
              #   Pass arguments to `get_schema_mode` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_schema_mode(name: nil)
              #   Pass arguments to `get_schema_mode` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the mode. The format is
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/mode/\\{subject}: mode for a schema registry, or
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/contexts/\\{context}/mode/\\{subject}: mode for a specific subject in a specific context
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest.new
              #
              #   # Call the get_schema_mode method.
              #   result = client.get_schema_mode request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode.
              #   p result
              #
              def get_schema_mode request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::GetSchemaModeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_schema_mode.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_schema_mode.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_schema_mode.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :get_schema_mode, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update mode at global level or for a subject.
              #
              # @overload update_schema_mode(request, options = nil)
              #   Pass arguments to `update_schema_mode` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_schema_mode(name: nil, mode: nil)
              #   Pass arguments to `update_schema_mode` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the mode. The format is
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/mode/\\{subject}: mode for a schema registry, or
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/contexts/\\{context}/mode/\\{subject}: mode for a specific subject in a specific context
              #   @param mode [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode::ModeType]
              #     Required. The mode type.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest.new
              #
              #   # Call the update_schema_mode method.
              #   result = client.update_schema_mode request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode.
              #   p result
              #
              def update_schema_mode request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::UpdateSchemaModeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_schema_mode.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_schema_mode.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_schema_mode.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :update_schema_mode, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete schema mode for a subject.
              #
              # @overload delete_schema_mode(request, options = nil)
              #   Pass arguments to `delete_schema_mode` via a request object, either of type
              #   {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_schema_mode(name: nil)
              #   Pass arguments to `delete_schema_mode` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of subject to delete the mode for. The format
              #     is
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/mode/\\{subject}
              #       * projects/\\{project}/locations/\\{location}/schemaRegistries/\\{schema_registry}/contexts/\\{context}/mode/\\{subject}
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/managed_kafka/schema_registry/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest.new
              #
              #   # Call the delete_schema_mode method.
              #   result = client.delete_schema_mode request
              #
              #   # The returned object is of type Google::Cloud::ManagedKafka::SchemaRegistry::V1::SchemaMode.
              #   p result
              #
              def delete_schema_mode request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::DeleteSchemaModeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_schema_mode.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_schema_mode.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_schema_mode.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @managed_schema_registry_stub.call_rpc :delete_schema_mode, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ManagedSchemaRegistry API.
              #
              # This class represents the configuration for ManagedSchemaRegistry,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_schema_registry to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_schema_registry.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_schema_registry.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::ManagedKafka::SchemaRegistry::V1::ManagedSchemaRegistry::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "managedkafka.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the ManagedSchemaRegistry API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_schema_registry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_schema_registry
                  ##
                  # RPC-specific configuration for `list_schema_registries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_schema_registries
                  ##
                  # RPC-specific configuration for `create_schema_registry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_schema_registry
                  ##
                  # RPC-specific configuration for `delete_schema_registry`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_schema_registry
                  ##
                  # RPC-specific configuration for `get_context`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_context
                  ##
                  # RPC-specific configuration for `list_contexts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_contexts
                  ##
                  # RPC-specific configuration for `get_schema`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_schema
                  ##
                  # RPC-specific configuration for `get_raw_schema`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_raw_schema
                  ##
                  # RPC-specific configuration for `list_schema_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_schema_versions
                  ##
                  # RPC-specific configuration for `list_schema_types`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_schema_types
                  ##
                  # RPC-specific configuration for `list_subjects`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_subjects
                  ##
                  # RPC-specific configuration for `list_subjects_by_schema_id`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_subjects_by_schema_id
                  ##
                  # RPC-specific configuration for `delete_subject`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_subject
                  ##
                  # RPC-specific configuration for `lookup_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :lookup_version
                  ##
                  # RPC-specific configuration for `get_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_version
                  ##
                  # RPC-specific configuration for `get_raw_schema_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_raw_schema_version
                  ##
                  # RPC-specific configuration for `list_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_versions
                  ##
                  # RPC-specific configuration for `create_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_version
                  ##
                  # RPC-specific configuration for `delete_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_version
                  ##
                  # RPC-specific configuration for `list_referenced_schemas`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_referenced_schemas
                  ##
                  # RPC-specific configuration for `check_compatibility`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :check_compatibility
                  ##
                  # RPC-specific configuration for `get_schema_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_schema_config
                  ##
                  # RPC-specific configuration for `update_schema_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_schema_config
                  ##
                  # RPC-specific configuration for `delete_schema_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_schema_config
                  ##
                  # RPC-specific configuration for `get_schema_mode`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_schema_mode
                  ##
                  # RPC-specific configuration for `update_schema_mode`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_schema_mode
                  ##
                  # RPC-specific configuration for `delete_schema_mode`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_schema_mode

                  # @private
                  def initialize parent_rpcs = nil
                    get_schema_registry_config = parent_rpcs.get_schema_registry if parent_rpcs.respond_to? :get_schema_registry
                    @get_schema_registry = ::Gapic::Config::Method.new get_schema_registry_config
                    list_schema_registries_config = parent_rpcs.list_schema_registries if parent_rpcs.respond_to? :list_schema_registries
                    @list_schema_registries = ::Gapic::Config::Method.new list_schema_registries_config
                    create_schema_registry_config = parent_rpcs.create_schema_registry if parent_rpcs.respond_to? :create_schema_registry
                    @create_schema_registry = ::Gapic::Config::Method.new create_schema_registry_config
                    delete_schema_registry_config = parent_rpcs.delete_schema_registry if parent_rpcs.respond_to? :delete_schema_registry
                    @delete_schema_registry = ::Gapic::Config::Method.new delete_schema_registry_config
                    get_context_config = parent_rpcs.get_context if parent_rpcs.respond_to? :get_context
                    @get_context = ::Gapic::Config::Method.new get_context_config
                    list_contexts_config = parent_rpcs.list_contexts if parent_rpcs.respond_to? :list_contexts
                    @list_contexts = ::Gapic::Config::Method.new list_contexts_config
                    get_schema_config = parent_rpcs.get_schema if parent_rpcs.respond_to? :get_schema
                    @get_schema = ::Gapic::Config::Method.new get_schema_config
                    get_raw_schema_config = parent_rpcs.get_raw_schema if parent_rpcs.respond_to? :get_raw_schema
                    @get_raw_schema = ::Gapic::Config::Method.new get_raw_schema_config
                    list_schema_versions_config = parent_rpcs.list_schema_versions if parent_rpcs.respond_to? :list_schema_versions
                    @list_schema_versions = ::Gapic::Config::Method.new list_schema_versions_config
                    list_schema_types_config = parent_rpcs.list_schema_types if parent_rpcs.respond_to? :list_schema_types
                    @list_schema_types = ::Gapic::Config::Method.new list_schema_types_config
                    list_subjects_config = parent_rpcs.list_subjects if parent_rpcs.respond_to? :list_subjects
                    @list_subjects = ::Gapic::Config::Method.new list_subjects_config
                    list_subjects_by_schema_id_config = parent_rpcs.list_subjects_by_schema_id if parent_rpcs.respond_to? :list_subjects_by_schema_id
                    @list_subjects_by_schema_id = ::Gapic::Config::Method.new list_subjects_by_schema_id_config
                    delete_subject_config = parent_rpcs.delete_subject if parent_rpcs.respond_to? :delete_subject
                    @delete_subject = ::Gapic::Config::Method.new delete_subject_config
                    lookup_version_config = parent_rpcs.lookup_version if parent_rpcs.respond_to? :lookup_version
                    @lookup_version = ::Gapic::Config::Method.new lookup_version_config
                    get_version_config = parent_rpcs.get_version if parent_rpcs.respond_to? :get_version
                    @get_version = ::Gapic::Config::Method.new get_version_config
                    get_raw_schema_version_config = parent_rpcs.get_raw_schema_version if parent_rpcs.respond_to? :get_raw_schema_version
                    @get_raw_schema_version = ::Gapic::Config::Method.new get_raw_schema_version_config
                    list_versions_config = parent_rpcs.list_versions if parent_rpcs.respond_to? :list_versions
                    @list_versions = ::Gapic::Config::Method.new list_versions_config
                    create_version_config = parent_rpcs.create_version if parent_rpcs.respond_to? :create_version
                    @create_version = ::Gapic::Config::Method.new create_version_config
                    delete_version_config = parent_rpcs.delete_version if parent_rpcs.respond_to? :delete_version
                    @delete_version = ::Gapic::Config::Method.new delete_version_config
                    list_referenced_schemas_config = parent_rpcs.list_referenced_schemas if parent_rpcs.respond_to? :list_referenced_schemas
                    @list_referenced_schemas = ::Gapic::Config::Method.new list_referenced_schemas_config
                    check_compatibility_config = parent_rpcs.check_compatibility if parent_rpcs.respond_to? :check_compatibility
                    @check_compatibility = ::Gapic::Config::Method.new check_compatibility_config
                    get_schema_config_config = parent_rpcs.get_schema_config if parent_rpcs.respond_to? :get_schema_config
                    @get_schema_config = ::Gapic::Config::Method.new get_schema_config_config
                    update_schema_config_config = parent_rpcs.update_schema_config if parent_rpcs.respond_to? :update_schema_config
                    @update_schema_config = ::Gapic::Config::Method.new update_schema_config_config
                    delete_schema_config_config = parent_rpcs.delete_schema_config if parent_rpcs.respond_to? :delete_schema_config
                    @delete_schema_config = ::Gapic::Config::Method.new delete_schema_config_config
                    get_schema_mode_config = parent_rpcs.get_schema_mode if parent_rpcs.respond_to? :get_schema_mode
                    @get_schema_mode = ::Gapic::Config::Method.new get_schema_mode_config
                    update_schema_mode_config = parent_rpcs.update_schema_mode if parent_rpcs.respond_to? :update_schema_mode
                    @update_schema_mode = ::Gapic::Config::Method.new update_schema_mode_config
                    delete_schema_mode_config = parent_rpcs.delete_schema_mode if parent_rpcs.respond_to? :delete_schema_mode
                    @delete_schema_mode = ::Gapic::Config::Method.new delete_schema_mode_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
