# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/managed_identities/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :managed_identities do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module ManagedIdentities
      ##
      # Create a new client object for ManagedIdentitiesService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-managed_identities-v1/latest/Google-Cloud-ManagedIdentities-V1-ManagedIdentitiesService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ManagedIdentitiesService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the ManagedIdentitiesService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::ManagedIdentities.managed_identities_service_available?}.
      #
      # ## About ManagedIdentitiesService
      #
      # API Overview
      #
      # The `managedidentites.googleapis.com` service implements the Google Cloud
      # Managed Identites API for identity services
      # (e.g. Microsoft Active Directory).
      #
      # The Managed Identities service provides methods to manage
      # (create/read/update/delete) domains, reset managed identities admin password,
      # add/remove domain controllers in GCP regions and add/remove VPC peering.
      #
      # Data Model
      #
      # The Managed Identities service exposes the following resources:
      #
      # * Locations as global, named as follows:
      #   `projects/{project_id}/locations/global`.
      #
      # * Domains, named as follows:
      #   `/projects/{project_id}/locations/global/domain/{domain_name}`.
      #
      # The `{domain_name}` refers to fully qualified domain name in the customer
      # project e.g. mydomain.myorganization.com, with the following restrictions:
      #
      #  * Must contain only lowercase letters, numbers, periods and hyphens.
      #  * Must start with a letter.
      #  * Must contain between 2-64 characters.
      #  * Must end with a number or a letter.
      #  * Must not start with period.
      #  * First segement length (mydomain form example above) shouldn't exceed
      #    15 chars.
      #  * The last segment cannot be fully numeric.
      #  * Must be unique within the customer project.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [::Object] A client object for the specified version.
      #
      def self.managed_identities_service version: :v1, &block
        require "google/cloud/managed_identities/#{version.to_s.downcase}"

        package_name = Google::Cloud::ManagedIdentities
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::ManagedIdentities.const_get(package_name).const_get(:ManagedIdentitiesService)
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ManagedIdentitiesService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::ManagedIdentities.managed_identities_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ManagedIdentitiesService service,
      # or if the versioned client gem needs an update to support the ManagedIdentitiesService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @return [boolean] Whether the service is available.
      #
      def self.managed_identities_service_available? version: :v1
        require "google/cloud/managed_identities/#{version.to_s.downcase}"
        package_name = Google::Cloud::ManagedIdentities
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::ManagedIdentities.const_get package_name
        return false unless service_module.const_defined? :ManagedIdentitiesService
        service_module = service_module.const_get :ManagedIdentitiesService
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Configure the google-cloud-managed_identities library.
      #
      # The following configuration parameters are supported:
      #
      # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
      #   The path to the keyfile as a String, the contents of the keyfile as a
      #   Hash, or a Google::Auth::Credentials object.
      # * `lib_name` (*type:* `String`) -
      #   The library name as recorded in instrumentation and logging.
      # * `lib_version` (*type:* `String`) -
      #   The library version as recorded in instrumentation and logging.
      # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
      #   An array of interceptors that are run before calls are executed.
      # * `timeout` (*type:* `Numeric`) -
      #   Default timeout in seconds.
      # * `metadata` (*type:* `Hash{Symbol=>String}`) -
      #   Additional headers to be sent with the call.
      # * `retry_policy` (*type:* `Hash`) -
      #   The retry policy. The value is a hash with the following keys:
      #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
      #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
      #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
      #     * `:retry_codes` (*type:* `Array<String>`) -
      #       The error codes that should trigger a retry.
      #
      # @return [::Google::Cloud::Config] The default configuration used by this library
      #
      def self.configure
        yield ::Google::Cloud.configure.managed_identities if block_given?

        ::Google::Cloud.configure.managed_identities
      end
    end
  end
end

helper_path = ::File.join __dir__, "managed_identities", "helpers.rb"
require "google/cloud/managed_identities/helpers" if ::File.file? helper_path
