# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/managedidentities/v1/managed_identities_service_pb"
require "google/cloud/managed_identities/v1/managed_identities_service"

class ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_microsoft_ad_domain
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    domain_name = "hello world"
    domain = {}

    create_microsoft_ad_domain_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_microsoft_ad_domain, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::CreateMicrosoftAdDomainRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["domain_name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedIdentities::V1::Domain), request["domain"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_microsoft_ad_domain_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_microsoft_ad_domain({ parent: parent, domain_name: domain_name, domain: domain }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_microsoft_ad_domain parent: parent, domain_name: domain_name, domain: domain do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_microsoft_ad_domain ::Google::Cloud::ManagedIdentities::V1::CreateMicrosoftAdDomainRequest.new(parent: parent, domain_name: domain_name, domain: domain) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_microsoft_ad_domain({ parent: parent, domain_name: domain_name, domain: domain }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_microsoft_ad_domain(::Google::Cloud::ManagedIdentities::V1::CreateMicrosoftAdDomainRequest.new(parent: parent, domain_name: domain_name, domain: domain), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_microsoft_ad_domain_client_stub.call_rpc_count
    end
  end

  def test_reset_admin_password
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reset_admin_password_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reset_admin_password, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reset_admin_password_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reset_admin_password({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reset_admin_password name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reset_admin_password ::Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reset_admin_password({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reset_admin_password(::Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reset_admin_password_client_stub.call_rpc_count
    end
  end

  def test_list_domains
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedIdentities::V1::ListDomainsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_domains_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_domains, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::ListDomainsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_domains_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_domains({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_domains parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_domains ::Google::Cloud::ManagedIdentities::V1::ListDomainsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_domains({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_domains(::Google::Cloud::ManagedIdentities::V1::ListDomainsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_domains_client_stub.call_rpc_count
    end
  end

  def test_get_domain
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::ManagedIdentities::V1::Domain.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_domain_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_domain, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::GetDomainRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_domain_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_domain({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_domain name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_domain ::Google::Cloud::ManagedIdentities::V1::GetDomainRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_domain({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_domain(::Google::Cloud::ManagedIdentities::V1::GetDomainRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_domain_client_stub.call_rpc_count
    end
  end

  def test_update_domain
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    domain = {}

    update_domain_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_domain, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::UpdateDomainRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedIdentities::V1::Domain), request["domain"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_domain_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_domain({ update_mask: update_mask, domain: domain }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_domain update_mask: update_mask, domain: domain do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_domain ::Google::Cloud::ManagedIdentities::V1::UpdateDomainRequest.new(update_mask: update_mask, domain: domain) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_domain({ update_mask: update_mask, domain: domain }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_domain(::Google::Cloud::ManagedIdentities::V1::UpdateDomainRequest.new(update_mask: update_mask, domain: domain), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_domain_client_stub.call_rpc_count
    end
  end

  def test_delete_domain
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_domain_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_domain, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::DeleteDomainRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_domain_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_domain({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_domain name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_domain ::Google::Cloud::ManagedIdentities::V1::DeleteDomainRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_domain({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_domain(::Google::Cloud::ManagedIdentities::V1::DeleteDomainRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_domain_client_stub.call_rpc_count
    end
  end

  def test_attach_trust
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    trust = {}

    attach_trust_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :attach_trust, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::AttachTrustRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedIdentities::V1::Trust), request["trust"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, attach_trust_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.attach_trust({ name: name, trust: trust }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.attach_trust name: name, trust: trust do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.attach_trust ::Google::Cloud::ManagedIdentities::V1::AttachTrustRequest.new(name: name, trust: trust) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.attach_trust({ name: name, trust: trust }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.attach_trust(::Google::Cloud::ManagedIdentities::V1::AttachTrustRequest.new(name: name, trust: trust), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, attach_trust_client_stub.call_rpc_count
    end
  end

  def test_reconfigure_trust
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    target_domain_name = "hello world"
    target_dns_ip_addresses = ["hello world"]

    reconfigure_trust_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reconfigure_trust, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::ReconfigureTrustRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["target_domain_name"]
      assert_equal ["hello world"], request["target_dns_ip_addresses"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reconfigure_trust_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reconfigure_trust({ name: name, target_domain_name: target_domain_name, target_dns_ip_addresses: target_dns_ip_addresses }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reconfigure_trust name: name, target_domain_name: target_domain_name, target_dns_ip_addresses: target_dns_ip_addresses do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reconfigure_trust ::Google::Cloud::ManagedIdentities::V1::ReconfigureTrustRequest.new(name: name, target_domain_name: target_domain_name, target_dns_ip_addresses: target_dns_ip_addresses) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reconfigure_trust({ name: name, target_domain_name: target_domain_name, target_dns_ip_addresses: target_dns_ip_addresses }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reconfigure_trust(::Google::Cloud::ManagedIdentities::V1::ReconfigureTrustRequest.new(name: name, target_domain_name: target_domain_name, target_dns_ip_addresses: target_dns_ip_addresses), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reconfigure_trust_client_stub.call_rpc_count
    end
  end

  def test_detach_trust
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    trust = {}

    detach_trust_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :detach_trust, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::DetachTrustRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedIdentities::V1::Trust), request["trust"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, detach_trust_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.detach_trust({ name: name, trust: trust }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.detach_trust name: name, trust: trust do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.detach_trust ::Google::Cloud::ManagedIdentities::V1::DetachTrustRequest.new(name: name, trust: trust) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.detach_trust({ name: name, trust: trust }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.detach_trust(::Google::Cloud::ManagedIdentities::V1::DetachTrustRequest.new(name: name, trust: trust), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, detach_trust_client_stub.call_rpc_count
    end
  end

  def test_validate_trust
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    trust = {}

    validate_trust_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :validate_trust, name
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::ValidateTrustRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::ManagedIdentities::V1::Trust), request["trust"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, validate_trust_client_stub do
      # Create client
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.validate_trust({ name: name, trust: trust }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.validate_trust name: name, trust: trust do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.validate_trust ::Google::Cloud::ManagedIdentities::V1::ValidateTrustRequest.new(name: name, trust: trust) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.validate_trust({ name: name, trust: trust }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.validate_trust(::Google::Cloud::ManagedIdentities::V1::ValidateTrustRequest.new(name: name, trust: trust), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, validate_trust_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Operations, client.operations_client
  end
end
