# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/managedidentities/v1/managed_identities_service_pb"

module Google
  module Cloud
    module ManagedIdentities
      module V1
        module ManagedIdentitiesService
          ##
          # Client for the ManagedIdentitiesService service.
          #
          # API Overview
          #
          # The `managedidentites.googleapis.com` service implements the Google Cloud
          # Managed Identites API for identity services
          # (e.g. Microsoft Active Directory).
          #
          # The Managed Identities service provides methods to manage
          # (create/read/update/delete) domains, reset managed identities admin password,
          # add/remove domain controllers in GCP regions and add/remove VPC peering.
          #
          # Data Model
          #
          # The Managed Identities service exposes the following resources:
          #
          # * Locations as global, named as follows:
          #   `projects/{project_id}/locations/global`.
          #
          # * Domains, named as follows:
          #   `/projects/{project_id}/locations/global/domain/{domain_name}`.
          #
          # The `{domain_name}` refers to fully qualified domain name in the customer
          # project e.g. mydomain.myorganization.com, with the following restrictions:
          #
          #  * Must contain only lowercase letters, numbers, periods and hyphens.
          #  * Must start with a letter.
          #  * Must contain between 2-64 characters.
          #  * Must end with a number or a letter.
          #  * Must not start with period.
          #  * First segement length (mydomain form example above) shouldn't exceed
          #    15 chars.
          #  * The last segment cannot be fully numeric.
          #  * Must be unique within the customer project.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "managedidentities.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :managed_identities_service_stub

            ##
            # Configure the ManagedIdentitiesService Client class.
            #
            # See {::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ManagedIdentitiesService clients
            #   ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "ManagedIdentities", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_microsoft_ad_domain.timeout = 60.0

                default_config.rpcs.reset_admin_password.timeout = 60.0

                default_config.rpcs.list_domains.timeout = 60.0

                default_config.rpcs.get_domain.timeout = 60.0

                default_config.rpcs.update_domain.timeout = 60.0

                default_config.rpcs.delete_domain.timeout = 60.0

                default_config.rpcs.attach_trust.timeout = 60.0

                default_config.rpcs.reconfigure_trust.timeout = 60.0

                default_config.rpcs.detach_trust.timeout = 60.0

                default_config.rpcs.validate_trust.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ManagedIdentitiesService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @managed_identities_service_stub.universe_domain
            end

            ##
            # Create a new ManagedIdentitiesService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ManagedIdentitiesService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/managedidentities/v1/managed_identities_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @managed_identities_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @managed_identities_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @managed_identities_service_stub.logger
            end

            # Service calls

            ##
            # Creates a Microsoft AD domain.
            #
            # @overload create_microsoft_ad_domain(request, options = nil)
            #   Pass arguments to `create_microsoft_ad_domain` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::CreateMicrosoftAdDomainRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::CreateMicrosoftAdDomainRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_microsoft_ad_domain(parent: nil, domain_name: nil, domain: nil)
            #   Pass arguments to `create_microsoft_ad_domain` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource project name and location using the form:
            #     `projects/{project_id}/locations/global`
            #   @param domain_name [::String]
            #     Required. The fully qualified domain name.
            #     e.g. mydomain.myorganization.com, with the following restrictions:
            #
            #      * Must contain only lowercase letters, numbers, periods and hyphens.
            #      * Must start with a letter.
            #      * Must contain between 2-64 characters.
            #      * Must end with a number or a letter.
            #      * Must not start with period.
            #      * First segement length (mydomain form example above) shouldn't exceed
            #        15 chars.
            #      * The last segment cannot be fully numeric.
            #      * Must be unique within the customer project.
            #   @param domain [::Google::Cloud::ManagedIdentities::V1::Domain, ::Hash]
            #     Required. A Managed Identity domain resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::CreateMicrosoftAdDomainRequest.new
            #
            #   # Call the create_microsoft_ad_domain method.
            #   result = client.create_microsoft_ad_domain request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_microsoft_ad_domain request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::CreateMicrosoftAdDomainRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_microsoft_ad_domain.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_microsoft_ad_domain.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_microsoft_ad_domain.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :create_microsoft_ad_domain, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resets a domain's administrator password.
            #
            # @overload reset_admin_password(request, options = nil)
            #   Pass arguments to `reset_admin_password` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reset_admin_password(name: nil)
            #   Pass arguments to `reset_admin_password` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The domain resource name using the form:
            #     `projects/{project_id}/locations/global/domains/{domain_name}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordRequest.new
            #
            #   # Call the reset_admin_password method.
            #   result = client.reset_admin_password request
            #
            #   # The returned object is of type Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordResponse.
            #   p result
            #
            def reset_admin_password request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::ResetAdminPasswordRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reset_admin_password.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reset_admin_password.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reset_admin_password.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :reset_admin_password, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists domains in a project.
            #
            # @overload list_domains(request, options = nil)
            #   Pass arguments to `list_domains` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::ListDomainsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::ListDomainsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_domains(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_domains` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the domain location using the form:
            #     `projects/{project_id}/locations/global`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of items to return.
            #     If not specified, a default value of 1000 will be used.
            #     Regardless of the page_size value, the response may include a partial list.
            #     Callers should rely on a response's
            #     {::Google::Cloud::ManagedIdentities::V1::ListDomainsResponse#next_page_token next_page_token}
            #     to determine if there are additional results to list.
            #   @param page_token [::String]
            #     Optional. The `next_page_token` value returned from a previous ListDomainsRequest
            #     request, if any.
            #   @param filter [::String]
            #     Optional. A filter specifying constraints of a list operation.
            #     For example, `Domain.fqdn="mydomain.myorginization"`.
            #   @param order_by [::String]
            #     Optional. Specifies the ordering of results. See
            #     [Sorting
            #     order](https://cloud.google.com/apis/design/design_patterns#sorting_order)
            #     for more information.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ManagedIdentities::V1::Domain>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ManagedIdentities::V1::Domain>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::ListDomainsRequest.new
            #
            #   # Call the list_domains method.
            #   result = client.list_domains request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ManagedIdentities::V1::Domain.
            #     p item
            #   end
            #
            def list_domains request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::ListDomainsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_domains.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_domains.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_domains.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :list_domains, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @managed_identities_service_stub, :list_domains, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets information about a domain.
            #
            # @overload get_domain(request, options = nil)
            #   Pass arguments to `get_domain` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::GetDomainRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::GetDomainRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_domain(name: nil)
            #   Pass arguments to `get_domain` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The domain resource name using the form:
            #     `projects/{project_id}/locations/global/domains/{domain_name}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ManagedIdentities::V1::Domain]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ManagedIdentities::V1::Domain]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::GetDomainRequest.new
            #
            #   # Call the get_domain method.
            #   result = client.get_domain request
            #
            #   # The returned object is of type Google::Cloud::ManagedIdentities::V1::Domain.
            #   p result
            #
            def get_domain request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::GetDomainRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_domain.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_domain.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_domain.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :get_domain, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the metadata and configuration of a domain.
            #
            # @overload update_domain(request, options = nil)
            #   Pass arguments to `update_domain` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::UpdateDomainRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::UpdateDomainRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_domain(update_mask: nil, domain: nil)
            #   Pass arguments to `update_domain` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update. At least one path must be supplied in this
            #     field. The elements of the repeated paths field may only include
            #     fields from {::Google::Cloud::ManagedIdentities::V1::Domain Domain}:
            #      * `labels`
            #      * `locations`
            #      * `authorized_networks`
            #   @param domain [::Google::Cloud::ManagedIdentities::V1::Domain, ::Hash]
            #     Required. Domain message with updated fields. Only supported fields specified in
            #     update_mask are updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::UpdateDomainRequest.new
            #
            #   # Call the update_domain method.
            #   result = client.update_domain request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_domain request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::UpdateDomainRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_domain.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.domain&.name
                header_params["domain.name"] = request.domain.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_domain.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_domain.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :update_domain, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a domain.
            #
            # @overload delete_domain(request, options = nil)
            #   Pass arguments to `delete_domain` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::DeleteDomainRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::DeleteDomainRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_domain(name: nil)
            #   Pass arguments to `delete_domain` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The domain resource name using the form:
            #     `projects/{project_id}/locations/global/domains/{domain_name}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::DeleteDomainRequest.new
            #
            #   # Call the delete_domain method.
            #   result = client.delete_domain request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_domain request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::DeleteDomainRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_domain.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_domain.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_domain.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :delete_domain, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Adds an AD trust to a domain.
            #
            # @overload attach_trust(request, options = nil)
            #   Pass arguments to `attach_trust` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::AttachTrustRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::AttachTrustRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload attach_trust(name: nil, trust: nil)
            #   Pass arguments to `attach_trust` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource domain name, project name and location using the form:
            #     `projects/{project_id}/locations/global/domains/{domain_name}`
            #   @param trust [::Google::Cloud::ManagedIdentities::V1::Trust, ::Hash]
            #     Required. The domain trust resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::AttachTrustRequest.new
            #
            #   # Call the attach_trust method.
            #   result = client.attach_trust request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def attach_trust request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::AttachTrustRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.attach_trust.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.attach_trust.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.attach_trust.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :attach_trust, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the DNS conditional forwarder.
            #
            # @overload reconfigure_trust(request, options = nil)
            #   Pass arguments to `reconfigure_trust` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::ReconfigureTrustRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::ReconfigureTrustRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reconfigure_trust(name: nil, target_domain_name: nil, target_dns_ip_addresses: nil)
            #   Pass arguments to `reconfigure_trust` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource domain name, project name and location using the form:
            #     `projects/{project_id}/locations/global/domains/{domain_name}`
            #   @param target_domain_name [::String]
            #     Required. The fully-qualified target domain name which will be in trust with current
            #     domain.
            #   @param target_dns_ip_addresses [::Array<::String>]
            #     Required. The target DNS server IP addresses to resolve the remote domain involved
            #     in the trust.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::ReconfigureTrustRequest.new
            #
            #   # Call the reconfigure_trust method.
            #   result = client.reconfigure_trust request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def reconfigure_trust request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::ReconfigureTrustRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reconfigure_trust.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reconfigure_trust.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reconfigure_trust.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :reconfigure_trust, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Removes an AD trust.
            #
            # @overload detach_trust(request, options = nil)
            #   Pass arguments to `detach_trust` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::DetachTrustRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::DetachTrustRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload detach_trust(name: nil, trust: nil)
            #   Pass arguments to `detach_trust` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource domain name, project name, and location using the form:
            #     `projects/{project_id}/locations/global/domains/{domain_name}`
            #   @param trust [::Google::Cloud::ManagedIdentities::V1::Trust, ::Hash]
            #     Required. The domain trust resource to removed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::DetachTrustRequest.new
            #
            #   # Call the detach_trust method.
            #   result = client.detach_trust request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def detach_trust request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::DetachTrustRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.detach_trust.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.detach_trust.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.detach_trust.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :detach_trust, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Validates a trust state, that the target domain is reachable, and that the
            # target domain is able to accept incoming trust requests.
            #
            # @overload validate_trust(request, options = nil)
            #   Pass arguments to `validate_trust` via a request object, either of type
            #   {::Google::Cloud::ManagedIdentities::V1::ValidateTrustRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ManagedIdentities::V1::ValidateTrustRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload validate_trust(name: nil, trust: nil)
            #   Pass arguments to `validate_trust` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource domain name, project name, and location using the form:
            #     `projects/{project_id}/locations/global/domains/{domain_name}`
            #   @param trust [::Google::Cloud::ManagedIdentities::V1::Trust, ::Hash]
            #     Required. The domain trust to validate trust state for.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/managed_identities/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ManagedIdentities::V1::ValidateTrustRequest.new
            #
            #   # Call the validate_trust method.
            #   result = client.validate_trust request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def validate_trust request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ManagedIdentities::V1::ValidateTrustRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.validate_trust.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ManagedIdentities::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.validate_trust.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.validate_trust.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @managed_identities_service_stub.call_rpc :validate_trust, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ManagedIdentitiesService API.
            #
            # This class represents the configuration for ManagedIdentitiesService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_microsoft_ad_domain to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_microsoft_ad_domain.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_microsoft_ad_domain.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::ManagedIdentities::V1::ManagedIdentitiesService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "managedidentities.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ManagedIdentitiesService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_microsoft_ad_domain`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_microsoft_ad_domain
                ##
                # RPC-specific configuration for `reset_admin_password`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reset_admin_password
                ##
                # RPC-specific configuration for `list_domains`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_domains
                ##
                # RPC-specific configuration for `get_domain`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_domain
                ##
                # RPC-specific configuration for `update_domain`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_domain
                ##
                # RPC-specific configuration for `delete_domain`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_domain
                ##
                # RPC-specific configuration for `attach_trust`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :attach_trust
                ##
                # RPC-specific configuration for `reconfigure_trust`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reconfigure_trust
                ##
                # RPC-specific configuration for `detach_trust`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :detach_trust
                ##
                # RPC-specific configuration for `validate_trust`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :validate_trust

                # @private
                def initialize parent_rpcs = nil
                  create_microsoft_ad_domain_config = parent_rpcs.create_microsoft_ad_domain if parent_rpcs.respond_to? :create_microsoft_ad_domain
                  @create_microsoft_ad_domain = ::Gapic::Config::Method.new create_microsoft_ad_domain_config
                  reset_admin_password_config = parent_rpcs.reset_admin_password if parent_rpcs.respond_to? :reset_admin_password
                  @reset_admin_password = ::Gapic::Config::Method.new reset_admin_password_config
                  list_domains_config = parent_rpcs.list_domains if parent_rpcs.respond_to? :list_domains
                  @list_domains = ::Gapic::Config::Method.new list_domains_config
                  get_domain_config = parent_rpcs.get_domain if parent_rpcs.respond_to? :get_domain
                  @get_domain = ::Gapic::Config::Method.new get_domain_config
                  update_domain_config = parent_rpcs.update_domain if parent_rpcs.respond_to? :update_domain
                  @update_domain = ::Gapic::Config::Method.new update_domain_config
                  delete_domain_config = parent_rpcs.delete_domain if parent_rpcs.respond_to? :delete_domain
                  @delete_domain = ::Gapic::Config::Method.new delete_domain_config
                  attach_trust_config = parent_rpcs.attach_trust if parent_rpcs.respond_to? :attach_trust
                  @attach_trust = ::Gapic::Config::Method.new attach_trust_config
                  reconfigure_trust_config = parent_rpcs.reconfigure_trust if parent_rpcs.respond_to? :reconfigure_trust
                  @reconfigure_trust = ::Gapic::Config::Method.new reconfigure_trust_config
                  detach_trust_config = parent_rpcs.detach_trust if parent_rpcs.respond_to? :detach_trust
                  @detach_trust = ::Gapic::Config::Method.new detach_trust_config
                  validate_trust_config = parent_rpcs.validate_trust if parent_rpcs.respond_to? :validate_trust
                  @validate_trust = ::Gapic::Config::Method.new validate_trust_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
