# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Maintenance
      module Api
        module V1beta
          # Request message for SummarizeMaintenances custom method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the resource maintenance.
          #     eg. `projects/123/locations/*`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of resource maintenances to send per page. The default
          #     page size is 20 and the maximum is 1000.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          #     Supported fields include:
          #     - state
          #     - resource.location
          #     - resource.resourceName
          #     - resource.type
          #     - maintenance.maintenanceName
          #     - maintenanceStartTime
          #     - maintenanceCompleteTime
          #     Examples:
          #     - state="SCHEDULED"
          #     - resource.location="us-central1-c"
          #     - resource.resourceName=~"*/instance-20241212-211259"
          #     - maintenanceStartTime>"2000-10-11T20:44:51Z"
          #     - state="SCHEDULED" OR resource.type="compute.googleapis.com/Instance"
          #     - maintenance.maitenanceName="eb3b709c-9ca1-5472-9fb6-800a3849eda1" AND
          #     maintenanceCompleteTime>"2000-10-11T20:44:51Z"
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class SummarizeMaintenancesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for SummarizeMaintenances custom method.
          # @!attribute [rw] maintenances
          #   @return [::Array<::Google::Cloud::Maintenance::Api::V1beta::MaintenanceSummary>]
          #     The resulting summaries.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     SummarizeMaintenances call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Unordered list. Locations that could not be reached.
          class SummarizeMaintenancesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # MaintenanceSummary contains maintenance statistics calculated based on
          # ResourceMaintenances within the scope: project and location.
          # @!attribute [r] maintenance_name
          #   @return [::String]
          #     Output only. The name of the maintenance.
          # @!attribute [r] title
          #   @return [::String]
          #     Output only. The title of the maintenance.
          # @!attribute [r] description
          #   @return [::String]
          #     Output only. The description of the maintenance.
          # @!attribute [r] category
          #   @return [::Google::Cloud::Maintenance::Api::V1beta::MaintenanceCategory]
          #     Output only. The category of the maintenance event.
          # @!attribute [r] maintenance_scheduled_start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Scheduled start time of the maintenance. The maintenance will
          #     start at `maintenanceScheduledStartTime` or later, with best effort to
          #     finish before `maintenanceScheduledEndTime`.
          # @!attribute [r] maintenance_scheduled_end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. An estimated (best effort, not guaranteed) end time of the
          #     scheduled maintenance.
          # @!attribute [r] maintenance_start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Actual date when the maintenance started. Field present only
          #     after the state changed to `RUNNING`.
          # @!attribute [r] maintenance_end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Actual date when the maintenance successfully completed. Field
          #     present only after the state changed to `SUCCEEDED`.
          # @!attribute [r] user_controllable
          #   @return [::Boolean]
          #     Output only. Indicates whether the user has some control over that
          #     maintenance, either proactively before maintenance was scheduled with
          #     maintenance policy or with reactive controls after it was scheduled (see
          #     controls field).
          # @!attribute [r] controls
          #   @return [::Array<::Google::Cloud::Maintenance::Api::V1beta::MaintenanceControl>]
          #     Output only. Control available for that Maintenance (might not be available
          #     for every resource that maintenance is applied to).
          # @!attribute [r] stats
          #   @return [::Array<::Google::Cloud::Maintenance::Api::V1beta::MaintenanceSummary::Stats>]
          #     Output only. Stats is a field of ResourceMaintenance used to aggregate the
          #     stats.
          class MaintenanceSummary
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Stats indicates the type of aggregate and the corresponding aggregates.
            # @!attribute [rw] group_by
            #   @return [::String]
            #     groupBy specifies the type of aggregate.
            #     For example a group_by might be `"state"`
            # @!attribute [rw] aggregates
            #   @return [::Array<::Google::Cloud::Maintenance::Api::V1beta::MaintenanceSummary::Aggregate>]
            #     Aggregates is a list <group, count> pairs. For example, if the
            #     group_by is `"state"` a possible tuple in the aggregates list could be
            #     "SCHEDULED" : `11`,
            class Stats
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Aggregate is a <group, count> pair.
            # @!attribute [rw] group
            #   @return [::String]
            #     Specifies what specific value of the group_by the count represents. For
            #     example if group_by is `"state"` its corresponding group could be
            #     `"SCHEDULED"`.
            # @!attribute [rw] count
            #   @return [::Integer]
            #     The count of the group.
            class Aggregate
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # ResourceMaintenance is a resource that represents a maintenance operation
          # on a resource.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the resource_maintenance resource.
          #     Format:
          #     `"projects/{project}/locations/{location}/resourceMaintenance/{resource-maintenance-id}"`
          # @!attribute [r] resource
          #   @return [::Google::Cloud::Maintenance::Api::V1beta::ResourceMaintenance::Resource]
          #     Output only. The resource spec of the resource maintenance.
          # @!attribute [r] maintenance
          #   @return [::Google::Cloud::Maintenance::Api::V1beta::ResourceMaintenance::Maintenance]
          #     Output only. The details of the maintenance.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Maintenance::Api::V1beta::ResourceMaintenance::State]
          #     Output only. The state of the resource maintenance.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The create time of the resource maintenance.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The update time of the resource maintenance.
          # @!attribute [r] maintenance_start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the resource maintenance has started.
          # @!attribute [r] maintenance_end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the resource maintenance has completed.
          # @!attribute [r] maintenance_cancel_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the resource maintenance was cancelled.
          # @!attribute [r] maintenance_scheduled_start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the maintenance on the resource was scheduled to
          #     start.
          # @!attribute [r] maintenance_scheduled_end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the maintenance on the resource was scheduled to
          #     end.
          # @!attribute [r] user_controllable
          #   @return [::Boolean]
          #     Output only. Indicates whether the user has some control over that
          #     maintenance, either
          #      proactively before maintenance was scheduled with maintenance policy or
          #      with reactive controls after it was scheduled (see controls field)
          # @!attribute [r] controls
          #   @return [::Array<::Google::Cloud::Maintenance::Api::V1beta::MaintenanceControl>]
          #     Output only. The controls of the maintenance.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The labels on the resource, which can be used for categorization.
          #     similar to Kubernetes resource labels.
          # @!attribute [rw] annotations
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Annotations is an unstructured key-value map stored with a
          #     resource that may be set by external tools to store and retrieve arbitrary
          #     metadata. They are not queryable and should be preserved when modifying
          #     objects.
          #
          #     More info: https://kubernetes.io/docs/user-guide/annotations
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. The unique identifier of the resource. UID is unique in the
          #     time and space for this resource within the scope of the service. It is
          #     typically generated by the server on successful creation of a resource
          #     and must not be changed. UID is used to uniquely identify resources
          #     with resource name reuses. This should be a UUID4.
          # @!attribute [r] etag
          #   @return [::String]
          #     Output only. An opaque value that uniquely identifies a version or
          #     generation of a resource. It can be used to confirm that the client
          #     and server agree on the ordering of a resource being written.
          class ResourceMaintenance
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Resource contains information about the resource affected by maintenance.
            # @!attribute [r] resource_name
            #   @return [::String]
            #     Output only. Name is the reference to the consumer resource affected by
            #     the maintenance. Available values can be found here:
            #     https://cloud.google.com/asset-inventory/docs/asset-names
            # @!attribute [r] location
            #   @return [::String]
            #     Output only. The location of the resource.
            #     Format:
            #     `us-central1`
            # @!attribute [r] type
            #   @return [::String]
            #     Output only. The type of the resource.
            #     Available values can be found here:
            #     https://cloud.google.com/asset-inventory/docs/asset-types#supported_resource_types
            #     Please note that not all the resource types will have their maintenances
            #     reported.
            class Resource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Maintenance is the maintenance details of a resource's maintenance.
            # @!attribute [rw] maintenance_name
            #   @return [::String]
            #     Maintenance is the name of the corresponding maintenance resource
            #     following the standard naming scheme: `"{maintenance-id}"`
            # @!attribute [r] title
            #   @return [::String]
            #     Output only. The title of the maintenance.
            # @!attribute [r] description
            #   @return [::String]
            #     Output only. The description of the maintenance.
            # @!attribute [r] category
            #   @return [::Google::Cloud::Maintenance::Api::V1beta::MaintenanceCategory]
            #     Output only. The category of the maintenance.
            class Maintenance
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AnnotationsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # State is the state of a resource maintenance.
            module State
              # Unspecified state.
              STATE_UNSPECIFIED = 0

              # Scheduled for a particular window. For disruptive maintenance it should
              # respect maintenance policy, i.e. its available windows, exclusions and
              # notification period.
              SCHEDULED = 1

              # Maintenance is ongoing.
              RUNNING = 2

              # No longer planned, typically when other maintenance (e.g. upgrade to
              # newer version) already happened, or the user skipped the maintenance.
              CANCELLED = 3

              # Successfully completed.
              SUCCEEDED = 4
            end
          end

          # The control of the maintenance.
          # @!attribute [rw] control
          #   @return [::Google::Cloud::Maintenance::Api::V1beta::MaintenanceControl::Control]
          #     The control of the resource maintenance.
          # @!attribute [rw] is_custom
          #   @return [::Boolean]
          #     Indicates whether the control is available only in Service Producer API
          #     (not through Unified Maintenance).
          # @!attribute [rw] documentation
          #   @return [::String]
          #     Link to Service Producer documentation about maintenance control. Provided
          #     only when `isCustom` is `true`.
          class MaintenanceControl
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Sets the type of control supported. comment (as in logs).
            module Control
              # Unspecified control.
              CONTROL_UNSPECIFIED = 0

              # Apply control.
              APPLY = 1

              # Manage policy control.
              MANAGE_POLICY = 2

              # Reschedule control.
              RESCHEDULE = 3
            end
          end

          # The request structure for the ListResourceMaintenances method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent of the resource maintenance.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of resource maintenances to send per page.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The page token: If the next_page_token from a previous response
          #     is provided, this request will send the subsequent page.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filter the list as specified in https://google.aip.dev/160.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Order results as specified in https://google.aip.dev/132.
          class ListResourceMaintenancesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response structure for the ListResourceMaintenances method.
          # @!attribute [rw] resource_maintenances
          #   @return [::Array<::Google::Cloud::Maintenance::Api::V1beta::ResourceMaintenance>]
          #     The resulting resource maintenances.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     If present, the next page token can be provided to a subsequent
          #     ListResourceMaintenances call to list the next page.
          #     If empty, there are no more pages.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListResourceMaintenancesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request structure for the GetResourceMaintenance method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the resource within a service.
          class GetResourceMaintenanceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The Category of the maintenance.
          module MaintenanceCategory
            # Unspecified category.
            MAINTENANCE_CATEGORY_UNSPECIFIED = 0

            # Infrastructure maintenance events are times that Google Cloud performs
            # regular maintenance on network equipment e.g. Google Cloud Interconnect
            # These events are usually scheduled in advance and we provide
            # notification, when possible, so that users can plan for the
            # infrastructure maintenance event and prevent downtime. Infrastructure
            # maintenance events don't have a set interval between occurrences, but
            # generally occur several times a year.
            INFRASTRUCTURE = 1

            # Updates that can include bug fixes, changes, or new features that are
            # backward compatible with existing versions (including patches).
            # Some SPs allow users to control the scheduling of these maintenance
            # events using maintenance windows and/or deny maintenance features.
            SERVICE_UPDATE = 3
          end
        end
      end
    end
  end
end
