# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Lustre
      module V1
        # Message for importing data to Lustre.
        # @!attribute [rw] gcs_path
        #   @return [::Google::Cloud::Lustre::V1::GcsPath]
        #     The Cloud Storage source bucket and, optionally, path inside the bucket.
        #     If a path inside the bucket is specified, it must end with a forward
        #     slash (`/`).
        # @!attribute [rw] lustre_path
        #   @return [::Google::Cloud::Lustre::V1::LustrePath]
        #     Lustre path destination.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Managed Lustre instance in the format
        #     `projects/{project}/locations/{location}/instances/{instance}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. UUID to identify requests.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. User-specified service account used to perform the transfer.
        #     If unspecified, the default Managed Lustre service agent will be used.
        class ImportDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Export data from Managed Lustre to a Cloud Storage bucket.
        # @!attribute [rw] lustre_path
        #   @return [::Google::Cloud::Lustre::V1::LustrePath]
        #     The root directory path to the Managed Lustre file system. Must start
        #     with `/`. Default is `/`.
        # @!attribute [rw] gcs_path
        #   @return [::Google::Cloud::Lustre::V1::GcsPath]
        #     The URI to a Cloud Storage bucket, or a path within a bucket, using
        #     the format `gs://<bucket_name>/<optional_path_inside_bucket>/`. If a
        #     path inside the bucket is specified, it must end with a forward slash
        #     (`/`).
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Managed Lustre instance in the format
        #     `projects/{project}/locations/{location}/instances/{instance}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. UUID to identify requests.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. User-specified service account used to perform the transfer.
        #     If unspecified, the Managed Lustre service agent is used.
        class ExportDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ExportData.
        class ExportDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ImportData.
        class ImportDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata of the export data operation.
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::Lustre::V1::TransferOperationMetadata]
        #     Data transfer operation metadata.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class ExportDataMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata of the import data operation.
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::Lustre::V1::TransferOperationMetadata]
        #     Data transfer operation metadata.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class ImportDataMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies a Cloud Storage bucket and, optionally, a path inside the bucket.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. The URI to a Cloud Storage bucket, or a path within a bucket,
        #     using the format `gs://<bucket_name>/<optional_path_inside_bucket>/`. If a
        #     path inside the bucket is specified, it must end with a forward slash
        #     (`/`).
        class GcsPath
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The root directory path to the Lustre file system.
        # @!attribute [rw] path
        #   @return [::String]
        #     Optional. The root directory path to the Managed Lustre file system. Must
        #     start with
        #     `/`. Default is `/`. If you're importing data into Managed Lustre, any
        #     path other than the default must already exist on the file system.
        class LustrePath
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of counters that report the progress of a transfer operation.
        # @!attribute [rw] found_objects_count
        #   @return [::Integer]
        #     Objects found in the data source that are scheduled to be transferred,
        #     excluding any that are filtered based on object conditions or skipped due
        #     to sync.
        # @!attribute [rw] bytes_found_count
        #   @return [::Integer]
        #     Total number of bytes found in the data source that are scheduled to be
        #     transferred, excluding any that are filtered based on object conditions or
        #     skipped due to sync.
        # @!attribute [rw] objects_skipped_count
        #   @return [::Integer]
        #     Objects in the data source that are not transferred because they already
        #     exist in the data destination.
        # @!attribute [rw] bytes_skipped_count
        #   @return [::Integer]
        #     Bytes in the data source that are not transferred because they already
        #     exist in the data destination.
        # @!attribute [rw] objects_copied_count
        #   @return [::Integer]
        #     Objects that are copied to the data destination.
        # @!attribute [rw] bytes_copied_count
        #   @return [::Integer]
        #     Bytes that are copied to the data destination.
        # @!attribute [r] objects_failed_count
        #   @return [::Integer]
        #     Output only. Objects that are failed to write to the data destination.
        # @!attribute [r] bytes_failed_count
        #   @return [::Integer]
        #     Output only. Bytes that are failed to write to the data destination.
        class TransferCounters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An entry describing an error that has occurred.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. A URL that refers to the target (a data source, a data sink,
        #     or an object) with which the error is associated.
        # @!attribute [rw] error_details
        #   @return [::Array<::String>]
        #     A list of messages that carry the error details.
        class ErrorLogEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A summary of errors by error code, plus a count and sample error log
        # entries.
        # @!attribute [rw] error_code
        #   @return [::Google::Rpc::Code]
        #     Required.
        # @!attribute [rw] error_count
        #   @return [::Integer]
        #     Required. Count of this type of error.
        # @!attribute [rw] error_log_entries
        #   @return [::Array<::Google::Cloud::Lustre::V1::ErrorLogEntry>]
        #     Error samples.
        #
        #     At most 5 error log entries are recorded for a given
        #     error code for a single transfer operation.
        class ErrorSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running transfer operation.
        # @!attribute [r] source_lustre_path
        #   @return [::Google::Cloud::Lustre::V1::LustrePath]
        #     Output only. Lustre source.
        #
        #     Note: The following fields are mutually exclusive: `source_lustre_path`, `source_gcs_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] source_gcs_path
        #   @return [::Google::Cloud::Lustre::V1::GcsPath]
        #     Output only. Cloud Storage source.
        #
        #     Note: The following fields are mutually exclusive: `source_gcs_path`, `source_lustre_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] destination_gcs_path
        #   @return [::Google::Cloud::Lustre::V1::GcsPath]
        #     Output only. Cloud Storage destination.
        #
        #     Note: The following fields are mutually exclusive: `destination_gcs_path`, `destination_lustre_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] destination_lustre_path
        #   @return [::Google::Cloud::Lustre::V1::LustrePath]
        #     Output only. Lustre destination.
        #
        #     Note: The following fields are mutually exclusive: `destination_lustre_path`, `destination_gcs_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] counters
        #   @return [::Google::Cloud::Lustre::V1::TransferCounters]
        #     Output only. The progress of the transfer operation.
        # @!attribute [r] transfer_type
        #   @return [::Google::Cloud::Lustre::V1::TransferType]
        #     Output only. The type of transfer occurring.
        # @!attribute [r] error_summaries
        #   @return [::Array<::Google::Cloud::Lustre::V1::ErrorSummary>]
        #     Output only. Error summary about the transfer operation
        class TransferOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Type of transfer that occurred.
        module TransferType
          # Zero is an illegal value.
          TRANSFER_TYPE_UNSPECIFIED = 0

          # Imports to Lustre.
          IMPORT = 1

          # Exports from Lustre.
          EXPORT = 2
        end
      end
    end
  end
end
