# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Lustre
      module V1
        # A Managed Lustre instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the instance.
        # @!attribute [rw] filesystem
        #   @return [::String]
        #     Required. Immutable. The filesystem name for this instance. This name is
        #     used by client-side tools, including when mounting the instance. Must be
        #     eight characters or less and can only contain letters and numbers.
        # @!attribute [rw] capacity_gib
        #   @return [::Integer]
        #     Required. The storage capacity of the instance in gibibytes (GiB). Allowed
        #     values are from `18000` to `954000`, in increments of 9000.
        # @!attribute [rw] network
        #   @return [::String]
        #     Required. Immutable. The full name of the VPC network to which the instance
        #     is connected. Must be in the format
        #     `projects/{project_id}/global/networks/{network_name}`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Lustre::V1::Instance::State]
        #     Output only. The state of the instance.
        # @!attribute [r] mount_point
        #   @return [::String]
        #     Output only. Mount point of the instance in the format
        #     `IP_ADDRESS@tcp:/FILESYSTEM`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the instance was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the instance was last updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A user-readable description of the instance.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs.
        # @!attribute [rw] per_unit_storage_throughput
        #   @return [::Integer]
        #     Required. The throughput of the instance in MB/s/TiB.
        #     Valid values are 125, 250, 500, 1000.
        # @!attribute [rw] gke_support_enabled
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Optional. Indicates whether you want to enable support for GKE clients. By
        #     default, GKE clients are not supported. Deprecated. No longer required for
        #     GKE instance creation.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The possible states of an instance.
          module State
            # Not set.
            STATE_UNSPECIFIED = 0

            # The instance is available for use.
            ACTIVE = 1

            # The instance is being created and is not yet ready for use.
            CREATING = 2

            # The instance is being deleted.
            DELETING = 3

            # The instance is being upgraded.
            UPGRADING = 4

            # The instance is being repaired.
            REPAIRING = 5

            # The instance is stopped.
            STOPPED = 6

            # The instance is being updated.
            UPDATING = 7
          end
        end

        # Message for requesting list of Instances
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve a list of
        #     instances, in the format `projects/{projectId}/locations/{location}`.
        #
        #     To retrieve instance information for all locations, use "-" as the value
        #     of `{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server might return fewer items than
        #     requested. If unspecified, the server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Desired order of results.
        class ListInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Instances
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::Lustre::V1::Instance>]
        #     Response from {::Google::Cloud::Lustre::V1::Lustre::Client#list_instances ListInstances}.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Instance
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The instance resource name, in the format
        #     `projects/{projectId}/locations/{location}/instances/{instanceId}`.
        class GetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Instance
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The instance's project and location, in the format
        #     `projects/{project}/locations/{location}`. Locations map to Google Cloud
        #     zones; for example, `us-west1-b`.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. The name of the Managed Lustre instance.
        #
        #     * Must contain only lowercase letters, numbers, and hyphens.
        #     * Must start with a letter.
        #     * Must be between 1-63 characters.
        #     * Must end with a number or a letter.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::Lustre::V1::Instance]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Instance
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Specifies the fields to be overwritten in the instance resource
        #     by the update.
        #
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If no
        #     mask is provided then all fields present in the request are
        #     overwritten.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::Lustre::V1::Instance]
        #     Required. The resource name of the instance to update, in the format
        #     `projects/{projectId}/locations/{location}/instances/{instanceId}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Instance
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the instance to delete, in the format
        #     `projects/{projectId}/locations/{location}/instances/{instanceId}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of a long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
