# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/logging/v2/logging_config_pb"
require "google/cloud/logging/v2/config_service"

class ::Google::Cloud::Logging::V2::ConfigService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_buckets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::ListBucketsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_buckets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_buckets, name
      assert_kind_of ::Google::Cloud::Logging::V2::ListBucketsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_buckets_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_buckets({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_buckets parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_buckets ::Google::Cloud::Logging::V2::ListBucketsRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_buckets({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_buckets(::Google::Cloud::Logging::V2::ListBucketsRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_buckets_client_stub.call_rpc_count
    end
  end

  def test_get_bucket
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogBucket.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_bucket_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_bucket, name
      assert_kind_of ::Google::Cloud::Logging::V2::GetBucketRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_bucket_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_bucket({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_bucket name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_bucket ::Google::Cloud::Logging::V2::GetBucketRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_bucket({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_bucket(::Google::Cloud::Logging::V2::GetBucketRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_bucket_client_stub.call_rpc_count
    end
  end

  def test_create_bucket_async
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    bucket_id = "hello world"
    bucket = {}

    create_bucket_async_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_bucket_async, name
      assert_kind_of ::Google::Cloud::Logging::V2::CreateBucketRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["bucket_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogBucket), request["bucket"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_bucket_async_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_bucket_async({ parent: parent, bucket_id: bucket_id, bucket: bucket }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_bucket_async parent: parent, bucket_id: bucket_id, bucket: bucket do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_bucket_async ::Google::Cloud::Logging::V2::CreateBucketRequest.new(parent: parent, bucket_id: bucket_id, bucket: bucket) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_bucket_async({ parent: parent, bucket_id: bucket_id, bucket: bucket }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_bucket_async(::Google::Cloud::Logging::V2::CreateBucketRequest.new(parent: parent, bucket_id: bucket_id, bucket: bucket), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_bucket_async_client_stub.call_rpc_count
    end
  end

  def test_update_bucket_async
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    bucket = {}
    update_mask = {}

    update_bucket_async_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_bucket_async, name
      assert_kind_of ::Google::Cloud::Logging::V2::UpdateBucketRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogBucket), request["bucket"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_bucket_async_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_bucket_async({ name: name, bucket: bucket, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_bucket_async name: name, bucket: bucket, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_bucket_async ::Google::Cloud::Logging::V2::UpdateBucketRequest.new(name: name, bucket: bucket, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_bucket_async({ name: name, bucket: bucket, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_bucket_async(::Google::Cloud::Logging::V2::UpdateBucketRequest.new(name: name, bucket: bucket, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_bucket_async_client_stub.call_rpc_count
    end
  end

  def test_create_bucket
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogBucket.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    bucket_id = "hello world"
    bucket = {}

    create_bucket_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_bucket, name
      assert_kind_of ::Google::Cloud::Logging::V2::CreateBucketRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["bucket_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogBucket), request["bucket"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_bucket_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_bucket({ parent: parent, bucket_id: bucket_id, bucket: bucket }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_bucket parent: parent, bucket_id: bucket_id, bucket: bucket do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_bucket ::Google::Cloud::Logging::V2::CreateBucketRequest.new(parent: parent, bucket_id: bucket_id, bucket: bucket) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_bucket({ parent: parent, bucket_id: bucket_id, bucket: bucket }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_bucket(::Google::Cloud::Logging::V2::CreateBucketRequest.new(parent: parent, bucket_id: bucket_id, bucket: bucket), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_bucket_client_stub.call_rpc_count
    end
  end

  def test_update_bucket
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogBucket.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    bucket = {}
    update_mask = {}

    update_bucket_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_bucket, name
      assert_kind_of ::Google::Cloud::Logging::V2::UpdateBucketRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogBucket), request["bucket"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_bucket_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_bucket({ name: name, bucket: bucket, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_bucket name: name, bucket: bucket, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_bucket ::Google::Cloud::Logging::V2::UpdateBucketRequest.new(name: name, bucket: bucket, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_bucket({ name: name, bucket: bucket, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_bucket(::Google::Cloud::Logging::V2::UpdateBucketRequest.new(name: name, bucket: bucket, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_bucket_client_stub.call_rpc_count
    end
  end

  def test_delete_bucket
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_bucket_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_bucket, name
      assert_kind_of ::Google::Cloud::Logging::V2::DeleteBucketRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_bucket_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_bucket({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_bucket name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_bucket ::Google::Cloud::Logging::V2::DeleteBucketRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_bucket({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_bucket(::Google::Cloud::Logging::V2::DeleteBucketRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_bucket_client_stub.call_rpc_count
    end
  end

  def test_undelete_bucket
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undelete_bucket_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undelete_bucket, name
      assert_kind_of ::Google::Cloud::Logging::V2::UndeleteBucketRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undelete_bucket_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undelete_bucket({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undelete_bucket name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undelete_bucket ::Google::Cloud::Logging::V2::UndeleteBucketRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undelete_bucket({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undelete_bucket(::Google::Cloud::Logging::V2::UndeleteBucketRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undelete_bucket_client_stub.call_rpc_count
    end
  end

  def test_list_views
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::ListViewsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_views_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_views, name
      assert_kind_of ::Google::Cloud::Logging::V2::ListViewsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_views_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_views({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_views parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_views ::Google::Cloud::Logging::V2::ListViewsRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_views({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_views(::Google::Cloud::Logging::V2::ListViewsRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_views_client_stub.call_rpc_count
    end
  end

  def test_get_view
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogView.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_view, name
      assert_kind_of ::Google::Cloud::Logging::V2::GetViewRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_view_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_view({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_view name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_view ::Google::Cloud::Logging::V2::GetViewRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_view({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_view(::Google::Cloud::Logging::V2::GetViewRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_view_client_stub.call_rpc_count
    end
  end

  def test_create_view
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogView.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    view_id = "hello world"
    view = {}

    create_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_view, name
      assert_kind_of ::Google::Cloud::Logging::V2::CreateViewRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["view_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogView), request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_view_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_view({ parent: parent, view_id: view_id, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_view parent: parent, view_id: view_id, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_view ::Google::Cloud::Logging::V2::CreateViewRequest.new(parent: parent, view_id: view_id, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_view({ parent: parent, view_id: view_id, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_view(::Google::Cloud::Logging::V2::CreateViewRequest.new(parent: parent, view_id: view_id, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_view_client_stub.call_rpc_count
    end
  end

  def test_update_view
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogView.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = {}
    update_mask = {}

    update_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_view, name
      assert_kind_of ::Google::Cloud::Logging::V2::UpdateViewRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogView), request["view"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_view_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_view({ name: name, view: view, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_view name: name, view: view, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_view ::Google::Cloud::Logging::V2::UpdateViewRequest.new(name: name, view: view, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_view({ name: name, view: view, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_view(::Google::Cloud::Logging::V2::UpdateViewRequest.new(name: name, view: view, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_view_client_stub.call_rpc_count
    end
  end

  def test_delete_view
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_view_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_view, name
      assert_kind_of ::Google::Cloud::Logging::V2::DeleteViewRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_view_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_view({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_view name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_view ::Google::Cloud::Logging::V2::DeleteViewRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_view({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_view(::Google::Cloud::Logging::V2::DeleteViewRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_view_client_stub.call_rpc_count
    end
  end

  def test_list_sinks
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::ListSinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_sinks_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_sinks, name
      assert_kind_of ::Google::Cloud::Logging::V2::ListSinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_sinks_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_sinks({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_sinks parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_sinks ::Google::Cloud::Logging::V2::ListSinksRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_sinks({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_sinks(::Google::Cloud::Logging::V2::ListSinksRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_sinks_client_stub.call_rpc_count
    end
  end

  def test_get_sink
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogSink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    sink_name = "hello world"

    get_sink_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_sink, name
      assert_kind_of ::Google::Cloud::Logging::V2::GetSinkRequest, request
      assert_equal "hello world", request["sink_name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_sink_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_sink({ sink_name: sink_name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_sink sink_name: sink_name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_sink ::Google::Cloud::Logging::V2::GetSinkRequest.new(sink_name: sink_name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_sink({ sink_name: sink_name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_sink(::Google::Cloud::Logging::V2::GetSinkRequest.new(sink_name: sink_name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_sink_client_stub.call_rpc_count
    end
  end

  def test_create_sink
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogSink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    sink = {}
    unique_writer_identity = true

    create_sink_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_sink, name
      assert_kind_of ::Google::Cloud::Logging::V2::CreateSinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogSink), request["sink"]
      assert_equal true, request["unique_writer_identity"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_sink_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_sink({ parent: parent, sink: sink, unique_writer_identity: unique_writer_identity }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_sink parent: parent, sink: sink, unique_writer_identity: unique_writer_identity do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_sink ::Google::Cloud::Logging::V2::CreateSinkRequest.new(parent: parent, sink: sink, unique_writer_identity: unique_writer_identity) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_sink({ parent: parent, sink: sink, unique_writer_identity: unique_writer_identity }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_sink(::Google::Cloud::Logging::V2::CreateSinkRequest.new(parent: parent, sink: sink, unique_writer_identity: unique_writer_identity), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_sink_client_stub.call_rpc_count
    end
  end

  def test_update_sink
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogSink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    sink_name = "hello world"
    sink = {}
    unique_writer_identity = true
    update_mask = {}

    update_sink_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_sink, name
      assert_kind_of ::Google::Cloud::Logging::V2::UpdateSinkRequest, request
      assert_equal "hello world", request["sink_name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogSink), request["sink"]
      assert_equal true, request["unique_writer_identity"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_sink_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_sink({ sink_name: sink_name, sink: sink, unique_writer_identity: unique_writer_identity, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_sink sink_name: sink_name, sink: sink, unique_writer_identity: unique_writer_identity, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_sink ::Google::Cloud::Logging::V2::UpdateSinkRequest.new(sink_name: sink_name, sink: sink, unique_writer_identity: unique_writer_identity, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_sink({ sink_name: sink_name, sink: sink, unique_writer_identity: unique_writer_identity, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_sink(::Google::Cloud::Logging::V2::UpdateSinkRequest.new(sink_name: sink_name, sink: sink, unique_writer_identity: unique_writer_identity, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_sink_client_stub.call_rpc_count
    end
  end

  def test_delete_sink
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    sink_name = "hello world"

    delete_sink_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_sink, name
      assert_kind_of ::Google::Cloud::Logging::V2::DeleteSinkRequest, request
      assert_equal "hello world", request["sink_name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_sink_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_sink({ sink_name: sink_name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_sink sink_name: sink_name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_sink ::Google::Cloud::Logging::V2::DeleteSinkRequest.new(sink_name: sink_name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_sink({ sink_name: sink_name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_sink(::Google::Cloud::Logging::V2::DeleteSinkRequest.new(sink_name: sink_name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_sink_client_stub.call_rpc_count
    end
  end

  def test_create_link
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    link = {}
    link_id = "hello world"

    create_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_link, name
      assert_kind_of ::Google::Cloud::Logging::V2::CreateLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::Link), request["link"]
      assert_equal "hello world", request["link_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_link_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_link({ parent: parent, link: link, link_id: link_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_link parent: parent, link: link, link_id: link_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_link ::Google::Cloud::Logging::V2::CreateLinkRequest.new(parent: parent, link: link, link_id: link_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_link({ parent: parent, link: link, link_id: link_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_link(::Google::Cloud::Logging::V2::CreateLinkRequest.new(parent: parent, link: link, link_id: link_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_link_client_stub.call_rpc_count
    end
  end

  def test_delete_link
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_link, name
      assert_kind_of ::Google::Cloud::Logging::V2::DeleteLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_link_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_link({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_link name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_link ::Google::Cloud::Logging::V2::DeleteLinkRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_link({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_link(::Google::Cloud::Logging::V2::DeleteLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_link_client_stub.call_rpc_count
    end
  end

  def test_list_links
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::ListLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_links, name
      assert_kind_of ::Google::Cloud::Logging::V2::ListLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_links_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_links({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_links parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_links ::Google::Cloud::Logging::V2::ListLinksRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_links({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_links(::Google::Cloud::Logging::V2::ListLinksRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_links_client_stub.call_rpc_count
    end
  end

  def test_get_link
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::Link.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_link, name
      assert_kind_of ::Google::Cloud::Logging::V2::GetLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_link_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_link ::Google::Cloud::Logging::V2::GetLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_link(::Google::Cloud::Logging::V2::GetLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_link_client_stub.call_rpc_count
    end
  end

  def test_list_exclusions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::ListExclusionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_exclusions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_exclusions, name
      assert_kind_of ::Google::Cloud::Logging::V2::ListExclusionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_exclusions_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_exclusions({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_exclusions parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_exclusions ::Google::Cloud::Logging::V2::ListExclusionsRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_exclusions({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_exclusions(::Google::Cloud::Logging::V2::ListExclusionsRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_exclusions_client_stub.call_rpc_count
    end
  end

  def test_get_exclusion
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogExclusion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_exclusion_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_exclusion, name
      assert_kind_of ::Google::Cloud::Logging::V2::GetExclusionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_exclusion_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_exclusion({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_exclusion name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_exclusion ::Google::Cloud::Logging::V2::GetExclusionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_exclusion({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_exclusion(::Google::Cloud::Logging::V2::GetExclusionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_exclusion_client_stub.call_rpc_count
    end
  end

  def test_create_exclusion
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogExclusion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    exclusion = {}

    create_exclusion_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_exclusion, name
      assert_kind_of ::Google::Cloud::Logging::V2::CreateExclusionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogExclusion), request["exclusion"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_exclusion_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_exclusion({ parent: parent, exclusion: exclusion }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_exclusion parent: parent, exclusion: exclusion do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_exclusion ::Google::Cloud::Logging::V2::CreateExclusionRequest.new(parent: parent, exclusion: exclusion) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_exclusion({ parent: parent, exclusion: exclusion }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_exclusion(::Google::Cloud::Logging::V2::CreateExclusionRequest.new(parent: parent, exclusion: exclusion), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_exclusion_client_stub.call_rpc_count
    end
  end

  def test_update_exclusion
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::LogExclusion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    exclusion = {}
    update_mask = {}

    update_exclusion_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_exclusion, name
      assert_kind_of ::Google::Cloud::Logging::V2::UpdateExclusionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::LogExclusion), request["exclusion"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_exclusion_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_exclusion({ name: name, exclusion: exclusion, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_exclusion name: name, exclusion: exclusion, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_exclusion ::Google::Cloud::Logging::V2::UpdateExclusionRequest.new(name: name, exclusion: exclusion, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_exclusion({ name: name, exclusion: exclusion, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_exclusion(::Google::Cloud::Logging::V2::UpdateExclusionRequest.new(name: name, exclusion: exclusion, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_exclusion_client_stub.call_rpc_count
    end
  end

  def test_delete_exclusion
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_exclusion_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_exclusion, name
      assert_kind_of ::Google::Cloud::Logging::V2::DeleteExclusionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_exclusion_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_exclusion({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_exclusion name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_exclusion ::Google::Cloud::Logging::V2::DeleteExclusionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_exclusion({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_exclusion(::Google::Cloud::Logging::V2::DeleteExclusionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_exclusion_client_stub.call_rpc_count
    end
  end

  def test_get_cmek_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::CmekSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cmek_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_cmek_settings, name
      assert_kind_of ::Google::Cloud::Logging::V2::GetCmekSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_cmek_settings_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_cmek_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_cmek_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_cmek_settings ::Google::Cloud::Logging::V2::GetCmekSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_cmek_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_cmek_settings(::Google::Cloud::Logging::V2::GetCmekSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_cmek_settings_client_stub.call_rpc_count
    end
  end

  def test_update_cmek_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::CmekSettings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    cmek_settings = {}
    update_mask = {}

    update_cmek_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_cmek_settings, name
      assert_kind_of ::Google::Cloud::Logging::V2::UpdateCmekSettingsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::CmekSettings), request["cmek_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_cmek_settings_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_cmek_settings({ name: name, cmek_settings: cmek_settings, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_cmek_settings name: name, cmek_settings: cmek_settings, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_cmek_settings ::Google::Cloud::Logging::V2::UpdateCmekSettingsRequest.new(name: name, cmek_settings: cmek_settings, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_cmek_settings({ name: name, cmek_settings: cmek_settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_cmek_settings(::Google::Cloud::Logging::V2::UpdateCmekSettingsRequest.new(name: name, cmek_settings: cmek_settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_cmek_settings_client_stub.call_rpc_count
    end
  end

  def test_get_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::Settings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_settings, name
      assert_kind_of ::Google::Cloud::Logging::V2::GetSettingsRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_settings_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_settings({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_settings name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_settings ::Google::Cloud::Logging::V2::GetSettingsRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_settings({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_settings(::Google::Cloud::Logging::V2::GetSettingsRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_settings_client_stub.call_rpc_count
    end
  end

  def test_update_settings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Logging::V2::Settings.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    settings = {}
    update_mask = {}

    update_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_settings, name
      assert_kind_of ::Google::Cloud::Logging::V2::UpdateSettingsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Logging::V2::Settings), request["settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_settings_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_settings({ name: name, settings: settings, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_settings name: name, settings: settings, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_settings ::Google::Cloud::Logging::V2::UpdateSettingsRequest.new(name: name, settings: settings, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_settings({ name: name, settings: settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_settings(::Google::Cloud::Logging::V2::UpdateSettingsRequest.new(name: name, settings: settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_settings_client_stub.call_rpc_count
    end
  end

  def test_copy_log_entries
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    filter = "hello world"
    destination = "hello world"

    copy_log_entries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :copy_log_entries, name
      assert_kind_of ::Google::Cloud::Logging::V2::CopyLogEntriesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["destination"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, copy_log_entries_client_stub do
      # Create client
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.copy_log_entries({ name: name, filter: filter, destination: destination }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.copy_log_entries name: name, filter: filter, destination: destination do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.copy_log_entries ::Google::Cloud::Logging::V2::CopyLogEntriesRequest.new(name: name, filter: filter, destination: destination) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.copy_log_entries({ name: name, filter: filter, destination: destination }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.copy_log_entries(::Google::Cloud::Logging::V2::CopyLogEntriesRequest.new(name: name, filter: filter, destination: destination), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, copy_log_entries_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Logging::V2::ConfigService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Logging::V2::ConfigService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Logging::V2::ConfigService::Operations, client.operations_client
  end
end
