# -*- ruby -*-
# encoding: utf-8

require File.expand_path("lib/google/cloud/logging/v2/version", __dir__)

Gem::Specification.new do |gem|
  gem.name          = "google-cloud-logging-v2"
  gem.version       = Google::Cloud::Logging::V2::VERSION

  gem.authors       = ["Google LLC"]
  gem.email         = "googleapis-packages@google.com"
  gem.description   = "The Cloud Logging API lets you programmatically read and write log entries, set up exclusions, create logs-based metrics, and manage export sinks. Note that google-cloud-logging-v2 is a version-specific client library. For most uses, we recommend installing the main client library google-cloud-logging instead. See the readme for more details."
  gem.summary       = "Writes log entries and manages your Cloud Logging configuration."
  gem.homepage      = "https://github.com/googleapis/google-cloud-ruby"
  gem.license       = "Apache-2.0"

  gem.platform      = Gem::Platform::RUBY

  gem.files         = `git ls-files -- lib/*`.split("\n") +
                      `git ls-files -- proto_docs/*`.split("\n") +
                      ["README.md", "LICENSE.md", "AUTHENTICATION.md", ".yardopts"]
  gem.require_paths = ["lib"]

  gem.required_ruby_version = ">= 3.1"

  gem.add_dependency "gapic-common", "~> 1.2"
  gem.add_dependency "google-cloud-errors", "~> 1.0"
end
