# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/locationfinder/v1/service_pb"
require "google/cloud/location_finder/v1/cloud_location_finder/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module LocationFinder
      module V1
        module CloudLocationFinder
          module Rest
            ##
            # REST client for the CloudLocationFinder service.
            #
            # Service describing handlers for resources
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudlocationfinder.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cloud_location_finder_stub

              ##
              # Configure the CloudLocationFinder Client class.
              #
              # See {::Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CloudLocationFinder clients
              #   ::Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "LocationFinder", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_cloud_locations.timeout = 60.0
                  default_config.rpcs.list_cloud_locations.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_cloud_location.timeout = 60.0
                  default_config.rpcs.get_cloud_location.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.search_cloud_locations.timeout = 60.0
                  default_config.rpcs.search_cloud_locations.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CloudLocationFinder Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cloud_location_finder_stub.universe_domain
              end

              ##
              # Create a new CloudLocationFinder REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CloudLocationFinder client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @cloud_location_finder_stub = ::Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @cloud_location_finder_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @cloud_location_finder_stub.endpoint
                  config.universe_domain = @cloud_location_finder_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @cloud_location_finder_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cloud_location_finder_stub.logger
              end

              # Service calls

              ##
              # Lists cloud locations under a given project and location.
              #
              # @overload list_cloud_locations(request, options = nil)
              #   Pass arguments to `list_cloud_locations` via a request object, either of type
              #   {::Google::Cloud::LocationFinder::V1::ListCloudLocationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::LocationFinder::V1::ListCloudLocationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_cloud_locations(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_cloud_locations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of cloud locations.
              #     Format: projects/\\{project}/locations/\\{location}
              #   @param page_size [::Integer]
              #     Optional. The maximum number of cloud locations to return per page. The
              #     service might return fewer cloud locations than this value. If unspecified,
              #     server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #     Provide page token returned by a previous 'ListCloudLocations' call to
              #     retrieve the next page of results. When paginating, all other parameters
              #     provided to 'ListCloudLocations' must match the call that provided the page
              #     token.
              #   @param filter [::String]
              #     Optional. A filter expression that filters resources listed in the
              #     response. The expression is in the form of field=value. For example,
              #     'cloud_location_type=CLOUD_LOCATION_TYPE_REGION'. Multiple filter queries
              #     are space-separated. For example,
              #     'cloud_location_type=CLOUD_LOCATION_TYPE_REGION territory_code="US"' By
              #     default, each expression is an AND expression. However, you can include AND
              #     and OR expressions explicitly.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::LocationFinder::V1::CloudLocation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::LocationFinder::V1::CloudLocation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/location_finder/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::LocationFinder::V1::ListCloudLocationsRequest.new
              #
              #   # Call the list_cloud_locations method.
              #   result = client.list_cloud_locations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::LocationFinder::V1::CloudLocation.
              #     p item
              #   end
              #
              def list_cloud_locations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::LocationFinder::V1::ListCloudLocationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_cloud_locations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::LocationFinder::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_cloud_locations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_cloud_locations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_location_finder_stub.list_cloud_locations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_location_finder_stub, :list_cloud_locations, "cloud_locations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a resource containing information about a cloud location.
              #
              # @overload get_cloud_location(request, options = nil)
              #   Pass arguments to `get_cloud_location` via a request object, either of type
              #   {::Google::Cloud::LocationFinder::V1::GetCloudLocationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::LocationFinder::V1::GetCloudLocationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_cloud_location(name: nil)
              #   Pass arguments to `get_cloud_location` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::LocationFinder::V1::CloudLocation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::LocationFinder::V1::CloudLocation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/location_finder/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::LocationFinder::V1::GetCloudLocationRequest.new
              #
              #   # Call the get_cloud_location method.
              #   result = client.get_cloud_location request
              #
              #   # The returned object is of type Google::Cloud::LocationFinder::V1::CloudLocation.
              #   p result
              #
              def get_cloud_location request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::LocationFinder::V1::GetCloudLocationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_cloud_location.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::LocationFinder::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_cloud_location.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_cloud_location.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_location_finder_stub.get_cloud_location request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Searches for cloud locations from a given source location.
              #
              # @overload search_cloud_locations(request, options = nil)
              #   Pass arguments to `search_cloud_locations` via a request object, either of type
              #   {::Google::Cloud::LocationFinder::V1::SearchCloudLocationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::LocationFinder::V1::SearchCloudLocationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_cloud_locations(parent: nil, source_cloud_location: nil, page_size: nil, page_token: nil, query: nil)
              #   Pass arguments to `search_cloud_locations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of cloud locations.
              #     Format: projects/\\{project}/locations/\\{location}
              #   @param source_cloud_location [::String]
              #     Required. The source cloud location to search from.
              #     Example search can be searching nearby cloud locations from the source
              #     cloud location by latency.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of cloud locations to return. The service
              #     might return fewer cloud locations than this value. If unspecified, server
              #     will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #     Provide Page token returned by a previous 'ListCloudLocations' call to
              #     retrieve the next page of results. When paginating, all other parameters
              #     provided to 'ListCloudLocations' must match the call that provided the page
              #     token.
              #   @param query [::String]
              #     Optional. The query string in search query syntax. While filter is used to
              #     filter the search results by attributes, query is used to specify the
              #     search requirements.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::LocationFinder::V1::CloudLocation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::LocationFinder::V1::CloudLocation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/location_finder/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::LocationFinder::V1::SearchCloudLocationsRequest.new
              #
              #   # Call the search_cloud_locations method.
              #   result = client.search_cloud_locations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::LocationFinder::V1::CloudLocation.
              #     p item
              #   end
              #
              def search_cloud_locations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::LocationFinder::V1::SearchCloudLocationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_cloud_locations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::LocationFinder::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_cloud_locations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_cloud_locations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_location_finder_stub.search_cloud_locations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_location_finder_stub, :search_cloud_locations, "cloud_locations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CloudLocationFinder REST API.
              #
              # This class represents the configuration for CloudLocationFinder REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_cloud_locations to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_cloud_locations.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::LocationFinder::V1::CloudLocationFinder::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_cloud_locations.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudlocationfinder.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CloudLocationFinder API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_cloud_locations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_cloud_locations
                  ##
                  # RPC-specific configuration for `get_cloud_location`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cloud_location
                  ##
                  # RPC-specific configuration for `search_cloud_locations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_cloud_locations

                  # @private
                  def initialize parent_rpcs = nil
                    list_cloud_locations_config = parent_rpcs.list_cloud_locations if parent_rpcs.respond_to? :list_cloud_locations
                    @list_cloud_locations = ::Gapic::Config::Method.new list_cloud_locations_config
                    get_cloud_location_config = parent_rpcs.get_cloud_location if parent_rpcs.respond_to? :get_cloud_location
                    @get_cloud_location = ::Gapic::Config::Method.new get_cloud_location_config
                    search_cloud_locations_config = parent_rpcs.search_cloud_locations if parent_rpcs.respond_to? :search_cloud_locations
                    @search_cloud_locations = ::Gapic::Config::Method.new search_cloud_locations_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
