# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module LifeSciences
      module V2beta
        # The arguments to the `RunPipeline` method. The requesting user must have
        # the `iam.serviceAccounts.actAs` permission for the Cloud Life Sciences
        # service account or the request will fail.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The project and location that this request should be executed against.
        # @!attribute [rw] pipeline
        #   @return [::Google::Cloud::LifeSciences::V2beta::Pipeline]
        #     Required. The description of the pipeline to run.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels to associate with the returned operation. These
        #     labels are not propagated to any Google Cloud Platform resources used by
        #     the operation, and can be modified at any time.
        #
        #     To associate labels with resources created while executing the operation,
        #     see the appropriate resource message (for example, `VirtualMachine`).
        # @!attribute [rw] pub_sub_topic
        #   @return [::String]
        #     The name of an existing Pub/Sub topic.  The server will publish
        #     messages to this topic whenever the status of the operation changes.
        #     The Life Sciences Service Agent account must have publisher permissions to
        #     the specified topic or notifications will not be sent.
        class RunPipelineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response to the RunPipeline method, returned in the operation's result
        # field on success.
        class RunPipelineResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies a series of actions to execute, expressed as Docker containers.
        # @!attribute [rw] actions
        #   @return [::Array<::Google::Cloud::LifeSciences::V2beta::Action>]
        #     The list of actions to execute, in the order they are specified.
        # @!attribute [rw] resources
        #   @return [::Google::Cloud::LifeSciences::V2beta::Resources]
        #     The resources required for execution.
        # @!attribute [rw] environment
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The environment to pass into every action. Each action can also specify
        #     additional environment variables but cannot delete an entry from this map
        #     (though they can overwrite it with a different value).
        # @!attribute [rw] encrypted_environment
        #   @return [::Google::Cloud::LifeSciences::V2beta::Secret]
        #     The encrypted environment to pass into every action. Each action can also
        #     specify its own encrypted environment.
        #
        #     The secret must decrypt to a JSON-encoded dictionary where key-value pairs
        #     serve as environment variable names and their values. The decoded
        #     environment variables can overwrite the values specified by the
        #     `environment` field.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     The maximum amount of time to give the pipeline to complete.  This includes
        #     the time spent waiting for a worker to be allocated.  If the pipeline fails
        #     to complete before the timeout, it will be cancelled and the error code
        #     will be set to DEADLINE_EXCEEDED.
        #
        #     If unspecified, it will default to 7 days.
        class Pipeline
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class EnvironmentEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Specifies a single action that runs a Docker container.
        # @!attribute [rw] container_name
        #   @return [::String]
        #     An optional name for the container. The container hostname will be set to
        #     this name, making it useful for inter-container communication. The name
        #     must contain only upper and lowercase alphanumeric characters and hyphens
        #     and cannot start with a hyphen.
        # @!attribute [rw] image_uri
        #   @return [::String]
        #     Required. The URI to pull the container image from. Note that all images
        #     referenced by actions in the pipeline are pulled before the first action
        #     runs. If multiple actions reference the same image, it is only pulled once,
        #     ensuring that the same image is used for all actions in a single pipeline.
        #
        #     The image URI can be either a complete host and image specification (e.g.,
        #     quay.io/biocontainers/samtools), a library and image name (e.g.,
        #     google/cloud-sdk) or a bare image name ('bash') to pull from the default
        #     library.  No schema is required in any of these cases.
        #
        #     If the specified image is not public, the service account specified for
        #     the Virtual Machine must have access to pull the images from GCR, or
        #     appropriate credentials must be specified in the
        #     {::Google::Cloud::LifeSciences::V2beta::Action#credentials google.cloud.lifesciences.v2beta.Action.credentials}
        #     field.
        # @!attribute [rw] commands
        #   @return [::Array<::String>]
        #     If specified, overrides the `CMD` specified in the container. If the
        #     container also has an `ENTRYPOINT` the values are used as entrypoint
        #     arguments. Otherwise, they are used as a command and arguments to run
        #     inside the container.
        # @!attribute [rw] entrypoint
        #   @return [::String]
        #     If specified, overrides the `ENTRYPOINT` specified in the container.
        # @!attribute [rw] environment
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The environment to pass into the container. This environment is merged
        #     with values specified in the
        #     {::Google::Cloud::LifeSciences::V2beta::Pipeline google.cloud.lifesciences.v2beta.Pipeline}
        #     message, overwriting any duplicate values.
        #
        #     In addition to the values passed here, a few other values are
        #     automatically injected into the environment. These cannot be hidden or
        #     overwritten.
        #
        #     `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
        #     because an action has exited with a non-zero status (and did not have the
        #     `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
        #     debug or logging actions should execute.
        #
        #     `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
        #     non-background action that executed. This can be used by workflow engine
        #     authors to determine whether an individual action has succeeded or failed.
        # @!attribute [rw] encrypted_environment
        #   @return [::Google::Cloud::LifeSciences::V2beta::Secret]
        #     The encrypted environment to pass into the container. This environment is
        #     merged with values specified in the
        #     {::Google::Cloud::LifeSciences::V2beta::Pipeline google.cloud.lifesciences.v2beta.Pipeline}
        #     message, overwriting any duplicate values.
        #
        #     The secret must decrypt to a JSON-encoded dictionary where key-value pairs
        #     serve as environment variable names and their values. The decoded
        #     environment variables can overwrite the values specified by the
        #     `environment` field.
        # @!attribute [rw] pid_namespace
        #   @return [::String]
        #     An optional identifier for a PID namespace to run the action inside.
        #     Multiple actions should use the same string to share a namespace.  If
        #     unspecified, a separate isolated namespace is used.
        # @!attribute [rw] port_mappings
        #   @return [::Google::Protobuf::Map{::Integer => ::Integer}]
        #     A map of containers to host port mappings for this container. If the
        #     container already specifies exposed ports, use the
        #     `PUBLISH_EXPOSED_PORTS` flag instead.
        #
        #     The host port number must be less than 65536. If it is zero, an unused
        #     random port is assigned. To determine the resulting port number, consult
        #     the `ContainerStartedEvent` in the operation metadata.
        # @!attribute [rw] mounts
        #   @return [::Array<::Google::Cloud::LifeSciences::V2beta::Mount>]
        #     A list of mounts to make available to the action.
        #
        #     In addition to the values specified here, every action has a special
        #     virtual disk mounted under `/google` that contains log files and other
        #     operational components.
        #
        #     <ul>
        #       <li><code>/google/logs</code> All logs written during the pipeline
        #       execution.</li>
        #       <li><code>/google/logs/output</code> The combined standard output and
        #       standard error of all actions run as part of the pipeline
        #       execution.</li>
        #       <li><code>/google/logs/action/*/stdout</code> The complete contents of
        #       each individual action's standard output.</li>
        #       <li><code>/google/logs/action/*/stderr</code> The complete contents of
        #       each individual action's standard error output.</li>
        #     </ul>
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels to associate with the action. This field is provided to assist
        #     workflow engine authors in identifying actions (for example, to indicate
        #     what sort of action they perform, such as localization or debugging).
        #     They are returned in the operation metadata, but are otherwise ignored.
        # @!attribute [rw] credentials
        #   @return [::Google::Cloud::LifeSciences::V2beta::Secret]
        #     If the specified image is hosted on a private registry other than Google
        #     Container Registry, the credentials required to pull the image must be
        #     specified here as an encrypted secret.
        #
        #     The secret must decrypt to a JSON-encoded dictionary containing both
        #     `username` and `password` keys.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     The maximum amount of time to give the action to complete. If the action
        #     fails to complete before the timeout, it will be terminated and the exit
        #     status will be non-zero. The pipeline will continue or terminate based
        #     on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
        # @!attribute [rw] ignore_exit_status
        #   @return [::Boolean]
        #     Normally, a non-zero exit status causes the pipeline to fail. This flag
        #     allows execution of other actions to continue instead.
        # @!attribute [rw] run_in_background
        #   @return [::Boolean]
        #     This flag allows an action to continue running in the background while
        #     executing subsequent actions. This is useful to provide services to
        #     other actions (or to provide debugging support tools like SSH servers).
        # @!attribute [rw] always_run
        #   @return [::Boolean]
        #     By default, after an action fails, no further actions are run. This flag
        #     indicates that this action must be run even if the pipeline has already
        #     failed. This is useful for actions that copy output files off of the VM
        #     or for debugging. Note that no actions will be run if image prefetching
        #     fails.
        # @!attribute [rw] enable_fuse
        #   @return [::Boolean]
        #     Enable access to the FUSE device for this action. Filesystems can then
        #     be mounted into disks shared with other actions. The other actions do
        #     not need the `enable_fuse` flag to access the mounted filesystem.
        #
        #     This has the effect of causing the container to be executed with
        #     `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
        #     for containers you trust.
        # @!attribute [rw] publish_exposed_ports
        #   @return [::Boolean]
        #     Exposes all ports specified by `EXPOSE` statements in the container. To
        #     discover the host side port numbers, consult the `ACTION_STARTED` event
        #     in the operation metadata.
        # @!attribute [rw] disable_image_prefetch
        #   @return [::Boolean]
        #     All container images are typically downloaded before any actions are
        #     executed. This helps prevent typos in URIs or issues like lack of disk
        #     space from wasting large amounts of compute resources.
        #
        #     If set, this flag prevents the worker from downloading the image until
        #     just before the action is executed.
        # @!attribute [rw] disable_standard_error_capture
        #   @return [::Boolean]
        #     A small portion of the container's standard error stream is typically
        #     captured and returned inside the `ContainerStoppedEvent`. Setting this
        #     flag disables this functionality.
        # @!attribute [rw] block_external_network
        #   @return [::Boolean]
        #     Prevents the container from accessing the external network.
        class Action
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class EnvironmentEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::Integer]
          # @!attribute [rw] value
          #   @return [::Integer]
          class PortMappingsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Holds encrypted information that is only decrypted and stored in RAM
        # by the worker VM when running the pipeline.
        # @!attribute [rw] key_name
        #   @return [::String]
        #     The name of the Cloud KMS key that will be used to decrypt the secret
        #     value. The VM service account must have the required permissions and
        #     authentication scopes to invoke the `decrypt` method on the specified key.
        # @!attribute [rw] cipher_text
        #   @return [::String]
        #     The value of the cipherText response from the `encrypt` method. This field
        #     is intentionally unaudited.
        class Secret
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Carries information about a particular disk mount inside a container.
        # @!attribute [rw] disk
        #   @return [::String]
        #     The name of the disk to mount, as specified in the resources section.
        # @!attribute [rw] path
        #   @return [::String]
        #     The path to mount the disk inside the container.
        # @!attribute [rw] read_only
        #   @return [::Boolean]
        #     If true, the disk is mounted read-only inside the container.
        class Mount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The system resources for the pipeline run.
        #
        # At least one zone or region must be specified or the pipeline run will fail.
        # @!attribute [rw] regions
        #   @return [::Array<::String>]
        #     The list of regions allowed for VM allocation. If set, the `zones` field
        #     must not be set.
        # @!attribute [rw] zones
        #   @return [::Array<::String>]
        #     The list of zones allowed for VM allocation. If set, the `regions` field
        #     must not be set.
        # @!attribute [rw] virtual_machine
        #   @return [::Google::Cloud::LifeSciences::V2beta::VirtualMachine]
        #     The virtual machine specification.
        class Resources
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Carries information about a Compute Engine VM resource.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Required. The machine type of the virtual machine to create. Must be the
        #     short name of a standard machine type (such as "n1-standard-1") or a custom
        #     machine type (such as "custom-1-4096", where "1" indicates the number of
        #     vCPUs and "4096" indicates the memory in MB). See [Creating an instance
        #     with a custom machine
        #     type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
        #     for more specifications on creating a custom machine type.
        # @!attribute [rw] preemptible
        #   @return [::Boolean]
        #     If true, allocate a preemptible VM.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional set of labels to apply to the VM and any attached disk resources.
        #     These labels must adhere to the [name and value
        #     restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
        #     VM labels imposed by Compute Engine.
        #
        #     Labels keys with the prefix 'google-' are reserved for use by Google.
        #
        #     Labels applied at creation time to the VM. Applied on a best-effort basis
        #     to attached disk resources shortly after VM creation.
        # @!attribute [rw] disks
        #   @return [::Array<::Google::Cloud::LifeSciences::V2beta::Disk>]
        #     The list of disks to create and attach to the VM.
        #
        #     Specify either the `volumes[]` field or the `disks[]` field, but not both.
        # @!attribute [rw] network
        #   @return [::Google::Cloud::LifeSciences::V2beta::Network]
        #     The VM network configuration.
        # @!attribute [rw] accelerators
        #   @return [::Array<::Google::Cloud::LifeSciences::V2beta::Accelerator>]
        #     The list of accelerators to attach to the VM.
        # @!attribute [rw] service_account
        #   @return [::Google::Cloud::LifeSciences::V2beta::ServiceAccount]
        #     The service account to install on the VM. This account does not need
        #     any permissions other than those required by the pipeline.
        # @!attribute [rw] boot_disk_size_gb
        #   @return [::Integer]
        #     The size of the boot disk, in GB. The boot disk must be large
        #     enough to accommodate all of the Docker images from each action in the
        #     pipeline at the same time. If not specified, a small but reasonable
        #     default value is used.
        # @!attribute [rw] cpu_platform
        #   @return [::String]
        #     The CPU platform to request. An instance based on a newer platform can be
        #     allocated, but never one with fewer capabilities. The value of this
        #     parameter must be a valid Compute Engine CPU platform name (such as "Intel
        #     Skylake"). This parameter is only useful for carefully optimized work
        #     loads where the CPU platform has a significant impact.
        #
        #     For more information about the effect of this parameter, see
        #     https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
        # @!attribute [rw] boot_image
        #   @return [::String]
        #     The host operating system image to use.
        #
        #     Currently, only Container-Optimized OS images can be used.
        #
        #     The default value is `projects/cos-cloud/global/images/family/cos-stable`,
        #     which selects the latest stable release of Container-Optimized OS.
        #
        #     This option is provided to allow testing against the beta release of the
        #     operating system to ensure that the new version does not interact
        #     negatively with production pipelines.
        #
        #     To test a pipeline against the beta release of Container-Optimized OS,
        #     use the value `projects/cos-cloud/global/images/family/cos-beta`.
        # @!attribute [rw] nvidia_driver_version
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
        #     The version specified here must be compatible with the GPU libraries
        #     contained in the container being executed, and must be one of the drivers
        #     hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
        # @!attribute [rw] enable_stackdriver_monitoring
        #   @return [::Boolean]
        #     Whether Stackdriver monitoring should be enabled on the VM.
        # @!attribute [rw] docker_cache_images
        #   @return [::Array<::String>]
        #     The Compute Engine Disk Images to use as a Docker cache. The disks will be
        #     mounted into the Docker folder in a way that the images present in the
        #     cache will not need to be pulled. The digests of the cached images must
        #     match those of the tags used or the latest version will still be pulled.
        #     The root directory of the ext4 image must contain `image` and `overlay2`
        #     directories copied from the Docker directory of a VM where the desired
        #     Docker images have already been pulled. Any images pulled that are not
        #     cached will be stored on the first cache disk instead of the boot disk.
        #     Only a single image is supported.
        # @!attribute [rw] volumes
        #   @return [::Array<::Google::Cloud::LifeSciences::V2beta::Volume>]
        #     The list of disks and other storage to create or attach to the VM.
        #
        #     Specify either the `volumes[]` field or the `disks[]` field, but not both.
        # @!attribute [rw] reservation
        #   @return [::String]
        #     If specified, the VM will only be allocated inside the matching
        #     reservation. It will fail if the VM parameters don't match the reservation.
        class VirtualMachine
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Carries information about a Google Cloud service account.
        # @!attribute [rw] email
        #   @return [::String]
        #     Email address of the service account. If not specified, the default
        #     Compute Engine service account for the project will be used.
        # @!attribute [rw] scopes
        #   @return [::Array<::String>]
        #     List of scopes to be enabled for this service account on the VM, in
        #     addition to the cloud-platform API scope that will be added by default.
        class ServiceAccount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Carries information about an accelerator that can be attached to a VM.
        # @!attribute [rw] type
        #   @return [::String]
        #     The accelerator type string (for example, "nvidia-tesla-t4").
        #
        #     Only NVIDIA GPU accelerators are currently supported. If an NVIDIA GPU is
        #     attached, the required runtime libraries will be made available to all
        #     containers under `/usr/local/nvidia`. The driver version to install must
        #     be specified using the NVIDIA driver version parameter on the virtual
        #     machine specification. Note that attaching a GPU increases the worker VM
        #     startup time by a few minutes.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     How many accelerators of this type to attach.
        class Accelerator
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VM networking options.
        # @!attribute [rw] network
        #   @return [::String]
        #     The network name to attach the VM's network interface to. The value will
        #     be prefixed with `global/networks/` unless it contains a `/`, in which
        #     case it is assumed to be a fully specified network resource URL.
        #
        #     If unspecified, the global default network is used.
        # @!attribute [rw] use_private_address
        #   @return [::Boolean]
        #     If set to true, do not attach a public IP address to the VM. Note that
        #     without a public IP address, additional configuration is required to
        #     allow the VM to access Google services.
        #
        #     See https://cloud.google.com/vpc/docs/configure-private-google-access
        #     for more information.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     If the specified network is configured for custom subnet creation, the
        #     name of the subnetwork to attach the instance to must be specified here.
        #
        #     The value is prefixed with `regions/*/subnetworks/` unless it contains a
        #     `/`, in which case it is assumed to be a fully specified subnetwork
        #     resource URL.
        #
        #     If the `*` character appears in the value, it is replaced with the region
        #     that the virtual machine has been allocated in.
        class Network
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Carries information about a disk that can be attached to a VM.
        #
        # See https://cloud.google.com/compute/docs/disks/performance for more
        # information about disk type, size, and performance considerations.
        #
        # Specify either {::Google::Cloud::LifeSciences::V2beta::Volume `Volume`} or
        # {::Google::Cloud::LifeSciences::V2beta::Disk `Disk`}, but not both.
        # @!attribute [rw] name
        #   @return [::String]
        #     A user-supplied name for the disk. Used when mounting the disk into
        #     actions. The name must contain only upper and lowercase alphanumeric
        #     characters and hyphens and cannot start with a hyphen.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     The size, in GB, of the disk to attach. If the size is not
        #     specified, a default is chosen to ensure reasonable I/O performance.
        #
        #     If the disk type is specified as `local-ssd`, multiple local drives are
        #     automatically combined to provide the requested size. Note, however, that
        #     each physical SSD is 375GB in size, and no more than 8 drives can be
        #     attached to a single instance.
        # @!attribute [rw] type
        #   @return [::String]
        #     The Compute Engine disk type. If unspecified, `pd-standard` is used.
        # @!attribute [rw] source_image
        #   @return [::String]
        #     An optional image to put on the disk before attaching it to the VM.
        class Disk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Carries information about storage that can be attached to a VM.
        #
        # Specify either {::Google::Cloud::LifeSciences::V2beta::Volume `Volume`} or
        # {::Google::Cloud::LifeSciences::V2beta::Disk `Disk`}, but not both.
        # @!attribute [rw] volume
        #   @return [::String]
        #     A user-supplied name for the volume. Used when mounting the volume into
        #     {::Google::Cloud::LifeSciences::V2beta::Action `Actions`}. The name must contain
        #     only upper and lowercase alphanumeric characters and hyphens and cannot
        #     start with a hyphen.
        # @!attribute [rw] persistent_disk
        #   @return [::Google::Cloud::LifeSciences::V2beta::PersistentDisk]
        #     Configuration for a persistent disk.
        #
        #     Note: The following fields are mutually exclusive: `persistent_disk`, `existing_disk`, `nfs_mount`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] existing_disk
        #   @return [::Google::Cloud::LifeSciences::V2beta::ExistingDisk]
        #     Configuration for a existing disk.
        #
        #     Note: The following fields are mutually exclusive: `existing_disk`, `persistent_disk`, `nfs_mount`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] nfs_mount
        #   @return [::Google::Cloud::LifeSciences::V2beta::NFSMount]
        #     Configuration for an NFS mount.
        #
        #     Note: The following fields are mutually exclusive: `nfs_mount`, `persistent_disk`, `existing_disk`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Volume
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for a persistent disk to be attached to the VM.
        #
        # See https://cloud.google.com/compute/docs/disks/performance for more
        # information about disk type, size, and performance considerations.
        # @!attribute [rw] size_gb
        #   @return [::Integer]
        #     The size, in GB, of the disk to attach. If the size is not
        #     specified, a default is chosen to ensure reasonable I/O performance.
        #
        #     If the disk type is specified as `local-ssd`, multiple local drives are
        #     automatically combined to provide the requested size. Note, however, that
        #     each physical SSD is 375GB in size, and no more than 8 drives can be
        #     attached to a single instance.
        # @!attribute [rw] type
        #   @return [::String]
        #     The Compute Engine disk type. If unspecified, `pd-standard` is used.
        # @!attribute [rw] source_image
        #   @return [::String]
        #     An image to put on the disk before attaching it to the VM.
        class PersistentDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for an existing disk to be attached to the VM.
        # @!attribute [rw] disk
        #   @return [::String]
        #     If `disk` contains slashes, the Cloud Life Sciences API assumes that it is
        #     a complete URL for the disk.  If `disk` does not contain slashes, the Cloud
        #     Life Sciences API assumes that the disk is a zonal disk and a URL will be
        #     generated of the form `zones/<zone>/disks/<disk>`, where `<zone>` is the
        #     zone in which the instance is allocated. The disk must be ext4 formatted.
        #
        #     If all `Mount` references to this disk have the `read_only` flag set to
        #     true, the disk will be attached in `read-only` mode and can be shared with
        #     other instances. Otherwise, the disk will be available for writing but
        #     cannot be shared.
        class ExistingDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for an `NFSMount` to be attached to the VM.
        # @!attribute [rw] target
        #   @return [::String]
        #     A target NFS mount. The target must be specified as `address:/mount".
        class NFSMount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Carries information about the pipeline execution that is returned
        # in the long running operation's metadata field.
        # @!attribute [rw] pipeline
        #   @return [::Google::Cloud::LifeSciences::V2beta::Pipeline]
        #     The pipeline this operation represents.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The user-defined labels associated with this operation.
        # @!attribute [rw] events
        #   @return [::Array<::Google::Cloud::LifeSciences::V2beta::Event>]
        #     The list of events that have happened so far during the execution of this
        #     operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the operation was created by the API.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The first time at which resources were allocated to execute the pipeline.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which execution was completed and resources were cleaned up.
        # @!attribute [rw] pub_sub_topic
        #   @return [::String]
        #     The name of the Cloud Pub/Sub topic where notifications of operation status
        #     changes are sent.
        class Metadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Carries information about events that occur during pipeline execution.
        # @!attribute [rw] timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the event occurred.
        # @!attribute [rw] description
        #   @return [::String]
        #     A human-readable description of the event. Note that these strings can
        #     change at any time without notice. Any application logic must use the
        #     information in the `details` field.
        # @!attribute [rw] delayed
        #   @return [::Google::Cloud::LifeSciences::V2beta::DelayedEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::DelayedEvent google.cloud.lifesciences.v2beta.DelayedEvent}.
        #
        #     Note: The following fields are mutually exclusive: `delayed`, `worker_assigned`, `worker_released`, `pull_started`, `pull_stopped`, `container_started`, `container_stopped`, `container_killed`, `unexpected_exit_status`, `failed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] worker_assigned
        #   @return [::Google::Cloud::LifeSciences::V2beta::WorkerAssignedEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::WorkerAssignedEvent google.cloud.lifesciences.v2beta.WorkerAssignedEvent}.
        #
        #     Note: The following fields are mutually exclusive: `worker_assigned`, `delayed`, `worker_released`, `pull_started`, `pull_stopped`, `container_started`, `container_stopped`, `container_killed`, `unexpected_exit_status`, `failed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] worker_released
        #   @return [::Google::Cloud::LifeSciences::V2beta::WorkerReleasedEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::WorkerReleasedEvent google.cloud.lifesciences.v2beta.WorkerReleasedEvent}.
        #
        #     Note: The following fields are mutually exclusive: `worker_released`, `delayed`, `worker_assigned`, `pull_started`, `pull_stopped`, `container_started`, `container_stopped`, `container_killed`, `unexpected_exit_status`, `failed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pull_started
        #   @return [::Google::Cloud::LifeSciences::V2beta::PullStartedEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::PullStartedEvent google.cloud.lifesciences.v2beta.PullStartedEvent}.
        #
        #     Note: The following fields are mutually exclusive: `pull_started`, `delayed`, `worker_assigned`, `worker_released`, `pull_stopped`, `container_started`, `container_stopped`, `container_killed`, `unexpected_exit_status`, `failed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pull_stopped
        #   @return [::Google::Cloud::LifeSciences::V2beta::PullStoppedEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::PullStoppedEvent google.cloud.lifesciences.v2beta.PullStoppedEvent}.
        #
        #     Note: The following fields are mutually exclusive: `pull_stopped`, `delayed`, `worker_assigned`, `worker_released`, `pull_started`, `container_started`, `container_stopped`, `container_killed`, `unexpected_exit_status`, `failed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] container_started
        #   @return [::Google::Cloud::LifeSciences::V2beta::ContainerStartedEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::ContainerStartedEvent google.cloud.lifesciences.v2beta.ContainerStartedEvent}.
        #
        #     Note: The following fields are mutually exclusive: `container_started`, `delayed`, `worker_assigned`, `worker_released`, `pull_started`, `pull_stopped`, `container_stopped`, `container_killed`, `unexpected_exit_status`, `failed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] container_stopped
        #   @return [::Google::Cloud::LifeSciences::V2beta::ContainerStoppedEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::ContainerStoppedEvent google.cloud.lifesciences.v2beta.ContainerStoppedEvent}.
        #
        #     Note: The following fields are mutually exclusive: `container_stopped`, `delayed`, `worker_assigned`, `worker_released`, `pull_started`, `pull_stopped`, `container_started`, `container_killed`, `unexpected_exit_status`, `failed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] container_killed
        #   @return [::Google::Cloud::LifeSciences::V2beta::ContainerKilledEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::ContainerKilledEvent google.cloud.lifesciences.v2beta.ContainerKilledEvent}.
        #
        #     Note: The following fields are mutually exclusive: `container_killed`, `delayed`, `worker_assigned`, `worker_released`, `pull_started`, `pull_stopped`, `container_started`, `container_stopped`, `unexpected_exit_status`, `failed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] unexpected_exit_status
        #   @return [::Google::Cloud::LifeSciences::V2beta::UnexpectedExitStatusEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::UnexpectedExitStatusEvent google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent}.
        #
        #     Note: The following fields are mutually exclusive: `unexpected_exit_status`, `delayed`, `worker_assigned`, `worker_released`, `pull_started`, `pull_stopped`, `container_started`, `container_stopped`, `container_killed`, `failed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] failed
        #   @return [::Google::Cloud::LifeSciences::V2beta::FailedEvent]
        #     See
        #     {::Google::Cloud::LifeSciences::V2beta::FailedEvent google.cloud.lifesciences.v2beta.FailedEvent}.
        #
        #     Note: The following fields are mutually exclusive: `failed`, `delayed`, `worker_assigned`, `worker_released`, `pull_started`, `pull_stopped`, `container_started`, `container_stopped`, `container_killed`, `unexpected_exit_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Event
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event generated whenever a resource limitation or transient error
        # delays execution of a pipeline that was otherwise ready to run.
        # @!attribute [rw] cause
        #   @return [::String]
        #     A textual description of the cause of the delay. The string can change
        #     without notice because it is often generated by another service (such as
        #     Compute Engine).
        # @!attribute [rw] metrics
        #   @return [::Array<::String>]
        #     If the delay was caused by a resource shortage, this field lists the
        #     Compute Engine metrics that are preventing this operation from running
        #     (for example, `CPUS` or `INSTANCES`). If the particular metric is not
        #     known, a single `UNKNOWN` metric will be present.
        class DelayedEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event generated after a worker VM has been assigned to run the
        # pipeline.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The zone the worker is running in.
        # @!attribute [rw] instance
        #   @return [::String]
        #     The worker's instance name.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     The machine type that was assigned for the worker.
        class WorkerAssignedEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event generated when the worker VM that was assigned to the pipeline
        # has been released (deleted).
        # @!attribute [rw] zone
        #   @return [::String]
        #     The zone the worker was running in.
        # @!attribute [rw] instance
        #   @return [::String]
        #     The worker's instance name.
        class WorkerReleasedEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event generated when the worker starts pulling an image.
        # @!attribute [rw] image_uri
        #   @return [::String]
        #     The URI of the image that was pulled.
        class PullStartedEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event generated when the worker stops pulling an image.
        # @!attribute [rw] image_uri
        #   @return [::String]
        #     The URI of the image that was pulled.
        class PullStoppedEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event generated when a container starts.
        # @!attribute [rw] action_id
        #   @return [::Integer]
        #     The numeric ID of the action that started this container.
        # @!attribute [rw] port_mappings
        #   @return [::Google::Protobuf::Map{::Integer => ::Integer}]
        #     The container-to-host port mappings installed for this container. This
        #     set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
        #     as well as any specified in the `Action` definition.
        # @!attribute [rw] ip_address
        #   @return [::String]
        #     The public IP address that can be used to connect to the container. This
        #     field is only populated when at least one port mapping is present. If the
        #     instance was created with a private address, this field will be empty even
        #     if port mappings exist.
        class ContainerStartedEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::Integer]
          # @!attribute [rw] value
          #   @return [::Integer]
          class PortMappingsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # An event generated when a container exits.
        # @!attribute [rw] action_id
        #   @return [::Integer]
        #     The numeric ID of the action that started this container.
        # @!attribute [rw] exit_status
        #   @return [::Integer]
        #     The exit status of the container.
        # @!attribute [rw] stderr
        #   @return [::String]
        #     The tail end of any content written to standard error by the container.
        #     If the content emits large amounts of debugging noise or contains
        #     sensitive information, you can prevent the content from being printed by
        #     setting the `DISABLE_STANDARD_ERROR_CAPTURE` flag.
        #
        #     Note that only a small amount of the end of the stream is captured here.
        #     The entire stream is stored in the `/google/logs` directory mounted into
        #     each action, and can be copied off the machine as described elsewhere.
        class ContainerStoppedEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event generated when the execution of a container results in a
        # non-zero exit status that was not otherwise ignored. Execution will
        # continue, but only actions that are flagged as `ALWAYS_RUN` will be
        # executed. Other actions will be skipped.
        # @!attribute [rw] action_id
        #   @return [::Integer]
        #     The numeric ID of the action that started the container.
        # @!attribute [rw] exit_status
        #   @return [::Integer]
        #     The exit status of the container.
        class UnexpectedExitStatusEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event generated when a container is forcibly terminated by the
        # worker. Currently, this only occurs when the container outlives the
        # timeout specified by the user.
        # @!attribute [rw] action_id
        #   @return [::Integer]
        #     The numeric ID of the action that started the container.
        class ContainerKilledEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An event generated when the execution of a pipeline has failed. Note
        # that other events can continue to occur after this event.
        # @!attribute [rw] code
        #   @return [::Google::Rpc::Code]
        #     The Google standard error code that best describes this failure.
        # @!attribute [rw] cause
        #   @return [::String]
        #     The human-readable description of the cause of the failure.
        class FailedEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
