# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/life_sciences/v2beta/version"

require "google/cloud/life_sciences/v2beta/workflows_service/credentials"
require "google/cloud/life_sciences/v2beta/workflows_service/operations"
require "google/cloud/life_sciences/v2beta/workflows_service/client"
require "google/cloud/life_sciences/v2beta/workflows_service/rest"

module Google
  module Cloud
    module LifeSciences
      module V2beta
        ##
        # A service for running workflows, such as pipelines consisting of Docker
        # containers.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/life_sciences/v2beta/workflows_service"
        #     client = ::Google::Cloud::LifeSciences::V2beta::WorkflowsService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/life_sciences/v2beta/workflows_service/rest"
        #     client = ::Google::Cloud::LifeSciences::V2beta::WorkflowsService::Rest::Client.new
        #
        module WorkflowsService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "workflows_service", "helpers.rb"
require "google/cloud/life_sciences/v2beta/workflows_service/helpers" if ::File.file? helper_path
