# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/licensemanager/v1/licensemanager_pb"
require "google/cloud/license_manager/v1/license_manager/rest"


class ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_configurations
    # Create test objects.
    client_result = ::Google::Cloud::LicenseManager::V1::ListConfigurationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_configurations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_list_configurations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_configurations_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_configurations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_configurations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_configurations ::Google::Cloud::LicenseManager::V1::ListConfigurationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_configurations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_configurations(::Google::Cloud::LicenseManager::V1::ListConfigurationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_configurations_client_stub.call_count
      end
    end
  end

  def test_get_configuration
    # Create test objects.
    client_result = ::Google::Cloud::LicenseManager::V1::Configuration.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_configuration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_get_configuration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_configuration_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_configuration({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_configuration name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_configuration ::Google::Cloud::LicenseManager::V1::GetConfigurationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_configuration({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_configuration(::Google::Cloud::LicenseManager::V1::GetConfigurationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_configuration_client_stub.call_count
      end
    end
  end

  def test_create_configuration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    configuration_id = "hello world"
    configuration = {}
    request_id = "hello world"

    create_configuration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_create_configuration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_configuration_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_configuration({ parent: parent, configuration_id: configuration_id, configuration: configuration, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_configuration parent: parent, configuration_id: configuration_id, configuration: configuration, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_configuration ::Google::Cloud::LicenseManager::V1::CreateConfigurationRequest.new(parent: parent, configuration_id: configuration_id, configuration: configuration, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_configuration({ parent: parent, configuration_id: configuration_id, configuration: configuration, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_configuration(::Google::Cloud::LicenseManager::V1::CreateConfigurationRequest.new(parent: parent, configuration_id: configuration_id, configuration: configuration, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_configuration_client_stub.call_count
      end
    end
  end

  def test_update_configuration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    configuration = {}
    request_id = "hello world"

    update_configuration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_update_configuration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_configuration_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_configuration({ update_mask: update_mask, configuration: configuration, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_configuration update_mask: update_mask, configuration: configuration, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_configuration ::Google::Cloud::LicenseManager::V1::UpdateConfigurationRequest.new(update_mask: update_mask, configuration: configuration, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_configuration({ update_mask: update_mask, configuration: configuration, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_configuration(::Google::Cloud::LicenseManager::V1::UpdateConfigurationRequest.new(update_mask: update_mask, configuration: configuration, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_configuration_client_stub.call_count
      end
    end
  end

  def test_delete_configuration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_configuration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_delete_configuration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_configuration_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_configuration({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_configuration name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_configuration ::Google::Cloud::LicenseManager::V1::DeleteConfigurationRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_configuration({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_configuration(::Google::Cloud::LicenseManager::V1::DeleteConfigurationRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_configuration_client_stub.call_count
      end
    end
  end

  def test_list_instances
    # Create test objects.
    client_result = ::Google::Cloud::LicenseManager::V1::ListInstancesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_list_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_instances_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_instances ::Google::Cloud::LicenseManager::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_instances(::Google::Cloud::LicenseManager::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_instances_client_stub.call_count
      end
    end
  end

  def test_get_instance
    # Create test objects.
    client_result = ::Google::Cloud::LicenseManager::V1::Instance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_get_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_instance_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_instance ::Google::Cloud::LicenseManager::V1::GetInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_instance(::Google::Cloud::LicenseManager::V1::GetInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_instance_client_stub.call_count
      end
    end
  end

  def test_deactivate_configuration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    deactivate_configuration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_deactivate_configuration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, deactivate_configuration_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.deactivate_configuration({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.deactivate_configuration name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.deactivate_configuration ::Google::Cloud::LicenseManager::V1::DeactivateConfigurationRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.deactivate_configuration({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.deactivate_configuration(::Google::Cloud::LicenseManager::V1::DeactivateConfigurationRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, deactivate_configuration_client_stub.call_count
      end
    end
  end

  def test_reactivate_configuration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    reactivate_configuration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_reactivate_configuration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reactivate_configuration_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reactivate_configuration({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reactivate_configuration name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reactivate_configuration ::Google::Cloud::LicenseManager::V1::ReactivateConfigurationRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reactivate_configuration({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reactivate_configuration(::Google::Cloud::LicenseManager::V1::ReactivateConfigurationRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reactivate_configuration_client_stub.call_count
      end
    end
  end

  def test_query_configuration_license_usage
    # Create test objects.
    client_result = ::Google::Cloud::LicenseManager::V1::QueryConfigurationLicenseUsageResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    start_time = {}
    end_time = {}

    query_configuration_license_usage_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_query_configuration_license_usage_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_configuration_license_usage_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_configuration_license_usage({ name: name, start_time: start_time, end_time: end_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_configuration_license_usage name: name, start_time: start_time, end_time: end_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_configuration_license_usage ::Google::Cloud::LicenseManager::V1::QueryConfigurationLicenseUsageRequest.new(name: name, start_time: start_time, end_time: end_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_configuration_license_usage({ name: name, start_time: start_time, end_time: end_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_configuration_license_usage(::Google::Cloud::LicenseManager::V1::QueryConfigurationLicenseUsageRequest.new(name: name, start_time: start_time, end_time: end_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_configuration_license_usage_client_stub.call_count
      end
    end
  end

  def test_aggregate_usage
    # Create test objects.
    client_result = ::Google::Cloud::LicenseManager::V1::AggregateUsageResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    start_time = {}
    end_time = {}

    aggregate_usage_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_aggregate_usage_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, aggregate_usage_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.aggregate_usage({ name: name, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, start_time: start_time, end_time: end_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.aggregate_usage name: name, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, start_time: start_time, end_time: end_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.aggregate_usage ::Google::Cloud::LicenseManager::V1::AggregateUsageRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, start_time: start_time, end_time: end_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.aggregate_usage({ name: name, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, start_time: start_time, end_time: end_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.aggregate_usage(::Google::Cloud::LicenseManager::V1::AggregateUsageRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, start_time: start_time, end_time: end_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, aggregate_usage_client_stub.call_count
      end
    end
  end

  def test_list_products
    # Create test objects.
    client_result = ::Google::Cloud::LicenseManager::V1::ListProductsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_products_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_list_products_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_products_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_products({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_products parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_products ::Google::Cloud::LicenseManager::V1::ListProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_products({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_products(::Google::Cloud::LicenseManager::V1::ListProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_products_client_stub.call_count
      end
    end
  end

  def test_get_product
    # Create test objects.
    client_result = ::Google::Cloud::LicenseManager::V1::Product.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_product_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::ServiceStub.stub :transcode_get_product_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_product_client_stub do
        # Create client
        client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_product({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_product name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_product ::Google::Cloud::LicenseManager::V1::GetProductRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_product({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_product(::Google::Cloud::LicenseManager::V1::GetProductRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_product_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::LicenseManager::V1::LicenseManager::Rest::Client::Configuration, config
  end
end
