# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module LicenseManager
      module V1
        # Configuration for a Google SPLA product
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. name of resource
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. User given name.
        # @!attribute [rw] product
        #   @return [::String]
        #     Required. Name field (with URL) of the Product offered for SPLA.
        # @!attribute [rw] license_type
        #   @return [::Google::Cloud::LicenseManager::V1::LicenseType]
        #     Required. LicenseType to be applied for billing
        # @!attribute [rw] current_billing_info
        #   @return [::Google::Cloud::LicenseManager::V1::BillingInfo]
        #     Required. Billing information applicable till end of the current month.
        # @!attribute [rw] next_billing_info
        #   @return [::Google::Cloud::LicenseManager::V1::BillingInfo]
        #     Required. Billing information applicable for next month.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create time stamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update time stamp
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs
        # @!attribute [r] state
        #   @return [::Google::Cloud::LicenseManager::V1::Configuration::State]
        #     Output only. State of the configuration.
        class Configuration
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of the configuration.
          module State
            # The Status of the configuration is unspecified
            STATE_UNSPECIFIED = 0

            # Configuration is in active state.
            STATE_ACTIVE = 1

            # Configuration is in deactivated state.
            STATE_SUSPENDED = 2

            # Configuration is in deleted state.
            STATE_DELETED = 3
          end
        end

        # Billing Information.
        # @!attribute [rw] user_count_billing
        #   @return [::Google::Cloud::LicenseManager::V1::UserCountBillingInfo]
        #     Required. This type of billing uses user count for computing total
        #     charge.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the billing starts.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the billing ends.
        class BillingInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # This approach uses total unique user count for billing.
        # @!attribute [rw] user_count
        #   @return [::Integer]
        #     Required. Number of users to bill for.
        class UserCountBillingInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing usage for license configurations which use user-count
        # billing.
        # @!attribute [rw] unique_user_count
        #   @return [::Integer]
        #     Required. Unique number of licensed users.
        class UserCountUsage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Products for Google SPLA.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Full name of the product resource.
        #     ex "projects/1/locations/us-central1/products/office-2021"
        # @!attribute [rw] version
        #   @return [::String]
        #     Required. Version of the product.
        # @!attribute [rw] product_company
        #   @return [::String]
        #     Required. Company that released the product.
        # @!attribute [r] state
        #   @return [::Google::Cloud::LicenseManager::V1::Product::State]
        #     Output only. State of the product.
        # @!attribute [rw] sku
        #   @return [::String]
        #     Required. SKU for mapping to the Billing/Subscription resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     Required. Human-readable, detailed description of the Product
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Human-readable name of the Product
        class Product
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the product.
          module State
            # The Status of the product is unknown.
            STATE_UNSPECIFIED = 0

            # Product is under provisioning stage.
            STATE_PROVISIONING = 1

            # Product is ok to run on instances.
            STATE_RUNNING = 2

            # The product is about to terminate or has been announced for termination.
            STATE_TERMINATING = 3

            # The product has been terminated.
            STATE_TERMINATED = 4
          end
        end

        # Message describing Instance object
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. name of resource
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create time stamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update time stamp
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs
        # @!attribute [r] state
        #   @return [::Google::Cloud::LicenseManager::V1::Instance::State]
        #     Output only. The state of the VM.
        # @!attribute [r] region
        #   @return [::String]
        #     Output only. The location of the VM.
        # @!attribute [r] product_activation
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::LicenseManager::V1::ActivationState}]
        #     Output only. Map with Product_Name and Activation State of the VM.
        # @!attribute [r] license_version_id
        #   @return [::String]
        #     Output only. license version id.
        # @!attribute [rw] compute_instance
        #   @return [::String]
        #     Required. Compute Instance resource name, i.e.
        #     projects/\\{project}/zones/\\{zone}/instances/\\{instance}
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::LicenseManager::V1::ActivationState]
          class ProductActivationEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # VM status enum.
          module State
            # The Status of the VM is unspecified.
            STATE_UNSPECIFIED = 0

            # Resources are being allocated for the instance.
            PROVISIONING = 1

            # All required resources have been allocated and
            # the instance is being started.
            STAGING = 2

            # The instance is running.
            RUNNING = 3

            # The instance is currently stopping (either being deleted or terminated).
            STOPPING = 4

            # The instance has stopped due to various reasons (user request, VM
            # preemption, project freezing, etc.).
            STOPPED = 5

            # The instance has failed in some way.
            TERMINATED = 6

            # The instance is in repair.
            REPAIRING = 7
          end
        end

        # Message describing total counts of users who accessed a VM.
        # @!attribute [rw] lima_instance
        #   @return [::String]
        #     LiMa Instance resource name, i.e.
        #     projects/\\{project}/locations/\\{location}/instances/\\{instance}
        # @!attribute [rw] users
        #   @return [::Integer]
        #     Number of unique users accessing the VM.
        class Usage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Different types of licenses that are supported.
        module LicenseType
          # unspecified.
          LICENSE_TYPE_UNSPECIFIED = 0

          # Billing will be based on number of users listed per month.
          LICENSE_TYPE_PER_MONTH_PER_USER = 1

          # Bring your own license.
          LICENSE_TYPE_BRING_YOUR_OWN_LICENSE = 2
        end

        # State of the License Key activation on the instance.
        module ActivationState
          # The Status of the activation is unspecified
          ACTIVATION_STATE_UNSPECIFIED = 0

          # Activation key (MAK) requested for the instance.
          ACTIVATION_STATE_KEY_REQUESTED = 1

          # License activation process is running on the instance.
          ACTIVATION_STATE_ACTIVATING = 2

          # License activation is complete on the instance.
          ACTIVATION_STATE_ACTIVATED = 3

          # License Key is deactivating on the instance.
          ACTIVATION_STATE_DEACTIVATING = 4

          # License Key is deactivated on the instance.
          ACTIVATION_STATE_DEACTIVATED = 5

          # License Key activation failed on the instance.
          ACTIVATION_STATE_TERMINATED = 6
        end
      end
    end
  end
end
